/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.lightEdit;

import com.intellij.ide.lightEdit.LightEditPanel;
import com.intellij.ide.lightEdit.LightEditService;
import com.intellij.ide.lightEdit.LightEditServiceImpl;
import com.intellij.ide.lightEdit.LightEditUtil;
import com.intellij.ide.lightEdit.LightEditorManager;
import com.intellij.ide.lightEdit.menuBar.LightEditMainMenuHelper;
import com.intellij.ide.lightEdit.statusBar.LightEditAutosaveWidget;
import com.intellij.ide.lightEdit.statusBar.LightEditEncodingWidgetWrapper;
import com.intellij.ide.lightEdit.statusBar.LightEditLineSeparatorWidgetWrapper;
import com.intellij.ide.lightEdit.statusBar.LightEditModeNotificationWidget;
import com.intellij.ide.lightEdit.statusBar.LightEditPositionWidget;
import com.intellij.ide.lightEdit.statusBar.LightEditStatusBarUI;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.impl.ProjectFrameAllocatorKt;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.LightEditFrame;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.impl.CloseProjectWindowHelper;
import com.intellij.openapi.wm.impl.FrameInfo;
import com.intellij.openapi.wm.impl.IdeFrameImpl;
import com.intellij.openapi.wm.impl.IdeRootPane;
import com.intellij.openapi.wm.impl.ProjectFrameBounds;
import com.intellij.openapi.wm.impl.ProjectFrameHelper;
import com.intellij.openapi.wm.impl.TitleInfoProvider;
import com.intellij.openapi.wm.impl.ToolWindowsPane;
import com.intellij.openapi.wm.impl.WindowManagerImpl;
import com.intellij.openapi.wm.impl.status.IdeStatusBarImpl;
import com.intellij.openapi.wm.impl.status.widget.StatusBarWidgetsManager;
import com.intellij.ui.PopupHandler;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.BooleanSupplier;
import javax.swing.JComponent;
import javax.swing.JFrame;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class LightEditFrameWrapper
extends ProjectFrameHelper
implements Disposable,
LightEditFrame {
    private final Project myProject;
    private final BooleanSupplier myCloseHandler;
    private LightEditPanel myEditPanel;
    private boolean myFrameTitleUpdateEnabled;

    LightEditFrameWrapper(@NotNull Project project, @NotNull IdeFrameImpl frame, @NotNull BooleanSupplier closeHandler) {
        if (project == null) {
            LightEditFrameWrapper.$$$reportNull$$$0(0);
        }
        if (frame == null) {
            LightEditFrameWrapper.$$$reportNull$$$0(1);
        }
        if (closeHandler == null) {
            LightEditFrameWrapper.$$$reportNull$$$0(2);
        }
        super(frame, null);
        this.myFrameTitleUpdateEnabled = true;
        this.myProject = project;
        this.myCloseHandler = closeHandler;
    }

    @Override
    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            LightEditFrameWrapper.$$$reportNull$$$0(3);
        }
        return project;
    }

    @NotNull
    LightEditPanel getLightEditPanel() {
        LightEditPanel lightEditPanel = this.myEditPanel;
        if (lightEditPanel == null) {
            LightEditFrameWrapper.$$$reportNull$$$0(4);
        }
        return lightEditPanel;
    }

    @Override
    @NotNull
    protected IdeRootPane createIdeRootPane() {
        return new LightEditRootPane(this.requireNotNullFrame(), this, this);
    }

    @Override
    protected void installDefaultProjectStatusBarWidgets(@NotNull Project project) {
        if (project == null) {
            LightEditFrameWrapper.$$$reportNull$$$0(5);
        }
        LightEditorManager editorManager = LightEditService.getInstance().getEditorManager();
        IdeStatusBarImpl statusBar2 = Objects.requireNonNull(this.getStatusBar());
        statusBar2.addWidgetToLeft((StatusBarWidget)new LightEditModeNotificationWidget(), this);
        statusBar2.addWidget((StatusBarWidget)new LightEditPositionWidget(project, editorManager), StatusBar.Anchors.before((String)"FatalError"), this);
        statusBar2.addWidget((StatusBarWidget)new LightEditAutosaveWidget(editorManager), StatusBar.Anchors.before((String)"FatalError"), this);
        statusBar2.addWidget((StatusBarWidget)new LightEditEncodingWidgetWrapper(project), StatusBar.Anchors.after((String)"Position"), this);
        statusBar2.addWidget((StatusBarWidget)new LightEditLineSeparatorWidgetWrapper(project), StatusBar.Anchors.before((String)"light.edit.encoding.widget"), this);
        PopupHandler.installPopupMenu((JComponent)statusBar2, (String)"ViewStatusBarWidgetsGroup", (String)"StatusBarPlace");
        StatusBarWidgetsManager statusBarWidgetsManager = (StatusBarWidgetsManager)((Object)project.getService(StatusBarWidgetsManager.class));
        ApplicationManager.getApplication().invokeLater(() -> statusBarWidgetsManager.updateAllWidgets());
        Disposer.register((Disposable)statusBar2, () -> statusBarWidgetsManager.disableAllWidgets());
    }

    @Override
    @NotNull
    protected List<TitleInfoProvider> getTitleInfoProviders() {
        List<TitleInfoProvider> list2 = Collections.emptyList();
        if (list2 == null) {
            LightEditFrameWrapper.$$$reportNull$$$0(6);
        }
        return list2;
    }

    @Override
    @NotNull
    protected CloseProjectWindowHelper createCloseProjectWindowHelper() {
        return new CloseProjectWindowHelper(){

            @Override
            public void windowClosing(@Nullable Project project) {
                if (LightEditFrameWrapper.this.myCloseHandler.getAsBoolean()) {
                    super.windowClosing(project);
                }
            }
        };
    }

    @Override
    public void dispose() {
        Disposer.dispose((Disposable)this.myEditPanel);
    }

    public void closeAndDispose(@NotNull LightEditServiceImpl lightEditServiceImpl) {
        if (lightEditServiceImpl == null) {
            LightEditFrameWrapper.$$$reportNull$$$0(7);
        }
        IdeFrameImpl frame = this.requireNotNullFrame();
        FrameInfo frameInfo = ProjectFrameBounds.getInstance(this.myProject).getActualFrameInfoInDeviceSpace(this, frame, (WindowManagerImpl)WindowManager.getInstance());
        lightEditServiceImpl.setFrameInfo(frameInfo);
        frame.setVisible(false);
        Disposer.dispose((Disposable)this);
    }

    @NotNull
    static LightEditFrameWrapper allocate(@NotNull Project project, @Nullable FrameInfo frameInfo, @NotNull BooleanSupplier closeHandler) {
        if (project == null) {
            LightEditFrameWrapper.$$$reportNull$$$0(8);
        }
        if (closeHandler == null) {
            LightEditFrameWrapper.$$$reportNull$$$0(9);
        }
        LightEditFrameWrapper lightEditFrameWrapper = (LightEditFrameWrapper)((WindowManagerImpl)WindowManager.getInstance()).allocateFrame(project, () -> new LightEditFrameWrapper(project, ProjectFrameAllocatorKt.createNewProjectFrame(false, frameInfo), closeHandler));
        if (lightEditFrameWrapper == null) {
            LightEditFrameWrapper.$$$reportNull$$$0(10);
        }
        return lightEditFrameWrapper;
    }

    void setFrameTitleUpdateEnabled(boolean frameTitleUpdateEnabled) {
        this.myFrameTitleUpdateEnabled = frameTitleUpdateEnabled;
    }

    @Override
    public void setFrameTitle(String text2) {
        if (this.myFrameTitleUpdateEnabled) {
            super.setFrameTitle(text2);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frame";
                break;
            }
            case 2: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "closeHandler";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/lightEdit/LightEditFrameWrapper";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lightEditServiceImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/lightEdit/LightEditFrameWrapper";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getLightEditPanel";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getTitleInfoProviders";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "allocate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 10: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "installDefaultProjectStatusBarWidgets";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "closeAndDispose";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "allocate";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class LightEditRootPane
    extends IdeRootPane {
        LightEditRootPane(@NotNull JFrame frame, @NotNull IdeFrame frameHelper, Disposable parentDisposable) {
            if (frame == null) {
                LightEditRootPane.$$$reportNull$$$0(0);
            }
            if (frameHelper == null) {
                LightEditRootPane.$$$reportNull$$$0(1);
            }
            if (parentDisposable == null) {
                LightEditRootPane.$$$reportNull$$$0(2);
            }
            super(frame, frameHelper, parentDisposable);
        }

        @Override
        @NotNull
        protected Component getCenterComponent(@NotNull JFrame frame, @NotNull Disposable parentDisposable) {
            if (frame == null) {
                LightEditRootPane.$$$reportNull$$$0(3);
            }
            if (parentDisposable == null) {
                LightEditRootPane.$$$reportNull$$$0(4);
            }
            LightEditPanel lightEditPanel = LightEditFrameWrapper.this.myEditPanel = new LightEditPanel(LightEditUtil.requireProject());
            if (lightEditPanel == null) {
                LightEditRootPane.$$$reportNull$$$0(5);
            }
            return lightEditPanel;
        }

        @Override
        @NotNull
        public ToolWindowsPane getToolWindowPane() {
            throw new IllegalStateException("Tool windows are unavailable in LightEdit");
        }

        @Override
        @Nullable
        protected ActionGroup getMainMenuActionGroup() {
            return new LightEditMainMenuHelper().getMainMenuActionGroup();
        }

        @Override
        @NotNull
        protected IdeStatusBarImpl createStatusBar(@NotNull IdeFrame frame) {
            if (frame == null) {
                LightEditRootPane.$$$reportNull$$$0(6);
            }
            return new IdeStatusBarImpl(frame, false){

                @Override
                public void updateUI() {
                    this.setUI(new LightEditStatusBarUI());
                }

                @Override
                public Dimension getPreferredSize() {
                    return LightEditStatusBarUI.withHeight(super.getPreferredSize());
                }
            };
        }

        @Override
        protected void updateNorthComponents() {
        }

        @Override
        protected void installNorthComponents(@NotNull Project project) {
            if (project == null) {
                LightEditRootPane.$$$reportNull$$$0(7);
            }
        }

        @Override
        protected void deinstallNorthComponents() {
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "frame";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "frameHelper";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parentDisposable";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/lightEdit/LightEditFrameWrapper$LightEditRootPane";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/lightEdit/LightEditFrameWrapper$LightEditRootPane";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCenterComponent";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getCenterComponent";
                    break;
                }
                case 5: {
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "createStatusBar";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "installNorthComponents";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

