/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.navigationToolbar.experimental;

import com.intellij.icons.AllIcons;
import com.intellij.ide.HelpTooltip;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.GotoClassPresentationUpdater;
import com.intellij.ide.actions.SearchEverywhereAction;
import com.intellij.ide.ui.UISettings;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.AnActionResult;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.ActionButtonLook;
import com.intellij.openapi.actionSystem.ex.AnActionListener;
import com.intellij.openapi.actionSystem.impl.ActionButtonWithText;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.options.advanced.AdvancedSettings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/ide/navigationToolbar/experimental/SearchEverywhereNewToolbarAction;", "Lcom/intellij/ide/actions/SearchEverywhereAction;", "Lcom/intellij/openapi/actionSystem/ex/AnActionListener;", "()V", "hotKeyWasUsed", "", "margin", "", "subscribedForDoubleShift", "afterActionPerformed", "", "action", "Lcom/intellij/openapi/actionSystem/AnAction;", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "result", "Lcom/intellij/openapi/actionSystem/AnActionResult;", "createCustomComponent", "Ljavax/swing/JComponent;", "presentation", "Lcom/intellij/openapi/actionSystem/Presentation;", "place", "", "update", "intellij.platform.lang.impl"})
public final class SearchEverywhereNewToolbarAction
extends SearchEverywhereAction
implements AnActionListener {
    private final int margin = JBUI.scale((int)4);
    private boolean hotKeyWasUsed = AdvancedSettings.Companion.getBoolean("ide.suppress.double.click.handler");
    private boolean subscribedForDoubleShift;

    @Override
    public void update(@NotNull AnActionEvent event) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            Presentation presentation2 = event.getPresentation();
            Intrinsics.checkNotNullExpressionValue((Object)presentation2, (String)"event.presentation");
            presentation2.setText(this.hotKeyWasUsed ? ActionsBundle.message((String)"action.SearchEverywhereToolbar.text", (Object[])new Object[0]) : ActionsBundle.message((String)"action.SearchEverywhereToolbarHotKey.text", (Object[])new Object[0]));
            if (this.subscribedForDoubleShift) break block1;
            Project project = event.getProject();
            if (project != null) {
                Project project2 = project;
                boolean bl = false;
                boolean bl2 = false;
                Project it = project2;
                boolean bl3 = false;
                Application application = ApplicationManager.getApplication();
                Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
                application.getMessageBus().connect((Disposable)it).subscribe(AnActionListener.TOPIC, (Object)this);
                this.subscribedForDoubleShift = true;
            }
        }
    }

    @Override
    @NotNull
    public JComponent createCustomComponent(@NotNull Presentation presentation2, @NotNull String place) {
        Intrinsics.checkNotNullParameter((Object)presentation2, (String)"presentation");
        Intrinsics.checkNotNullParameter((Object)place, (String)"place");
        return new ActionButtonWithText(this, presentation2, place, this, presentation2, place, ActionToolbar.DEFAULT_MINIMUM_BUTTON_SIZE){
            final /* synthetic */ SearchEverywhereNewToolbarAction this$0;
            final /* synthetic */ Presentation $presentation;
            final /* synthetic */ String $place;

            protected void updateToolTipText() {
                String shortcutText = SearchEverywhereNewToolbarAction.access$getShortcut$s1869332970();
                String classesTabName = String.join((CharSequence)"/", (Iterable<? extends CharSequence>)GotoClassPresentationUpdater.getActionTitlePluralized());
                if (Registry.is((String)"ide.helptooltip.enabled")) {
                    HelpTooltip.dispose((Component)this);
                    HelpTooltip helpTooltip = new HelpTooltip();
                    Presentation presentation2 = this.myPresentation;
                    Intrinsics.checkNotNullExpressionValue((Object)presentation2, (String)"myPresentation");
                    helpTooltip.setTitle(presentation2.getText()).setShortcut(shortcutText).setDescription(IdeBundle.message((String)"search.everywhere.action.tooltip.description.text", (Object[])new Object[]{classesTabName})).installOn((JComponent)this);
                } else {
                    this.setToolTipText(IdeBundle.message((String)"search.everywhere.action.tooltip.text", (Object[])new Object[]{shortcutText, classesTabName}));
                }
            }

            protected void actionPerformed(@NotNull AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                super.actionPerformed(new AnActionEvent(e.getInputEvent(), e.getDataContext(), "NewToolbar", this.this$0.getTemplatePresentation(), ActionManager.getInstance(), 0));
            }

            public void paint(@Nullable Graphics g) {
                this.setForeground(JBUI.CurrentTheme.TabbedPane.DISABLED_TEXT_COLOR);
                this.setBackground(JBUI.CurrentTheme.BigPopup.searchFieldBackground());
                super.paint(g);
            }

            protected int iconTextSpace() {
                return super.iconTextSpace() + SearchEverywhereNewToolbarAction.access$getMargin$p(this.this$0);
            }

            public void paintComponent(@NotNull Graphics g) {
                Intrinsics.checkNotNullParameter((Object)g, (String)"g");
                Icon icon2 = this.getIcon();
                UISettings.Companion.setupAntialiasing(g);
                FontMetrics fm = this.getFontMetrics(this.getFont());
                Rectangle viewRect = this.getButtonRect();
                JBInsets.removeFrom((Rectangle)viewRect, (Insets)this.getInsets());
                JBInsets.removeFrom((Rectangle)viewRect, (Insets)this.getMargins());
                Rectangle iconRect = new Rectangle();
                Rectangle textRect = new Rectangle();
                String text2 = SwingUtilities.layoutCompoundLabel(this, fm, this.$presentation.getText(true), icon2, 0, this.horizontalTextAlignment(), 0, this.horizontalTextPosition(), viewRect, iconRect, textRect, this.iconTextSpace());
                iconRect.x = SearchEverywhereNewToolbarAction.access$getMargin$p(this.this$0);
                ActionButtonLook look = this.getButtonLook();
                look.paintBackground(g, (JComponent)this);
                look.paintIcon(g, this, icon2, iconRect.x, iconRect.y);
                look.paintBorder(g, (JComponent)this);
                g.setColor(this.$presentation.isEnabled() ? this.getForeground() : this.getInactiveTextColor());
                int n = this.getMnemonicCharIndex(text2);
                int n2 = textRect.x;
                int n3 = textRect.y;
                FontMetrics fontMetrics = fm;
                Intrinsics.checkNotNullExpressionValue((Object)fontMetrics, (String)"fm");
                BasicGraphicsUtils.drawStringUnderlineCharAt(g, text2, n, n2, n3 + fontMetrics.getAscent());
            }
            {
                this.this$0 = this$0;
                this.$presentation = $captured_local_variable$1;
                this.$place = $captured_local_variable$2;
                super($super_call_param$3, $super_call_param$4, $super_call_param$5, $super_call_param$6);
                $captured_local_variable$1.setIcon(AllIcons.Actions.Search);
                $captured_local_variable$1.setText(SearchEverywhereNewToolbarAction.access$getHotKeyWasUsed$p(this$0) ? ActionsBundle.message((String)"action.SearchEverywhereToolbar.text", (Object[])new Object[0]) : ActionsBundle.message((String)"action.SearchEverywhereToolbarHotKey.text", (Object[])new Object[0]));
                this.setHorizontalTextAlignment(2);
            }
        };
    }

    public void afterActionPerformed(@NotNull AnAction action2, @NotNull AnActionEvent event, @NotNull AnActionResult result2) {
        Intrinsics.checkNotNullParameter((Object)action2, (String)"action");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        if (action2 instanceof SearchEverywhereAction && !this.hotKeyWasUsed && event.getInputEvent() instanceof KeyEvent) {
            InputEvent inputEvent = event.getInputEvent();
            if (inputEvent == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.awt.event.KeyEvent");
            }
            if (((KeyEvent)inputEvent).getKeyCode() == 16) {
                this.hotKeyWasUsed = true;
            }
        }
    }

    public SearchEverywhereNewToolbarAction() {
        Presentation presentation2 = this.getTemplatePresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation2, (String)"templatePresentation");
        presentation2.setIcon(AllIcons.Actions.Search);
    }

    public static final /* synthetic */ String access$getShortcut$s1869332970() {
        return SearchEverywhereAction.getShortcut();
    }

    public static final /* synthetic */ int access$getMargin$p(SearchEverywhereNewToolbarAction $this) {
        return $this.margin;
    }

    public static final /* synthetic */ boolean access$getHotKeyWasUsed$p(SearchEverywhereNewToolbarAction $this) {
        return $this.hotKeyWasUsed;
    }

    public static final /* synthetic */ void access$setHotKeyWasUsed$p(SearchEverywhereNewToolbarAction $this, boolean bl) {
        $this.hotKeyWasUsed = bl;
    }
}

