/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins.marketplace;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.PluginInstaller;
import com.intellij.ide.plugins.marketplace.GuessFileParameters;
import com.intellij.ide.plugins.marketplace.MarketplacePluginDownloadService;
import com.intellij.ide.plugins.marketplace.MarketplacePluginDownloadServiceKt;
import com.intellij.ide.plugins.marketplace.PluginChunkDataSource;
import com.intellij.ide.plugins.marketplace.PluginChunkMerger;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.io.HttpRequests;
import com.intellij.util.io.PathKt;
import com.jetbrains.plugin.blockmap.core.BlockMap;
import com.jetbrains.plugin.blockmap.core.FileHash;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u001e\u0010\u000f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\u000eJ\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R\u001b\u0010\u0003\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0017"}, d2={"Lcom/intellij/ide/plugins/marketplace/MarketplacePluginDownloadService;", "", "()V", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "getObjectMapper", "()Lcom/fasterxml/jackson/databind/ObjectMapper;", "objectMapper$delegate", "Lkotlin/Lazy;", "downloadPlugin", "Ljava/io/File;", "pluginUrl", "", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "downloadPluginViaBlockMap", "prevPlugin", "Ljava/nio/file/Path;", "getBlockMapFromZip", "Lcom/jetbrains/plugin/blockmap/core/BlockMap;", "input", "Ljava/io/InputStream;", "Companion", "intellij.platform.ide.impl"})
public class MarketplacePluginDownloadService {
    private final Lazy objectMapper$delegate = LazyKt.lazy((Function0)objectMapper.2.INSTANCE);
    @NotNull
    private static final MarketplacePluginDownloadService instance;
    @NotNull
    public static final Companion Companion;

    private final ObjectMapper getObjectMapper() {
        Lazy lazy = this.objectMapper$delegate;
        MarketplacePluginDownloadService marketplacePluginDownloadService = this;
        Object var3_3 = null;
        boolean bl = false;
        return (ObjectMapper)lazy.getValue();
    }

    @NotNull
    public File downloadPlugin(@NotNull String pluginUrl, @NotNull ProgressIndicator indicator2) throws IOException {
        Intrinsics.checkNotNullParameter((Object)pluginUrl, (String)"pluginUrl");
        Intrinsics.checkNotNullParameter((Object)indicator2, (String)"indicator");
        File file2 = Companion.getPluginTempFile();
        Object object = HttpRequests.request((String)pluginUrl).gzip(false).productNameAsUserAgent().connect(new HttpRequests.RequestProcessor(file2, indicator2, pluginUrl){
            final /* synthetic */ File $file;
            final /* synthetic */ ProgressIndicator $indicator;
            final /* synthetic */ String $pluginUrl;

            public final File process(@NotNull HttpRequests.Request request) {
                File file2;
                Intrinsics.checkNotNullParameter((Object)request, (String)"request");
                request.saveToFile(this.$file, this.$indicator);
                URLConnection uRLConnection = request.getConnection();
                Intrinsics.checkNotNullExpressionValue((Object)uRLConnection, (String)"request.connection");
                String pluginFileUrl = MarketplacePluginDownloadServiceKt.access$getPluginFileUrl(uRLConnection);
                if (StringsKt.endsWith$default((String)pluginFileUrl, (String)".zip", (boolean)false, (int)2, null)) {
                    file2 = MarketplacePluginDownloadService.Companion.renameFileToZipRoot(this.$file);
                } else {
                    String contentDisposition = request.getConnection().getHeaderField("Content-Disposition");
                    URLConnection uRLConnection2 = request.getConnection();
                    Intrinsics.checkNotNullExpressionValue((Object)uRLConnection2, (String)"request.connection");
                    String string = uRLConnection2.getURL().toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"request.connection.url.toString()");
                    String url = string;
                    file2 = MarketplacePluginDownloadServiceKt.access$guessPluginFile(contentDisposition, url, this.$file, this.$pluginUrl);
                }
                return file2;
            }
            {
                this.$file = file2;
                this.$indicator = progressIndicator;
                this.$pluginUrl = string;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"HttpRequests.request(plu\u2026inUrl)\n        }\n      })");
        return (File)object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public final File downloadPluginViaBlockMap(@NotNull String pluginUrl, @NotNull Path prevPlugin, @NotNull ProgressIndicator indicator2) throws IOException {
        void pluginFileUrl;
        Intrinsics.checkNotNullParameter((Object)pluginUrl, (String)"pluginUrl");
        Intrinsics.checkNotNullParameter((Object)prevPlugin, (String)"prevPlugin");
        Intrinsics.checkNotNullParameter((Object)indicator2, (String)"indicator");
        Path prevPluginArchive = MarketplacePluginDownloadServiceKt.access$getPrevPluginArchive(prevPlugin);
        if (!PathKt.exists((Path)prevPluginArchive)) {
            MarketplacePluginDownloadServiceKt.access$getLOG$p().info(IdeBundle.message((String)"error.file.not.found.message", (Object[])new Object[]{((Object)prevPluginArchive).toString()}));
            return this.downloadPlugin(pluginUrl, indicator2);
        }
        Pair pair = MarketplacePluginDownloadServiceKt.access$getPluginFileUrlAndGuessFileParameters(pluginUrl);
        String string = (String)pair.component1();
        GuessFileParameters guessFileParameters = (GuessFileParameters)pair.component2();
        String blockMapFileUrl = (String)pluginFileUrl + ".blockmap.zip";
        String pluginHashFileUrl = (String)pluginFileUrl + ".hash.json";
        try {
            FileHash fileHash;
            boolean $i$a$-use-MarketplacePluginDownloadService$downloadPluginViaBlockMap$oldBlockMap$22;
            Object[] input2;
            BlockMap newBlockMap2 = (BlockMap)HttpRequests.request((String)blockMapFileUrl).productNameAsUserAgent().connect(new HttpRequests.RequestProcessor(this){
                final /* synthetic */ MarketplacePluginDownloadService this$0;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public final BlockMap process(@NotNull HttpRequests.Request request) {
                    BlockMap blockMap;
                    Intrinsics.checkNotNullParameter((Object)request, (String)"request");
                    Closeable closeable = request.getInputStream();
                    boolean bl = false;
                    boolean bl2 = false;
                    Throwable throwable = null;
                    try {
                        InputStream input = (InputStream)closeable;
                        boolean bl3 = false;
                        InputStream inputStream2 = input;
                        Intrinsics.checkNotNullExpressionValue((Object)inputStream2, (String)"input");
                        blockMap = MarketplacePluginDownloadService.access$getBlockMapFromZip(this.this$0, inputStream2);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    }
                    return blockMap;
                }
                {
                    this.this$0 = marketplacePluginDownloadService;
                }
            });
            MarketplacePluginDownloadServiceKt.access$getLOG$p().info("Plugin's blockmap file downloaded");
            FileHash newPluginHash2 = (FileHash)HttpRequests.request((String)pluginHashFileUrl).productNameAsUserAgent().connect(new HttpRequests.RequestProcessor(this){
                final /* synthetic */ MarketplacePluginDownloadService this$0;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public final FileHash process(@NotNull HttpRequests.Request request) {
                    FileHash fileHash;
                    Intrinsics.checkNotNullParameter((Object)request, (String)"request");
                    InputStream inputStream2 = request.getInputStream();
                    Intrinsics.checkNotNullExpressionValue((Object)inputStream2, (String)"request.inputStream");
                    Closeable closeable = inputStream2;
                    Charset charset = Charsets.UTF_8;
                    boolean bl = false;
                    closeable = new InputStreamReader((InputStream)closeable, charset);
                    int n = 8192;
                    bl = false;
                    closeable = closeable instanceof BufferedReader ? (BufferedReader)closeable : new BufferedReader((Reader)closeable, n);
                    n = 0;
                    bl = false;
                    Throwable throwable = null;
                    try {
                        BufferedReader input = (BufferedReader)closeable;
                        boolean bl2 = false;
                        fileHash = (FileHash)MarketplacePluginDownloadService.access$getObjectMapper$p(this.this$0).readValue(TextStreamsKt.readText((Reader)input), FileHash.class);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    }
                    return fileHash;
                }
                {
                    this.this$0 = marketplacePluginDownloadService;
                }
            });
            MarketplacePluginDownloadServiceKt.access$getLOG$p().info("Plugin's hash file downloaded");
            Closeable closeable = new FileInputStream(prevPluginArchive.toFile());
            boolean bl = false;
            boolean bl2 = false;
            Object object = null;
            try {
                input2 = (Object[])closeable;
                $i$a$-use-MarketplacePluginDownloadService$downloadPluginViaBlockMap$oldBlockMap$22 = false;
                input2 = new BlockMap((InputStream)input2, newBlockMap2.getAlgorithm(), newBlockMap2.getMinSize(), newBlockMap2.getMaxSize(), newBlockMap2.getNormalSize());
            }
            catch (Throwable input2) {
                object = input2;
                throw input2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)object);
            }
            Object[] oldBlockMap = input2;
            BlockMap blockMap = newBlockMap2;
            Intrinsics.checkNotNullExpressionValue((Object)blockMap, (String)"newBlockMap");
            double downloadPercent = MarketplacePluginDownloadServiceKt.access$downloadPercent((BlockMap)oldBlockMap, blockMap);
            Logger logger = MarketplacePluginDownloadServiceKt.access$getLOG$p();
            object = "Plugin's download percent is = %.2f";
            input2 = new Object[]{downloadPercent * (double)100};
            $i$a$-use-MarketplacePluginDownloadService$downloadPluginViaBlockMap$oldBlockMap$22 = false;
            String string2 = String.format((String)object, Arrays.copyOf(input2, input2.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(this, *args)");
            logger.info(string2);
            if (downloadPercent > 0.65) {
                MarketplacePluginDownloadServiceKt.access$getLOG$p().info(IdeBundle.message((String)"too.large.download.size", (Object[])new Object[0]));
                return this.downloadPlugin((String)pluginFileUrl, indicator2);
            }
            File file2 = Companion.getPluginTempFile();
            File file3 = prevPluginArchive.toFile();
            Intrinsics.checkNotNullExpressionValue((Object)file3, (String)"prevPluginArchive.toFile()");
            PluginChunkMerger merger = new PluginChunkMerger(file3, (BlockMap)oldBlockMap, newBlockMap2, indicator2);
            Closeable $i$a$-use-MarketplacePluginDownloadService$downloadPluginViaBlockMap$oldBlockMap$22 = new FileOutputStream(file2);
            boolean bl3 = false;
            boolean bl4 = false;
            Throwable throwable = null;
            try {
                FileOutputStream output2 = (FileOutputStream)$i$a$-use-MarketplacePluginDownloadService$downloadPluginViaBlockMap$oldBlockMap$22;
                boolean bl5 = false;
                merger.merge(output2, new PluginChunkDataSource((BlockMap)oldBlockMap, newBlockMap2, (String)pluginFileUrl));
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)$i$a$-use-MarketplacePluginDownloadService$downloadPluginViaBlockMap$oldBlockMap$22, (Throwable)throwable);
            }
            Closeable closeable2 = new FileInputStream(file2);
            boolean bl6 = false;
            boolean bl7 = false;
            Throwable throwable3 = null;
            try {
                FileInputStream input3 = (FileInputStream)closeable2;
                boolean bl8 = false;
                fileHash = new FileHash((InputStream)input3, newPluginHash2.getAlgorithm());
            }
            catch (Throwable throwable4) {
                throwable3 = throwable4;
                throw throwable4;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable3);
            }
            FileHash curFileHash = fileHash;
            if (Intrinsics.areEqual((Object)curFileHash, (Object)newPluginHash2) ^ true) {
                MarketplacePluginDownloadServiceKt.access$getLOG$p().info(IdeBundle.message((String)"hashes.doesnt.match", (Object[])new Object[0]));
                return this.downloadPlugin((String)pluginFileUrl, indicator2);
            }
            return StringsKt.endsWith$default((String)pluginFileUrl, (String)".zip", (boolean)false, (int)2, null) ? Companion.renameFileToZipRoot(file2) : MarketplacePluginDownloadServiceKt.access$guessPluginFile(guessFileParameters.getContentDisposition(), guessFileParameters.getUrl(), file2, pluginUrl);
        }
        catch (Exception e) {
            MarketplacePluginDownloadServiceKt.access$getLOG$p().info(IdeBundle.message((String)"error.download.plugin.via.blockmap", (Object[])new Object[0]), (Throwable)e);
            return this.downloadPlugin((String)pluginFileUrl, indicator2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final BlockMap getBlockMapFromZip(InputStream input) throws IOException {
        BlockMap blockMap;
        Closeable closeable = input;
        int n = 8192;
        boolean bl = false;
        closeable = closeable instanceof BufferedInputStream ? (BufferedInputStream)closeable : new BufferedInputStream((InputStream)closeable, n);
        n = 0;
        bl = false;
        Throwable throwable = null;
        try {
            BlockMap blockMap2;
            BufferedInputStream source = (BufferedInputStream)closeable;
            boolean bl2 = false;
            Closeable closeable2 = new ZipInputStream(source);
            boolean bl3 = false;
            boolean bl4 = false;
            Throwable throwable2 = null;
            try {
                ZipInputStream zip = (ZipInputStream)closeable2;
                boolean bl5 = false;
                ZipEntry entry2 = zip.getNextEntry();
                while (true) {
                    ZipEntry zipEntry = entry2;
                    Intrinsics.checkNotNullExpressionValue((Object)zipEntry, (String)"entry");
                    if (!(Intrinsics.areEqual((Object)zipEntry.getName(), (Object)"blockmap.json") ^ true) || entry2.getName() == null) break;
                    entry2 = zip.getNextEntry();
                }
                if (!Intrinsics.areEqual((Object)entry2.getName(), (Object)"blockmap.json")) {
                    throw (Throwable)new IOException("There is no entry blockmap.json");
                }
                blockMap2 = (BlockMap)this.getObjectMapper().readValue(ByteStreamsKt.readBytes((InputStream)zip), BlockMap.class);
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            }
            BlockMap blockMap3 = blockMap2;
            blockMap = blockMap3;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        Intrinsics.checkNotNullExpressionValue((Object)blockMap, (String)"input.buffered().use { s\u2026)\n        }\n      }\n    }");
        return blockMap;
    }

    static {
        Companion = new Companion(null);
        instance = new MarketplacePluginDownloadService();
    }

    public static final /* synthetic */ BlockMap access$getBlockMapFromZip(MarketplacePluginDownloadService $this, InputStream input) {
        return $this.getBlockMapFromZip(input);
    }

    public static final /* synthetic */ ObjectMapper access$getObjectMapper$p(MarketplacePluginDownloadService $this) {
        return $this.getObjectMapper();
    }

    @NotNull
    public static final MarketplacePluginDownloadService getInstance() {
        Companion companion = Companion;
        return instance;
    }

    @JvmStatic
    @NotNull
    public static final File getPluginTempFile() throws IOException {
        return Companion.getPluginTempFile();
    }

    @JvmStatic
    @NotNull
    public static final File renameFileToZipRoot(@NotNull File zip) {
        return Companion.renameFileToZipRoot(zip);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\b\u001a\u00020\tH\u0007J\u0010\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\tH\u0007R\u001c\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0005\u0010\u0002\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\f"}, d2={"Lcom/intellij/ide/plugins/marketplace/MarketplacePluginDownloadService$Companion;", "", "()V", "instance", "Lcom/intellij/ide/plugins/marketplace/MarketplacePluginDownloadService;", "getInstance$annotations", "getInstance", "()Lcom/intellij/ide/plugins/marketplace/MarketplacePluginDownloadService;", "getPluginTempFile", "Ljava/io/File;", "renameFileToZipRoot", "zip", "intellij.platform.ide.impl"})
    public static final class Companion {
        @JvmStatic
        public static /* synthetic */ void getInstance$annotations() {
        }

        @NotNull
        public final MarketplacePluginDownloadService getInstance() {
            return instance;
        }

        @JvmStatic
        @NotNull
        public final File getPluginTempFile() throws IOException {
            File pluginsTemp = new File(PathManager.getPluginTempPath());
            if (!pluginsTemp.exists() && !pluginsTemp.mkdirs()) {
                throw (Throwable)new IOException(IdeBundle.message((String)"error.cannot.create.temp.dir", (Object[])new Object[]{pluginsTemp}));
            }
            File file2 = FileUtil.createTempFile((File)pluginsTemp, (String)"plugin_", (String)"_download", (boolean)true, (boolean)false);
            Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"FileUtil.createTempFile(\u2026\"_download\", true, false)");
            return file2;
        }

        @JvmStatic
        @NotNull
        public final File renameFileToZipRoot(@NotNull File zip) {
            Intrinsics.checkNotNullParameter((Object)zip, (String)"zip");
            String newName2 = PluginInstaller.rootEntryName(zip.toPath()) + ".zip";
            File newZip = new File(zip.getParent() + '/' + newName2);
            if (newZip.exists()) {
                FileUtil.delete((File)newZip);
            }
            FileUtil.rename((File)zip, (String)newName2);
            return newZip;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

