/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins.newui;

import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerConfigurable;
import com.intellij.ide.plugins.newui.EventHandler;
import com.intellij.ide.plugins.newui.HorizontalLayout;
import com.intellij.ide.plugins.newui.ListPluginComponent;
import com.intellij.ide.plugins.newui.PluginListLayout;
import com.intellij.ide.plugins.newui.PluginLogo;
import com.intellij.ide.plugins.newui.PluginsGroup;
import com.intellij.ide.plugins.newui.UIPluginGroup;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBPanelWithEmptyText;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.components.panels.OpaquePanel;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollBar;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PluginsGroupComponent
extends JBPanelWithEmptyText {
    @NotNull
    private final EventHandler myEventHandler;
    private final List<UIPluginGroup> myGroups;
    public static final Color SECTION_HEADER_FOREGROUND = JBColor.namedColor((String)"Plugins.SectionHeader.foreground", (Color)new JBColor(0x787878, 0x999999));
    private static final Color SECTION_HEADER_BACKGROUND = JBColor.namedColor((String)"Plugins.SectionHeader.background", (Color)new JBColor(0xF7F7F7, 3948353));

    public PluginsGroupComponent(@NotNull EventHandler eventHandler) {
        if (eventHandler == null) {
            PluginsGroupComponent.$$$reportNull$$$0(0);
        }
        super((LayoutManager)((Object)new PluginListLayout()));
        this.myGroups = new ArrayList<UIPluginGroup>();
        this.myEventHandler = eventHandler;
        this.myEventHandler.connect(this);
        this.setOpaque(true);
        this.setBackground(PluginManagerConfigurable.MAIN_BG_COLOR);
    }

    @NotNull
    protected abstract ListPluginComponent createListComponent(@NotNull IdeaPluginDescriptor var1);

    @NotNull
    public final List<UIPluginGroup> getGroups() {
        List<UIPluginGroup> list2 = Collections.unmodifiableList(this.myGroups);
        if (list2 == null) {
            PluginsGroupComponent.$$$reportNull$$$0(1);
        }
        return list2;
    }

    public void setSelectionListener(@Nullable Consumer<? super PluginsGroupComponent> listener2) {
        this.myEventHandler.setSelectionListener(listener2);
    }

    @NotNull
    public final List<? extends ListPluginComponent> getSelection() {
        List<? extends ListPluginComponent> list2 = this.myEventHandler.getSelection();
        if (list2 == null) {
            PluginsGroupComponent.$$$reportNull$$$0(2);
        }
        return list2;
    }

    public void setSelection(@NotNull ListPluginComponent component2) {
        if (component2 == null) {
            PluginsGroupComponent.$$$reportNull$$$0(3);
        }
        this.myEventHandler.setSelection(component2);
    }

    public void setSelection(@NotNull List<? extends ListPluginComponent> components) {
        if (components == null) {
            PluginsGroupComponent.$$$reportNull$$$0(4);
        }
        this.myEventHandler.setSelection(components);
    }

    public void addGroup(@NotNull PluginsGroup group2) {
        if (group2 == null) {
            PluginsGroupComponent.$$$reportNull$$$0(5);
        }
        this.addGroup(group2, -1);
    }

    public void addGroup(@NotNull PluginsGroup group2, int groupIndex) {
        if (group2 == null) {
            PluginsGroupComponent.$$$reportNull$$$0(6);
        }
        this.addGroup(group2, group2.descriptors, groupIndex);
    }

    public void addLazyGroup(final @NotNull PluginsGroup group2, final @NotNull JScrollBar scrollBar, final int gapSize, final @NotNull Runnable uiCallback) {
        if (group2 == null) {
            PluginsGroupComponent.$$$reportNull$$$0(7);
        }
        if (scrollBar == null) {
            PluginsGroupComponent.$$$reportNull$$$0(8);
        }
        if (uiCallback == null) {
            PluginsGroupComponent.$$$reportNull$$$0(9);
        }
        if (group2.descriptors.size() <= gapSize) {
            this.addGroup(group2);
        } else {
            this.addGroup(group2, group2.descriptors.subList(0, gapSize), -1);
            AdjustmentListener listener2 = new AdjustmentListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void adjustmentValueChanged(AdjustmentEvent e) {
                    if (scrollBar.getValue() + scrollBar.getVisibleAmount() >= scrollBar.getMaximum()) {
                        int fromIndex = group2.ui.plugins.size();
                        int toIndex = Math.min(fromIndex + gapSize, group2.descriptors.size());
                        ListPluginComponent lastComponent = group2.ui.plugins.get(fromIndex - 1);
                        int uiIndex = PluginsGroupComponent.this.getComponentIndex(lastComponent);
                        int eventIndex = PluginsGroupComponent.this.myEventHandler.getCellIndex(lastComponent);
                        try {
                            PluginLogo.startBatchMode();
                            PluginsGroupComponent.this.addToGroup(group2, group2.descriptors.subList(fromIndex, toIndex), uiIndex, eventIndex);
                        }
                        finally {
                            PluginLogo.endBatchMode();
                        }
                        if (group2.descriptors.size() == group2.ui.plugins.size()) {
                            scrollBar.removeAdjustmentListener(this);
                            group2.clearCallback = null;
                        }
                        uiCallback.run();
                    }
                }
            };
            group2.clearCallback = () -> scrollBar.removeAdjustmentListener(listener2);
            scrollBar.addAdjustmentListener(listener2);
        }
    }

    private void addGroup(@NotNull PluginsGroup group2, @NotNull List<? extends IdeaPluginDescriptor> descriptors2, int groupIndex) {
        int eventIndex;
        int index2;
        UIPluginGroup uiGroup;
        if (group2 == null) {
            PluginsGroupComponent.$$$reportNull$$$0(10);
        }
        if (descriptors2 == null) {
            PluginsGroupComponent.$$$reportNull$$$0(11);
        }
        group2.ui = uiGroup = new UIPluginGroup();
        this.myGroups.add(groupIndex == -1 ? this.myGroups.size() : groupIndex, uiGroup);
        OpaquePanel panel2 = new OpaquePanel((LayoutManager)new BorderLayout(), SECTION_HEADER_BACKGROUND);
        panel2.setBorder((Border)JBUI.Borders.empty((int)4, (int)10));
        JLabel title2 = new JLabel(group2.title){

            @Override
            public Dimension getPreferredSize() {
                Dimension size2 = super.getPreferredSize();
                Container parent = this.getParent();
                Insets insets = parent.getInsets();
                size2.width = Math.min(parent.getWidth() - insets.left - insets.right - (parent.getComponentCount() == 2 ? parent.getComponent(1).getWidth() + JBUIScale.scale((int)20) : 0), size2.width);
                return size2;
            }

            @Override
            public String getToolTipText() {
                return super.getPreferredSize().width > this.getWidth() ? super.getToolTipText() : null;
            }
        };
        title2.setToolTipText(group2.title);
        title2.setForeground(SECTION_HEADER_FOREGROUND);
        panel2.add((Component)title2, (Object)"West");
        group2.titleLabel = title2;
        if (group2.rightAction != null) {
            panel2.add(group2.rightAction, (Object)"East");
        } else if (!ContainerUtil.isEmpty(group2.rightActions)) {
            NonOpaquePanel actions2 = new NonOpaquePanel((LayoutManager)((Object)new HorizontalLayout(JBUIScale.scale((int)5))));
            panel2.add((Component)actions2, (Object)"East");
            for (JComponent action2 : group2.rightActions) {
                actions2.add(action2);
            }
        }
        if (groupIndex == 0) {
            this.add((Component)panel2, 0);
            index2 = 1;
            eventIndex = 0;
        } else if (groupIndex == -1) {
            this.add((Component)panel2);
            eventIndex = -1;
            index2 = -1;
        } else {
            assert (groupIndex < this.myGroups.size());
            index2 = this.getComponentIndex(this.myGroups.get((int)(groupIndex + 1)).panel);
            assert (index2 != -1);
            this.add((Component)panel2, index2++);
            eventIndex = this.getEventIndexForGroup(groupIndex + 1);
        }
        uiGroup.panel = panel2;
        this.addToGroup(group2, descriptors2, index2, eventIndex);
    }

    private int getEventIndexForGroup(int groupIndex) {
        for (int i2 = groupIndex; i2 >= 0; --i2) {
            List<ListPluginComponent> plugins2 = this.myGroups.get((int)i2).plugins;
            if (plugins2.isEmpty()) continue;
            return this.myEventHandler.getCellIndex(plugins2.get(0));
        }
        return -1;
    }

    private void addToGroup(@NotNull PluginsGroup group2, @NotNull List<? extends IdeaPluginDescriptor> descriptors2, int index2, int eventIndex) {
        if (group2 == null) {
            PluginsGroupComponent.$$$reportNull$$$0(12);
        }
        if (descriptors2 == null) {
            PluginsGroupComponent.$$$reportNull$$$0(13);
        }
        for (IdeaPluginDescriptor ideaPluginDescriptor : descriptors2) {
            ListPluginComponent pluginComponent = this.createListComponent(ideaPluginDescriptor);
            group2.ui.plugins.add(pluginComponent);
            this.add(pluginComponent, index2);
            this.myEventHandler.addCell(pluginComponent, eventIndex);
            pluginComponent.setListeners(this.myEventHandler);
            if (index2 != -1) {
                ++index2;
            }
            if (eventIndex == -1) continue;
            ++eventIndex;
        }
    }

    public void addToGroup(@NotNull PluginsGroup group2, @NotNull IdeaPluginDescriptor descriptor2) {
        if (group2 == null) {
            PluginsGroupComponent.$$$reportNull$$$0(14);
        }
        if (descriptor2 == null) {
            PluginsGroupComponent.$$$reportNull$$$0(15);
        }
        int index2 = group2.addWithIndex(descriptor2);
        ListPluginComponent anchor2 = null;
        int uiIndex = -1;
        if (index2 == group2.ui.plugins.size()) {
            int groupIndex = this.myGroups.indexOf(group2.ui);
            if (groupIndex < this.myGroups.size() - 1) {
                UIPluginGroup nextGroup = this.myGroups.get(groupIndex + 1);
                anchor2 = nextGroup.plugins.get(0);
                uiIndex = this.getComponentIndex(nextGroup.panel);
            }
        } else {
            anchor2 = group2.ui.plugins.get(index2);
            uiIndex = this.getComponentIndex(anchor2);
        }
        ListPluginComponent pluginComponent = this.createListComponent(descriptor2);
        group2.ui.plugins.add(index2, pluginComponent);
        this.add(pluginComponent, uiIndex);
        this.myEventHandler.addCell(pluginComponent, anchor2);
        pluginComponent.setListeners(this.myEventHandler);
    }

    public void removeGroup(@NotNull PluginsGroup group2) {
        if (group2 == null) {
            PluginsGroupComponent.$$$reportNull$$$0(16);
        }
        this.myGroups.remove(group2.ui);
        this.remove(group2.ui.panel);
        for (ListPluginComponent plugin2 : group2.ui.plugins) {
            plugin2.close();
            this.remove(plugin2);
            this.myEventHandler.removeCell(plugin2);
        }
        this.myEventHandler.updateSelection();
        group2.clear();
    }

    public void removeFromGroup(@NotNull PluginsGroup group2, @NotNull IdeaPluginDescriptor descriptor2) {
        if (group2 == null) {
            PluginsGroupComponent.$$$reportNull$$$0(17);
        }
        if (descriptor2 == null) {
            PluginsGroupComponent.$$$reportNull$$$0(18);
        }
        int index2 = ContainerUtil.indexOf(group2.ui.plugins, component2 -> component2.getPluginDescriptor() == descriptor2);
        assert (index2 != -1);
        ListPluginComponent component3 = group2.ui.plugins.remove(index2);
        component3.close();
        this.remove(component3);
        this.myEventHandler.removeCell(component3);
        if (component3.getSelection() == EventHandler.SelectionType.SELECTION) {
            this.myEventHandler.updateSelection();
        }
        group2.descriptors.remove(descriptor2);
    }

    private int getComponentIndex(@NotNull Component component2) {
        if (component2 == null) {
            PluginsGroupComponent.$$$reportNull$$$0(19);
        }
        int components = this.getComponentCount();
        for (int i2 = 0; i2 < components; ++i2) {
            if (this.getComponent(i2) != component2) continue;
            return i2;
        }
        return -1;
    }

    public void clear() {
        for (UIPluginGroup group2 : this.myGroups) {
            for (ListPluginComponent plugin2 : group2.plugins) {
                plugin2.close();
            }
        }
        this.myGroups.clear();
        this.myEventHandler.clear();
        this.removeAll();
    }

    public void initialSelection() {
        this.initialSelection(true);
    }

    public void initialSelection(boolean scrollAndFocus) {
        SwingUtilities.invokeLater(() -> {
            this.myEventHandler.initialSelection(scrollAndFocus);
            if (!this.myGroups.isEmpty()) {
                this.scrollRectToVisible(this.myGroups.get((int)0).panel.getBounds());
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "eventHandler";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/plugins/newui/PluginsGroupComponent";
                break;
            }
            case 3: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "components";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scrollBar";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uiCallback";
                break;
            }
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/plugins/newui/PluginsGroupComponent";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroups";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setSelection";
                break;
            }
            case 5: 
            case 6: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addGroup";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addLazyGroup";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "addToGroup";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "removeGroup";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "removeFromGroup";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getComponentIndex";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

