/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util;

import com.intellij.ide.IdeBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.DocumentAdapter;
import com.intellij.util.PatternUtil;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GotoLineNumberDialog
extends DialogWrapper {
    private final Pattern myPattern = PatternUtil.compileSafe((String)"\\s*(\\d+)?\\s*(?:[,:]?\\s*(\\d+)?)?\\s*", null);
    private JTextField myField;
    private JTextField myOffsetField;

    public GotoLineNumberDialog(Project project) {
        super(project, true);
        this.setTitle(IdeBundle.message((String)"dialog.title.go.to.line.column", (Object[])new Object[0]));
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myField;
    }

    protected JComponent createCenterPanel() {
        return null;
    }

    private String getText() {
        return this.myField.getText();
    }

    @Nullable
    protected final Coordinates getCoordinates() {
        Matcher m = this.myPattern.matcher(this.getText());
        if (!m.matches()) {
            return null;
        }
        int l = StringUtil.parseInt((String)m.group(1), (int)(this.getLine() + 1));
        int c = StringUtil.parseInt((String)m.group(2), (int)-1);
        return l > 0 ? new Coordinates(l - 1, Math.max(0, c - 1)) : null;
    }

    protected abstract int getLine();

    protected abstract int getColumn();

    protected abstract int getOffset();

    protected abstract int getMaxOffset();

    protected abstract int coordinatesToOffset(@NotNull Coordinates var1);

    @NotNull
    protected abstract Coordinates offsetToCoordinates(int var1);

    protected JComponent createNorthPanel() {
        JPanel panel2 = new JPanel(new GridBagLayout());
        GridBagConstraints gbConstraints = new GridBagConstraints();
        gbConstraints.insets = JBUI.insets((int)4, (int)0, (int)8, (int)8);
        gbConstraints.fill = 3;
        gbConstraints.weightx = 0.0;
        gbConstraints.weighty = 1.0;
        gbConstraints.anchor = 13;
        JLabel label2 = new JLabel(IdeBundle.message((String)"label.line.column", (Object[])new Object[0]));
        panel2.add((Component)label2, gbConstraints);
        gbConstraints.fill = 1;
        gbConstraints.weightx = 1.0;
        class MyTextField
        extends JTextField {
            MyTextField() {
                super("");
                this.addFocusListener(new FocusAdapter(){

                    @Override
                    public void focusGained(FocusEvent e) {
                        if (!e.isTemporary()) {
                            this.selectAll();
                        }
                    }
                });
            }

            @Override
            public Dimension getPreferredSize() {
                Dimension d = super.getPreferredSize();
                return new Dimension(200, d.height);
            }
        }
        this.myField = new MyTextField();
        panel2.add((Component)this.myField, gbConstraints);
        this.myField.setText(String.format("%d:%d", this.getLine() + 1, this.getColumn() + 1));
        if (ApplicationManager.getApplication().isInternal()) {
            gbConstraints.gridy = 1;
            gbConstraints.weightx = 0.0;
            gbConstraints.weighty = 1.0;
            gbConstraints.anchor = 13;
            JLabel offsetLabel = new JLabel(IdeBundle.message((String)"label.offset", (Object[])new Object[0]));
            panel2.add((Component)offsetLabel, gbConstraints);
            gbConstraints.fill = 1;
            gbConstraints.weightx = 1.0;
            this.myOffsetField = new MyTextField();
            panel2.add((Component)this.myOffsetField, gbConstraints);
            this.myOffsetField.setText(String.valueOf(this.getOffset()));
            DocumentAdapter valueSync = new DocumentAdapter(){
                boolean inSync;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                protected void textChanged(@NotNull DocumentEvent e) {
                    if (e == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (this.inSync) {
                        return;
                    }
                    this.inSync = true;
                    String s = "<invalid>";
                    JTextComponent f = null;
                    try {
                        if (e.getDocument() == GotoLineNumberDialog.this.myField.getDocument()) {
                            f = GotoLineNumberDialog.this.myOffsetField;
                            Coordinates p = GotoLineNumberDialog.this.getCoordinates();
                            s = p == null ? s : String.valueOf(GotoLineNumberDialog.this.coordinatesToOffset(p));
                        } else {
                            f = GotoLineNumberDialog.this.myField;
                            int offset = StringUtil.parseInt((String)GotoLineNumberDialog.this.myOffsetField.getText(), (int)-1);
                            Coordinates p = offset >= 0 ? GotoLineNumberDialog.this.offsetToCoordinates(Math.min(GotoLineNumberDialog.this.getMaxOffset() - 1, offset)) : null;
                            s = p == null ? s : String.format("%d:%d", p.row + 1, p.column + 1);
                        }
                        f.setText(s);
                    }
                    catch (IndexOutOfBoundsException ignored) {
                        if (f != null) {
                            f.setText(s);
                        }
                    }
                    finally {
                        this.inSync = false;
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/util/GotoLineNumberDialog$1", "textChanged"));
                }
            };
            this.myField.getDocument().addDocumentListener((DocumentListener)valueSync);
            this.myOffsetField.getDocument().addDocumentListener((DocumentListener)valueSync);
        }
        return panel2;
    }

    protected static class Coordinates {
        public final int row;
        public final int column;

        public Coordinates(int row2, int column2) {
            this.row = row2;
            this.column = column2;
        }
    }
}

