/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.idea;

import com.intellij.diagnostic.Activity;
import com.intellij.diagnostic.LoadingState;
import com.intellij.diagnostic.StartUpMeasurer;
import com.intellij.featureStatistics.fusCollectors.LifecycleUsageTriggerCollector;
import com.intellij.ide.AppLifecycleListener;
import com.intellij.ide.RecentProjectsManager;
import com.intellij.ide.customize.CustomizeIDEWizardStepsProvider;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.idea.IdeStarter;
import com.intellij.idea.IdeStarterKt;
import com.intellij.internal.inspector.UiInspectorAction;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationStarter;
import com.intellij.openapi.application.JetBrainsProtocolHandler;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.impl.welcomeScreen.WelcomeFrame;
import com.intellij.ui.AppUIUtil;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ForkJoinPool;
import java.util.function.Consumer;
import javax.swing.JOptionPane;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u0000 \u00152\u00020\u0001:\u0002\u0015\u0016B\u0005\u00a2\u0006\u0002\u0010\u0002J\n\u0010\u0003\u001a\u0004\u0018\u00010\u0004H\u0016J\u0006\u0010\u0005\u001a\u00020\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0016\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\fH\u0016J*\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000e2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\f2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0014J\u0018\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\bH\u0002\u00a8\u0006\u0017"}, d2={"Lcom/intellij/idea/IdeStarter;", "Lcom/intellij/openapi/application/ApplicationStarter;", "()V", "getCommandName", "", "getRequiredModality", "", "isHeadless", "", "main", "", "args", "", "openProjectIfNeeded", "Ljava/util/concurrent/CompletableFuture;", "app", "Lcom/intellij/openapi/application/ex/ApplicationEx;", "lifecyclePublisher", "Lcom/intellij/ide/AppLifecycleListener;", "showWelcomeFrame", "willOpenProject", "Companion", "StandaloneLightEditStarter", "intellij.platform.ide.impl"})
public class IdeStarter
implements ApplicationStarter {
    private static List<? extends Path> filesToLoad;
    private static CustomizeIDEWizardStepsProvider wizardStepProvider;
    @NotNull
    public static final Companion Companion;

    public boolean isHeadless() {
        return false;
    }

    @Nullable
    public String getCommandName() {
        return null;
    }

    public final int getRequiredModality() {
        return 3;
    }

    public void main(@NotNull List<String> args) {
        ApplicationEx app;
        Intrinsics.checkNotNullParameter(args, (String)"args");
        ApplicationEx applicationEx = app = ApplicationManagerEx.getApplicationEx();
        Intrinsics.checkNotNullExpressionValue((Object)applicationEx, (String)"app");
        boolean bl = !applicationEx.isDispatchThread();
        boolean bl2 = false;
        boolean bl3 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl4 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        if (app.isLightEditMode() && !app.isHeadlessEnvironment()) {
            ForkJoinPool.commonPool().execute(main.1.INSTANCE);
        }
        Object object = app.getMessageBus().syncPublisher(AppLifecycleListener.TOPIC);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"app.messageBus.syncPubli\u2026pLifecycleListener.TOPIC)");
        AppLifecycleListener lifecyclePublisher = (AppLifecycleListener)object;
        this.openProjectIfNeeded(args, app, lifecyclePublisher).thenRun(new Runnable(app, lifecyclePublisher){
            final /* synthetic */ ApplicationEx $app;
            final /* synthetic */ AppLifecycleListener $lifecyclePublisher;

            public final void run() {
                IdeStarterKt.access$reportPluginErrors();
                ApplicationEx applicationEx = this.$app;
                Intrinsics.checkNotNullExpressionValue((Object)applicationEx, (String)"app");
                if (!applicationEx.isHeadlessEnvironment()) {
                    ApplicationEx applicationEx2 = this.$app;
                    Intrinsics.checkNotNullExpressionValue((Object)applicationEx2, (String)"app");
                    IdeStarterKt.access$postOpenUiTasks(applicationEx2);
                }
                StartUpMeasurer.compareAndSetCurrentState((LoadingState)LoadingState.COMPONENTS_LOADED, (LoadingState)LoadingState.APP_STARTED);
                this.$lifecyclePublisher.appStarted();
                ApplicationEx applicationEx3 = this.$app;
                Intrinsics.checkNotNullExpressionValue((Object)applicationEx3, (String)"app");
                if (!applicationEx3.isHeadlessEnvironment() && PluginManagerCore.isRunningFromSources()) {
                    AppUIUtil.updateWindowIcon(JOptionPane.getRootFrame());
                }
            }
            {
                this.$app = applicationEx;
                this.$lifecyclePublisher = appLifecycleListener;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected CompletableFuture<?> openProjectIfNeeded(@NotNull List<String> args, @NotNull ApplicationEx app, @NotNull AppLifecycleListener lifecyclePublisher) {
        void $this$runChild$iv;
        Activity frameInitActivity;
        Intrinsics.checkNotNullParameter(args, (String)"args");
        Intrinsics.checkNotNullParameter((Object)app, (String)"app");
        Intrinsics.checkNotNullParameter((Object)lifecyclePublisher, (String)"lifecyclePublisher");
        Activity activity = StartUpMeasurer.startActivity((String)"frame initialization");
        Intrinsics.checkNotNullExpressionValue((Object)activity, (String)"startActivity(\"frame initialization\")");
        Activity activity2 = frameInitActivity = activity;
        String name$iv = "app frame created callback";
        boolean $i$f$runChild = false;
        void v1 = $this$runChild$iv;
        Activity activity$iv = v1 != null ? v1.startChild(name$iv) : null;
        boolean bl = false;
        lifecyclePublisher.appFrameCreated(args);
        Unit result$iv = Unit.INSTANCE;
        Activity activity3 = activity$iv;
        if (activity3 != null) {
            activity3.end();
        }
        if (app.isHeadlessEnvironment()) {
            frameInitActivity.end();
            LifecycleUsageTriggerCollector.onIdeStart();
            lifecyclePublisher.appStarting(null);
            CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
            Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"CompletableFuture.completedFuture(null)");
            return completableFuture;
        }
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
        if (application.isInternal()) {
            UiInspectorAction.initGlobalInspector();
        }
        if (JetBrainsProtocolHandler.appStartedWithCommand()) {
            boolean needToOpenProject = this.showWelcomeFrame(lifecyclePublisher, false);
            frameInitActivity.end();
            LifecycleUsageTriggerCollector.onIdeStart();
            Project project = !needToOpenProject ? null : (!filesToLoad.isEmpty() ? ProjectUtil.tryOpenFiles(null, filesToLoad, "MacMenu") : (!args.isEmpty() ? IdeStarterKt.access$loadProjectFromExternalCommandLine(args) : null));
            lifecyclePublisher.appStarting(project);
        } else {
            RecentProjectsManager recentProjectManager = RecentProjectsManager.getInstance();
            boolean willReopenRecentProjectOnStart = recentProjectManager.willReopenProjectOnStart();
            boolean willOpenProject = willReopenRecentProjectOnStart || !args.isEmpty() || !filesToLoad.isEmpty();
            boolean needToOpenProject = this.showWelcomeFrame(lifecyclePublisher, willOpenProject);
            frameInitActivity.end();
            ForkJoinPool.commonPool().execute(openProjectIfNeeded.2.INSTANCE);
            if (!needToOpenProject) {
                lifecyclePublisher.appStarting(null);
                CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
                Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"CompletableFuture.completedFuture(null)");
                return completableFuture;
            }
            Project project = !filesToLoad.isEmpty() ? ProjectUtil.tryOpenFiles(null, filesToLoad, "MacMenu") : (!args.isEmpty() ? IdeStarterKt.access$loadProjectFromExternalCommandLine(args) : null);
            lifecyclePublisher.appStarting(project);
            if (project == null && willReopenRecentProjectOnStart) {
                CompletionStage completionStage = recentProjectManager.reopenLastProjectsOnStart().thenAccept((Consumer)openProjectIfNeeded.3.INSTANCE);
                Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"recentProjectManager.reo\u2026            }\n          }");
                return completionStage;
            }
        }
        CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
        Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"CompletableFuture.completedFuture(null)");
        return completableFuture;
    }

    private final boolean showWelcomeFrame(AppLifecycleListener lifecyclePublisher, boolean willOpenProject) {
        Runnable doShowWelcomeFrame;
        Runnable runnable2 = doShowWelcomeFrame = willOpenProject ? null : WelcomeFrame.prepareToShow();
        if (doShowWelcomeFrame == null) {
            return true;
        }
        ApplicationManager.getApplication().invokeLater(new Runnable(doShowWelcomeFrame, lifecyclePublisher){
            final /* synthetic */ Runnable $doShowWelcomeFrame;
            final /* synthetic */ AppLifecycleListener $lifecyclePublisher;

            public final void run() {
                this.$doShowWelcomeFrame.run();
                this.$lifecyclePublisher.welcomeScreenDisplayed();
            }
            {
                this.$doShowWelcomeFrame = runnable2;
                this.$lifecyclePublisher = appLifecycleListener;
            }
        });
        return false;
    }

    static {
        Companion = new Companion(null);
        List list2 = Collections.emptyList();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"Collections.emptyList()");
        filesToLoad = list2;
    }

    public static final /* synthetic */ CustomizeIDEWizardStepsProvider access$getWizardStepProvider$cp() {
        return wizardStepProvider;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J*\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0014\u00a8\u0006\f"}, d2={"Lcom/intellij/idea/IdeStarter$StandaloneLightEditStarter;", "Lcom/intellij/idea/IdeStarter;", "()V", "openProjectIfNeeded", "Ljava/util/concurrent/CompletableFuture;", "args", "", "", "app", "Lcom/intellij/openapi/application/ex/ApplicationEx;", "lifecyclePublisher", "Lcom/intellij/ide/AppLifecycleListener;", "intellij.platform.ide.impl"})
    public static final class StandaloneLightEditStarter
    extends IdeStarter {
        @Override
        @NotNull
        protected CompletableFuture<?> openProjectIfNeeded(@NotNull List<String> args, @NotNull ApplicationEx app, @NotNull AppLifecycleListener lifecyclePublisher) {
            Project project;
            Intrinsics.checkNotNullParameter(args, (String)"args");
            Intrinsics.checkNotNullParameter((Object)app, (String)"app");
            Intrinsics.checkNotNullParameter((Object)lifecyclePublisher, (String)"lifecyclePublisher");
            Object object = !filesToLoad.isEmpty() ? ProjectUtil.tryOpenFiles(null, filesToLoad, "MacMenu") : (project = !args.isEmpty() ? IdeStarterKt.access$loadProjectFromExternalCommandLine(args) : null);
            if (project != null || JetBrainsProtocolHandler.appStartedWithCommand()) {
                CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
                Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"CompletableFuture.completedFuture(null)");
                return completableFuture;
            }
            RecentProjectsManager recentProjectManager = RecentProjectsManager.getInstance();
            CompletionStage completionStage = (recentProjectManager.willReopenProjectOnStart() ? recentProjectManager.reopenLastProjectsOnStart() : CompletableFuture.completedFuture(true)).thenAccept((Consumer)openProjectIfNeeded.1.INSTANCE);
            Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"(if (recentProjectManage\u2026  }\n          }\n        }");
            return completionStage;
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004J\u000e\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u0007R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/idea/IdeStarter$Companion;", "", "()V", "filesToLoad", "", "Ljava/nio/file/Path;", "wizardStepProvider", "Lcom/intellij/ide/customize/CustomizeIDEWizardStepsProvider;", "openFilesOnLoading", "", "value", "setWizardStepsProvider", "provider", "intellij.platform.ide.impl"})
    public static final class Companion {
        public final void openFilesOnLoading(@NotNull List<? extends Path> value2) {
            Intrinsics.checkNotNullParameter(value2, (String)"value");
            filesToLoad = value2;
        }

        public final void setWizardStepsProvider(@NotNull CustomizeIDEWizardStepsProvider provider2) {
            Intrinsics.checkNotNullParameter((Object)provider2, (String)"provider");
            wizardStepProvider = provider2;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

