/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal;

import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.lang.management.ManagementFactory;
import java.lang.reflect.InvocationTargetException;
import java.util.Properties;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DebugAttachDetector {
    private static final Logger LOG = Logger.getInstance(DebugAttachDetector.class);
    private Properties myAgentProperties;
    private ScheduledFuture<?> myTask;
    private boolean myAttached;
    private boolean myReady;
    @Nullable
    private static final String DEBUG_ARGS = DebugAttachDetector.getDebugArgs();

    public DebugAttachDetector() {
        Application app;
        block8: {
            Class<?> vmSupportClass;
            this.myAgentProperties = null;
            try {
                vmSupportClass = Class.forName("jdk.internal.vm.VMSupport");
            }
            catch (Exception e) {
                try {
                    vmSupportClass = Class.forName("sun.misc.VMSupport");
                }
                catch (Exception ignored) {
                    LOG.warn("Unable to init DebugAttachDetector, VMSupport class not found");
                    return;
                }
            }
            app = ApplicationManager.getApplication();
            try {
                this.myAgentProperties = (Properties)vmSupportClass.getMethod("getAgentProperties", new Class[0]).invoke(null, new Object[0]);
            }
            catch (NoSuchMethodException | InvocationTargetException ex) {
                LOG.error((Throwable)ex);
            }
            catch (IllegalAccessException ex) {
                if (!app.isInternal() || PluginManagerCore.isRunningFromSources()) break block8;
                LOG.warn("Unable to start DebugAttachDetector, please add `--add-exports java.base/jdk.internal.vm=ALL-UNNAMED` to VM options");
            }
        }
        if (this.myAgentProperties == null || !app.isInternal() || app.isUnitTestMode() || Boolean.getBoolean("disable.attach.detector") || PluginManagerCore.isRunningFromSources() || !DebugAttachDetector.isDebugEnabled()) {
            return;
        }
        this.myTask = AppExecutorUtil.getAppScheduledExecutorService().scheduleWithFixedDelay(() -> {
            boolean attached = DebugAttachDetector.isAttached(this.myAgentProperties);
            if (!this.myReady) {
                this.myAttached = attached;
                this.myReady = true;
            } else if (attached != this.myAttached) {
                this.myAttached = attached;
                Notifications.Bus.notify((Notification)new Notification("System Messages", "Remote debugger", this.myAttached ? "attached" : "detached", NotificationType.WARNING));
            }
        }, 5L, 5L, TimeUnit.SECONDS);
    }

    private static boolean isAttached(@NotNull Properties properties) {
        String property2;
        if (properties == null) {
            DebugAttachDetector.$$$reportNull$$$0(0);
        }
        return (property2 = properties.getProperty("sun.jdwp.listenerAddress")) != null && property2.isEmpty();
    }

    @Nullable
    private static String getDebugArgs() {
        for (String value2 : ManagementFactory.getRuntimeMXBean().getInputArguments()) {
            if (!value2.contains("-agentlib:jdwp")) continue;
            return value2;
        }
        return null;
    }

    public static boolean isDebugEnabled() {
        return DEBUG_ARGS != null;
    }

    private static boolean isDebugServer() {
        return DEBUG_ARGS != null && DEBUG_ARGS.contains("server=y");
    }

    public static boolean isAttached() {
        if (!DebugAttachDetector.isDebugEnabled()) {
            return false;
        }
        if (!DebugAttachDetector.isDebugServer()) {
            return true;
        }
        Properties properties = ((DebugAttachDetector)ApplicationManager.getApplication().getService(DebugAttachDetector.class)).myAgentProperties;
        if (properties == null) {
            return true;
        }
        return DebugAttachDetector.isAttached(properties);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "com/intellij/internal/DebugAttachDetector", "isAttached"));
    }
}

