/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.retype;

import com.intellij.internal.retype.RetypeSessionKt;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import java.util.ArrayList;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\f\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0015\u001a\u00020\u0016J\b\u0010\u0017\u001a\u00020\u0016H\u0002J\b\u0010\u0018\u001a\u00020\u0016H\u0002J\u0006\u0010\u0019\u001a\u00020\u0016J\u000e\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u001cJ\u000e\u0010\u001d\u001a\u00020\u00162\u0006\u0010\u001e\u001a\u00020\u000eJ\u000e\u0010\u001f\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u001cR\u0016\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001e\u0010\n\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0010\u001a\u0012\u0012\u0004\u0012\u00020\u000e0\u0011j\b\u0012\u0004\u0012\u00020\u000e`\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0013\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\f\u00a8\u0006 "}, d2={"Lcom/intellij/internal/retype/RetypeLog;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "<set-?>", "", "completedChars", "getCompletedChars", "()I", "currentCompletion", "", "currentTyping", "log", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "typedChars", "getTypedChars", "flush", "", "flushCompletion", "flushTyping", "printToStdout", "recordCompletion", "c", "", "recordDesync", "message", "recordTyping", "intellij.platform.lang.impl"})
public final class RetypeLog {
    @NotNull
    private final Logger LOG;
    private final ArrayList<String> log;
    private String currentTyping;
    private String currentCompletion;
    private int typedChars;
    private int completedChars;

    @NotNull
    public final Logger getLOG() {
        return this.LOG;
    }

    public final int getTypedChars() {
        return this.typedChars;
    }

    public final int getCompletedChars() {
        return this.completedChars;
    }

    public final void recordTyping(char c) {
        if (this.currentTyping == null) {
            this.flushCompletion();
            this.currentTyping = "";
        }
        this.currentTyping = Intrinsics.stringPlus((String)this.currentTyping, (Object)RetypeSessionKt.toReadable(String.valueOf(c)));
        int n = this.typedChars;
        this.typedChars = n + 1;
    }

    public final void recordCompletion(char c) {
        if (this.currentCompletion == null) {
            this.flushTyping();
            this.currentCompletion = "";
        }
        this.currentCompletion = Intrinsics.stringPlus((String)this.currentCompletion, (Object)RetypeSessionKt.toReadable(String.valueOf(c)));
        int n = this.completedChars;
        this.completedChars = n + 1;
    }

    public final void recordDesync(@NotNull String message2) {
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        this.flush();
        this.log.add("Desync: " + message2);
    }

    public final void flush() {
        this.flushTyping();
        this.flushCompletion();
    }

    private final void flushTyping() {
        if (this.currentTyping != null) {
            this.log.add("Type: " + this.currentTyping);
            this.currentTyping = null;
        }
    }

    private final void flushCompletion() {
        if (this.currentCompletion != null) {
            this.log.add("Complete: " + this.currentCompletion);
            this.currentCompletion = null;
        }
    }

    public final void printToStdout() {
        for (String s : this.log) {
            Application application = ApplicationManager.getApplication();
            Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
            if (application.isUnitTestMode()) {
                this.LOG.debug(s);
                continue;
            }
            boolean bl = false;
            System.out.println((Object)s);
        }
    }

    public RetypeLog() {
        Logger logger = Logger.getInstance(RetypeLog.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(RetypeLog::class.java)");
        this.LOG = logger;
        boolean bl = false;
        this.log = new ArrayList();
    }
}

