/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.fileTypes;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.internal.statistic.fileTypes.FileTypeStatisticProvider;
import com.intellij.internal.statistic.fileTypes.UpdateComponentWatcher;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.updateSettings.impl.PluginDownloader;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.ObjectUtils;
import com.intellij.util.io.HttpRequests;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u00002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\u001a\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0002\u001a\u0018\u0010\r\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0002\u001a\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000bH\u0002\u001a\u0018\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0002\"\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0013\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"EP_NAME", "Lcom/intellij/openapi/extensions/ExtensionPointName;", "Lcom/intellij/internal/statistic/fileTypes/FileTypeStatisticProvider;", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "lock", "", "checkUpdateRequired", "", "pluginIdString", "", "pluginVersion", "getUpdateUrl", "sendRequest", "", "url", "update", "intellij.platform.ide.impl"})
public final class UpdateComponentWatcherKt {
    private static final ExtensionPointName<FileTypeStatisticProvider> EP_NAME = new ExtensionPointName("com.intellij.fileTypeStatisticProvider");
    private static final Object lock;
    private static final Logger LOG;

    private static final void update(String pluginIdString, String pluginVersion) {
        String url = UpdateComponentWatcherKt.getUpdateUrl(pluginIdString, pluginVersion);
        UpdateComponentWatcherKt.sendRequest(url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final boolean checkUpdateRequired(String pluginIdString, String pluginVersion) {
        Object object = lock;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            PropertiesComponent properties;
            String lastUpdateKey;
            String lastVersionKey;
            block4: {
                boolean shouldUpdate;
                boolean bl3 = false;
                lastVersionKey = pluginIdString + ".LAST_VERSION";
                lastUpdateKey = pluginIdString + ".LAST_UPDATE";
                properties = PropertiesComponent.getInstance();
                String lastPluginVersion = properties.getValue(lastVersionKey);
                long lastUpdate = properties.getLong(lastUpdateKey, 0L);
                boolean bl4 = shouldUpdate = lastUpdate == 0L || System.currentTimeMillis() - lastUpdate > TimeUnit.DAYS.toMillis(1L) || lastPluginVersion == null || Intrinsics.areEqual((Object)lastPluginVersion, (Object)pluginVersion) ^ true;
                if (shouldUpdate) break block4;
                boolean bl5 = false;
                return bl5;
            }
            properties.setValue(lastUpdateKey, String.valueOf(System.currentTimeMillis()));
            properties.setValue(lastVersionKey, pluginVersion);
            boolean bl6 = true;
            return bl6;
        }
    }

    private static final void sendRequest(String url) {
        try {
            HttpRequests.request((String)url).connect(new HttpRequests.RequestProcessor(url){
                final /* synthetic */ String $url;

                public final void process(@NotNull HttpRequests.Request it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    try {
                        JDOMUtil.load((InputStream)it.getInputStream());
                    }
                    catch (JDOMException e) {
                        UpdateComponentWatcherKt.access$getLOG$p().warn((Throwable)e);
                    }
                    UpdateComponentWatcherKt.access$getLOG$p().info("updated: " + this.$url);
                }
                {
                    this.$url = string;
                }
            });
        }
        catch (UnknownHostException unknownHostException) {
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
        }
    }

    private static final String getUpdateUrl(String pluginIdString, String pluginVersion) {
        ApplicationInfoEx applicationInfo;
        ApplicationInfoEx applicationInfoEx = applicationInfo = ApplicationInfoEx.getInstanceEx();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)applicationInfoEx), (String)"applicationInfo");
        String string = applicationInfoEx.getBuild().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"applicationInfo.build.asString()");
        String buildNumber = string;
        String os = URLEncoder.encode(SystemInfo.OS_NAME + ' ' + SystemInfo.OS_VERSION, Charsets.UTF_8.name());
        String uid = PluginDownloader.getMarketplaceDownloadsUUID();
        String baseUrl = "https://plugins.jetbrains.com/plugins/list";
        return baseUrl + "?pluginId=" + pluginIdString + "&build=" + buildNumber + "&pluginVersion=" + pluginVersion + "&os=" + os + "&uuid=" + uid;
    }

    static {
        Object object = ObjectUtils.sentinel((String)"updating_monitor");
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"ObjectUtils.sentinel(\"updating_monitor\")");
        lock = object;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(UpdateComponentWatcher.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        LOG = logger;
    }

    public static final /* synthetic */ ExtensionPointName access$getEP_NAME$p() {
        return EP_NAME;
    }

    public static final /* synthetic */ Logger access$getLOG$p() {
        return LOG;
    }

    public static final /* synthetic */ boolean access$checkUpdateRequired(String pluginIdString, String pluginVersion) {
        return UpdateComponentWatcherKt.checkUpdateRequired(pluginIdString, pluginVersion);
    }

    public static final /* synthetic */ void access$update(String pluginIdString, String pluginVersion) {
        UpdateComponentWatcherKt.update(pluginIdString, pluginVersion);
    }
}

