/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.notification;

import com.intellij.application.Topics;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.featureStatistics.FeatureUsageTrackerImpl;
import com.intellij.ide.FrameStateListener;
import com.intellij.ide.StatisticsNotificationManager;
import com.intellij.ide.gdpr.ConsentOptions;
import com.intellij.internal.statistic.persistence.UsageStatisticsPersistenceComponent;
import com.intellij.internal.statistic.utils.StatisticsUploadAssistant;
import com.intellij.notification.impl.NotificationsConfigurationImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.openapi.wm.impl.ProjectFrameHelper;
import com.intellij.ui.AppUIUtil;
import com.intellij.ui.BalloonLayout;
import com.intellij.ui.BalloonLayoutImpl;
import com.intellij.util.messages.Topic;
import java.awt.Window;
import org.jetbrains.annotations.Nullable;

final class StatisticsNotificationManagerImpl
implements StatisticsNotificationManager {
    StatisticsNotificationManagerImpl() {
    }

    public void showNotificationIfNeeded() {
        if (!StatisticsNotificationManagerImpl.isShouldShowNotification()) {
            return;
        }
        NotificationsConfigurationImpl.remove("SendUsagesStatistics");
        final Disposable disposable2 = Disposer.newDisposable();
        Topics.subscribe((Topic)FrameStateListener.TOPIC, (Disposable)disposable2, (Object)new FrameStateListener(){

            public void onFrameActivated() {
                if (StatisticsNotificationManagerImpl.isEmpty(WindowManagerEx.getInstanceEx().getMostRecentFocusedWindow())) {
                    ApplicationManager.getApplication().invokeLater(() -> StatisticsNotificationManagerImpl.showNotification());
                    Disposer.dispose((Disposable)disposable2);
                }
            }
        });
    }

    private static boolean isShouldShowNotification() {
        return UsageStatisticsPersistenceComponent.getInstance().isShowNotification() && System.currentTimeMillis() - 604800000L > ((FeatureUsageTrackerImpl)FeatureUsageTracker.getInstance()).getFirstRunTime();
    }

    private static void showNotification() {
        if (AppUIUtil.showConsentsAgreementIfNeeded(Logger.getInstance(StatisticsNotificationManagerImpl.class), ConsentOptions.condUsageStatsConsent())) {
            ApplicationManager.getApplication().executeOnPooledThread(() -> StatisticsUploadAssistant.getEventLogStatisticsService((String)"FUS").send());
            UsageStatisticsPersistenceComponent.getInstance().setShowNotification(false);
        }
    }

    private static boolean isEmpty(@Nullable Window window) {
        BalloonLayout layout;
        ProjectFrameHelper frameHelper = ProjectFrameHelper.getFrameHelper(window);
        if (frameHelper != null && (layout = frameHelper.getBalloonLayout()) instanceof BalloonLayoutImpl) {
            return ((BalloonLayoutImpl)layout).isEmpty();
        }
        return false;
    }
}

