/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.json.codeinsight;

import com.intellij.json.JsonBundle;
import com.intellij.json.codeinsight.JsonLiteralChecker;
import com.intellij.json.highlighting.JsonSyntaxHighlighterFactory;
import com.intellij.json.psi.JsonNumberLiteral;
import com.intellij.json.psi.JsonPsiUtil;
import com.intellij.json.psi.JsonReferenceExpression;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class JsonLiteralAnnotator
implements Annotator {
    public void annotate(@NotNull PsiElement element2, @NotNull AnnotationHolder holder) {
        block8: {
            List extensions2;
            block9: {
                block7: {
                    if (element2 == null) {
                        JsonLiteralAnnotator.$$$reportNull$$$0(0);
                    }
                    if (holder == null) {
                        JsonLiteralAnnotator.$$$reportNull$$$0(1);
                    }
                    extensions2 = JsonLiteralChecker.EP_NAME.getExtensionList();
                    if (!(element2 instanceof JsonReferenceExpression)) break block7;
                    JsonLiteralAnnotator.highlightPropertyKey(element2, holder);
                    break block8;
                }
                if (!(element2 instanceof JsonStringLiteral)) break block9;
                JsonStringLiteral stringLiteral = (JsonStringLiteral)element2;
                int elementOffset = element2.getTextOffset();
                JsonLiteralAnnotator.highlightPropertyKey(element2, holder);
                String text2 = JsonPsiUtil.getElementTextWithoutHostEscaping(element2);
                int length = text2.length();
                if (length <= 1 || text2.charAt(0) != text2.charAt(length - 1) || JsonPsiUtil.isEscapedChar(text2, length - 1)) {
                    holder.newAnnotation(HighlightSeverity.ERROR, JsonBundle.message("syntax.error.missing.closing.quote", new Object[0])).create();
                }
                List<Pair<TextRange, String>> fragments = stringLiteral.getTextFragments();
                for (Pair<TextRange, String> fragment2 : fragments) {
                    for (JsonLiteralChecker checker : extensions2) {
                        Pair<TextRange, String> error2;
                        if (!checker.isApplicable(element2) || (error2 = checker.getErrorForStringFragment(fragment2, stringLiteral)) == null) continue;
                        holder.newAnnotation(HighlightSeverity.ERROR, (String)error2.second).range(((TextRange)error2.getFirst()).shiftRight(elementOffset)).create();
                    }
                }
                break block8;
            }
            if (!(element2 instanceof JsonNumberLiteral)) break block8;
            String text3 = null;
            for (JsonLiteralChecker checker : extensions2) {
                String error3;
                if (!checker.isApplicable(element2)) continue;
                if (text3 == null) {
                    text3 = JsonPsiUtil.getElementTextWithoutHostEscaping(element2);
                }
                if ((error3 = checker.getErrorForNumericLiteral(text3)) == null) continue;
                holder.newAnnotation(HighlightSeverity.ERROR, error3).create();
            }
        }
    }

    private static void highlightPropertyKey(@NotNull PsiElement element2, @NotNull AnnotationHolder holder) {
        if (element2 == null) {
            JsonLiteralAnnotator.$$$reportNull$$$0(2);
        }
        if (holder == null) {
            JsonLiteralAnnotator.$$$reportNull$$$0(3);
        }
        if (JsonPsiUtil.isPropertyKey(element2)) {
            if (Holder.DEBUG) {
                holder.newAnnotation(HighlightSeverity.INFORMATION, JsonBundle.message("annotation.property.key", new Object[0])).textAttributes(JsonSyntaxHighlighterFactory.JSON_PROPERTY_KEY).create();
            } else {
                holder.newSilentAnnotation(HighlightSeverity.INFORMATION).textAttributes(JsonSyntaxHighlighterFactory.JSON_PROPERTY_KEY).create();
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        objectArray2[1] = "com/intellij/json/codeinsight/JsonLiteralAnnotator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "annotate";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "highlightPropertyKey";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class Holder {
        private static final boolean DEBUG = ApplicationManager.getApplication().isUnitTestMode();

        private Holder() {
        }
    }
}

