/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.json.intentions;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.ide.lightEdit.LightEditCompatible;
import com.intellij.json.JsonBundle;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonSortPropertiesIntention
implements IntentionAction,
LowPriorityAction,
LightEditCompatible,
DumbAware {
    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getText() {
        String string = JsonBundle.message("json.intention.sort.properties", new Object[0]);
        if (string == null) {
            JsonSortPropertiesIntention.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        String string = JsonBundle.message("json.intention.sort.properties", new Object[0]);
        if (string == null) {
            JsonSortPropertiesIntention.$$$reportNull$$$0(1);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file2) {
        PsiElement parent;
        if (project == null) {
            JsonSortPropertiesIntention.$$$reportNull$$$0(2);
        }
        return (parent = JsonSortPropertiesIntention.findParentObject(editor, file2)) instanceof JsonObject && !JsonSortPropertiesIntention.isSorted((JsonObject)parent);
    }

    @Nullable
    private static PsiElement findParentObject(@NotNull Editor editor, @NotNull PsiFile file2) {
        PsiElement element2;
        JsonProperty property2;
        if (editor == null) {
            JsonSortPropertiesIntention.$$$reportNull$$$0(3);
        }
        if (file2 == null) {
            JsonSortPropertiesIntention.$$$reportNull$$$0(4);
        }
        return (property2 = (JsonProperty)PsiTreeUtil.getParentOfType((PsiElement)(element2 = file2.findElementAt(editor.getCaretModel().getOffset())), JsonProperty.class)) == null ? null : property2.getParent();
    }

    private static boolean isSorted(@NotNull JsonObject parent) {
        List<JsonProperty> list2;
        if (parent == null) {
            JsonSortPropertiesIntention.$$$reportNull$$$0(5);
        }
        if ((list2 = parent.getPropertyList()).size() <= 1) {
            return true;
        }
        List names2 = ContainerUtil.map(list2, p -> p.getName());
        return ContainerUtil.equalsIdentity((List)ContainerUtil.sorted((Collection)names2), (List)names2);
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file2) throws IncorrectOperationException {
        if (project == null) {
            JsonSortPropertiesIntention.$$$reportNull$$$0(6);
        }
        if (!CommonRefactoringUtil.checkReadOnlyStatus((Project)project, (PsiElement)file2)) {
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)JsonBundle.message("file.is.readonly", new Object[0]), (String)JsonBundle.message("cannot.sort.properties", new Object[0]), null);
            return;
        }
        PsiElement parentObject = JsonSortPropertiesIntention.findParentObject(editor, file2);
        assert (parentObject instanceof JsonObject);
        JsonSortPropertiesIntention.cycleSortProperties(((JsonObject)parentObject).getPropertyList());
        SmartPsiElementPointer pointer = SmartPointerManager.createPointer((PsiElement)parentObject);
        PsiDocumentManager.getInstance((Project)project).doPostponedOperationsAndUnblockDocument(editor.getDocument());
        PsiElement element2 = pointer.getElement();
        if (element2 == null) {
            return;
        }
        CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)project);
        codeStyleManager.reformatText(element2.getContainingFile(), Collections.singleton(element2.getTextRange()));
    }

    public boolean startInWriteAction() {
        return true;
    }

    private static void cycleSortProperties(@NotNull List<JsonProperty> properties) {
        if (properties == null) {
            JsonSortPropertiesIntention.$$$reportNull$$$0(7);
        }
        int size2 = properties.size();
        for (int cycleStart = 0; cycleStart < size2; ++cycleStart) {
            JsonProperty item = properties.get(cycleStart);
            int pos = JsonSortPropertiesIntention.advance(properties, size2, cycleStart, item);
            if (pos == -1) continue;
            if (pos != cycleStart) {
                JsonSortPropertiesIntention.exchange(properties, pos, cycleStart);
            }
            while (pos != cycleStart && (pos = JsonSortPropertiesIntention.advance(properties, size2, cycleStart, properties.get(cycleStart))) != -1) {
                if (pos == cycleStart) continue;
                JsonSortPropertiesIntention.exchange(properties, pos, cycleStart);
            }
        }
    }

    private static int advance(@NotNull List<JsonProperty> properties, int size2, int cycleStart, JsonProperty item) {
        if (properties == null) {
            JsonSortPropertiesIntention.$$$reportNull$$$0(8);
        }
        int pos = cycleStart;
        String itemName = item.getName();
        for (int i2 = cycleStart + 1; i2 < size2; ++i2) {
            if (properties.get(i2).getName().compareTo(itemName) >= 0) continue;
            ++pos;
        }
        if (pos == cycleStart) {
            return -1;
        }
        while (Objects.equals(itemName, properties.get(pos).getName())) {
            ++pos;
        }
        return pos;
    }

    private static void exchange(@NotNull List<JsonProperty> properties, int pos, int item) {
        if (properties == null) {
            JsonSortPropertiesIntention.$$$reportNull$$$0(9);
        }
        JsonProperty propertyAtPos = properties.get(pos);
        JsonProperty itemProperty = properties.get(item);
        properties.set(pos, (JsonProperty)propertyAtPos.getParent().addBefore((PsiElement)itemProperty, (PsiElement)propertyAtPos));
        properties.set(item, (JsonProperty)itemProperty.getParent().addBefore((PsiElement)propertyAtPos, (PsiElement)itemProperty));
        propertyAtPos.delete();
        itemProperty.delete();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/json/intentions/JsonSortPropertiesIntention";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/json/intentions/JsonSortPropertiesIntention";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findParentObject";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isSorted";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "cycleSortProperties";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "advance";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "exchange";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

