/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem.impl;

import com.intellij.AbstractBundle;
import com.intellij.BundleBase;
import com.intellij.DynamicBundle;
import com.intellij.diagnostic.LoadingState;
import com.intellij.diagnostic.PluginException;
import com.intellij.diagnostic.StartUpMeasurer;
import com.intellij.icons.AllIcons;
import com.intellij.ide.ActivityTracker;
import com.intellij.ide.DataManager;
import com.intellij.ide.ProhibitAWTEvents;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.RawPluginDescriptor;
import com.intellij.ide.ui.customization.ActionUrl;
import com.intellij.ide.ui.customization.CustomActionsSchema;
import com.intellij.idea.IdeaLogger;
import com.intellij.internal.statistic.collectors.fus.actions.persistence.ActionIdProvider;
import com.intellij.internal.statistic.collectors.fus.actions.persistence.ActionsCollectorImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AbbreviationManager;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionGroupStub;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.ActionStub;
import com.intellij.openapi.actionSystem.ActionStubBase;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.AnActionResult;
import com.intellij.openapi.actionSystem.Anchor;
import com.intellij.openapi.actionSystem.Constraints;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.DefaultCompactActionGroup;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.MouseShortcut;
import com.intellij.openapi.actionSystem.OverridingAction;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.TimerListener;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.actionSystem.ex.ActionPopupMenuListener;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.actionSystem.ex.AnActionListener;
import com.intellij.openapi.actionSystem.impl.AbbreviationManagerImpl;
import com.intellij.openapi.actionSystem.impl.ActionConfigurationCustomizer;
import com.intellij.openapi.actionSystem.impl.ActionPopupMenuImpl;
import com.intellij.openapi.actionSystem.impl.ActionToolbarImpl;
import com.intellij.openapi.actionSystem.impl.ButtonToolbarImpl;
import com.intellij.openapi.actionSystem.impl.ChameleonAction;
import com.intellij.openapi.actionSystem.impl.DynamicActionConfigurationCustomizer;
import com.intellij.openapi.actionSystem.impl.PresentationFactory;
import com.intellij.openapi.actionSystem.impl.ProxyShortcutSet;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationActivationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.application.TransactionGuardImpl;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.actionSystem.EditorAction;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.keymap.ex.KeymapManagerEx;
import com.intellij.openapi.keymap.impl.DefaultKeymap;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.ProjectType;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.openapi.util.text.Strings;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.serviceContainer.ContainerUtilKt;
import com.intellij.ui.icons.IconLoadMeasurer;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.DefaultBundleService;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.XmlElement;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.UIUtil;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.WindowEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class ActionManagerImpl
extends ActionManagerEx
implements Disposable {
    private static final ExtensionPointName<ActionConfigurationCustomizer> EP = new ExtensionPointName("com.intellij.actionConfigurationCustomizer");
    private static final ExtensionPointName<DynamicActionConfigurationCustomizer> DYNAMIC_EP_NAME = new ExtensionPointName("com.intellij.dynamicActionConfigurationCustomizer");
    private static final String ACTION_ELEMENT_NAME = "action";
    private static final String GROUP_ELEMENT_NAME = "group";
    private static final String CLASS_ATTR_NAME = "class";
    private static final String ID_ATTR_NAME = "id";
    private static final String INTERNAL_ATTR_NAME = "internal";
    private static final String ICON_ATTR_NAME = "icon";
    private static final String ADD_TO_GROUP_ELEMENT_NAME = "add-to-group";
    private static final String DESCRIPTION = "description";
    private static final String TEXT_ATTR_NAME = "text";
    private static final String KEY_ATTR_NAME = "key";
    private static final String SEPARATOR_ELEMENT_NAME = "separator";
    private static final String REFERENCE_ELEMENT_NAME = "reference";
    private static final String GROUP_ID_ATTR_NAME = "group-id";
    private static final String KEYMAP_ATTR_NAME = "keymap";
    private static final String REF_ATTR_NAME = "ref";
    private static final String USE_SHORTCUT_OF_ATTR_NAME = "use-shortcut-of";
    private static final String PROJECT_TYPE = "project-type";
    private static final String OVERRIDE_TEXT_ELEMENT_NAME = "override-text";
    private static final String SYNONYM_ELEMENT_NAME = "synonym";
    private static final Logger LOG = Logger.getInstance(ActionManagerImpl.class);
    private static final int DEACTIVATED_TIMER_DELAY = 5000;
    private static final int TIMER_DELAY = 500;
    private static final int UPDATE_DELAY_AFTER_TYPING = 500;
    private final Object myLock = new Object();
    private final Map<String, AnAction> idToAction = CollectionFactory.createSmallMemoryFootprintMap();
    private final MultiMap<PluginId, String> pluginToId = new MultiMap();
    private final Object2IntMap<String> idToIndex = new Object2IntOpenHashMap();
    private final Set<String> myProhibitedActionIds = new HashSet<String>();
    private final Map<Object, String> actionToId = CollectionFactory.createSmallMemoryFootprintMap();
    private final MultiMap<String, String> idToGroupId = new MultiMap();
    private final List<String> myNotRegisteredInternalActionIds = new ArrayList<String>();
    private final List<AnActionListener> myActionListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private final List<ActionPopupMenuListener> myActionPopupMenuListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private final List<Object> myPopups = new ArrayList<Object>();
    private MyTimer myTimer;
    private int myRegisteredActionsCount;
    private String myLastPreformedActionId;
    private String myPrevPerformedActionId;
    private long myLastTimeEditorWasTypedIn;
    private final Map<OverridingAction, AnAction> myBaseActions = new HashMap<OverridingAction, AnAction>();
    private int myAnonymousGroupIdCounter;

    protected ActionManagerImpl() {
        Application app = ApplicationManager.getApplication();
        if (!app.isUnitTestMode()) {
            LoadingState.COMPONENTS_LOADED.checkOccurred();
            if (!app.isHeadlessEnvironment() && !app.isCommandLine()) {
                LOG.assertTrue(!app.isDispatchThread());
            }
        }
        this.registerActions(PluginManagerCore.getLoadedPlugins(null));
        EP.forEachExtensionSafe(customizer -> customizer.customize((ActionManager)this));
        DYNAMIC_EP_NAME.forEachExtensionSafe(customizer -> customizer.registerActions((ActionManager)this));
        DYNAMIC_EP_NAME.addExtensionPointListener((ExtensionPointListener)new ExtensionPointListener<DynamicActionConfigurationCustomizer>(){

            public void extensionAdded(@NotNull DynamicActionConfigurationCustomizer extension2, @NotNull PluginDescriptor pluginDescriptor) {
                if (extension2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (pluginDescriptor == null) {
                    1.$$$reportNull$$$0(1);
                }
                extension2.registerActions((ActionManager)ActionManagerImpl.this);
            }

            public void extensionRemoved(@NotNull DynamicActionConfigurationCustomizer extension2, @NotNull PluginDescriptor pluginDescriptor) {
                if (extension2 == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (pluginDescriptor == null) {
                    1.$$$reportNull$$$0(3);
                }
                extension2.unregisterActions((ActionManager)ActionManagerImpl.this);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "extension";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "pluginDescriptor";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/openapi/actionSystem/impl/ActionManagerImpl$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extensionAdded";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extensionRemoved";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, (Disposable)this);
        ApplicationManager.getApplication().getExtensionArea().getExtensionPoint("com.intellij.editorActionHandler").addChangeListener(() -> {
            Object object = this.myLock;
            synchronized (object) {
                this.actionToId.keySet().forEach(ActionManagerImpl::updateHandlers);
            }
        }, (Disposable)this);
    }

    @ApiStatus.Internal
    public void registerActions(@NotNull List<IdeaPluginDescriptorImpl> plugins2) {
        if (plugins2 == null) {
            ActionManagerImpl.$$$reportNull$$$0(0);
        }
        KeymapManagerEx keymapManager2 = Objects.requireNonNull(KeymapManagerEx.getInstanceEx());
        ContainerUtilKt.executeRegisterTask(plugins2, (Function1<? super IdeaPluginDescriptorImpl, Unit>)((Function1)it -> {
            this.registerPluginActions((IdeaPluginDescriptorImpl)it, keymapManager2);
            return Unit.INSTANCE;
        }));
    }

    @NotNull
    private static AnActionListener publisher() {
        AnActionListener anActionListener = (AnActionListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(AnActionListener.TOPIC);
        if (anActionListener == null) {
            ActionManagerImpl.$$$reportNull$$$0(1);
        }
        return anActionListener;
    }

    @Nullable
    static AnAction convertStub(@NotNull ActionStub stub) {
        AnAction anAction2;
        if (stub == null) {
            ActionManagerImpl.$$$reportNull$$$0(2);
        }
        if ((anAction2 = ActionManagerImpl.instantiate(stub.getClassName(), stub.getPlugin(), AnAction.class)) == null) {
            return null;
        }
        stub.initAction(anAction2);
        ActionManagerImpl.updateIconFromStub((ActionStubBase)stub, anAction2);
        return anAction2;
    }

    @Nullable
    private static <T> T instantiate(@NotNull String stubClassName, @NotNull PluginDescriptor pluginDescriptor, @NotNull Class<T> expectedClass) {
        Object obj2;
        if (stubClassName == null) {
            ActionManagerImpl.$$$reportNull$$$0(3);
        }
        if (pluginDescriptor == null) {
            ActionManagerImpl.$$$reportNull$$$0(4);
        }
        if (expectedClass == null) {
            ActionManagerImpl.$$$reportNull$$$0(5);
        }
        try {
            obj2 = ApplicationManager.getApplication().instantiateClass(stubClassName, pluginDescriptor);
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Throwable e) {
            LOG.error(e);
            return null;
        }
        if (expectedClass.isInstance(obj2)) {
            return (T)obj2;
        }
        LOG.error((Throwable)new PluginException("class with name '" + stubClassName + "' must be an instance of '" + expectedClass.getName() + "'; got " + obj2, pluginDescriptor.getPluginId()));
        return null;
    }

    private static void updateIconFromStub(@NotNull ActionStubBase stub, @NotNull AnAction anAction2) {
        String iconPath;
        if (stub == null) {
            ActionManagerImpl.$$$reportNull$$$0(6);
        }
        if (anAction2 == null) {
            ActionManagerImpl.$$$reportNull$$$0(7);
        }
        if ((iconPath = stub.getIconPath()) != null) {
            ActionManagerImpl.setIconFromClass(anAction2.getClass(), stub.getPlugin(), iconPath, anAction2.getTemplatePresentation());
        }
    }

    @Nullable
    private static ActionGroup convertGroupStub(@NotNull ActionGroupStub stub, @NotNull ActionManager actionManager) {
        if (stub == null) {
            ActionManagerImpl.$$$reportNull$$$0(8);
        }
        if (actionManager == null) {
            ActionManagerImpl.$$$reportNull$$$0(9);
        }
        IdeaPluginDescriptor plugin2 = stub.getPlugin();
        ActionGroup group2 = ActionManagerImpl.instantiate(stub.getActionClass(), (PluginDescriptor)plugin2, ActionGroup.class);
        if (group2 == null) {
            return null;
        }
        stub.initGroup(group2, actionManager);
        ActionManagerImpl.updateIconFromStub((ActionStubBase)stub, (AnAction)group2);
        return group2;
    }

    private static void processAbbreviationNode(@NotNull XmlElement e, @NotNull String id2) {
        String abbr;
        if (e == null) {
            ActionManagerImpl.$$$reportNull$$$0(10);
        }
        if (id2 == null) {
            ActionManagerImpl.$$$reportNull$$$0(11);
        }
        if (!Strings.isEmpty((String)(abbr = (String)e.attributes.get("value")))) {
            AbbreviationManagerImpl abbreviationManager = (AbbreviationManagerImpl)AbbreviationManager.getInstance();
            abbreviationManager.register(abbr, id2, true);
        }
    }

    private static boolean isSecondary(XmlElement element2) {
        return "true".equalsIgnoreCase((String)element2.attributes.get("secondary"));
    }

    private static void setIconFromClass(@Nullable Class<?> actionClass, @NotNull PluginDescriptor pluginDescriptor, @NotNull String iconPath, @NotNull Presentation presentation2) {
        if (pluginDescriptor == null) {
            ActionManagerImpl.$$$reportNull$$$0(12);
        }
        if (iconPath == null) {
            ActionManagerImpl.$$$reportNull$$$0(13);
        }
        if (presentation2 == null) {
            ActionManagerImpl.$$$reportNull$$$0(14);
        }
        long start2 = StartUpMeasurer.getCurrentTimeIfEnabled();
        Icon icon2 = IconLoader.findIcon((String)iconPath, actionClass, (ClassLoader)pluginDescriptor.getPluginClassLoader(), null, (boolean)true);
        if (icon2 == null) {
            ActionManagerImpl.reportActionError(pluginDescriptor.getPluginId(), "Icon cannot be found in '" + iconPath + "', action '" + actionClass + "'");
            icon2 = AllIcons.Nodes.Unknown;
        }
        IconLoadMeasurer.actionIcon.end(start2);
        presentation2.setIcon(icon2);
    }

    @NlsActions.ActionDescription
    private static String computeDescription(@NotNull ResourceBundle bundle, String id2, String elementType, String descriptionValue) {
        if (bundle == null) {
            ActionManagerImpl.$$$reportNull$$$0(15);
        }
        String key = elementType + "." + id2 + ".description";
        return AbstractBundle.messageOrDefault((ResourceBundle)bundle, (String)key, (String)Strings.notNullize((String)descriptionValue), (Object[])new Object[0]);
    }

    @NlsActions.ActionText
    private static String computeActionText(@Nullable ResourceBundle bundle, String id2, String elementType, @Nullable String textValue, @NotNull ClassLoader classLoader) {
        if (classLoader == null) {
            ActionManagerImpl.$$$reportNull$$$0(16);
        }
        String defaultValue = Strings.notNullize((String)textValue);
        if (bundle != null && DefaultBundleService.isDefaultBundle()) {
            bundle = DynamicBundle.INSTANCE.getResourceBundle(bundle.getBaseBundleName(), classLoader);
        }
        return bundle == null ? defaultValue : AbstractBundle.messageOrDefault((ResourceBundle)bundle, (String)(elementType + "." + id2 + ".text"), (String)defaultValue, (Object[])new Object[0]);
    }

    private static boolean checkRelativeToAction(String relativeToActionId, @NotNull Anchor anchor2, @NotNull String actionName, @Nullable PluginId pluginId) {
        if (anchor2 == null) {
            ActionManagerImpl.$$$reportNull$$$0(17);
        }
        if (actionName == null) {
            ActionManagerImpl.$$$reportNull$$$0(18);
        }
        if ((Anchor.BEFORE == anchor2 || Anchor.AFTER == anchor2) && relativeToActionId == null) {
            ActionManagerImpl.reportActionError(pluginId, actionName + ": \"relative-to-action\" cannot be null if anchor is \"after\" or \"before\"");
            return false;
        }
        return true;
    }

    @Nullable
    private static Anchor parseAnchor(String anchorStr, @Nullable String actionName, @Nullable PluginId pluginId) {
        if (anchorStr == null) {
            return Anchor.LAST;
        }
        if ("first".equalsIgnoreCase(anchorStr)) {
            return Anchor.FIRST;
        }
        if ("last".equalsIgnoreCase(anchorStr)) {
            return Anchor.LAST;
        }
        if ("before".equalsIgnoreCase(anchorStr)) {
            return Anchor.BEFORE;
        }
        if ("after".equalsIgnoreCase(anchorStr)) {
            return Anchor.AFTER;
        }
        ActionManagerImpl.reportActionError(pluginId, actionName + ": anchor should be one of the following constants: \"first\", \"last\", \"before\" or \"after\"");
        return null;
    }

    private static void processMouseShortcutNode(XmlElement element2, String actionId, PluginId pluginId, @NotNull KeymapManager keymapManager2) {
        MouseShortcut shortcut;
        String keystrokeString;
        if (keymapManager2 == null) {
            ActionManagerImpl.$$$reportNull$$$0(19);
        }
        if ((keystrokeString = (String)element2.attributes.get("keystroke")) == null || keystrokeString.trim().isEmpty()) {
            ActionManagerImpl.reportActionError(pluginId, "\"keystroke\" attribute must be specified for action with id=" + actionId);
            return;
        }
        try {
            shortcut = KeymapUtil.parseMouseShortcut((String)keystrokeString);
        }
        catch (Exception ex) {
            ActionManagerImpl.reportActionError(pluginId, "\"keystroke\" attribute has invalid value for action with id=" + actionId);
            return;
        }
        String keymapName = (String)element2.attributes.get(KEYMAP_ATTR_NAME);
        if (keymapName == null || keymapName.isEmpty()) {
            ActionManagerImpl.reportActionError(pluginId, "attribute \"keymap\" should be defined");
            return;
        }
        Keymap keymap2 = keymapManager2.getKeymap(keymapName);
        if (keymap2 == null) {
            ActionManagerImpl.reportKeymapNotFoundWarning(pluginId, keymapName);
            return;
        }
        ActionManagerImpl.processRemoveAndReplace(element2, actionId, keymap2, (Shortcut)shortcut);
    }

    private static void reportActionError(@Nullable PluginId pluginId, @NotNull String message2) {
        if (message2 == null) {
            ActionManagerImpl.$$$reportNull$$$0(20);
        }
        ActionManagerImpl.reportActionError(pluginId, message2, null);
    }

    private static void reportActionError(@Nullable PluginId pluginId, @NotNull String message2, @Nullable Throwable cause) {
        if (message2 == null) {
            ActionManagerImpl.$$$reportNull$$$0(21);
        }
        if (pluginId != null) {
            LOG.error((Throwable)new PluginException(message2, cause, pluginId));
        } else if (cause != null) {
            LOG.error(message2, cause);
        } else {
            LOG.error(message2);
        }
    }

    private static void reportKeymapNotFoundWarning(@Nullable PluginId pluginId, @NotNull String keymapName) {
        if (keymapName == null) {
            ActionManagerImpl.$$$reportNull$$$0(22);
        }
        if (DefaultKeymap.Companion.isBundledKeymapHidden(keymapName)) {
            return;
        }
        String message2 = "keymap \"" + keymapName + "\" not found";
        LOG.warn((String)(pluginId == null ? message2 : new PluginException(message2, null, pluginId).getMessage()));
    }

    private static String getPluginInfo(@Nullable PluginId id2) {
        IdeaPluginDescriptor plugin2;
        IdeaPluginDescriptor ideaPluginDescriptor = plugin2 = id2 == null ? null : PluginManagerCore.getPlugin(id2);
        if (plugin2 == null) {
            return "";
        }
        String name = plugin2.getName();
        if (name == null) {
            name = id2.getIdString();
        }
        return " (Plugin: " + name + ")";
    }

    @NotNull
    private static DataContext getContextBy(Component contextComponent) {
        DataManager dataManager = DataManager.getInstance();
        DataContext dataContext = contextComponent != null ? dataManager.getDataContext(contextComponent) : dataManager.getDataContext();
        if (dataContext == null) {
            ActionManagerImpl.$$$reportNull$$$0(23);
        }
        return dataContext;
    }

    public void dispose() {
        if (this.myTimer != null) {
            this.myTimer.stop();
            this.myTimer = null;
        }
    }

    public void addTimerListener(int unused, @NotNull TimerListener listener2) {
        if (listener2 == null) {
            ActionManagerImpl.$$$reportNull$$$0(24);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        if (this.myTimer == null) {
            this.myTimer = new MyTimer();
            this.myTimer.start();
        }
        this.myTimer.listeners.add(listener2);
    }

    public void removeTimerListener(@NotNull TimerListener listener2) {
        if (listener2 == null) {
            ActionManagerImpl.$$$reportNull$$$0(25);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        if (LOG.assertTrue(this.myTimer != null)) {
            this.myTimer.listeners.remove(listener2);
        }
    }

    @NotNull
    public ActionPopupMenu createActionPopupMenu(@NotNull String place, @NotNull ActionGroup group2, @Nullable PresentationFactory presentationFactory) {
        if (place == null) {
            ActionManagerImpl.$$$reportNull$$$0(26);
        }
        if (group2 == null) {
            ActionManagerImpl.$$$reportNull$$$0(27);
        }
        return new ActionPopupMenuImpl(place, group2, this, presentationFactory);
    }

    @NotNull
    public ActionPopupMenu createActionPopupMenu(@NotNull String place, @NotNull ActionGroup group2) {
        if (place == null) {
            ActionManagerImpl.$$$reportNull$$$0(28);
        }
        if (group2 == null) {
            ActionManagerImpl.$$$reportNull$$$0(29);
        }
        return new ActionPopupMenuImpl(place, group2, this, null);
    }

    @NotNull
    public ActionToolbar createActionToolbar(@NotNull String place, @NotNull ActionGroup group2, boolean horizontal) {
        if (place == null) {
            ActionManagerImpl.$$$reportNull$$$0(30);
        }
        if (group2 == null) {
            ActionManagerImpl.$$$reportNull$$$0(31);
        }
        ActionToolbar actionToolbar = this.createActionToolbar(place, group2, horizontal, false);
        if (actionToolbar == null) {
            ActionManagerImpl.$$$reportNull$$$0(32);
        }
        return actionToolbar;
    }

    @NotNull
    public ActionToolbar createActionToolbar(@NotNull String place, @NotNull ActionGroup group2, boolean horizontal, boolean decorateButtons) {
        if (place == null) {
            ActionManagerImpl.$$$reportNull$$$0(33);
        }
        if (group2 == null) {
            ActionManagerImpl.$$$reportNull$$$0(34);
        }
        return new ActionToolbarImpl(place, group2, horizontal, decorateButtons);
    }

    private void registerPluginActions(@NotNull IdeaPluginDescriptorImpl pluginDescriptor, @NotNull KeymapManagerEx keymapManager2) {
        List<RawPluginDescriptor.ActionDescriptor> elements;
        if (pluginDescriptor == null) {
            ActionManagerImpl.$$$reportNull$$$0(35);
        }
        if (keymapManager2 == null) {
            ActionManagerImpl.$$$reportNull$$$0(36);
        }
        if ((elements = pluginDescriptor.actions) == null) {
            return;
        }
        long startTime = StartUpMeasurer.getCurrentTime();
        String lastBundleName = null;
        ResourceBundle lastBundle = null;
        block18: for (RawPluginDescriptor.ActionDescriptor descriptor2 : elements) {
            ResourceBundle bundle;
            String bundleName = descriptor2.resourceBundle;
            if (bundleName == null) {
                bundleName = PluginManagerCore.CORE_ID.equals((Object)pluginDescriptor.getPluginId()) ? "messages.ActionsBundle" : pluginDescriptor.getResourceBundleBaseName();
            }
            XmlElement element2 = descriptor2.element;
            if (bundleName == null) {
                bundle = null;
            } else if (bundleName.equals(lastBundleName)) {
                bundle = lastBundle;
            } else {
                try {
                    lastBundle = bundle = DynamicBundle.INSTANCE.getResourceBundle(bundleName, pluginDescriptor.getPluginClassLoader());
                    lastBundleName = bundleName;
                }
                catch (MissingResourceException e) {
                    LOG.error((Throwable)new PluginException("Cannot resolve resource bundle " + bundleName + " for action " + element2, (Throwable)e, pluginDescriptor.getPluginId()));
                    bundle = null;
                }
            }
            switch (descriptor2.name) {
                case "action": {
                    this.processActionElement(element2, pluginDescriptor, bundle, keymapManager2, pluginDescriptor.getPluginClassLoader());
                    continue block18;
                }
                case "group": {
                    this.processGroupElement(element2, pluginDescriptor, bundle, keymapManager2, pluginDescriptor.getPluginClassLoader());
                    continue block18;
                }
                case "separator": {
                    this.processSeparatorNode(null, element2, pluginDescriptor.getPluginId(), bundle);
                    continue block18;
                }
                case "reference": {
                    this.processReferenceNode(element2, pluginDescriptor.getPluginId(), bundle);
                    continue block18;
                }
                case "unregister": {
                    this.processUnregisterNode(element2, pluginDescriptor.getPluginId());
                    continue block18;
                }
                case "prohibit": {
                    this.processProhibitNode(element2, pluginDescriptor.getPluginId());
                    continue block18;
                }
            }
            LOG.error((Throwable)new PluginException("Unexpected name of element" + descriptor2.name, pluginDescriptor.getPluginId()));
        }
        StartUpMeasurer.addPluginCost((String)pluginDescriptor.getPluginId().getIdString(), (String)"Actions", (long)(StartUpMeasurer.getCurrentTime() - startTime));
    }

    @Nullable
    public AnAction getAction(@NotNull String id2) {
        if (id2 == null) {
            ActionManagerImpl.$$$reportNull$$$0(37);
        }
        return this.getActionImpl(id2, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private AnAction getActionImpl(@NotNull String id2, boolean canReturnStub) {
        AnAction converted;
        AnAction action2;
        if (id2 == null) {
            ActionManagerImpl.$$$reportNull$$$0(38);
        }
        Object object = this.myLock;
        synchronized (object) {
            action2 = this.idToAction.get(id2);
            if (canReturnStub || !(action2 instanceof ActionStubBase)) {
                return action2;
            }
        }
        Object object2 = converted = action2 instanceof ActionStub ? ActionManagerImpl.convertStub((ActionStub)action2) : ActionManagerImpl.convertGroupStub((ActionGroupStub)action2, (ActionManager)this);
        if (converted == null) {
            this.unregisterAction(id2);
            return null;
        }
        Object object3 = this.myLock;
        synchronized (object3) {
            action2 = this.idToAction.get(id2);
            if (action2 instanceof ActionStubBase) {
                action2 = this.replaceStub((ActionStubBase)action2, converted);
            }
            return action2;
        }
    }

    @Nullable
    private AnAction replaceStub(@NotNull ActionStubBase stub, @NotNull AnAction anAction2) {
        if (stub == null) {
            ActionManagerImpl.$$$reportNull$$$0(39);
        }
        if (anAction2 == null) {
            ActionManagerImpl.$$$reportNull$$$0(40);
        }
        LOG.assertTrue(this.actionToId.containsKey(stub));
        this.actionToId.remove(stub);
        LOG.assertTrue(this.idToAction.containsKey(stub.getId()));
        AnAction action2 = this.idToAction.remove(stub.getId());
        LOG.assertTrue(action2 != null);
        LOG.assertTrue(action2.equals(stub));
        this.actionToId.put(anAction2, stub.getId());
        ActionManagerImpl.updateHandlers(anAction2);
        AnAction result2 = this.addToMap(stub.getId(), anAction2, stub instanceof ActionStub ? ((ActionStub)stub).getProjectType() : null);
        if (result2 == null) {
            this.reportActionIdCollision(stub.getId(), action2, stub.getPlugin().getPluginId());
        }
        return result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getId(@NotNull AnAction action2) {
        if (action2 == null) {
            ActionManagerImpl.$$$reportNull$$$0(41);
        }
        if (action2 instanceof ActionStubBase) {
            return ((ActionStubBase)action2).getId();
        }
        Object object = this.myLock;
        synchronized (object) {
            return this.actionToId.get(action2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public List<String> getActionIdList(@NotNull String idPrefix) {
        if (idPrefix == null) {
            ActionManagerImpl.$$$reportNull$$$0(42);
        }
        ArrayList<String> result2 = new ArrayList<String>();
        Object object = this.myLock;
        synchronized (object) {
            for (String id2 : this.idToAction.keySet()) {
                if (!id2.startsWith(idPrefix)) continue;
                result2.add(id2);
            }
        }
        ArrayList<String> arrayList = result2;
        if (arrayList == null) {
            ActionManagerImpl.$$$reportNull$$$0(43);
        }
        return arrayList;
    }

    public String @NotNull [] getActionIds(@NotNull String idPrefix) {
        if (idPrefix == null) {
            ActionManagerImpl.$$$reportNull$$$0(44);
        }
        String[] stringArray = ArrayUtilRt.toStringArray(this.getActionIdList(idPrefix));
        if (stringArray == null) {
            ActionManagerImpl.$$$reportNull$$$0(45);
        }
        return stringArray;
    }

    public boolean isGroup(@NotNull String actionId) {
        if (actionId == null) {
            ActionManagerImpl.$$$reportNull$$$0(46);
        }
        return this.getActionImpl(actionId, true) instanceof ActionGroup;
    }

    @NotNull
    public JComponent createButtonToolbar(@NotNull String actionPlace, @NotNull ActionGroup messageActionGroup) {
        if (actionPlace == null) {
            ActionManagerImpl.$$$reportNull$$$0(47);
        }
        if (messageActionGroup == null) {
            ActionManagerImpl.$$$reportNull$$$0(48);
        }
        return new ButtonToolbarImpl(actionPlace, messageActionGroup);
    }

    public AnAction getActionOrStub(@NotNull String id2) {
        if (id2 == null) {
            ActionManagerImpl.$$$reportNull$$$0(49);
        }
        return this.getActionImpl(id2, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private AnAction processActionElement(@NotNull XmlElement element2, @NotNull IdeaPluginDescriptorImpl plugin2, @Nullable ResourceBundle bundle, @NotNull KeymapManager keymapManager2, @NotNull ClassLoader classLoader) {
        String className;
        if (element2 == null) {
            ActionManagerImpl.$$$reportNull$$$0(50);
        }
        if (plugin2 == null) {
            ActionManagerImpl.$$$reportNull$$$0(51);
        }
        if (keymapManager2 == null) {
            ActionManagerImpl.$$$reportNull$$$0(52);
        }
        if (classLoader == null) {
            ActionManagerImpl.$$$reportNull$$$0(53);
        }
        if ((className = (String)element2.attributes.get(CLASS_ATTR_NAME)) == null || className.isEmpty()) {
            ActionManagerImpl.reportActionError(plugin2.getPluginId(), "action element should have specified \"class\" attribute");
            return null;
        }
        String id2 = ActionManagerImpl.obtainActionId(element2, className);
        Object object = this.myLock;
        synchronized (object) {
            if (this.myProhibitedActionIds.contains(id2)) {
                return null;
            }
        }
        if (Boolean.parseBoolean((String)element2.attributes.get(INTERNAL_ATTR_NAME)) && !ApplicationManager.getApplication().isInternal()) {
            this.myNotRegisteredInternalActionIds.add(id2);
            return null;
        }
        String iconPath = (String)element2.attributes.get(ICON_ATTR_NAME);
        String projectType = (String)element2.attributes.get(PROJECT_TYPE);
        String textValue = (String)element2.attributes.get(TEXT_ATTR_NAME);
        String descriptionValue = (String)element2.attributes.get(DESCRIPTION);
        ActionStub stub = new ActionStub(className, id2, (PluginDescriptor)plugin2, iconPath, ProjectType.create((String)projectType), () -> {
            Supplier<String> text2 = () -> ActionManagerImpl.computeActionText(bundle, id2, ACTION_ELEMENT_NAME, textValue, classLoader);
            if (text2.get() == null) {
                ActionManagerImpl.reportActionError(plugin2.getPluginId(), "'text' attribute is mandatory (actionId=" + id2 + ", plugin=" + plugin2 + ")");
            }
            Presentation presentation2 = new Presentation();
            presentation2.setText(text2);
            if (bundle == null) {
                presentation2.setDescription(descriptionValue);
            } else {
                presentation2.setDescription(() -> ActionManagerImpl.computeDescription(bundle, id2, ACTION_ELEMENT_NAME, descriptionValue));
            }
            return presentation2;
        });
        block19: for (XmlElement e : element2.children) {
            switch (e.name) {
                case "add-to-group": {
                    this.processAddToGroupNode((AnAction)stub, e, plugin2.getPluginId(), ActionManagerImpl.isSecondary(e));
                    continue block19;
                }
                case "keyboard-shortcut": {
                    ActionManagerImpl.processKeyboardShortcutNode(e, id2, plugin2.getPluginId(), keymapManager2);
                    continue block19;
                }
                case "mouse-shortcut": {
                    ActionManagerImpl.processMouseShortcutNode(e, id2, plugin2.getPluginId(), keymapManager2);
                    continue block19;
                }
                case "abbreviation": {
                    ActionManagerImpl.processAbbreviationNode(e, id2);
                    continue block19;
                }
                case "override-text": {
                    ActionManagerImpl.processOverrideTextNode((AnAction)stub, stub.getId(), e, plugin2.getPluginId(), bundle);
                    continue block19;
                }
                case "synonym": {
                    ActionManagerImpl.processSynonymNode((AnAction)stub, e, plugin2.getPluginId(), bundle);
                    continue block19;
                }
            }
            ActionManagerImpl.reportActionError(plugin2.getPluginId(), "unexpected name of element \"" + e.name + "\"");
            return null;
        }
        String shortcutOfActionId = (String)element2.attributes.get(USE_SHORTCUT_OF_ATTR_NAME);
        if (shortcutOfActionId != null) {
            keymapManager2.bindShortcuts(shortcutOfActionId, id2);
        }
        this.registerOrReplaceActionInner(element2, id2, (AnAction)stub, plugin2);
        return stub;
    }

    private static String obtainActionId(XmlElement element2, String className) {
        String id2 = (String)element2.attributes.get(ID_ATTR_NAME);
        return Strings.isEmpty((String)id2) ? StringUtilRt.getShortName((String)className) : id2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerOrReplaceActionInner(@NotNull XmlElement element2, @NotNull String id2, @NotNull AnAction action2, @NotNull IdeaPluginDescriptor plugin2) {
        if (element2 == null) {
            ActionManagerImpl.$$$reportNull$$$0(54);
        }
        if (id2 == null) {
            ActionManagerImpl.$$$reportNull$$$0(55);
        }
        if (action2 == null) {
            ActionManagerImpl.$$$reportNull$$$0(56);
        }
        if (plugin2 == null) {
            ActionManagerImpl.$$$reportNull$$$0(57);
        }
        Object object = this.myLock;
        synchronized (object) {
            if (this.myProhibitedActionIds.contains(id2)) {
                return;
            }
            if (Boolean.parseBoolean((String)element2.attributes.get("overrides"))) {
                if (this.getActionOrStub(id2) == null) {
                    LOG.error(element2 + " '" + id2 + "' doesn't override anything");
                    return;
                }
                AnAction prev2 = this.replaceAction(id2, action2, plugin2.getPluginId());
                if (action2 instanceof DefaultActionGroup && prev2 instanceof DefaultActionGroup && Boolean.parseBoolean((String)element2.attributes.get("keep-content"))) {
                    ((DefaultActionGroup)action2).copyFromGroup((DefaultActionGroup)prev2);
                }
            } else {
                this.registerAction(id2, action2, plugin2.getPluginId(), (String)element2.attributes.get(PROJECT_TYPE));
            }
            ActionsCollectorImpl.onActionLoadedFromXml(action2, id2, plugin2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AnAction processGroupElement(@NotNull XmlElement element2, @NotNull IdeaPluginDescriptorImpl plugin2, @Nullable ResourceBundle bundle, @NotNull KeymapManagerEx keymapManager2, @NotNull ClassLoader classLoader) {
        String className;
        if (element2 == null) {
            ActionManagerImpl.$$$reportNull$$$0(58);
        }
        if (plugin2 == null) {
            ActionManagerImpl.$$$reportNull$$$0(59);
        }
        if (keymapManager2 == null) {
            ActionManagerImpl.$$$reportNull$$$0(60);
        }
        if (classLoader == null) {
            ActionManagerImpl.$$$reportNull$$$0(61);
        }
        if ((className = (String)element2.attributes.get(CLASS_ATTR_NAME)) == null) {
            className = "true".equals(element2.attributes.get("compact")) ? DefaultCompactActionGroup.class.getName() : DefaultActionGroup.class.getName();
        }
        try {
            String searchable;
            DefaultActionGroup group2;
            Object id2 = (String)element2.attributes.get(ID_ATTR_NAME);
            if (id2 != null && ((String)id2).isEmpty()) {
                ActionManagerImpl.reportActionError(plugin2.getPluginId(), "ID of the group cannot be an empty string");
                return null;
            }
            Object object = this.myLock;
            synchronized (object) {
                if (this.myProhibitedActionIds.contains(id2)) {
                    return null;
                }
            }
            boolean customClass = false;
            if (DefaultActionGroup.class.getName().equals(className)) {
                group2 = new DefaultActionGroup();
            } else if (DefaultCompactActionGroup.class.getName().equals(className)) {
                group2 = new DefaultCompactActionGroup();
            } else if (id2 == null) {
                Object obj2 = ApplicationManager.getApplication().instantiateClass(className, (PluginDescriptor)plugin2);
                if (!(obj2 instanceof ActionGroup)) {
                    ActionManagerImpl.reportActionError(plugin2.getPluginId(), "class with name \"" + className + "\" should be instance of " + ActionGroup.class.getName());
                    return null;
                }
                if (element2.children.size() != element2.count(ADD_TO_GROUP_ELEMENT_NAME) && !(obj2 instanceof DefaultActionGroup)) {
                    ActionManagerImpl.reportActionError(plugin2.getPluginId(), "class with name \"" + className + "\" should be instance of " + DefaultActionGroup.class.getName() + " because there are children specified");
                    return null;
                }
                customClass = true;
                group2 = (ActionGroup)obj2;
            } else {
                group2 = new ActionGroupStub((String)id2, className, (IdeaPluginDescriptor)plugin2);
                customClass = true;
            }
            if (Boolean.parseBoolean((String)element2.attributes.get(INTERNAL_ATTR_NAME)) && !ApplicationManager.getApplication().isInternal()) {
                this.myNotRegisteredInternalActionIds.add((String)id2);
                return null;
            }
            if (id2 == null) {
                id2 = "<anonymous-group-" + this.myAnonymousGroupIdCounter++ + ">";
            }
            this.registerOrReplaceActionInner(element2, (String)id2, (AnAction)group2, plugin2);
            Presentation presentation2 = group2.getTemplatePresentation();
            Object finalId = id2;
            Supplier<String> text2 = () -> ActionManagerImpl.lambda$processGroupElement$7(bundle, (String)finalId, element2, classLoader);
            if (!Strings.isEmpty((String)text2.get()) || presentation2.getText() == null) {
                presentation2.setText(text2);
            }
            String description2 = (String)element2.attributes.get(DESCRIPTION);
            if (bundle == null) {
                if (!Strings.isEmpty((String)description2) || presentation2.getDescription() == null) {
                    presentation2.setDescription(description2);
                }
            } else {
                Supplier<String> descriptionSupplier = () -> ActionManagerImpl.lambda$processGroupElement$8(bundle, (String)finalId, description2);
                if (!Strings.isEmpty((String)descriptionSupplier.get()) || presentation2.getDescription() == null) {
                    presentation2.setDescription(descriptionSupplier);
                }
            }
            String iconPath = (String)element2.attributes.get(ICON_ATTR_NAME);
            if (group2 instanceof ActionGroupStub) {
                ((ActionGroupStub)group2).setIconPath(iconPath);
            } else if (iconPath != null) {
                ActionManagerImpl.setIconFromClass(null, (PluginDescriptor)plugin2, iconPath, presentation2);
            }
            String popup2 = (String)element2.attributes.get("popup");
            if (popup2 != null) {
                group2.setPopup(Boolean.parseBoolean(popup2));
                if (group2 instanceof ActionGroupStub) {
                    ((ActionGroupStub)group2).setPopupDefinedInXml(true);
                }
            }
            if ((searchable = (String)element2.attributes.get("searchable")) != null) {
                group2.setSearchable(Boolean.parseBoolean(searchable));
            }
            String shortcutOfActionId = (String)element2.attributes.get(USE_SHORTCUT_OF_ATTR_NAME);
            if (customClass && shortcutOfActionId != null) {
                keymapManager2.bindShortcuts(shortcutOfActionId, (String)id2);
            }
            block21: for (XmlElement child2 : element2.children) {
                switch (child2.name) {
                    case "action": {
                        AnAction action2 = this.processActionElement(child2, plugin2, bundle, keymapManager2, classLoader);
                        if (action2 == null) continue block21;
                        this.addToGroupInner((AnAction)group2, action2, Constraints.LAST, ActionManagerImpl.isSecondary(child2));
                        continue block21;
                    }
                    case "separator": {
                        this.processSeparatorNode(group2, child2, plugin2.getPluginId(), bundle);
                        continue block21;
                    }
                    case "group": {
                        AnAction action2 = this.processGroupElement(child2, plugin2, bundle, keymapManager2, classLoader);
                        if (action2 == null) continue block21;
                        this.addToGroupInner((AnAction)group2, action2, Constraints.LAST, false);
                        continue block21;
                    }
                    case "add-to-group": {
                        this.processAddToGroupNode((AnAction)group2, child2, plugin2.getPluginId(), ActionManagerImpl.isSecondary(child2));
                        continue block21;
                    }
                    case "reference": {
                        AnAction action2 = this.processReferenceElement(child2, plugin2.getPluginId());
                        if (action2 == null) continue block21;
                        this.addToGroupInner((AnAction)group2, action2, Constraints.LAST, ActionManagerImpl.isSecondary(child2));
                        continue block21;
                    }
                    case "override-text": {
                        ActionManagerImpl.processOverrideTextNode((AnAction)group2, (String)id2, child2, plugin2.getPluginId(), bundle);
                        continue block21;
                    }
                }
                ActionManagerImpl.reportActionError(plugin2.getPluginId(), "unexpected name of element \"" + child2.name + "\n");
                return null;
            }
            return group2;
        }
        catch (Exception e) {
            String message2 = "cannot create class \"" + className + "\"";
            ActionManagerImpl.reportActionError(plugin2.getPluginId(), message2, e);
            return null;
        }
    }

    private void processReferenceNode(@NotNull XmlElement element2, @Nullable PluginId pluginId, @Nullable ResourceBundle bundle) {
        AnAction action2;
        if (element2 == null) {
            ActionManagerImpl.$$$reportNull$$$0(62);
        }
        if ((action2 = this.processReferenceElement(element2, pluginId)) == null) {
            return;
        }
        for (XmlElement child2 : element2.children) {
            if (ADD_TO_GROUP_ELEMENT_NAME.equals(child2.name)) {
                this.processAddToGroupNode(action2, child2, pluginId, ActionManagerImpl.isSecondary(child2));
                continue;
            }
            if (!SYNONYM_ELEMENT_NAME.equals(child2.name)) continue;
            ActionManagerImpl.processSynonymNode(action2, child2, pluginId, bundle);
        }
    }

    private void processAddToGroupNode(AnAction action2, XmlElement element2, PluginId pluginId, boolean secondary) {
        String name = action2 instanceof ActionStub ? ((ActionStub)action2).getClassName() : action2.getClass().getName();
        String id2 = action2 instanceof ActionStub ? ((ActionStub)action2).getId() : this.actionToId.get(action2);
        String actionName = name + " (" + id2 + ")";
        DefaultActionGroup parentGroup = this.getParentGroup((String)element2.attributes.get(GROUP_ID_ATTR_NAME), actionName, pluginId);
        if (parentGroup == null) {
            return;
        }
        Anchor anchor2 = ActionManagerImpl.parseAnchor((String)element2.attributes.get("anchor"), actionName, pluginId);
        if (anchor2 == null) {
            return;
        }
        String relativeToActionId = (String)element2.attributes.get("relative-to-action");
        if (!ActionManagerImpl.checkRelativeToAction(relativeToActionId, anchor2, actionName, pluginId)) {
            return;
        }
        this.addToGroupInner((AnAction)parentGroup, action2, new Constraints(anchor2, relativeToActionId), secondary);
    }

    private void addToGroupInner(AnAction group2, AnAction action2, Constraints constraints2, boolean secondary) {
        String actionId = action2 instanceof ActionStub ? ((ActionStub)action2).getId() : this.actionToId.get(action2);
        ((DefaultActionGroup)group2).addAction(action2, constraints2, (ActionManager)this).setAsSecondary(secondary);
        this.idToGroupId.putValue((Object)actionId, (Object)this.actionToId.get(group2));
    }

    @Nullable
    public DefaultActionGroup getParentGroup(String groupId2, @Nullable String actionName, @Nullable PluginId pluginId) {
        if (groupId2 == null || groupId2.isEmpty()) {
            ActionManagerImpl.reportActionError(pluginId, actionName + ": attribute \"group-id\" should be defined");
            return null;
        }
        AnAction parentGroup = this.getActionImpl(groupId2, true);
        if (parentGroup == null) {
            ActionManagerImpl.reportActionError(pluginId, actionName + ": group with id \"" + groupId2 + "\" isn't registered; action will be added to the \"Other\" group", null);
            parentGroup = this.getActionImpl("OtherMenu", true);
        }
        if (!(parentGroup instanceof DefaultActionGroup)) {
            ActionManagerImpl.reportActionError(pluginId, actionName + ": group with id \"" + groupId2 + "\" should be instance of " + DefaultActionGroup.class.getName() + " but was " + (Serializable)(parentGroup != null ? parentGroup.getClass() : "[null]"));
            return null;
        }
        return (DefaultActionGroup)parentGroup;
    }

    private static void processOverrideTextNode(AnAction action2, String id2, XmlElement element2, PluginId pluginId, @Nullable ResourceBundle bundle) {
        String place = (String)element2.attributes.get("place");
        if (place == null) {
            ActionManagerImpl.reportActionError(pluginId, id2 + ": override-text specified without place");
            return;
        }
        String useTextOfPlace = (String)element2.attributes.get("use-text-of-place");
        if (useTextOfPlace != null) {
            action2.copyActionTextOverride(useTextOfPlace, place, id2);
        } else {
            String text2 = (String)element2.attributes.get(TEXT_ATTR_NAME);
            if ((text2 == null || text2.isEmpty()) && bundle != null) {
                String prefix2 = action2 instanceof ActionGroup ? GROUP_ELEMENT_NAME : ACTION_ELEMENT_NAME;
                String key = prefix2 + "." + id2 + "." + place + ".text";
                action2.addTextOverride(place, () -> BundleBase.message((ResourceBundle)bundle, (String)key, (Object[])new Object[0]));
            } else {
                action2.addTextOverride(place, () -> text2);
            }
        }
    }

    private static void processSynonymNode(AnAction action2, XmlElement element2, PluginId pluginId, @Nullable ResourceBundle bundle) {
        String text2 = (String)element2.attributes.get(TEXT_ATTR_NAME);
        if (text2 != null && !text2.isEmpty()) {
            action2.addSynonym(() -> text2);
        } else {
            String key = (String)element2.attributes.get(KEY_ATTR_NAME);
            if (key != null && bundle != null) {
                action2.addSynonym(() -> BundleBase.message((ResourceBundle)bundle, (String)key, (Object[])new Object[0]));
            } else {
                ActionManagerImpl.reportActionError(pluginId, "Can't process synonym: neither text nor resource bundle key is specified");
            }
        }
    }

    private void processSeparatorNode(@Nullable DefaultActionGroup parentGroup, @NotNull XmlElement element2, PluginId pluginId, @Nullable ResourceBundle bundle) {
        Separator separator;
        if (element2 == null) {
            ActionManagerImpl.$$$reportNull$$$0(63);
        }
        String text2 = (String)element2.attributes.get(TEXT_ATTR_NAME);
        String key = (String)element2.attributes.get(KEY_ATTR_NAME);
        Separator separator2 = text2 != null ? new Separator(text2) : (separator = key != null ? ActionManagerImpl.createSeparator(bundle, key) : Separator.getInstance());
        if (parentGroup != null) {
            parentGroup.add((AnAction)separator, (ActionManager)this);
        }
        for (XmlElement child2 : element2.children) {
            if (!ADD_TO_GROUP_ELEMENT_NAME.equals(child2.name)) continue;
            this.processAddToGroupNode((AnAction)separator, child2, pluginId, ActionManagerImpl.isSecondary(child2));
        }
    }

    @NotNull
    private static Separator createSeparator(@Nullable ResourceBundle bundle, @NotNull String key) {
        if (key == null) {
            ActionManagerImpl.$$$reportNull$$$0(64);
        }
        String text2 = bundle != null ? AbstractBundle.messageOrNull((ResourceBundle)bundle, (String)key, (Object[])new Object[0]) : null;
        Separator separator = text2 != null ? new Separator(text2) : Separator.getInstance();
        if (separator == null) {
            ActionManagerImpl.$$$reportNull$$$0(65);
        }
        return separator;
    }

    private void processProhibitNode(XmlElement element2, PluginId pluginId) {
        String id2 = (String)element2.attributes.get(ID_ATTR_NAME);
        if (id2 == null) {
            ActionManagerImpl.reportActionError(pluginId, "'id' attribute is required for 'unregister' elements");
            return;
        }
        this.prohibitAction(id2);
    }

    private void processUnregisterNode(XmlElement element2, PluginId pluginId) {
        String id2 = (String)element2.attributes.get(ID_ATTR_NAME);
        if (id2 == null) {
            ActionManagerImpl.reportActionError(pluginId, "'id' attribute is required for 'unregister' elements");
            return;
        }
        AnAction action2 = this.getAction(id2);
        if (action2 == null) {
            ActionManagerImpl.reportActionError(pluginId, "Trying to unregister non-existing action " + id2);
            return;
        }
        AbbreviationManager.getInstance().removeAllAbbreviations(id2);
        this.unregisterAction(id2);
    }

    private static void processKeyboardShortcutNode(XmlElement element2, String actionId, PluginId pluginId, @NotNull KeymapManager keymapManager2) {
        String firstStrokeString;
        if (keymapManager2 == null) {
            ActionManagerImpl.$$$reportNull$$$0(66);
        }
        if ((firstStrokeString = (String)element2.attributes.get("first-keystroke")) == null) {
            ActionManagerImpl.reportActionError(pluginId, "\"first-keystroke\" attribute must be specified for action with id=" + actionId);
            return;
        }
        KeyStroke firstKeyStroke = ActionManagerImpl.getKeyStroke((String)firstStrokeString);
        if (firstKeyStroke == null) {
            ActionManagerImpl.reportActionError(pluginId, "\"first-keystroke\" attribute has invalid value for action with id=" + actionId);
            return;
        }
        KeyStroke secondKeyStroke = null;
        String secondStrokeString = (String)element2.attributes.get("second-keystroke");
        if (secondStrokeString != null && (secondKeyStroke = ActionManagerImpl.getKeyStroke((String)secondStrokeString)) == null) {
            ActionManagerImpl.reportActionError(pluginId, "\"second-keystroke\" attribute has invalid value for action with id=" + actionId);
            return;
        }
        String keymapName = (String)element2.attributes.get(KEYMAP_ATTR_NAME);
        if (keymapName == null || keymapName.trim().isEmpty()) {
            ActionManagerImpl.reportActionError(pluginId, "attribute \"keymap\" should be defined");
            return;
        }
        Keymap keymap2 = keymapManager2.getKeymap(keymapName);
        if (keymap2 == null) {
            ActionManagerImpl.reportKeymapNotFoundWarning(pluginId, keymapName);
            return;
        }
        ActionManagerImpl.processRemoveAndReplace(element2, actionId, keymap2, (Shortcut)new KeyboardShortcut(firstKeyStroke, secondKeyStroke));
    }

    private static void processRemoveAndReplace(@NotNull XmlElement element2, String actionId, @NotNull Keymap keymap2, @NotNull Shortcut shortcut) {
        if (element2 == null) {
            ActionManagerImpl.$$$reportNull$$$0(67);
        }
        if (keymap2 == null) {
            ActionManagerImpl.$$$reportNull$$$0(68);
        }
        if (shortcut == null) {
            ActionManagerImpl.$$$reportNull$$$0(69);
        }
        boolean remove = Boolean.parseBoolean((String)element2.attributes.get("remove"));
        boolean replace = Boolean.parseBoolean((String)element2.attributes.get("replace-all"));
        if (remove) {
            keymap2.removeShortcut(actionId, shortcut);
        }
        if (replace) {
            keymap2.removeAllActionShortcuts(actionId);
        }
        if (!remove) {
            keymap2.addShortcut(actionId, shortcut);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private AnAction processReferenceElement(XmlElement element2, PluginId pluginId) {
        String ref = ActionManagerImpl.getReferenceActionId(element2);
        if (ref == null || ref.isEmpty()) {
            ActionManagerImpl.reportActionError(pluginId, "ID of reference element should be defined", null);
            return null;
        }
        Object object = this.myLock;
        synchronized (object) {
            if (this.myProhibitedActionIds.contains(ref)) {
                return null;
            }
        }
        AnAction action2 = this.getActionImpl(ref, true);
        if (action2 == null) {
            if (!this.myNotRegisteredInternalActionIds.contains(ref)) {
                ActionManagerImpl.reportActionError(pluginId, "action specified by reference isn't registered (ID=" + ref + ")", null);
            }
            return null;
        }
        return action2;
    }

    private static String getReferenceActionId(@NotNull XmlElement element2) {
        String ref;
        if (element2 == null) {
            ActionManagerImpl.$$$reportNull$$$0(70);
        }
        if ((ref = (String)element2.attributes.get(REF_ATTR_NAME)) == null) {
            ref = (String)element2.attributes.get(ID_ATTR_NAME);
        }
        return ref;
    }

    @ApiStatus.Internal
    @Nullable
    public static String checkUnloadActions(PluginId pluginId, @NotNull IdeaPluginDescriptorImpl pluginDescriptor) {
        List<RawPluginDescriptor.ActionDescriptor> descriptors2;
        if (pluginDescriptor == null) {
            ActionManagerImpl.$$$reportNull$$$0(71);
        }
        if ((descriptors2 = pluginDescriptor.actions) == null) {
            return null;
        }
        for (RawPluginDescriptor.ActionDescriptor descriptor2 : descriptors2) {
            XmlElement element2 = descriptor2.element;
            String elementName = descriptor2.name;
            if (elementName.equals(ACTION_ELEMENT_NAME) || elementName.equals(GROUP_ELEMENT_NAME) && ActionManagerImpl.canUnloadGroup(element2) || elementName.equals(REFERENCE_ELEMENT_NAME)) continue;
            return "Plugin " + pluginId + " is not unload-safe because of action element " + elementName;
        }
        return null;
    }

    private static boolean canUnloadGroup(@NotNull XmlElement element2) {
        if (element2 == null) {
            ActionManagerImpl.$$$reportNull$$$0(72);
        }
        if (element2.attributes.get(ID_ATTR_NAME) == null) {
            return false;
        }
        for (XmlElement child2 : element2.children) {
            if (!child2.name.equals(GROUP_ELEMENT_NAME) || ActionManagerImpl.canUnloadGroup(child2)) continue;
            return false;
        }
        return true;
    }

    public void unloadActions(@NotNull IdeaPluginDescriptorImpl pluginDescriptor) {
        List<RawPluginDescriptor.ActionDescriptor> descriptors2;
        if (pluginDescriptor == null) {
            ActionManagerImpl.$$$reportNull$$$0(73);
        }
        if ((descriptors2 = pluginDescriptor.actions) == null) {
            return;
        }
        block10: for (int i2 = descriptors2.size() - 1; i2 >= 0; --i2) {
            RawPluginDescriptor.ActionDescriptor descriptor2 = descriptors2.get(i2);
            XmlElement element2 = descriptor2.element;
            switch (descriptor2.name) {
                case "action": {
                    this.unloadActionElement(element2);
                    continue block10;
                }
                case "group": {
                    this.unloadGroupElement(element2);
                    continue block10;
                }
                case "reference": {
                    PluginId pluginId = pluginDescriptor.getPluginId();
                    AnAction action2 = this.processReferenceElement(element2, pluginId);
                    if (action2 == null) {
                        return;
                    }
                    String actionId = ActionManagerImpl.getReferenceActionId(element2);
                    for (XmlElement child2 : element2.children) {
                        if (!child2.name.equals(ADD_TO_GROUP_ELEMENT_NAME)) continue;
                        String groupId2 = (String)child2.attributes.get(GROUP_ID_ATTR_NAME);
                        DefaultActionGroup parentGroup = this.getParentGroup(groupId2, actionId, pluginId);
                        if (parentGroup == null) {
                            return;
                        }
                        parentGroup.remove(action2);
                        this.idToGroupId.remove((Object)actionId, (Object)groupId2);
                    }
                    continue block10;
                }
            }
        }
    }

    private void unloadGroupElement(XmlElement element2) {
        String id2 = (String)element2.attributes.get(ID_ATTR_NAME);
        if (id2 == null) {
            throw new IllegalStateException("Cannot unload groups with no ID");
        }
        for (XmlElement groupChild : element2.children) {
            if (groupChild.name.equals(ACTION_ELEMENT_NAME)) {
                this.unloadActionElement(groupChild);
                continue;
            }
            if (!groupChild.name.equals(GROUP_ELEMENT_NAME)) continue;
            this.unloadGroupElement(groupChild);
        }
        this.unregisterAction(id2);
    }

    private void unloadActionElement(@NotNull XmlElement element2) {
        if (element2 == null) {
            ActionManagerImpl.$$$reportNull$$$0(74);
        }
        String className = (String)element2.attributes.get(CLASS_ATTR_NAME);
        String id2 = ActionManagerImpl.obtainActionId(element2, className);
        this.unregisterAction(id2);
    }

    public void registerAction(@NotNull String actionId, @NotNull AnAction action2, @Nullable PluginId pluginId) {
        if (actionId == null) {
            ActionManagerImpl.$$$reportNull$$$0(75);
        }
        if (action2 == null) {
            ActionManagerImpl.$$$reportNull$$$0(76);
        }
        this.registerAction(actionId, action2, pluginId, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerAction(@NotNull String actionId, @NotNull AnAction action2, @Nullable PluginId pluginId, @Nullable String projectType) {
        if (actionId == null) {
            ActionManagerImpl.$$$reportNull$$$0(77);
        }
        if (action2 == null) {
            ActionManagerImpl.$$$reportNull$$$0(78);
        }
        Object object = this.myLock;
        synchronized (object) {
            if (this.myProhibitedActionIds.contains(actionId)) {
                return;
            }
            if (this.addToMap(actionId, action2, ProjectType.create((String)projectType)) == null) {
                this.reportActionIdCollision(actionId, action2, pluginId);
                return;
            }
            if (this.actionToId.containsKey(action2)) {
                ActionManagerImpl.reportActionError(pluginId, "ID \"" + this.actionToId.get(action2) + "\" is already taken by action \"" + action2 + "\"" + ActionManagerImpl.getPluginInfo(pluginId) + ". ID \"" + actionId + "\" cannot be registered for the same action");
                return;
            }
            this.idToIndex.put((Object)actionId, this.myRegisteredActionsCount++);
            this.actionToId.put(action2, actionId);
            if (pluginId != null) {
                this.pluginToId.putValue((Object)pluginId, (Object)actionId);
            }
            action2.registerCustomShortcutSet((ShortcutSet)new ProxyShortcutSet(actionId), null);
            ActionManagerImpl.notifyCustomActionsSchema(actionId);
            ActionManagerImpl.updateHandlers(action2);
        }
    }

    private static void notifyCustomActionsSchema(@NotNull String registeredID) {
        CustomActionsSchema schema2;
        if (registeredID == null) {
            ActionManagerImpl.$$$reportNull$$$0(79);
        }
        if ((schema2 = (CustomActionsSchema)ApplicationManager.getApplication().getServiceIfCreated(CustomActionsSchema.class)) == null) {
            return;
        }
        for (ActionUrl url : schema2.getActions()) {
            if (!registeredID.equals(url.getComponent())) continue;
            schema2.incrementModificationStamp();
            break;
        }
    }

    @Nullable
    private AnAction addToMap(@NotNull String actionId, @NotNull AnAction action2, @Nullable ProjectType projectType) {
        AnAction chameleonAction;
        if (actionId == null) {
            ActionManagerImpl.$$$reportNull$$$0(80);
        }
        if (action2 == null) {
            ActionManagerImpl.$$$reportNull$$$0(81);
        }
        if ((chameleonAction = this.idToAction.computeIfPresent(actionId, (__, old) -> old instanceof ChameleonAction ? old : new ChameleonAction((AnAction)old, projectType))) == null) {
            AnAction result2 = projectType == null ? action2 : new ChameleonAction(action2, projectType);
            this.idToAction.put(actionId, result2);
            return result2;
        }
        return ((ChameleonAction)chameleonAction).addAction(action2, projectType);
    }

    private void reportActionIdCollision(@NotNull String actionId, @NotNull AnAction action2, @Nullable PluginId pluginId) {
        if (actionId == null) {
            ActionManagerImpl.$$$reportNull$$$0(82);
        }
        if (action2 == null) {
            ActionManagerImpl.$$$reportNull$$$0(83);
        }
        String oldPluginInfo = this.pluginToId.entrySet().stream().filter(entry2 -> ((Collection)entry2.getValue()).contains(actionId)).map(Map.Entry::getKey).map(ActionManagerImpl::getPluginInfo).collect(Collectors.joining(","));
        ActionManagerImpl.reportActionError(pluginId, "ID \"" + actionId + "\" is already taken by action \"" + this.idToAction.get(actionId) + "\"" + oldPluginInfo + ". Action \"" + action2 + "\"" + ActionManagerImpl.getPluginInfo(pluginId) + " cannot use the same ID");
    }

    public void registerAction(@NotNull String actionId, @NotNull AnAction action2) {
        if (actionId == null) {
            ActionManagerImpl.$$$reportNull$$$0(84);
        }
        if (action2 == null) {
            ActionManagerImpl.$$$reportNull$$$0(85);
        }
        this.registerAction(actionId, action2, null, null);
    }

    public void unregisterAction(@NotNull String actionId) {
        if (actionId == null) {
            ActionManagerImpl.$$$reportNull$$$0(86);
        }
        this.unregisterAction(actionId, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregisterAction(@NotNull String actionId, boolean removeFromGroups) {
        if (actionId == null) {
            ActionManagerImpl.$$$reportNull$$$0(87);
        }
        Object object = this.myLock;
        synchronized (object) {
            if (!this.idToAction.containsKey(actionId)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("action with ID " + actionId + " wasn't registered");
                }
                return;
            }
            AnAction actionToRemove = this.idToAction.remove(actionId);
            this.actionToId.remove(actionToRemove);
            this.idToIndex.removeInt((Object)actionId);
            for (Object entry2 : this.pluginToId.entrySet()) {
                ((Collection)entry2.getValue()).remove(actionId);
            }
            if (removeFromGroups) {
                CustomActionsSchema customActionSchema = (CustomActionsSchema)ApplicationManager.getApplication().getServiceIfCreated(CustomActionsSchema.class);
                for (String groupId2 : this.idToGroupId.get((Object)actionId)) {
                    DefaultActionGroup group2;
                    if (customActionSchema != null) {
                        customActionSchema.invalidateCustomizedActionGroup(groupId2);
                    }
                    if ((group2 = (DefaultActionGroup)this.getActionOrStub(groupId2)) == null) {
                        LOG.error("Trying to remove action " + actionId + " from non-existing group " + groupId2);
                        continue;
                    }
                    group2.remove(actionToRemove, actionId);
                    if (group2 instanceof ActionGroupStub) continue;
                    for (String parentOfGroup : this.idToGroupId.get((Object)groupId2)) {
                        DefaultActionGroup parentOfGroupAction = (DefaultActionGroup)this.getActionOrStub(parentOfGroup);
                        if (parentOfGroupAction == null) {
                            LOG.error("Trying to remove action " + actionId + " from non-existing group " + parentOfGroup);
                            continue;
                        }
                        for (AnAction stub : parentOfGroupAction.getChildActionsOrStubs()) {
                            if (!(stub instanceof ActionGroupStub) || ((ActionGroupStub)stub).getId() != groupId2) continue;
                            ((ActionGroupStub)stub).remove(actionToRemove, actionId);
                        }
                    }
                }
            }
            if (actionToRemove instanceof ActionGroup) {
                for (Object entry2 : this.idToGroupId.entrySet()) {
                    ((Collection)entry2.getValue()).remove(actionId);
                }
            }
            ActionManagerImpl.updateHandlers(actionToRemove);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiStatus.Internal
    public void prohibitAction(@NotNull String actionId) {
        if (actionId == null) {
            ActionManagerImpl.$$$reportNull$$$0(88);
        }
        Object object = this.myLock;
        synchronized (object) {
            this.myProhibitedActionIds.add(actionId);
        }
        AnAction action2 = this.getAction(actionId);
        if (action2 != null) {
            AbbreviationManager.getInstance().removeAllAbbreviations(actionId);
            this.unregisterAction(actionId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestOnly
    public void resetProhibitedActions() {
        Object object = this.myLock;
        synchronized (object) {
            this.myProhibitedActionIds.clear();
        }
    }

    @NotNull
    public Comparator<String> getRegistrationOrderComparator() {
        Comparator<String> comparator2 = Comparator.comparingInt(arg_0 -> this.idToIndex.getInt(arg_0));
        if (comparator2 == null) {
            ActionManagerImpl.$$$reportNull$$$0(89);
        }
        return comparator2;
    }

    public String @NotNull [] getPluginActions(@NotNull PluginId pluginName) {
        if (pluginName == null) {
            ActionManagerImpl.$$$reportNull$$$0(90);
        }
        String[] stringArray = ArrayUtilRt.toStringArray((Collection)this.pluginToId.get((Object)pluginName));
        if (stringArray == null) {
            ActionManagerImpl.$$$reportNull$$$0(91);
        }
        return stringArray;
    }

    public void addActionPopup(@NotNull Object menu) {
        if (menu == null) {
            ActionManagerImpl.$$$reportNull$$$0(92);
        }
        this.myPopups.add(menu);
        if (menu instanceof ActionPopupMenu) {
            for (ActionPopupMenuListener listener2 : this.myActionPopupMenuListeners) {
                listener2.actionPopupMenuCreated((ActionPopupMenu)menu);
            }
        }
    }

    void removeActionPopup(@NotNull Object menu) {
        boolean removed;
        if (menu == null) {
            ActionManagerImpl.$$$reportNull$$$0(93);
        }
        if ((removed = this.myPopups.remove(menu)) && menu instanceof ActionPopupMenu) {
            for (ActionPopupMenuListener listener2 : this.myActionPopupMenuListeners) {
                listener2.actionPopupMenuReleased((ActionPopupMenu)menu);
            }
        }
    }

    public boolean isToolWindowContextMenuVisible() {
        for (Object popup2 : this.myPopups) {
            if (!(popup2 instanceof ActionPopupMenuImpl) || !((ActionPopupMenuImpl)popup2).isToolWindowContextMenu()) continue;
            return true;
        }
        return false;
    }

    public boolean isActionPopupStackEmpty() {
        return this.myPopups.isEmpty();
    }

    public void addActionPopupMenuListener(@NotNull ActionPopupMenuListener listener2, @NotNull Disposable parentDisposable) {
        if (listener2 == null) {
            ActionManagerImpl.$$$reportNull$$$0(94);
        }
        if (parentDisposable == null) {
            ActionManagerImpl.$$$reportNull$$$0(95);
        }
        this.myActionPopupMenuListeners.add(listener2);
        Disposer.register((Disposable)parentDisposable, () -> this.myActionPopupMenuListeners.remove(listener2));
    }

    public void replaceAction(@NotNull String actionId, @NotNull AnAction newAction) {
        Class callerClass;
        if (actionId == null) {
            ActionManagerImpl.$$$reportNull$$$0(96);
        }
        if (newAction == null) {
            ActionManagerImpl.$$$reportNull$$$0(97);
        }
        PluginId pluginId = (callerClass = ReflectionUtil.getGrandCallerClass()) != null ? PluginManagerCore.getPluginByClassName(callerClass.getName()) : null;
        this.replaceAction(actionId, newAction, pluginId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AnAction replaceAction(@NotNull String actionId, @NotNull AnAction newAction, @Nullable PluginId pluginId) {
        AnAction oldAction;
        if (actionId == null) {
            ActionManagerImpl.$$$reportNull$$$0(98);
        }
        if (newAction == null) {
            ActionManagerImpl.$$$reportNull$$$0(99);
        }
        Object object = this.myLock;
        synchronized (object) {
            if (this.myProhibitedActionIds.contains(actionId)) {
                return null;
            }
        }
        AnAction anAction2 = oldAction = newAction instanceof OverridingAction ? this.getAction(actionId) : this.getActionOrStub(actionId);
        if (oldAction != null) {
            boolean isGroup;
            if (newAction instanceof OverridingAction) {
                this.myBaseActions.put((OverridingAction)newAction, oldAction);
            }
            if ((isGroup = oldAction instanceof ActionGroup) != newAction instanceof ActionGroup) {
                throw new IllegalStateException("cannot replace a group with an action and vice versa: " + actionId);
            }
            for (String groupId2 : this.idToGroupId.get((Object)actionId)) {
                DefaultActionGroup group2 = (DefaultActionGroup)this.getActionOrStub(groupId2);
                if (group2 == null) {
                    throw new IllegalStateException("Trying to replace action which has been added to a non-existing group " + groupId2);
                }
                group2.replaceAction(oldAction, newAction);
            }
            this.unregisterAction(actionId, false);
        }
        this.registerAction(actionId, newAction, pluginId);
        return oldAction;
    }

    public AnAction getBaseAction(OverridingAction overridingAction) {
        return this.myBaseActions.get(overridingAction);
    }

    public Collection<String> getParentGroupIds(String actionId) {
        return this.idToGroupId.get((Object)actionId);
    }

    public void addAnActionListener(AnActionListener listener2) {
        this.myActionListeners.add(listener2);
    }

    public void removeAnActionListener(AnActionListener listener2) {
        this.myActionListeners.remove(listener2);
    }

    public void fireBeforeActionPerformed(@NotNull AnAction action2, @NotNull AnActionEvent event) {
        if (action2 == null) {
            ActionManagerImpl.$$$reportNull$$$0(100);
        }
        if (event == null) {
            ActionManagerImpl.$$$reportNull$$$0(101);
        }
        this.myPrevPerformedActionId = this.myLastPreformedActionId;
        this.myLastPreformedActionId = this.getId(action2);
        if (this.myLastPreformedActionId == null && action2 instanceof ActionIdProvider) {
            this.myLastPreformedActionId = ((ActionIdProvider)action2).getId();
        }
        IdeaLogger.ourLastActionId = this.myLastPreformedActionId;
        try (AccessToken ignore = ProhibitAWTEvents.start("fireBeforeActionPerformed");){
            for (AnActionListener listener2 : this.myActionListeners) {
                listener2.beforeActionPerformed(action2, event);
            }
            ActionManagerImpl.publisher().beforeActionPerformed(action2, event);
            ActionsCollectorImpl.onBeforeActionInvoked(action2, event);
        }
    }

    public void fireAfterActionPerformed(@NotNull AnAction action2, @NotNull AnActionEvent event, @NotNull AnActionResult result2) {
        if (action2 == null) {
            ActionManagerImpl.$$$reportNull$$$0(102);
        }
        if (event == null) {
            ActionManagerImpl.$$$reportNull$$$0(103);
        }
        if (result2 == null) {
            ActionManagerImpl.$$$reportNull$$$0(104);
        }
        this.myPrevPerformedActionId = this.myLastPreformedActionId;
        IdeaLogger.ourLastActionId = this.myLastPreformedActionId = this.getId(action2);
        try (AccessToken ignore = ProhibitAWTEvents.start("fireAfterActionPerformed");){
            ActionsCollectorImpl.onAfterActionInvoked(action2, event, result2);
            for (AnActionListener listener2 : this.myActionListeners) {
                listener2.afterActionPerformed(action2, event, result2);
            }
            ActionManagerImpl.publisher().afterActionPerformed(action2, event, result2);
        }
    }

    public KeyboardShortcut getKeyboardShortcut(@NotNull String actionId) {
        Shortcut[] shortcuts;
        AnAction action2;
        if (actionId == null) {
            ActionManagerImpl.$$$reportNull$$$0(105);
        }
        if ((action2 = ActionManager.getInstance().getAction(actionId)) == null) {
            return null;
        }
        ShortcutSet shortcutSet = action2.getShortcutSet();
        for (Shortcut shortcut : shortcuts = shortcutSet.getShortcuts()) {
            KeyboardShortcut kb;
            if (!(shortcut instanceof KeyboardShortcut) || (kb = (KeyboardShortcut)shortcut).getSecondKeyStroke() != null) continue;
            return (KeyboardShortcut)shortcut;
        }
        return null;
    }

    public void fireBeforeEditorTyping(char c, @NotNull DataContext dataContext) {
        if (dataContext == null) {
            ActionManagerImpl.$$$reportNull$$$0(106);
        }
        this.myLastTimeEditorWasTypedIn = System.currentTimeMillis();
        for (AnActionListener listener2 : this.myActionListeners) {
            listener2.beforeEditorTyping(c, dataContext);
        }
        ActionManagerImpl.publisher().beforeEditorTyping(c, dataContext);
    }

    public void fireAfterEditorTyping(char c, @NotNull DataContext dataContext) {
        if (dataContext == null) {
            ActionManagerImpl.$$$reportNull$$$0(107);
        }
        for (AnActionListener listener2 : this.myActionListeners) {
            listener2.afterEditorTyping(c, dataContext);
        }
        ActionManagerImpl.publisher().afterEditorTyping(c, dataContext);
    }

    public String getLastPreformedActionId() {
        return this.myLastPreformedActionId;
    }

    public String getPrevPreformedActionId() {
        return this.myPrevPerformedActionId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public Set<String> getActionIds() {
        Object object = this.myLock;
        // MONITORENTER : object
        HashSet<String> hashSet = new HashSet<String>(this.idToAction.keySet());
        // MONITOREXIT : object
        if (hashSet != null) return hashSet;
        ActionManagerImpl.$$$reportNull$$$0(108);
        return hashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preloadActions(@NotNull ProgressIndicator indicator2) {
        ArrayList<String> ids;
        if (indicator2 == null) {
            ActionManagerImpl.$$$reportNull$$$0(109);
        }
        Iterator iterator2 = this.myLock;
        synchronized (iterator2) {
            ids = new ArrayList<String>(this.idToAction.keySet());
        }
        for (String id2 : ids) {
            indicator2.checkCanceled();
            this.getActionImpl(id2, false);
        }
    }

    @NotNull
    public ActionCallback tryToExecute(@NotNull AnAction action2, @Nullable InputEvent inputEvent, @Nullable Component contextComponent, @Nullable String place, boolean now) {
        if (action2 == null) {
            ActionManagerImpl.$$$reportNull$$$0(110);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        ActionCallback result2 = new ActionCallback();
        Runnable doRunnable = () -> this.tryToExecuteNow(action2, inputEvent, contextComponent, place, result2);
        if (now) {
            doRunnable.run();
        } else {
            SwingUtilities.invokeLater(doRunnable);
        }
        ActionCallback actionCallback = result2;
        if (actionCallback == null) {
            ActionManagerImpl.$$$reportNull$$$0(111);
        }
        return actionCallback;
    }

    private void tryToExecuteNow(@NotNull AnAction action2, @Nullable InputEvent inputEvent, @Nullable Component contextComponent, String place, ActionCallback result2) {
        if (action2 == null) {
            ActionManagerImpl.$$$reportNull$$$0(112);
        }
        Presentation presentation2 = action2.getTemplatePresentation().clone();
        IdeFocusManager.findInstanceByContext((DataContext)ActionManagerImpl.getContextBy(contextComponent)).doWhenFocusSettlesDown(() -> ((TransactionGuardImpl)TransactionGuard.getInstance()).performUserActivity(() -> {
            DataContext context2 = ActionManagerImpl.getContextBy(contextComponent);
            AnActionEvent event = new AnActionEvent(inputEvent, context2, place != null ? place : "unknown", presentation2, (ActionManager)this, inputEvent == null ? 0 : inputEvent.getModifiersEx());
            ActionUtil.performDumbAwareUpdate((boolean)LaterInvocator.isInModalContext(), (AnAction)action2, (AnActionEvent)event, (boolean)false);
            if (!event.getPresentation().isEnabled()) {
                result2.setRejected();
                return;
            }
            ActionUtil.lastUpdateAndCheckDumb((AnAction)action2, (AnActionEvent)event, (boolean)false);
            if (!event.getPresentation().isEnabled()) {
                result2.setRejected();
                return;
            }
            UIUtil.addAwtListener(event1 -> {
                if (!(event1.getID() != 200 && event1.getID() != 205 || result2.isProcessed())) {
                    WindowEvent we = (WindowEvent)event1;
                    IdeFocusManager.findInstanceByComponent((Component)we.getWindow()).doWhenFocusSettlesDown(result2.createSetDoneRunnable(), ModalityState.defaultModalityState());
                }
            }, (long)64L, (Disposable)result2);
            try {
                ActionUtil.performActionDumbAwareWithCallbacks((AnAction)action2, (AnActionEvent)event);
            }
            finally {
                result2.setDone();
            }
        }), ModalityState.defaultModalityState());
    }

    private static void updateHandlers(Object action2) {
        if (action2 instanceof EditorAction) {
            ((EditorAction)action2).clearDynamicHandlersCache();
        }
    }

    private static /* synthetic */ String lambda$processGroupElement$8(ResourceBundle bundle, String finalId, String description2) {
        return ActionManagerImpl.computeDescription(bundle, finalId, GROUP_ELEMENT_NAME, description2);
    }

    private static /* synthetic */ String lambda$processGroupElement$7(ResourceBundle bundle, String finalId, XmlElement element2, ClassLoader classLoader) {
        return ActionManagerImpl.computeActionText(bundle, finalId, GROUP_ELEMENT_NAME, (String)element2.attributes.get(TEXT_ATTR_NAME), classLoader);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 23: 
            case 32: 
            case 43: 
            case 45: 
            case 65: 
            case 89: 
            case 91: 
            case 108: 
            case 111: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 23: 
            case 32: 
            case 43: 
            case 45: 
            case 65: 
            case 89: 
            case 91: 
            case 108: 
            case 111: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "plugins";
                break;
            }
            case 1: 
            case 23: 
            case 32: 
            case 43: 
            case 45: 
            case 65: 
            case 89: 
            case 91: 
            case 108: 
            case 111: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/actionSystem/impl/ActionManagerImpl";
                break;
            }
            case 2: 
            case 6: 
            case 8: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stub";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stubClassName";
                break;
            }
            case 4: 
            case 12: 
            case 35: 
            case 71: 
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginDescriptor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedClass";
                break;
            }
            case 7: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anAction";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionManager";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 11: 
            case 37: 
            case 38: 
            case 49: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = ID_ATTR_NAME;
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iconPath";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bundle";
                break;
            }
            case 16: 
            case 53: 
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classLoader";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionName";
                break;
            }
            case 19: 
            case 36: 
            case 52: 
            case 60: 
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keymapManager";
                break;
            }
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keymapName";
                break;
            }
            case 24: 
            case 25: 
            case 94: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 26: 
            case 28: 
            case 30: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 27: 
            case 29: 
            case 31: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = GROUP_ELEMENT_NAME;
                break;
            }
            case 41: 
            case 56: 
            case 76: 
            case 78: 
            case 81: 
            case 83: 
            case 85: 
            case 100: 
            case 102: 
            case 110: 
            case 112: {
                objectArray2 = objectArray3;
                objectArray3[0] = ACTION_ELEMENT_NAME;
                break;
            }
            case 42: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "idPrefix";
                break;
            }
            case 46: 
            case 75: 
            case 77: 
            case 80: 
            case 82: 
            case 84: 
            case 86: 
            case 87: 
            case 88: 
            case 96: 
            case 98: 
            case 105: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionId";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionPlace";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messageActionGroup";
                break;
            }
            case 50: 
            case 54: 
            case 58: 
            case 62: 
            case 63: 
            case 67: 
            case 70: 
            case 72: 
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 51: 
            case 57: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "plugin";
                break;
            }
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = KEY_ATTR_NAME;
                break;
            }
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = KEYMAP_ATTR_NAME;
                break;
            }
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shortcut";
                break;
            }
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registeredID";
                break;
            }
            case 90: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginName";
                break;
            }
            case 92: 
            case 93: {
                objectArray2 = objectArray3;
                objectArray3[0] = "menu";
                break;
            }
            case 95: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 97: 
            case 99: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newAction";
                break;
            }
            case 101: 
            case 103: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 104: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 106: 
            case 107: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 109: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/actionSystem/impl/ActionManagerImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "publisher";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getContextBy";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "createActionToolbar";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionIdList";
                break;
            }
            case 45: 
            case 108: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionIds";
                break;
            }
            case 65: {
                objectArray = objectArray2;
                objectArray2[1] = "createSeparator";
                break;
            }
            case 89: {
                objectArray = objectArray2;
                objectArray2[1] = "getRegistrationOrderComparator";
                break;
            }
            case 91: {
                objectArray = objectArray2;
                objectArray2[1] = "getPluginActions";
                break;
            }
            case 111: {
                objectArray = objectArray2;
                objectArray2[1] = "tryToExecute";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "registerActions";
                break;
            }
            case 1: 
            case 23: 
            case 32: 
            case 43: 
            case 45: 
            case 65: 
            case 89: 
            case 91: 
            case 108: 
            case 111: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "convertStub";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "instantiate";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "updateIconFromStub";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "convertGroupStub";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "processAbbreviationNode";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "setIconFromClass";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "computeDescription";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "computeActionText";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "checkRelativeToAction";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "processMouseShortcutNode";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "reportActionError";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "reportKeymapNotFoundWarning";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "addTimerListener";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "removeTimerListener";
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "createActionPopupMenu";
                break;
            }
            case 30: 
            case 31: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "createActionToolbar";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "registerPluginActions";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getAction";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getActionImpl";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "replaceStub";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getId";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "getActionIdList";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "getActionIds";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "isGroup";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "createButtonToolbar";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "getActionOrStub";
                break;
            }
            case 50: 
            case 51: 
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "processActionElement";
                break;
            }
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "registerOrReplaceActionInner";
                break;
            }
            case 58: 
            case 59: 
            case 60: 
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "processGroupElement";
                break;
            }
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "processReferenceNode";
                break;
            }
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "processSeparatorNode";
                break;
            }
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "createSeparator";
                break;
            }
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "processKeyboardShortcutNode";
                break;
            }
            case 67: 
            case 68: 
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "processRemoveAndReplace";
                break;
            }
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "getReferenceActionId";
                break;
            }
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "checkUnloadActions";
                break;
            }
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "canUnloadGroup";
                break;
            }
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "unloadActions";
                break;
            }
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "unloadActionElement";
                break;
            }
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 84: 
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "registerAction";
                break;
            }
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "notifyCustomActionsSchema";
                break;
            }
            case 80: 
            case 81: {
                objectArray = objectArray;
                objectArray[2] = "addToMap";
                break;
            }
            case 82: 
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "reportActionIdCollision";
                break;
            }
            case 86: 
            case 87: {
                objectArray = objectArray;
                objectArray[2] = "unregisterAction";
                break;
            }
            case 88: {
                objectArray = objectArray;
                objectArray[2] = "prohibitAction";
                break;
            }
            case 90: {
                objectArray = objectArray;
                objectArray[2] = "getPluginActions";
                break;
            }
            case 92: {
                objectArray = objectArray;
                objectArray[2] = "addActionPopup";
                break;
            }
            case 93: {
                objectArray = objectArray;
                objectArray[2] = "removeActionPopup";
                break;
            }
            case 94: 
            case 95: {
                objectArray = objectArray;
                objectArray[2] = "addActionPopupMenuListener";
                break;
            }
            case 96: 
            case 97: 
            case 98: 
            case 99: {
                objectArray = objectArray;
                objectArray[2] = "replaceAction";
                break;
            }
            case 100: 
            case 101: {
                objectArray = objectArray;
                objectArray[2] = "fireBeforeActionPerformed";
                break;
            }
            case 102: 
            case 103: 
            case 104: {
                objectArray = objectArray;
                objectArray[2] = "fireAfterActionPerformed";
                break;
            }
            case 105: {
                objectArray = objectArray;
                objectArray[2] = "getKeyboardShortcut";
                break;
            }
            case 106: {
                objectArray = objectArray;
                objectArray[2] = "fireBeforeEditorTyping";
                break;
            }
            case 107: {
                objectArray = objectArray;
                objectArray[2] = "fireAfterEditorTyping";
                break;
            }
            case 109: {
                objectArray = objectArray;
                objectArray[2] = "preloadActions";
                break;
            }
            case 110: {
                objectArray = objectArray;
                objectArray[2] = "tryToExecute";
                break;
            }
            case 112: {
                objectArray = objectArray;
                objectArray[2] = "tryToExecuteNow";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 23: 
            case 32: 
            case 43: 
            case 45: 
            case 65: 
            case 89: 
            case 91: 
            case 108: 
            case 111: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private final class MyTimer
    extends Timer
    implements ActionListener {
        final List<TimerListener> listeners;
        private int myLastTimePerformed;

        private MyTimer() {
            super(500, null);
            this.listeners = ContainerUtil.createLockFreeCopyOnWriteList();
            this.addActionListener(this);
            this.setRepeats(true);
            MessageBusConnection connection = ApplicationManager.getApplication().getMessageBus().connect();
            connection.subscribe(ApplicationActivationListener.TOPIC, (Object)new ApplicationActivationListener(){

                public void applicationActivated(@NotNull IdeFrame ideFrame) {
                    if (ideFrame == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    MyTimer.this.setDelay(500);
                    MyTimer.this.restart();
                }

                public void applicationDeactivated(@NotNull IdeFrame ideFrame) {
                    if (ideFrame == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    MyTimer.this.setDelay(5000);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    objectArray2[0] = "ideFrame";
                    objectArray2[1] = "com/intellij/openapi/actionSystem/impl/ActionManagerImpl$MyTimer$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "applicationActivated";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "applicationDeactivated";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }

        public String toString() {
            return "Action manager timer";
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (ActionManagerImpl.this.myLastTimeEditorWasTypedIn + 500L > System.currentTimeMillis()) {
                return;
            }
            int lastEventCount = this.myLastTimePerformed;
            this.myLastTimePerformed = ActivityTracker.getInstance().getCount();
            if (this.myLastTimePerformed == lastEventCount) {
                return;
            }
            for (TimerListener listener2 : this.listeners) {
                this.runListenerAction(listener2);
            }
        }

        private void runListenerAction(@NotNull TimerListener listener2) {
            ModalityState modalityState;
            if (listener2 == null) {
                MyTimer.$$$reportNull$$$0(0);
            }
            if ((modalityState = listener2.getModalityState()) == null) {
                return;
            }
            LOG.debug("notify ", new Object[]{listener2});
            if (!ModalityState.current().dominates(modalityState)) {
                try {
                    listener2.run();
                }
                catch (ProcessCanceledException processCanceledException) {
                }
                catch (Throwable e) {
                    LOG.error(e);
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/actionSystem/impl/ActionManagerImpl$MyTimer", "runListenerAction"));
        }
    }
}

