/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application;

import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import java.util.prefs.Preferences;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class PermanentInstallationID {
    private static final Logger LOG = Logger.getInstance((String)"#PermanentInstallationID");
    private static final String OLD_USER_ON_MACHINE_ID_KEY = "JetBrains.UserIdOnMachine";
    @NonNls
    private static final String INSTALLATION_ID_KEY = "user_id_on_machine";
    private static final String INSTALLATION_ID = PermanentInstallationID.calculateInstallationId();

    @NotNull
    public static String get() {
        String string = INSTALLATION_ID;
        if (string == null) {
            PermanentInstallationID.$$$reportNull$$$0(0);
        }
        return string;
    }

    private static String calculateInstallationId() {
        String installationId = null;
        try {
            ApplicationInfoEx appInfo = ApplicationInfoImpl.getShadowInstance();
            Preferences oldPrefs = Preferences.userRoot();
            String oldValue = appInfo.isVendorJetBrains() ? oldPrefs.get(OLD_USER_ON_MACHINE_ID_KEY, null) : null;
            String companyName = appInfo.getShortCompanyName();
            Preferences prefs = Preferences.userRoot().node(StringUtil.isEmptyOrSpaces((String)companyName) ? "jetbrains" : StringUtil.toLowerCase((String)companyName));
            installationId = prefs.get(INSTALLATION_ID_KEY, null);
            if (StringUtil.isEmptyOrSpaces((String)installationId)) {
                installationId = !StringUtil.isEmptyOrSpaces((String)oldValue) ? oldValue : UUID.randomUUID().toString();
                prefs.put(INSTALLATION_ID_KEY, installationId);
            }
            if (!appInfo.isVendorJetBrains()) {
                return installationId;
            }
            if (SystemInfo.isWindows) {
                installationId = PermanentInstallationID.syncWithSharedFile("PermanentUserId", installationId, prefs, INSTALLATION_ID_KEY);
            }
            if (!installationId.equals(oldValue)) {
                oldPrefs.put(OLD_USER_ON_MACHINE_ID_KEY, installationId);
            }
        }
        catch (Throwable ex) {
            LOG.info("Unexpected error initializing Installation ID", ex);
        }
        return installationId == null ? UUID.randomUUID().toString() : installationId;
    }

    @NotNull
    public static String syncWithSharedFile(@NotNull String fileName, @NotNull String installationId, @NotNull Preferences prefs, @NotNull String prefsKey) {
        if (fileName == null) {
            PermanentInstallationID.$$$reportNull$$$0(1);
        }
        if (installationId == null) {
            PermanentInstallationID.$$$reportNull$$$0(2);
        }
        if (prefs == null) {
            PermanentInstallationID.$$$reportNull$$$0(3);
        }
        if (prefsKey == null) {
            PermanentInstallationID.$$$reportNull$$$0(4);
        }
        try {
            File dir;
            String appdata = System.getenv("APPDATA");
            if (appdata != null && ((dir = new File(appdata, "JetBrains")).exists() || dir.mkdirs())) {
                File permanentIdFile = new File(dir, fileName);
                String fromFile = "";
                if (permanentIdFile.exists()) {
                    fromFile = PermanentInstallationID.loadFromFile(permanentIdFile).trim();
                }
                if (!fromFile.isEmpty()) {
                    if (!fromFile.equals(installationId)) {
                        installationId = fromFile;
                        prefs.put(prefsKey, installationId);
                    }
                } else {
                    PermanentInstallationID.writeToFile(permanentIdFile, installationId);
                }
            }
        }
        catch (Throwable ex) {
            LOG.info("Error synchronizing Installation ID", ex);
        }
        String string = installationId;
        if (string == null) {
            PermanentInstallationID.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    private static String loadFromFile(@NotNull File file2) throws IOException {
        if (file2 == null) {
            PermanentInstallationID.$$$reportNull$$$0(6);
        }
        FileInputStream is = new FileInputStream(file2);
        byte[] bytes = FileUtilRt.loadBytes((InputStream)is);
        int offset = CharsetToolkit.hasUTF8Bom((byte[])bytes) ? CharsetToolkit.UTF8_BOM.length : 0;
        String string = new String(bytes, offset, bytes.length - offset, StandardCharsets.UTF_8);
        String string2 = string;
        if (string2 == null) {
            PermanentInstallationID.$$$reportNull$$$0(7);
        }
        return string2;
        finally {
            is.close();
        }
    }

    private static void writeToFile(@NotNull File file2, @NotNull String text2) throws IOException {
        if (file2 == null) {
            PermanentInstallationID.$$$reportNull$$$0(8);
        }
        if (text2 == null) {
            PermanentInstallationID.$$$reportNull$$$0(9);
        }
        try (DataOutputStream stream = new DataOutputStream(new FileOutputStream(file2));){
            stream.write(text2.getBytes(StandardCharsets.UTF_8));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 9: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 9: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/application/PermanentInstallationID";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "installationId";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefs";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefsKey";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "get";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/application/PermanentInstallationID";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "syncWithSharedFile";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "loadFromFile";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "syncWithSharedFile";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "loadFromFile";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "writeToFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 9: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

