/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.command.impl;

import com.intellij.ide.IdeBundle;
import com.intellij.openapi.command.impl.DocumentReferenceByDocument;
import com.intellij.openapi.command.impl.EditorAndState;
import com.intellij.openapi.command.impl.MentionOnlyUndoableAction;
import com.intellij.openapi.command.impl.MovementAvailability;
import com.intellij.openapi.command.impl.SharedUndoRedoStacksHolder;
import com.intellij.openapi.command.impl.UndoManagerImpl;
import com.intellij.openapi.command.impl.UndoRedoStacksHolder;
import com.intellij.openapi.command.impl.UndoReportHandler;
import com.intellij.openapi.command.impl.UndoableGroup;
import com.intellij.openapi.command.undo.ActionChangeRange;
import com.intellij.openapi.command.undo.AdjustableUndoableAction;
import com.intellij.openapi.command.undo.DocumentReference;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.command.undo.UnexpectedUndoException;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.FileEditorStateLevel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

abstract class UndoRedo {
    protected final UndoManagerImpl myManager;
    protected final FileEditor myEditor;
    protected final UndoableGroup myUndoableGroup;

    protected UndoRedo(UndoManagerImpl manager2, FileEditor editor) {
        this.myManager = manager2;
        this.myEditor = editor;
        this.myUndoableGroup = this.getLastAction();
    }

    private UndoableGroup getLastAction() {
        return this.getStacksHolder().getLastAction(this.getDocRefs());
    }

    boolean isTransparent() {
        return this.myUndoableGroup.isTransparent();
    }

    boolean isTemporary() {
        return this.myUndoableGroup.isTemporary();
    }

    boolean hasMoreActions() {
        return this.getStacksHolder().canBeUndoneOrRedone(this.getDocRefs());
    }

    private Collection<DocumentReference> getDocRefs() {
        return this.myEditor == null ? Collections.emptySet() : UndoManagerImpl.getDocumentReferences(this.myEditor);
    }

    protected abstract UndoRedoStacksHolder getStacksHolder();

    protected abstract UndoRedoStacksHolder getReverseStacksHolder();

    protected abstract SharedUndoRedoStacksHolder getSharedStacksHolder();

    protected abstract SharedUndoRedoStacksHolder getSharedReverseStacksHolder();

    @NlsContexts.DialogTitle
    protected abstract String getActionName();

    @NlsContexts.DialogMessage
    protected abstract String getActionName(String var1);

    protected abstract EditorAndState getBeforeState();

    protected abstract EditorAndState getAfterState();

    protected abstract void performAction() throws UnexpectedUndoException;

    protected abstract void setBeforeState(EditorAndState var1);

    public boolean execute(boolean drop, boolean disableConfirmation) {
        Collection<Document> readOnlyDocuments;
        Collection<VirtualFile> readOnlyFiles;
        if (!this.myUndoableGroup.isUndoable()) {
            this.reportNonUndoable(this.myUndoableGroup.getAffectedDocuments());
            return false;
        }
        Set<DocumentReference> clashing = this.getStacksHolder().collectClashingActions(this.myUndoableGroup);
        if (!clashing.isEmpty()) {
            this.reportClashingDocuments(clashing);
            return false;
        }
        Map<DocumentReference, Set<ActionChangeRange>> reference2Ranges = UndoRedo.decompose(this.myUndoableGroup, this.isRedo());
        SharedUndoRedoStacksHolder sharedStacksHolder = this.getSharedStacksHolder();
        boolean shouldMove = false;
        for (Map.Entry<DocumentReference, Set<ActionChangeRange>> entry2 : reference2Ranges.entrySet()) {
            MovementAvailability availability = sharedStacksHolder.canMoveToStackTop(entry2.getKey(), entry2.getValue());
            if (availability == MovementAvailability.CANNOT_MOVE) {
                this.reportCannotAdjust(Collections.singleton(entry2.getKey()));
                return false;
            }
            if (availability != MovementAvailability.CAN_MOVE) continue;
            shouldMove = true;
        }
        if (shouldMove) {
            for (Map.Entry<DocumentReference, Set<ActionChangeRange>> entry2 : reference2Ranges.entrySet()) {
                sharedStacksHolder.moveToStackTop(entry2.getKey(), entry2.getValue());
            }
        }
        if (!disableConfirmation && this.myUndoableGroup.shouldAskConfirmation(this.isRedo()) && !UndoManagerImpl.ourNeverAskUser) {
            if (!this.askUser()) {
                return false;
            }
        } else if (!shouldMove && this.restore(this.getBeforeState(), true)) {
            this.setBeforeState(new EditorAndState(this.myEditor, this.myEditor.getState(FileEditorStateLevel.UNDO)));
            return true;
        }
        if (!(readOnlyFiles = this.collectReadOnlyAffectedFiles()).isEmpty()) {
            Project project = this.myManager.getProject();
            if (project == null) {
                return false;
            }
            ReadonlyStatusHandler.OperationStatus operationStatus = ReadonlyStatusHandler.getInstance((Project)project).ensureFilesWritable(readOnlyFiles);
            if (operationStatus.hasReadonlyFiles()) {
                return false;
            }
        }
        if (!(readOnlyDocuments = this.collectReadOnlyDocuments()).isEmpty()) {
            for (Document document : readOnlyDocuments) {
                document.fireReadOnlyModificationAttempt();
            }
            return false;
        }
        this.getStacksHolder().removeFromStacks(this.myUndoableGroup);
        if (!drop) {
            this.getReverseStacksHolder().addToStacks(this.myUndoableGroup);
        }
        SharedUndoRedoStacksHolder sharedReverseStacksHolder = this.getSharedReverseStacksHolder();
        for (Map.Entry<DocumentReference, Set<ActionChangeRange>> entry3 : reference2Ranges.entrySet()) {
            DocumentReference reference2 = entry3.getKey();
            int rangeCount = entry3.getValue().size();
            for (int i2 = 0; i2 < rangeCount; ++i2) {
                ActionChangeRange changeRange = sharedStacksHolder.removeLastFromStack(reference2);
                ActionChangeRange inverted2 = changeRange.asInverted();
                if (drop) {
                    inverted2 = inverted2.createIndependentCopy(true);
                }
                sharedReverseStacksHolder.addToStack(reference2, inverted2);
            }
        }
        try {
            this.performAction();
        }
        catch (UnexpectedUndoException e) {
            this.reportException(e);
            return false;
        }
        if (!shouldMove) {
            this.restore(this.getAfterState(), false);
        }
        return true;
    }

    private static Map<DocumentReference, Set<ActionChangeRange>> decompose(@NotNull UndoableGroup group2, boolean isRedo) {
        if (group2 == null) {
            UndoRedo.$$$reportNull$$$0(0);
        }
        HashMap<DocumentReference, Set<ActionChangeRange>> reference2Ranges = new HashMap<DocumentReference, Set<ActionChangeRange>>();
        for (UndoableAction undoableAction : group2.getActions()) {
            AdjustableUndoableAction adjustable;
            DocumentReference[] affected;
            if (!(undoableAction instanceof AdjustableUndoableAction) || (affected = (adjustable = (AdjustableUndoableAction)undoableAction).getAffectedDocuments()) == null) continue;
            for (DocumentReference reference2 : affected) {
                Set savedChangeRanges = reference2Ranges.computeIfAbsent(reference2, r -> new HashSet());
                for (ActionChangeRange changeRange : adjustable.getChangeRanges(reference2)) {
                    savedChangeRanges.add(isRedo ? changeRange.asInverted() : changeRange);
                }
            }
        }
        return reference2Ranges;
    }

    protected abstract boolean isRedo();

    private Collection<Document> collectReadOnlyDocuments() {
        ArrayList<Document> readOnlyDocs = new ArrayList<Document>();
        for (UndoableAction undoableAction : this.myUndoableGroup.getActions()) {
            DocumentReference[] refs;
            if (undoableAction instanceof MentionOnlyUndoableAction || (refs = undoableAction.getAffectedDocuments()) == null) continue;
            for (DocumentReference ref : refs) {
                Document doc;
                if (!(ref instanceof DocumentReferenceByDocument) || (doc = ref.getDocument()) == null || doc.isWritable()) continue;
                readOnlyDocs.add(doc);
            }
        }
        return readOnlyDocs;
    }

    private Collection<VirtualFile> collectReadOnlyAffectedFiles() {
        ArrayList<VirtualFile> readOnlyFiles = new ArrayList<VirtualFile>();
        for (UndoableAction undoableAction : this.myUndoableGroup.getActions()) {
            DocumentReference[] refs;
            if (undoableAction instanceof MentionOnlyUndoableAction || (refs = undoableAction.getAffectedDocuments()) == null) continue;
            for (DocumentReference ref : refs) {
                VirtualFile file2 = ref.getFile();
                if (file2 == null || !file2.isValid() || file2.isWritable()) continue;
                readOnlyFiles.add(file2);
            }
        }
        return readOnlyFiles;
    }

    private void reportNonUndoable(@NotNull Collection<? extends DocumentReference> problemFiles) {
        if (problemFiles == null) {
            UndoRedo.$$$reportNull$$$0(1);
        }
        UndoRedo.doWithReportHandler(handler2 -> handler2.reportNonUndoable(this.myManager.getProject(), problemFiles, !this.isRedo()));
    }

    private void reportClashingDocuments(@NotNull Collection<? extends DocumentReference> problemFiles) {
        if (problemFiles == null) {
            UndoRedo.$$$reportNull$$$0(2);
        }
        UndoRedo.doWithReportHandler(handler2 -> handler2.reportClashingDocuments(this.myManager.getProject(), problemFiles, !this.isRedo()));
    }

    private void reportCannotAdjust(@NotNull Collection<? extends DocumentReference> problemFiles) {
        if (problemFiles == null) {
            UndoRedo.$$$reportNull$$$0(3);
        }
        UndoRedo.doWithReportHandler(handler2 -> handler2.reportCannotAdjust(this.myManager.getProject(), problemFiles, !this.isRedo()));
    }

    private void reportException(@NotNull UnexpectedUndoException e) {
        if (e == null) {
            UndoRedo.$$$reportNull$$$0(4);
        }
        UndoRedo.doWithReportHandler(handler2 -> handler2.reportException(this.myManager.getProject(), e, !this.isRedo()));
    }

    private static void doWithReportHandler(Predicate<UndoReportHandler> condition2) {
        for (UndoReportHandler handler2 : UndoReportHandler.EP_NAME.getExtensionList()) {
            if (!condition2.test(handler2)) continue;
            return;
        }
    }

    private boolean askUser() {
        String actionText = this.getActionName(this.myUndoableGroup.getCommandName());
        return Messages.showOkCancelDialog((Project)this.myManager.getProject(), (String)(actionText + "?"), (String)this.getActionName(), (Icon)Messages.getQuestionIcon()) == 0;
    }

    boolean confirmSwitchTo(@NotNull UndoRedo other) {
        if (other == null) {
            UndoRedo.$$$reportNull$$$0(5);
        }
        String message2 = IdeBundle.message((String)"undo.conflicting.change.confirmation", (Object[])new Object[0]) + "\n" + this.getActionName(other.myUndoableGroup.getCommandName()) + "?";
        return Messages.showOkCancelDialog((Project)this.myManager.getProject(), (String)message2, (String)this.getActionName(), (Icon)Messages.getQuestionIcon()) == 0;
    }

    private boolean restore(EditorAndState pair, boolean onlyIfDiffers) {
        if (pair == null || this.myEditor == null || !this.myEditor.isValid() || !pair.canBeAppliedTo(this.myEditor)) {
            return false;
        }
        FileEditorState stateToRestore = pair.getState();
        FileEditorState currentState = this.myEditor.getState(FileEditorStateLevel.UNDO);
        if (onlyIfDiffers && currentState.equals(stateToRestore)) {
            return false;
        }
        this.myEditor.setState(stateToRestore);
        FileEditorState newState2 = this.myEditor.getState(FileEditorStateLevel.UNDO);
        return newState2.equals(stateToRestore);
    }

    public boolean isBlockedByOtherChanges() {
        return this.myUndoableGroup.isGlobal() && this.myUndoableGroup.isUndoable() && !this.getStacksHolder().collectClashingActions(this.myUndoableGroup).isEmpty();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problemFiles";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "other";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/command/impl/UndoRedo";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "decompose";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "reportNonUndoable";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "reportClashingDocuments";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "reportCannotAdjust";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "reportException";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "confirmSwitchTo";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

