/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff;

import com.intellij.diff.util.DiffDrawUtil;
import com.intellij.openapi.diff.DefaultFlagsProvider;
import com.intellij.openapi.diff.DefaultLineFlags;
import com.intellij.openapi.diff.DiffColors;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.EditorGutterComponentEx;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.vcs.ex.ChangedLines;
import com.intellij.openapi.vcs.ex.ChangesBlock;
import com.intellij.openapi.vcs.ex.LineStatusTrackerI;
import com.intellij.openapi.vcs.ex.Range;
import com.intellij.openapi.vcs.ex.VisibleRangeMerger;
import com.intellij.ui.paint.LinePainter2D;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.IntPair;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import kotlin.Unit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LineStatusMarkerDrawUtil {
    @NotNull
    public static List<Range> getSelectedRanges(@NotNull List<? extends Range> ranges, @NotNull Editor editor, int y) {
        if (ranges == null) {
            LineStatusMarkerDrawUtil.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            LineStatusMarkerDrawUtil.$$$reportNull$$$0(1);
        }
        int lineHeight = editor.getLineHeight();
        int triangleGap = lineHeight / 3;
        Rectangle clip = new Rectangle(0, y - lineHeight, editor.getComponent().getWidth(), lineHeight * 2);
        List<ChangesBlock<Unit>> blocks = VisibleRangeMerger.merge(editor, ranges, clip);
        ArrayList<Range> result2 = new ArrayList<Range>();
        for (ChangesBlock<Unit> block : blocks) {
            ChangedLines firstChange = block.changes.get(0);
            ChangedLines lastChange = block.changes.get(block.changes.size() - 1);
            int startY = firstChange.y1;
            int endY = lastChange.y2;
            if (firstChange.y1 == firstChange.y2) {
                startY -= triangleGap;
            }
            if (lastChange.y1 == lastChange.y2) {
                endY += triangleGap;
            }
            if (startY > y || endY <= y) continue;
            result2.addAll(block.ranges);
        }
        ArrayList<Range> arrayList = result2;
        if (arrayList == null) {
            LineStatusMarkerDrawUtil.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    public static Rectangle calcBounds(@NotNull List<? extends Range> ranges, @NotNull Editor editor, int lineNum) {
        int yStart;
        Rectangle clip;
        List<ChangesBlock<Unit>> blocks;
        if (ranges == null) {
            LineStatusMarkerDrawUtil.$$$reportNull$$$0(3);
        }
        if (editor == null) {
            LineStatusMarkerDrawUtil.$$$reportNull$$$0(4);
        }
        if ((blocks = VisibleRangeMerger.merge(editor, ranges, clip = new Rectangle(0, yStart = editor.visualLineToY(lineNum), 0, editor.getLineHeight()))).isEmpty()) {
            return null;
        }
        List changes = blocks.get((int)0).changes;
        int y = changes.get((int)0).y1;
        int endY = changes.get((int)(changes.size() - 1)).y2;
        if (y == endY) {
            endY += editor.getLineHeight();
        }
        IntPair area = LineStatusMarkerDrawUtil.getGutterArea(editor);
        return new Rectangle(area.first, y, area.second - area.first, endY - y);
    }

    public static void paintDefault(@NotNull Editor editor, @NotNull Graphics g, @NotNull LineStatusTrackerI<?> tracker2, @NotNull VisibleRangeMerger.FlagsProvider<DefaultLineFlags> flagsProvider, int framingBorder) {
        List<?> ranges;
        if (editor == null) {
            LineStatusMarkerDrawUtil.$$$reportNull$$$0(5);
        }
        if (g == null) {
            LineStatusMarkerDrawUtil.$$$reportNull$$$0(6);
        }
        if (tracker2 == null) {
            LineStatusMarkerDrawUtil.$$$reportNull$$$0(7);
        }
        if (flagsProvider == null) {
            LineStatusMarkerDrawUtil.$$$reportNull$$$0(8);
        }
        if ((ranges = tracker2.getRanges()) == null) {
            return;
        }
        List<ChangesBlock<DefaultLineFlags>> blocks = VisibleRangeMerger.merge(editor, ranges, flagsProvider, g.getClipBounds());
        for (ChangesBlock<DefaultLineFlags> block : blocks) {
            LineStatusMarkerDrawUtil.paintChangedLines((Graphics2D)g, editor, block.changes, framingBorder);
        }
    }

    public static void paintChangedLines(@NotNull Graphics2D g, @NotNull Editor editor, @NotNull List<? extends ChangedLines<DefaultLineFlags>> block, int framingBorder) {
        int start2;
        int end;
        if (g == null) {
            LineStatusMarkerDrawUtil.$$$reportNull$$$0(9);
        }
        if (editor == null) {
            LineStatusMarkerDrawUtil.$$$reportNull$$$0(10);
        }
        if (block == null) {
            LineStatusMarkerDrawUtil.$$$reportNull$$$0(11);
        }
        Color borderColor = LineStatusMarkerDrawUtil.getGutterBorderColor(editor);
        Color gutterBackgroundColor = ((EditorEx)editor).getGutterComponentEx().getBackground();
        IntPair area = LineStatusMarkerDrawUtil.getGutterArea(editor);
        int x = area.first;
        int endX = area.second;
        int y = block.get((int)0).y1;
        int endY = block.get((int)(block.size() - 1)).y2;
        if (framingBorder > 0 && y != endY) {
            g.setColor(gutterBackgroundColor);
            g.fillRect(x - framingBorder, y - framingBorder, endX - x + framingBorder, endY - y + framingBorder * 2);
        }
        for (ChangedLines<DefaultLineFlags> changedLines : block) {
            if (changedLines.y1 == changedLines.y2 || ((DefaultLineFlags)changedLines.flags).isIgnored) continue;
            int start22 = changedLines.y1;
            end = changedLines.y2;
            Color gutterColor = LineStatusMarkerDrawUtil.getGutterColor(changedLines.type, editor);
            LineStatusMarkerDrawUtil.paintRect(g, gutterColor, null, x, start22, endX, end);
        }
        if (borderColor == null) {
            for (ChangedLines<DefaultLineFlags> changedLines : block) {
                if (changedLines.y1 == changedLines.y2 || !((DefaultLineFlags)changedLines.flags).isIgnored) continue;
                start2 = changedLines.y1;
                end = changedLines.y2;
                Color ignoredBorderColor = LineStatusMarkerDrawUtil.getIgnoredGutterBorderColor(changedLines.type, editor);
                LineStatusMarkerDrawUtil.paintRect(g, null, ignoredBorderColor, x, start2, endX, end);
            }
        } else if (y != endY) {
            LineStatusMarkerDrawUtil.paintRect(g, null, borderColor, x, y, endX, endY);
        }
        for (ChangedLines<DefaultLineFlags> changedLines : block) {
            if (changedLines.y1 != changedLines.y2) continue;
            start2 = changedLines.y1;
            if (!((DefaultLineFlags)changedLines.flags).isIgnored) {
                Color gutterColor = LineStatusMarkerDrawUtil.getGutterColor(changedLines.type, editor);
                LineStatusMarkerDrawUtil.paintTriangle(g, editor, gutterColor, borderColor, x, endX, start2);
                continue;
            }
            Color ignoredBorderColor = borderColor != null ? borderColor : LineStatusMarkerDrawUtil.getIgnoredGutterBorderColor(changedLines.type, editor);
            LineStatusMarkerDrawUtil.paintTriangle(g, editor, null, ignoredBorderColor, x, endX, start2);
        }
    }

    public static void paintRange(@NotNull Graphics g, @NotNull Editor editor, @NotNull Range range2, int framingBorder, boolean isIgnored) {
        if (g == null) {
            LineStatusMarkerDrawUtil.$$$reportNull$$$0(12);
        }
        if (editor == null) {
            LineStatusMarkerDrawUtil.$$$reportNull$$$0(13);
        }
        if (range2 == null) {
            LineStatusMarkerDrawUtil.$$$reportNull$$$0(14);
        }
        VisibleRangeMerger.FlagsProvider<DefaultLineFlags> flagsProvider = isIgnored ? DefaultFlagsProvider.ALL_IGNORED : DefaultFlagsProvider.DEFAULT;
        List<ChangesBlock<DefaultLineFlags>> blocks = VisibleRangeMerger.merge(editor, Collections.singletonList(range2), flagsProvider, g.getClipBounds());
        for (ChangesBlock<DefaultLineFlags> block : blocks) {
            LineStatusMarkerDrawUtil.paintChangedLines((Graphics2D)g, editor, block.changes, framingBorder);
        }
    }

    public static void paintSimpleRange(Graphics g, Editor editor, int line1, int line2, @Nullable Color color) {
        IntPair horizontalArea = LineStatusMarkerDrawUtil.getGutterArea(editor);
        int x = horizontalArea.first;
        int endX = horizontalArea.second;
        int y = DiffDrawUtil.lineToY(editor, line1);
        int endY = DiffDrawUtil.lineToY(editor, line2);
        Color borderColor = LineStatusMarkerDrawUtil.getGutterBorderColor(editor);
        if (endY != y) {
            LineStatusMarkerDrawUtil.paintRect((Graphics2D)g, color, borderColor, x, y, endX, endY);
        } else {
            LineStatusMarkerDrawUtil.paintTriangle((Graphics2D)g, editor, color, borderColor, x, endX, y);
        }
    }

    @NotNull
    public static IntPair getGutterArea(@NotNull Editor editor) {
        if (editor == null) {
            LineStatusMarkerDrawUtil.$$$reportNull$$$0(15);
        }
        EditorGutterComponentEx gutter = ((EditorEx)editor).getGutterComponentEx();
        int x = gutter.getLineMarkerFreePaintersAreaOffset() + 1;
        int endX = gutter.getWhitespaceSeparatorOffset();
        return new IntPair(x, endX);
    }

    public static boolean isInsideMarkerArea(@NotNull MouseEvent e) {
        if (e == null) {
            LineStatusMarkerDrawUtil.$$$reportNull$$$0(16);
        }
        EditorGutterComponentEx gutter = (EditorGutterComponentEx)e.getComponent();
        return e.getX() > gutter.getLineMarkerFreePaintersAreaOffset();
    }

    public static void paintRect(@NotNull Graphics2D g, @Nullable Color color, @Nullable Color borderColor, int x1, int y1, int x2, int y2) {
        if (g == null) {
            LineStatusMarkerDrawUtil.$$$reportNull$$$0(17);
        }
        if (color != null) {
            g.setColor(color);
            g.fillRect(x1, y1, x2 - x1, y2 - y1);
        }
        if (borderColor != null) {
            Stroke oldStroke = g.getStroke();
            g.setStroke(new BasicStroke(JBUIScale.scale((int)1)));
            g.setColor(borderColor);
            LinePainter2D.paint((Graphics2D)g, (double)x1, (double)y1, (double)(x2 - 1), (double)y1);
            LinePainter2D.paint((Graphics2D)g, (double)x1, (double)y1, (double)x1, (double)(y2 - 1));
            LinePainter2D.paint((Graphics2D)g, (double)x1, (double)(y2 - 1), (double)(x2 - 1), (double)(y2 - 1));
            g.setStroke(oldStroke);
        }
    }

    public static void paintTriangle(@NotNull Graphics2D g, @NotNull Editor editor, @Nullable Color color, @Nullable Color borderColor, int x1, int x2, int y) {
        float editorScale;
        int size2;
        if (g == null) {
            LineStatusMarkerDrawUtil.$$$reportNull$$$0(18);
        }
        if (editor == null) {
            LineStatusMarkerDrawUtil.$$$reportNull$$$0(19);
        }
        if (y < (size2 = (int)JBUIScale.scale((float)(4.0f * (editorScale = editor instanceof EditorImpl ? ((EditorImpl)editor).getScale() : 1.0f))))) {
            y = size2;
        }
        int[] xPoints = new int[]{x1, x1, x2};
        int[] yPoints = new int[]{y - size2, y + size2, y};
        if (color != null) {
            g.setColor(color);
            g.fillPolygon(xPoints, yPoints, xPoints.length);
        }
        if (borderColor != null) {
            Stroke oldStroke = g.getStroke();
            g.setStroke(new BasicStroke(JBUIScale.scale((int)1)));
            g.setColor(borderColor);
            g.drawPolygon(xPoints, yPoints, xPoints.length);
            g.setStroke(oldStroke);
        }
    }

    @Nullable
    public static Color getGutterColor(byte type, @Nullable Editor editor) {
        EditorColorsScheme scheme2 = LineStatusMarkerDrawUtil.getColorScheme(editor);
        switch (type) {
            case 2: {
                return scheme2.getColor(EditorColors.ADDED_LINES_COLOR);
            }
            case 3: {
                return scheme2.getColor(EditorColors.DELETED_LINES_COLOR);
            }
            case 1: {
                return scheme2.getColor(EditorColors.MODIFIED_LINES_COLOR);
            }
            case 0: {
                return scheme2.getColor(EditorColors.WHITESPACES_MODIFIED_LINES_COLOR);
            }
        }
        assert (false);
        return null;
    }

    @Nullable
    public static Color getErrorStripeColor(@NotNull Range range2) {
        if (range2 == null) {
            LineStatusMarkerDrawUtil.$$$reportNull$$$0(20);
        }
        return LineStatusMarkerDrawUtil.getErrorStripeColor(range2.getType());
    }

    @Nullable
    public static Color getErrorStripeColor(byte type) {
        EditorColorsScheme scheme2 = LineStatusMarkerDrawUtil.getColorScheme(null);
        switch (type) {
            case 2: {
                return scheme2.getAttributes(DiffColors.DIFF_INSERTED).getErrorStripeColor();
            }
            case 3: {
                return scheme2.getAttributes(DiffColors.DIFF_DELETED).getErrorStripeColor();
            }
            case 1: {
                return scheme2.getAttributes(DiffColors.DIFF_MODIFIED).getErrorStripeColor();
            }
        }
        assert (false);
        return null;
    }

    @Nullable
    public static Color getIgnoredGutterBorderColor(byte type, @Nullable Editor editor) {
        EditorColorsScheme scheme2 = LineStatusMarkerDrawUtil.getColorScheme(editor);
        switch (type) {
            case 2: {
                return scheme2.getColor(EditorColors.IGNORED_ADDED_LINES_BORDER_COLOR);
            }
            case 3: {
                return scheme2.getColor(EditorColors.IGNORED_DELETED_LINES_BORDER_COLOR);
            }
            case 0: 
            case 1: {
                return scheme2.getColor(EditorColors.IGNORED_MODIFIED_LINES_BORDER_COLOR);
            }
        }
        assert (false);
        return null;
    }

    @Nullable
    public static Color getGutterBorderColor(@Nullable Editor editor) {
        return LineStatusMarkerDrawUtil.getColorScheme(editor).getColor(EditorColors.BORDER_LINES_COLOR);
    }

    @NotNull
    private static EditorColorsScheme getColorScheme(@Nullable Editor editor) {
        EditorColorsScheme editorColorsScheme = editor != null ? editor.getColorsScheme() : EditorColorsManager.getInstance().getGlobalScheme();
        if (editorColorsScheme == null) {
            LineStatusMarkerDrawUtil.$$$reportNull$$$0(21);
        }
        return editorColorsScheme;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 21: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 21: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ranges";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 10: 
            case 13: 
            case 15: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/diff/LineStatusMarkerDrawUtil";
                break;
            }
            case 6: 
            case 9: 
            case 12: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "g";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tracker";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "flagsProvider";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "block";
                break;
            }
            case 14: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/diff/LineStatusMarkerDrawUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedRanges";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getColorScheme";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedRanges";
                break;
            }
            case 2: 
            case 21: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "calcBounds";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "paintDefault";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "paintChangedLines";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "paintRange";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getGutterArea";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isInsideMarkerArea";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "paintRect";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "paintTriangle";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getErrorStripeColor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 21: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class DiffStripeTextAttributes
    extends TextAttributes {
        private final byte myType;

        public DiffStripeTextAttributes(byte type) {
            this.myType = type;
        }

        public byte getType() {
            return this.myType;
        }

        public Color getErrorStripeColor() {
            return LineStatusMarkerDrawUtil.getErrorStripeColor(this.myType);
        }
    }
}

