/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.dir;

import com.intellij.DynamicBundle;
import com.intellij.diff.DiffContentFactory;
import com.intellij.diff.chains.DiffRequestProducerException;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.EmptyContent;
import com.intellij.diff.impl.CacheDiffRequestProcessor;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.requests.SimpleDiffRequest;
import com.intellij.diff.tools.util.DiffDataKeys;
import com.intellij.diff.tools.util.PrevNextDifferenceIterable;
import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.ide.DataManager;
import com.intellij.ide.diff.DiffElement;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.ShortcutProvider;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.diff.impl.dir.DirDiffElementImpl;
import com.intellij.openapi.diff.impl.dir.DirDiffModelListener;
import com.intellij.openapi.diff.impl.dir.DirDiffTableCellRenderer;
import com.intellij.openapi.diff.impl.dir.DirDiffTableModel;
import com.intellij.openapi.diff.impl.dir.DirDiffWindow;
import com.intellij.openapi.diff.impl.dir.actions.DirDiffToolbarActions;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.pom.Navigatable;
import com.intellij.ui.ClickListener;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.FilterComponent;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.TableSpeedSearch;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.ui.components.JBLoadingPanelListener;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.table.JBTable;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DirDiffPanel
implements Disposable,
DataProvider {
    private static final Logger LOG = Logger.getInstance(DirDiffPanel.class);
    public static final String DIVIDER_PROPERTY = "dir.diff.panel.divider.location";
    private static final int DIVIDER_PROPERTY_DEFAULT_VALUE = 200;
    private JPanel myDiffPanel;
    private JBTable myTable;
    private JPanel myComponent;
    private JSplitPane mySplitPanel;
    private TextFieldWithBrowseButton mySourceDirField;
    private TextFieldWithBrowseButton myTargetDirField;
    private JBLabel myTargetDirLabel;
    private JBLabel mySourceDirLabel;
    private JPanel myToolBarPanel;
    private JPanel myRootPanel;
    private JPanel myFilterPanel;
    private JBLabel myFilterLabel;
    private JPanel myFilesPanel;
    private JPanel myHeaderPanel;
    private final FilterComponent myFilter;
    private final DirDiffTableModel myModel;
    private final DirDiffWindow myDiffWindow;
    private final MyDiffRequestProcessor myDiffRequestProcessor;
    private final PrevNextDifferenceIterable myPrevNextDifferenceIterable;
    private String oldFilter;
    public static final DataKey<DirDiffTableModel> DIR_DIFF_MODEL = DataKey.create("DIR_DIFF_MODEL");
    public static final DataKey<JTable> DIR_DIFF_TABLE = DataKey.create("DIR_DIFF_TABLE");

    public DirDiffPanel(DirDiffTableModel model2, DirDiffWindow wnd) {
        this.myModel = model2;
        this.myDiffWindow = wnd;
        this.$$$setupUI$$$();
        this.mySourceDirField.setText(model2.getSourceDir().getPath());
        this.myTargetDirField.setText(model2.getTargetDir().getPath());
        this.mySourceDirField.setBorder((Border)JBUI.Borders.emptyRight((int)8));
        this.myTargetDirField.setBorder((Border)JBUI.Borders.emptyRight((int)12));
        this.mySourceDirLabel.setIcon(model2.getSourceDir().getIcon());
        this.myTargetDirLabel.setIcon(model2.getTargetDir().getIcon());
        this.myTargetDirLabel.setBorder((Border)JBUI.Borders.emptyLeft((int)8));
        this.myModel.setTable(this.myTable);
        this.myModel.setPanel(this);
        Disposer.register((Disposable)this, (Disposable)this.myModel);
        this.myTable.setModel((TableModel)this.myModel);
        new TableSpeedSearch((JTable)this.myTable);
        DirDiffTableCellRenderer renderer2 = new DirDiffTableCellRenderer();
        this.myTable.setExpandableItemsEnabled(false);
        this.myTable.getTableHeader().setReorderingAllowed(false);
        this.myTable.setAutoResizeMode(1);
        this.myTable.setDefaultRenderer(Object.class, (TableCellRenderer)renderer2);
        this.myTable.getSelectionModel().setSelectionMode(2);
        Project project = this.myModel.getProject();
        this.myTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int ind;
                ListSelectionModel selectionModel = (ListSelectionModel)e.getSource();
                int lastIndex = e.getLastIndex();
                int firstIndex = e.getFirstIndex();
                DirDiffElementImpl last = DirDiffPanel.this.myModel.getElementAt(lastIndex);
                DirDiffElementImpl first = DirDiffPanel.this.myModel.getElementAt(firstIndex);
                if (last == null || first == null) {
                    DirDiffPanel.this.update(false);
                    return;
                }
                if (last.isSeparator() && selectionModel.isSelectedIndex(lastIndex)) {
                    ind = lastIndex + (lastIndex < firstIndex ? 1 : -1);
                    selectionModel.addSelectionInterval(ind, ind);
                }
                if (first.isSeparator() && selectionModel.isSelectedIndex(firstIndex)) {
                    ind = firstIndex + (firstIndex < lastIndex ? 1 : -1);
                    selectionModel.addSelectionInterval(ind, ind);
                } else {
                    DirDiffPanel.this.update(false);
                }
                DirDiffPanel.this.myDiffWindow.setTitle(DirDiffPanel.this.myModel.getTitle());
            }
        });
        if (model2.isOperationsEnabled()) {
            new DumbAwareAction(DiffBundle.messagePointer((String)"action.Anonymous.text.change.diff.operation", (Object[])new Object[0])){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    if (e == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    DirDiffPanel.this.changeOperationForSelection();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/diff/impl/dir/DirDiffPanel$2", "actionPerformed"));
                }
            }.registerCustomShortcutSet((ShortcutSet)CustomShortcutSet.fromString((String[])new String[]{"SPACE"}), (JComponent)this.myTable);
            new ClickListener(){

                public boolean onClick(@NotNull MouseEvent e, int clickCount) {
                    if (e == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    if (e.getButton() == 3) {
                        return false;
                    }
                    if (DirDiffPanel.this.myTable.getRowCount() > 0) {
                        int row2 = DirDiffPanel.this.myTable.rowAtPoint(e.getPoint());
                        int col = DirDiffPanel.this.myTable.columnAtPoint(e.getPoint());
                        if (row2 != -1 && col == (DirDiffPanel.this.myTable.getColumnCount() - 1) / 2) {
                            DirDiffPanel.this.changeOperationForSelection();
                        }
                    }
                    return true;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/diff/impl/dir/DirDiffPanel$3", "onClick"));
                }
            }.installOn((Component)this.myTable);
        }
        this.myTable.getActionMap().put("selectPreviousRow", this.createNavigationAction(false, false));
        this.myTable.getActionMap().put("selectNextRow", this.createNavigationAction(true, false));
        this.myTable.getActionMap().put("selectPreviousRowExtendSelection", this.createNavigationAction(false, true));
        this.myTable.getActionMap().put("selectNextRowExtendSelection", this.createNavigationAction(true, true));
        TableColumnModel columnModel = this.myTable.getColumnModel();
        for (int i2 = 0; i2 < columnModel.getColumnCount(); ++i2) {
            DirDiffTableModel.ColumnType type = this.myModel.getColumnType(i2);
            TableColumn column2 = columnModel.getColumn(i2);
            if (type == DirDiffTableModel.ColumnType.DATE) {
                column2.setPreferredWidth(JBUIScale.scale((int)110));
                column2.setMinWidth(JBUIScale.scale((int)90));
                continue;
            }
            if (type == DirDiffTableModel.ColumnType.SIZE) {
                column2.setPreferredWidth(JBUIScale.scale((int)120));
                column2.setMinWidth(JBUIScale.scale((int)90));
                continue;
            }
            if (type == DirDiffTableModel.ColumnType.NAME) {
                column2.setPreferredWidth(JBUIScale.scale((int)800));
                column2.setMinWidth(JBUIScale.scale((int)120));
                continue;
            }
            if (type != DirDiffTableModel.ColumnType.OPERATION) continue;
            column2.setMaxWidth(JBUIScale.scale((int)25));
            column2.setMinWidth(JBUIScale.scale((int)25));
        }
        DirDiffToolbarActions actions2 = new DirDiffToolbarActions(this.myModel, this.myDiffPanel);
        ActionManager actionManager = ActionManager.getInstance();
        ActionToolbar toolbar = actionManager.createActionToolbar("DirDiff", (ActionGroup)actions2, true);
        DirDiffPanel.registerCustomShortcuts(actions2, (JComponent)this.myTable);
        this.myToolBarPanel.add((Component)toolbar.getComponent(), "Center");
        if (model2.isOperationsEnabled()) {
            JBLabel label2 = new JBLabel(DiffBundle.message((String)"use.space.button.or.mouse.click", (Object[])new Object[0]), 0);
            label2.setForeground(UIUtil.getInactiveTextColor());
            UIUtil.applyStyle((UIUtil.ComponentStyle)UIUtil.ComponentStyle.MINI, (Component)label2);
            this.myFilesPanel.add((Component)label2, "South");
        }
        DataManager.registerDataProvider((JComponent)this.myFilesPanel, (DataProvider)this);
        PopupHandler.installPopupMenu((JComponent)this.myTable, (String)"DirDiffMenu", (String)"DirDiffPanel");
        JBLoadingPanel loadingPanel2 = new JBLoadingPanel((LayoutManager)new BorderLayout(), wnd.getDisposable());
        loadingPanel2.addListener((JBLoadingPanelListener)new JBLoadingPanelListener.Adapter(){
            boolean showHelp = true;

            public void onLoadingFinish() {
                long count;
                if (this.showHelp && DirDiffPanel.this.myModel.isOperationsEnabled() && DirDiffPanel.this.myModel.getRowCount() > 0 && (count = PropertiesComponent.getInstance().getLong("dir.diff.space.button.info", 0L)) < 3L) {
                    JBPopupFactory.getInstance().createBalloonBuilder((JComponent)new JLabel(DiffBundle.message((String)"use.space.button.to.change.operation", (Object[])new Object[0]))).setFadeoutTime(5000L).setContentInsets((Insets)JBUI.insets((int)15)).createBalloon().show(new RelativePoint((Component)DirDiffPanel.this.myTable, new Point(DirDiffPanel.this.myTable.getWidth() / 2, 0)), Balloon.Position.above);
                    PropertiesComponent.getInstance().setValue("dir.diff.space.button.info", String.valueOf(count + 1L));
                }
                this.showHelp = false;
            }
        });
        loadingPanel2.add((Component)this.myComponent, (Object)"Center");
        ComponentUtil.putClientProperty((JComponent)this.myTable, DirDiffTableModel.DECORATOR_KEY, (Object)loadingPanel2);
        this.myTable.addComponentListener((ComponentListener)new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                DirDiffPanel.this.myTable.removeComponentListener((ComponentListener)this);
                DirDiffPanel.this.myModel.reloadModel(false);
            }
        });
        this.myRootPanel.removeAll();
        this.myRootPanel.add((Component)loadingPanel2, "Center");
        this.myFilter = new MyFilterComponent();
        this.myModel.addModelListener(new DirDiffModelListener(){

            @Override
            public void updateStarted() {
                UIUtil.setEnabled((Component)DirDiffPanel.this.myFilter, (boolean)false, (boolean)true);
            }

            @Override
            public void updateFinished() {
                UIUtil.setEnabled((Component)DirDiffPanel.this.myFilter, (boolean)true, (boolean)true);
            }
        });
        this.myFilter.getTextEditor().setColumns(10);
        this.myFilter.setFilter(this.myModel.getSettings().getFilter());
        this.oldFilter = this.myFilter.getFilter();
        this.myFilterPanel.add((Component)this.myFilter, "Center");
        this.myFilterLabel.setLabelFor((Component)this.myFilter);
        this.setDirFieldChooser(this.myModel.getSourceDir().getElementChooser(project), false);
        this.setDirFieldChooser(this.myModel.getTargetDir().getElementChooser(project), true);
        this.myDiffRequestProcessor = new MyDiffRequestProcessor(project);
        Disposer.register((Disposable)this, (Disposable)this.myDiffRequestProcessor);
        this.myDiffPanel.add((Component)this.myDiffRequestProcessor.getComponent(), "Center");
        this.myPrevNextDifferenceIterable = new MyPrevNextDifferenceIterable();
    }

    private void setDirFieldChooser(final @Nullable Callable<DiffElement<?>> chooser2, final boolean isTarget) {
        final @NotNull TextFieldWithBrowseButton dirField = isTarget ? this.myTargetDirField : this.mySourceDirField;
        dirField.setEditable(false);
        if (chooser2 != null && this.myModel.getSettings().enableChoosers) {
            dirField.setButtonEnabled(true);
            dirField.addActionListener((ActionListener)new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        DiffElement newElement = (DiffElement)chooser2.call();
                        if (newElement == null) {
                            return;
                        }
                        if (StringUtil.equals((CharSequence)dirField.getText(), (CharSequence)newElement.getPath())) {
                            return;
                        }
                        dirField.setText(newElement.getPath());
                        if (isTarget) {
                            DirDiffPanel.this.myModel.setTargetDir(newElement);
                        } else {
                            DirDiffPanel.this.myModel.setSourceDir(newElement);
                        }
                        DirDiffPanel.this.myModel.clear();
                        DirDiffPanel.this.myModel.reloadModel(true);
                        DirDiffPanel.this.myModel.updateFromUI();
                    }
                    catch (Exception err) {
                        LOG.warn((Throwable)err);
                    }
                }
            });
        } else {
            Dimension preferredSize = dirField.getPreferredSize();
            dirField.setButtonEnabled(false);
            dirField.getButton().setVisible(false);
            dirField.setPreferredSize(preferredSize);
        }
    }

    @NotNull
    private AbstractAction createNavigationAction(final boolean goDown, final boolean withSelection) {
        return new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int row2;
                int n = row2 = goDown ? DirDiffPanel.this.getNextRow() : DirDiffPanel.this.getPrevRow();
                if (row2 != -1) {
                    DirDiffPanel.this.selectRow(row2, withSelection);
                }
            }
        };
    }

    private int getNextRow() {
        DirDiffElementImpl element2;
        if (this.myTable.getSelectedRows().length == 0) {
            return -1;
        }
        int rowCount = this.myTable.getRowCount();
        int row2 = this.myTable.getSelectionModel().getLeadSelectionIndex();
        do {
            if (row2 >= rowCount) {
                return -1;
            }
            if ((element2 = this.myModel.getElementAt(++row2)) != null) continue;
            return -1;
        } while (element2.isSeparator());
        return row2;
    }

    private int getPrevRow() {
        DirDiffElementImpl element2;
        if (this.myTable.getSelectedRows().length == 0) {
            return -1;
        }
        int row2 = this.myTable.getSelectionModel().getLeadSelectionIndex();
        do {
            if (row2 <= 0) {
                return -1;
            }
            if ((element2 = this.myModel.getElementAt(--row2)) != null) continue;
            return -1;
        } while (element2.isSeparator());
        return row2;
    }

    private void selectRow(int row2, boolean extend) {
        if (row2 == -1) {
            return;
        }
        DirDiffElementImpl element2 = this.myModel.getElementAt(row2);
        if (element2 == null || element2.isSeparator()) {
            return;
        }
        this.myTable.changeSelection(row2, (this.myModel.getColumnCount() - 1) / 2, false, extend);
    }

    public AnAction[] getActions() {
        return new DirDiffToolbarActions(this.myModel, this.myDiffPanel).getChildren(null);
    }

    public JComponent extractFilterPanel() {
        this.myHeaderPanel.setVisible(false);
        return this.myFilterPanel;
    }

    private void changeOperationForSelection() {
        for (int row2 : this.myTable.getSelectedRows()) {
            DirDiffElementImpl element2;
            if (row2 == -1 || (element2 = this.myModel.getElementAt(row2)) == null) continue;
            element2.setNextOperation();
            this.myModel.fireTableRowsUpdated(row2, row2);
        }
    }

    public void update(boolean force) {
        this.myDiffRequestProcessor.updateRequest(force);
    }

    private static void registerCustomShortcuts(DirDiffToolbarActions actions2, JComponent component2) {
        for (AnAction action2 : actions2.getChildren(null)) {
            ShortcutSet shortcut;
            if (!(action2 instanceof ShortcutProvider) || (shortcut = ((ShortcutProvider)action2).getShortcut()) == null) continue;
            action2.registerCustomShortcutSet(shortcut, component2);
        }
    }

    public void focusTable() {
        Project project = this.myModel.getProject();
        IdeFocusManager focusManager = project == null || project.isDefault() ? IdeFocusManager.getGlobalInstance() : IdeFocusManager.getInstance((Project)project);
        focusManager.requestFocus((Component)this.myTable, true);
    }

    public String getFilter() {
        return this.myFilter.getFilter();
    }

    private void fireFilterUpdated() {
        String newFilter = this.myFilter.getFilter();
        if (!StringUtil.equals((CharSequence)this.oldFilter, (CharSequence)newFilter)) {
            this.oldFilter = newFilter;
            this.myModel.getSettings().setFilter(newFilter);
            this.myModel.applySettings();
        }
    }

    public JComponent getPanel() {
        return this.myRootPanel;
    }

    public JBTable getTable() {
        return this.myTable;
    }

    public void dispose() {
        this.myModel.stopUpdating();
        PropertiesComponent.getInstance().setValue(DIVIDER_PROPERTY, this.mySplitPanel.getDividerLocation(), 200);
    }

    private void createUIComponents() {
        this.myTable = new MyJBTable();
        this.mySourceDirField = new TextFieldWithBrowseButton(null, (Disposable)this);
        this.myTargetDirField = new TextFieldWithBrowseButton(null, (Disposable)this);
        final AtomicBoolean callUpdate = new AtomicBoolean(true);
        this.myRootPanel = new JPanel(new BorderLayout()){

            @Override
            protected void paintChildren(Graphics g) {
                super.paintChildren(g);
                if (callUpdate.get()) {
                    callUpdate.set(false);
                    DirDiffPanel.this.myModel.reloadModel(false);
                }
            }
        };
    }

    public void setupSplitter() {
        int value2 = PropertiesComponent.getInstance().getInt(DIVIDER_PROPERTY, 200);
        this.mySplitPanel.setDividerLocation(value2);
    }

    @Override
    public Object getData(@NotNull @NonNls String dataId) {
        if (dataId == null) {
            DirDiffPanel.$$$reportNull$$$0(0);
        }
        if (CommonDataKeys.PROJECT.is(dataId)) {
            return this.myModel.getProject();
        }
        if (DIR_DIFF_MODEL.is(dataId)) {
            return this.myModel;
        }
        if (DIR_DIFF_TABLE.is(dataId)) {
            return this.myTable;
        }
        if (DiffDataKeys.NAVIGATABLE_ARRAY.is(dataId)) {
            return this.getNavigatableArray();
        }
        if (DiffDataKeys.PREV_NEXT_DIFFERENCE_ITERABLE.is(dataId)) {
            return this.myPrevNextDifferenceIterable;
        }
        return null;
    }

    private Navigatable @NotNull [] getNavigatableArray() {
        Project project = this.myModel.getProject();
        List<DirDiffElementImpl> elements = this.myModel.getSelectedElements();
        ArrayList<Navigatable> navigatables = new ArrayList<Navigatable>();
        for (DirDiffElementImpl element2 : elements) {
            Navigatable navigatable2;
            DiffElement source = element2.getSource();
            DiffElement target2 = element2.getTarget();
            Navigatable navigatable1 = source != null ? source.getNavigatable(project) : null;
            Navigatable navigatable = navigatable2 = target2 != null ? target2.getNavigatable(project) : null;
            if (navigatable1 != null) {
                navigatables.add(navigatable1);
            }
            if (navigatable2 == null) continue;
            navigatables.add(navigatable2);
        }
        Navigatable[] navigatableArray = navigatables.toArray(Navigatable.EMPTY_NAVIGATABLE_ARRAY);
        if (navigatableArray == null) {
            DirDiffPanel.$$$reportNull$$$0(1);
        }
        return navigatableArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/diff/impl/dir/DirDiffPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/diff/impl/dir/DirDiffPanel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getNavigatableArray";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel2;
        JBLabel jBLabel;
        JPanel jPanel3;
        JPanel jPanel4;
        JPanel jPanel5;
        JBLabel jBLabel2;
        JBLabel jBLabel3;
        JPanel jPanel6;
        JSplitPane jSplitPane;
        JPanel jPanel7;
        this.createUIComponents();
        JPanel jPanel8 = this.myRootPanel;
        jPanel8.setLayout(new BorderLayout(0, 0));
        this.myComponent = jPanel7 = new JPanel();
        jPanel7.setLayout(new BorderLayout(0, 0));
        jPanel8.add((Component)jPanel7, "Center");
        this.mySplitPanel = jSplitPane = new JSplitPane();
        jSplitPane.setDividerLocation(422);
        jSplitPane.setOrientation(0);
        jPanel7.add((Component)jSplitPane, "Center");
        jSplitPane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), null, 0, 0, null, null));
        this.myDiffPanel = jPanel6 = new JPanel();
        jPanel6.setLayout(new BorderLayout(0, 0));
        jSplitPane.setRightComponent(jPanel6);
        JPanel jPanel9 = new JPanel();
        jPanel9.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jSplitPane.setLeftComponent(jPanel9);
        JPanel jPanel10 = new JPanel();
        jPanel10.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel9.add((Component)jPanel10, new GridConstraints(0, 0, 1, 1, 1, 1, 7, 0, null, null, null));
        JPanel jPanel11 = new JPanel();
        jPanel11.setLayout(new BorderLayout(0, 0));
        jPanel10.add((Component)jPanel11, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.mySourceDirLabel = jBLabel3 = new JBLabel();
        jPanel11.add((Component)jBLabel3, "West");
        TextFieldWithBrowseButton textFieldWithBrowseButton2 = this.mySourceDirField;
        jPanel11.add((Component)textFieldWithBrowseButton2, "Center");
        JPanel jPanel12 = new JPanel();
        jPanel12.setLayout(new BorderLayout(0, 0));
        jPanel10.add((Component)jPanel12, new GridConstraints(1, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myTargetDirLabel = jBLabel2 = new JBLabel();
        jPanel12.add((Component)jBLabel2, "West");
        TextFieldWithBrowseButton textFieldWithBrowseButton3 = this.myTargetDirField;
        jPanel12.add((Component)textFieldWithBrowseButton3, "Center");
        JPanel jPanel13 = new JPanel();
        jPanel13.setLayout(new BorderLayout(0, 0));
        jPanel10.add((Component)jPanel13, new GridConstraints(0, 0, 1, 2, 0, 3, 7, 3, null, null, null));
        this.myHeaderPanel = jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel13.add((Component)jPanel5, "Center");
        this.myToolBarPanel = jPanel4 = new JPanel();
        jPanel4.setLayout(new BorderLayout(0, 0));
        jPanel5.add((Component)jPanel4, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myFilterPanel = jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout(0, 0));
        jPanel5.add((Component)jPanel3, new GridConstraints(0, 2, 1, 1, 1, 1, 0, 0, null, null, null));
        this.myFilterLabel = jBLabel = new JBLabel();
        jBLabel.setHorizontalAlignment(2);
        jBLabel.setIconTextGap(0);
        this.$$$loadLabelText$$$((JLabel)jBLabel, DynamicBundle.getBundle((String)"messages/DiffBundle", DirDiffPanel.class).getString("button.dirdiff.filter"));
        jPanel3.add((Component)jBLabel, "West");
        Spacer spacer = new Spacer();
        jPanel5.add((Component)spacer, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myFilesPanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        jPanel9.add((Component)jPanel2, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel2.add((Component)jBScrollPane, "Center");
        JBTable jBTable = this.myTable;
        jBTable.setIntercellSpacing(new Dimension(0, 0));
        jBTable.setShowHorizontalLines(false);
        jBTable.setShowVerticalLines(false);
        jBScrollPane.setViewportView((Component)jBTable);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRootPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int j = 0; j < string.length(); ++j) {
            if (string.charAt(j) == '&') {
                if (++j == string.length()) break;
                if (!bl && string.charAt(j) != '&') {
                    bl = true;
                    c = string.charAt(j);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(j));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private class MyFilterComponent
    extends FilterComponent {
        MyFilterComponent() {
            super("dir.diff.filter", 15, false);
            DumbAwareAction.create(e -> this.userTriggeredFilter()).registerCustomShortcutSet(CommonShortcuts.ENTER, (JComponent)((Object)this));
        }

        public void filter() {
            DirDiffPanel.this.fireFilterUpdated();
        }

        protected void onEscape(@NotNull KeyEvent e) {
            if (e == null) {
                MyFilterComponent.$$$reportNull$$$0(0);
            }
            e.consume();
            DirDiffPanel.this.focusTable();
        }

        protected JComponent getPopupLocationComponent() {
            return UIUtil.findComponentOfType((JComponent)super.getPopupLocationComponent(), JTextComponent.class);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/diff/impl/dir/DirDiffPanel$MyFilterComponent", "onEscape"));
        }
    }

    private static class ElementWrapper {
        @Nullable
        public final DiffElement sourceElement;
        @Nullable
        public final DiffElement targetElement;

        ElementWrapper(@NotNull DirDiffElementImpl element2) {
            if (element2 == null) {
                ElementWrapper.$$$reportNull$$$0(0);
            }
            this.sourceElement = element2.getSource();
            this.targetElement = element2.getTarget();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ElementWrapper wrapper2 = (ElementWrapper)o;
            return Objects.equals(this.sourceElement, wrapper2.sourceElement) && Objects.equals(this.targetElement, wrapper2.targetElement);
        }

        public int hashCode() {
            int result2 = this.sourceElement != null ? this.sourceElement.hashCode() : 0;
            result2 = 31 * result2 + (this.targetElement != null ? this.targetElement.hashCode() : 0);
            return result2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/openapi/diff/impl/dir/DirDiffPanel$ElementWrapper", "<init>"));
        }
    }

    private class MyDiffRequestProcessor
    extends CacheDiffRequestProcessor<ElementWrapper> {
        MyDiffRequestProcessor(Project project) {
            super(project, "DirDiff");
        }

        @Override
        @Nullable
        protected String getRequestName(@NotNull ElementWrapper element2) {
            if (element2 == null) {
                MyDiffRequestProcessor.$$$reportNull$$$0(0);
            }
            return null;
        }

        @Override
        protected ElementWrapper getCurrentRequestProvider() {
            DirDiffElementImpl element2 = DirDiffPanel.this.myModel.getElementAt(DirDiffPanel.this.myTable.getSelectedRow());
            return element2 != null ? new ElementWrapper(element2) : null;
        }

        @Override
        @NotNull
        protected DiffRequest loadRequest(@NotNull ElementWrapper element2, @NotNull ProgressIndicator indicator2) throws ProcessCanceledException, DiffRequestProducerException {
            if (element2 == null) {
                MyDiffRequestProcessor.$$$reportNull$$$0(1);
            }
            if (indicator2 == null) {
                MyDiffRequestProcessor.$$$reportNull$$$0(2);
            }
            Project project = DirDiffPanel.this.myModel.getProject();
            DiffElement sourceElement = element2.sourceElement;
            DiffElement targetElement = element2.targetElement;
            EmptyContent sourceContent = sourceElement != null ? sourceElement.createDiffContent(project, indicator2) : DiffContentFactory.getInstance().createEmpty();
            EmptyContent targetContent = targetElement != null ? targetElement.createDiffContent(project, indicator2) : DiffContentFactory.getInstance().createEmpty();
            return new SimpleDiffRequest(null, (DiffContent)sourceContent, (DiffContent)targetContent, null, null);
        }

        @Override
        protected boolean hasNextChange(boolean fromUpdate) {
            return DirDiffPanel.this.getNextRow() != -1;
        }

        @Override
        protected boolean hasPrevChange(boolean fromUpdate) {
            return DirDiffPanel.this.getPrevRow() != -1;
        }

        @Override
        protected void goToNextChange(boolean fromDifferences) {
            DirDiffPanel.this.selectRow(DirDiffPanel.this.getNextRow(), false);
            this.updateRequest(false, fromDifferences ? DiffUserDataKeysEx.ScrollToPolicy.FIRST_CHANGE : null);
        }

        @Override
        protected void goToPrevChange(boolean fromDifferences) {
            DirDiffPanel.this.selectRow(DirDiffPanel.this.getPrevRow(), false);
            this.updateRequest(false, fromDifferences ? DiffUserDataKeysEx.ScrollToPolicy.LAST_CHANGE : null);
        }

        @Override
        protected boolean isNavigationEnabled() {
            return DirDiffPanel.this.myModel.getRowCount() > 0;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/diff/impl/dir/DirDiffPanel$MyDiffRequestProcessor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getRequestName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "loadRequest";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class MyPrevNextDifferenceIterable
    implements PrevNextDifferenceIterable {
        private MyPrevNextDifferenceIterable() {
        }

        @Override
        public boolean canGoPrev() {
            return DirDiffPanel.this.getPrevRow() != -1;
        }

        @Override
        public boolean canGoNext() {
            return DirDiffPanel.this.getNextRow() != -1;
        }

        @Override
        public void goPrev() {
            DirDiffPanel.this.selectRow(DirDiffPanel.this.getPrevRow(), false);
        }

        @Override
        public void goNext() {
            DirDiffPanel.this.selectRow(DirDiffPanel.this.getNextRow(), false);
        }
    }

    private static class MyJBTable
    extends JBTable {
        private MyJBTable() {
        }

        public void doLayout() {
            super.doLayout();
            int totalWidth1 = 0;
            int totalWidth2 = 0;
            for (int i2 = 0; i2 < (this.columnModel.getColumnCount() - 1) / 2; ++i2) {
                TableColumn column1 = this.columnModel.getColumn(i2);
                TableColumn column2 = this.columnModel.getColumn(this.columnModel.getColumnCount() - i2 - 1);
                int delta = (column2.getWidth() - column1.getWidth()) / 2;
                if (Math.abs(delta) > 0) {
                    column1.setWidth(column1.getWidth() + delta);
                    column2.setWidth(column2.getWidth() - delta);
                }
                totalWidth1 += column1.getWidth();
                totalWidth2 += column2.getWidth();
            }
            TableColumn column1 = this.columnModel.getColumn(0);
            TableColumn column2 = this.columnModel.getColumn(this.columnModel.getColumnCount() - 1);
            int delta = (totalWidth2 - totalWidth1) / 2;
            if (Math.abs(delta) > 0) {
                column1.setWidth(column1.getWidth() + delta);
                column2.setWidth(column2.getWidth() - delta);
                totalWidth1 += delta;
                totalWidth2 -= delta;
            }
            if (totalWidth1 != totalWidth2 && totalWidth1 % 2 != 0) {
                column1.setWidth(column1.getWidth() - 1);
                column2.setWidth(column2.getWidth() + 1);
            }
        }
    }
}

