/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.patch.formove;

import com.intellij.history.Label;
import com.intellij.history.LocalHistory;
import com.intellij.history.LocalHistoryException;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.impl.patch.ApplyPatchContext;
import com.intellij.openapi.diff.impl.patch.ApplyPatchStatus;
import com.intellij.openapi.diff.impl.patch.FilePatch;
import com.intellij.openapi.diff.impl.patch.apply.ApplyFilePatchBase;
import com.intellij.openapi.diff.impl.patch.formove.PathsVerifier;
import com.intellij.openapi.diff.impl.patch.formove.TriggerAdditionOrDeletion;
import com.intellij.openapi.diff.impl.patch.formove.UndoApplyPatchDialog;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.VcsShowConfirmationOption;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.CommitContext;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vcs.changes.patch.ApplyPatchAction;
import com.intellij.openapi.vcs.impl.PartialChangesUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcsUtil.VcsImplUtil;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PatchApplier {
    private static final Logger LOG = Logger.getInstance(PatchApplier.class);
    private final Project myProject;
    private final VirtualFile myBaseDirectory;
    @NotNull
    private final List<? extends FilePatch> myPatches;
    private final CommitContext myCommitContext;
    @Nullable
    private final LocalChangeList myTargetChangeList;
    @NotNull
    private final List<FilePatch> myRemainingPatches;
    @NotNull
    private final List<FilePatch> myFailedPatches;
    private final PathsVerifier myVerifier;
    private final boolean myReverseConflict;
    private final @NlsContexts.Label @Nullable String myLeftConflictPanelTitle;
    private final @NlsContexts.Label @Nullable String myRightConflictPanelTitle;

    public PatchApplier(@NotNull Project project, @NotNull VirtualFile baseDirectory, @NotNull List<? extends FilePatch> patches2, @Nullable LocalChangeList targetChangeList, @Nullable CommitContext commitContext, boolean reverseConflict, @NlsContexts.Label @Nullable String leftConflictPanelTitle, @NlsContexts.Label @Nullable String rightConflictPanelTitle) {
        if (project == null) {
            PatchApplier.$$$reportNull$$$0(0);
        }
        if (baseDirectory == null) {
            PatchApplier.$$$reportNull$$$0(1);
        }
        if (patches2 == null) {
            PatchApplier.$$$reportNull$$$0(2);
        }
        this.myProject = project;
        this.myBaseDirectory = baseDirectory;
        this.myPatches = patches2;
        this.myTargetChangeList = targetChangeList;
        this.myCommitContext = commitContext;
        this.myReverseConflict = reverseConflict;
        this.myLeftConflictPanelTitle = leftConflictPanelTitle;
        this.myRightConflictPanelTitle = rightConflictPanelTitle;
        this.myRemainingPatches = new ArrayList<FilePatch>();
        this.myFailedPatches = new ArrayList<FilePatch>();
        this.myVerifier = new PathsVerifier(this.myProject, baseDirectory, this.myPatches);
    }

    public void setIgnoreContentRootsCheck() {
        this.myVerifier.setIgnoreContentRootsCheck(true);
    }

    public PatchApplier(@NotNull Project project, @NotNull VirtualFile baseDirectory, @NotNull List<? extends FilePatch> patches2, @Nullable LocalChangeList targetChangeList, @Nullable CommitContext commitContext) {
        if (project == null) {
            PatchApplier.$$$reportNull$$$0(3);
        }
        if (baseDirectory == null) {
            PatchApplier.$$$reportNull$$$0(4);
        }
        if (patches2 == null) {
            PatchApplier.$$$reportNull$$$0(5);
        }
        this(project, baseDirectory, patches2, targetChangeList, commitContext, false, null, null);
    }

    @NotNull
    public List<FilePatch> getRemainingPatches() {
        List<FilePatch> list2 = this.myRemainingPatches;
        if (list2 == null) {
            PatchApplier.$$$reportNull$$$0(6);
        }
        return list2;
    }

    @NotNull
    public Collection<FilePatch> getFailedPatches() {
        List<FilePatch> list2 = this.myFailedPatches;
        if (list2 == null) {
            PatchApplier.$$$reportNull$$$0(7);
        }
        return list2;
    }

    @NotNull
    private List<FilePatch> getBinaryPatches() {
        List list2 = ContainerUtil.mapNotNull(this.myVerifier.getBinaryPatches(), patchInfo -> patchInfo.getApplyPatch().getPatch());
        if (list2 == null) {
            PatchApplier.$$$reportNull$$$0(8);
        }
        return list2;
    }

    public void execute() {
        this.execute(true, false);
    }

    public ApplyPatchStatus execute(boolean showSuccessNotification, boolean silentAddDelete) {
        return PatchApplier.executePatchGroup(Collections.singletonList(this), this.myTargetChangeList, showSuccessNotification, silentAddDelete);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void runWithDefaultConfirmations(@NotNull Project project, boolean resetConfirmations, @NotNull Runnable task2) {
        if (project == null) {
            PatchApplier.$$$reportNull$$$0(9);
        }
        if (task2 == null) {
            PatchApplier.$$$reportNull$$$0(10);
        }
        if (!resetConfirmations) {
            task2.run();
        } else {
            ProjectLevelVcsManager vcsManager2 = ProjectLevelVcsManager.getInstance((Project)project);
            VcsShowConfirmationOption addConfirmation = vcsManager2.getStandardConfirmation(VcsConfiguration.StandardConfirmation.ADD, null);
            VcsShowConfirmationOption deleteConfirmation = vcsManager2.getStandardConfirmation(VcsConfiguration.StandardConfirmation.REMOVE, null);
            VcsShowConfirmationOption.Value addConfirmationValue = addConfirmation.getValue();
            VcsShowConfirmationOption.Value deleteConfirmationValue = deleteConfirmation.getValue();
            addConfirmation.setValue(VcsShowConfirmationOption.Value.DO_ACTION_SILENTLY);
            deleteConfirmation.setValue(VcsShowConfirmationOption.Value.DO_ACTION_SILENTLY);
            try {
                task2.run();
            }
            finally {
                addConfirmation.setValue(addConfirmationValue);
                deleteConfirmation.setValue(deleteConfirmationValue);
            }
        }
    }

    public static ApplyPatchStatus executePatchGroup(Collection<PatchApplier> group2, @Nullable LocalChangeList localChangeList) {
        return PatchApplier.executePatchGroup(group2, localChangeList, true, false);
    }

    private static ApplyPatchStatus executePatchGroup(@NotNull Collection<PatchApplier> group2, @Nullable LocalChangeList targetChangeList, boolean showSuccessNotification, boolean silentAddDelete) {
        if (group2 == null) {
            PatchApplier.$$$reportNull$$$0(11);
        }
        if (group2.isEmpty()) {
            return ApplyPatchStatus.SUCCESS;
        }
        Project project = group2.iterator().next().myProject;
        return (ApplyPatchStatus)((Object)PartialChangesUtil.computeUnderChangeListSync(project, targetChangeList, () -> {
            ApplyPatchStatus result2 = ApplyPatchStatus.SUCCESS;
            for (PatchApplier patchApplier : group2) {
                result2 = ApplyPatchStatus.and(result2, patchApplier.nonWriteActionPreCheck());
            }
            Label beforeLabel = LocalHistory.getInstance().putSystemLabel(project, VcsBundle.message((String)"patch.apply.before.patch.label.text", (Object[])new Object[0]));
            TriggerAdditionOrDeletion trigger = new TriggerAdditionOrDeletion(project);
            Ref refStatus = new Ref((Object)result2);
            ApplicationManager.getApplication().invokeAndWait(() -> {
                try {
                    PatchApplier.runWithDefaultConfirmations(project, silentAddDelete, () -> CommandProcessor.getInstance().executeCommand(project, () -> {
                        ArrayList<FilePath> toBeAdded = new ArrayList<FilePath>();
                        ArrayList<FilePath> toBeDeleted = new ArrayList<FilePath>();
                        for (PatchApplier applier : group2) {
                            refStatus.set((Object)ApplyPatchStatus.and((ApplyPatchStatus)((Object)((Object)((Object)((Object)((Object)refStatus.get()))))), applier.createFiles()));
                            toBeAdded.addAll(applier.myVerifier.getToBeAdded());
                            toBeDeleted.addAll(applier.myVerifier.getToBeDeleted());
                        }
                        trigger.prepare(toBeAdded, toBeDeleted);
                        if (refStatus.get() == ApplyPatchStatus.SUCCESS) {
                            refStatus.set(null);
                        }
                        for (PatchApplier applier : group2) {
                            refStatus.set((Object)ApplyPatchStatus.and((ApplyPatchStatus)((Object)((Object)((Object)((Object)((Object)refStatus.get()))))), applier.executeWritable()));
                            if (refStatus.get() != ApplyPatchStatus.ABORT) continue;
                            break;
                        }
                    }, VcsBundle.message((String)"patch.apply.command", (Object[])new Object[0]), null));
                }
                finally {
                    trigger.cleanup();
                    LocalHistory.getInstance().putSystemLabel(project, VcsBundle.message((String)"patch.apply.after.patch.label.text", (Object[])new Object[0]));
                }
            });
            result2 = (ApplyPatchStatus)((Object)((Object)refStatus.get()));
            result2 = result2 == null ? ApplyPatchStatus.FAILURE : result2;
            trigger.processIt();
            AtomicBoolean doRollback = new AtomicBoolean();
            if (result2 == ApplyPatchStatus.FAILURE) {
                ApplicationManager.getApplication().invokeAndWait(() -> doRollback.set(PatchApplier.askToRollback(project, group2)));
            }
            if (result2 == ApplyPatchStatus.ABORT || doRollback.get()) {
                PatchApplier.rollbackUnderProgressIfNeeded(project, beforeLabel);
            }
            if (showSuccessNotification || !ApplyPatchStatus.SUCCESS.equals((Object)result2)) {
                PatchApplier.showApplyStatus(project, result2);
            }
            HashSet<FilePath> directlyAffected = new HashSet<FilePath>();
            HashSet<VirtualFile> indirectlyAffected = new HashSet<VirtualFile>();
            for (PatchApplier applier : group2) {
                directlyAffected.addAll(applier.getDirectlyAffected());
                indirectlyAffected.addAll(applier.getIndirectlyAffected());
            }
            directlyAffected.addAll(trigger.getAffected());
            PatchApplier.refreshPassedFiles(project, directlyAffected, indirectlyAffected);
            return result2;
        }));
    }

    /*
     * WARNING - void declaration
     */
    @RequiresEdt
    private static boolean askToRollback(@NotNull Project project, @NotNull Collection<PatchApplier> collection) {
        void group2;
        Project project2;
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (project2 == null) {
            PatchApplier.$$$reportNull$$$0(12);
        }
        if (group2 == null) {
            PatchApplier.$$$reportNull$$$0(13);
        }
        List allFailed = ContainerUtil.concat((Iterable)group2, PatchApplier::getFailedPatches);
        boolean shouldInformAboutBinaries = ContainerUtil.exists((Iterable)group2, applier -> !applier.getBinaryPatches().isEmpty());
        List filePaths = ContainerUtil.map((Collection)allFailed, filePatch -> VcsUtil.getFilePath((String)((String)ObjectUtils.chooseNotNull((Object)filePatch.getAfterName(), (Object)filePatch.getBeforeName()))));
        UndoApplyPatchDialog undoApplyPatchDialog = new UndoApplyPatchDialog(project2, filePaths, shouldInformAboutBinaries);
        return undoApplyPatchDialog.showAndGet();
    }

    private static void rollbackUnderProgressIfNeeded(@NotNull Project project, @NotNull Label labelToRevert) {
        if (project == null) {
            PatchApplier.$$$reportNull$$$0(14);
        }
        if (labelToRevert == null) {
            PatchApplier.$$$reportNull$$$0(15);
        }
        Runnable rollback = () -> {
            try {
                labelToRevert.revert(project, project.getBaseDir());
                VcsNotifier.getInstance(project).notifyImportantWarning("vcs.patch.apply.aborted", VcsBundle.message((String)"patch.apply.aborted.title", (Object[])new Object[0]), VcsBundle.message((String)"patch.apply.aborted.message", (Object[])new Object[0]));
            }
            catch (LocalHistoryException e) {
                VcsNotifier.getInstance(project).notifyImportantWarning("vcs.patch.apply.rollback.failed", VcsBundle.message((String)"patch.apply.rollback.failed.title", (Object[])new Object[0]), VcsBundle.message((String)"patch.apply.rollback.failed.message", (Object[])new Object[0]));
            }
        };
        if (ApplicationManager.getApplication().isDispatchThread()) {
            ProgressManager.getInstance().runProcessWithProgressSynchronously(rollback, VcsBundle.message((String)"patch.apply.rollback.progress.title", (Object[])new Object[0]), true, project);
        } else {
            ProgressManager.progress((String)VcsBundle.message((String)"patch.apply.rollback.progress", (Object[])new Object[0]));
            rollback.run();
        }
    }

    @NotNull
    private ApplyPatchStatus nonWriteActionPreCheck() {
        List<FilePatch> failedPreCheck = this.myVerifier.nonWriteActionPreCheck();
        List<FilePatch> skipped = this.myVerifier.getSkipped();
        this.myRemainingPatches.addAll(this.myPatches);
        this.myFailedPatches.addAll(failedPreCheck);
        this.myPatches.removeAll(failedPreCheck);
        this.myPatches.removeAll(skipped);
        if (!failedPreCheck.isEmpty()) {
            ApplyPatchStatus applyPatchStatus = ApplyPatchStatus.FAILURE;
            if (applyPatchStatus == null) {
                PatchApplier.$$$reportNull$$$0(16);
            }
            return applyPatchStatus;
        }
        if (skipped.isEmpty()) {
            ApplyPatchStatus applyPatchStatus = ApplyPatchStatus.SUCCESS;
            if (applyPatchStatus == null) {
                PatchApplier.$$$reportNull$$$0(17);
            }
            return applyPatchStatus;
        }
        if (skipped.size() == this.myPatches.size()) {
            ApplyPatchStatus applyPatchStatus = ApplyPatchStatus.ALREADY_APPLIED;
            if (applyPatchStatus == null) {
                PatchApplier.$$$reportNull$$$0(18);
            }
            return applyPatchStatus;
        }
        ApplyPatchStatus applyPatchStatus = ApplyPatchStatus.PARTIAL;
        if (applyPatchStatus == null) {
            PatchApplier.$$$reportNull$$$0(19);
        }
        return applyPatchStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private ApplyPatchStatus executeWritable() {
        ReadonlyStatusHandler.OperationStatus readOnlyFilesStatus = ReadonlyStatusHandler.getInstance((Project)this.myProject).ensureFilesWritable(this.myVerifier.getWritableFiles());
        if (readOnlyFilesStatus.hasReadonlyFiles()) {
            PatchApplier.showError(this.myProject, readOnlyFilesStatus.getReadonlyFilesMessage());
            return ApplyPatchStatus.ABORT;
        }
        this.myFailedPatches.addAll(this.myVerifier.filterBadFileTypePatches());
        ApplyPatchStatus result2 = this.myFailedPatches.isEmpty() ? null : ApplyPatchStatus.FAILURE;
        List<PathsVerifier.PatchAndFile> textPatches = this.myVerifier.getTextPatches();
        try {
            PatchApplier.markInternalOperation(textPatches, true);
            ApplyPatchStatus applyPatchStatus = ApplyPatchStatus.and(result2, this.actualApply(textPatches, this.myVerifier.getBinaryPatches(), this.myCommitContext));
            return applyPatchStatus;
        }
        finally {
            PatchApplier.markInternalOperation(textPatches, false);
        }
    }

    @NotNull
    private ApplyPatchStatus createFiles() {
        Boolean isSuccess = (Boolean)ApplicationManager.getApplication().runWriteAction(() -> {
            List<FilePatch> filePatches = this.myVerifier.execute();
            this.myFailedPatches.addAll(filePatches);
            this.myPatches.removeAll(filePatches);
            return this.myFailedPatches.isEmpty();
        });
        ApplyPatchStatus applyPatchStatus = isSuccess != false ? ApplyPatchStatus.SUCCESS : ApplyPatchStatus.FAILURE;
        if (applyPatchStatus == null) {
            PatchApplier.$$$reportNull$$$0(20);
        }
        return applyPatchStatus;
    }

    private static void markInternalOperation(List<PathsVerifier.PatchAndFile> textPatches, boolean set2) {
        for (PathsVerifier.PatchAndFile patch2 : textPatches) {
            ChangesUtil.markInternalOperation((VirtualFile)patch2.getFile(), (boolean)set2);
        }
    }

    private List<FilePath> getDirectlyAffected() {
        return this.myVerifier.getDirectlyAffected();
    }

    private List<VirtualFile> getIndirectlyAffected() {
        return this.myVerifier.getAllAffected();
    }

    private static void refreshPassedFiles(@NotNull Project project, @NotNull Collection<? extends FilePath> directlyAffected, @NotNull Collection<? extends VirtualFile> indirectlyAffected) {
        if (project == null) {
            PatchApplier.$$$reportNull$$$0(21);
        }
        if (directlyAffected == null) {
            PatchApplier.$$$reportNull$$$0(22);
        }
        if (indirectlyAffected == null) {
            PatchApplier.$$$reportNull$$$0(23);
        }
        LocalFileSystem lfs = LocalFileSystem.getInstance();
        for (FilePath filePath : directlyAffected) {
            lfs.refreshAndFindFileByIoFile(filePath.getIOFile());
        }
        if (project.isDisposed()) {
            return;
        }
        VcsDirtyScopeManager vcsDirtyScopeManager = VcsDirtyScopeManager.getInstance((Project)project);
        vcsDirtyScopeManager.filePathsDirty(directlyAffected, null);
        vcsDirtyScopeManager.filesDirty(indirectlyAffected, null);
    }

    @Nullable
    private ApplyPatchStatus actualApply(@NotNull List<PathsVerifier.PatchAndFile> textPatches, @NotNull List<PathsVerifier.PatchAndFile> binaryPatches, @Nullable CommitContext commitContext) {
        if (textPatches == null) {
            PatchApplier.$$$reportNull$$$0(24);
        }
        if (binaryPatches == null) {
            PatchApplier.$$$reportNull$$$0(25);
        }
        ApplyPatchContext context2 = new ApplyPatchContext(this.myBaseDirectory, 0, true, true);
        try {
            ApplyPatchStatus status = this.applyList(textPatches, context2, null, commitContext);
            return status == ApplyPatchStatus.ABORT ? status : this.applyList(binaryPatches, context2, status, commitContext);
        }
        catch (IOException e) {
            PatchApplier.showError(this.myProject, e.getMessage());
            return ApplyPatchStatus.ABORT;
        }
    }

    @Nullable
    private ApplyPatchStatus applyList(@NotNull List<PathsVerifier.PatchAndFile> patches2, @NotNull ApplyPatchContext context2, @Nullable ApplyPatchStatus status, @Nullable CommitContext commitContext) throws IOException {
        if (patches2 == null) {
            PatchApplier.$$$reportNull$$$0(26);
        }
        if (context2 == null) {
            PatchApplier.$$$reportNull$$$0(27);
        }
        for (PathsVerifier.PatchAndFile patch2 : patches2) {
            ApplyFilePatchBase<?> applyFilePatch = patch2.getApplyPatch();
            ApplyPatchStatus patchStatus = ApplyPatchAction.applyContent(this.myProject, applyFilePatch, context2, patch2.getFile(), commitContext, this.myReverseConflict, this.myLeftConflictPanelTitle, this.myRightConflictPanelTitle);
            if (patchStatus == ApplyPatchStatus.SUCCESS || patchStatus == ApplyPatchStatus.ALREADY_APPLIED) {
                PatchApplier.applyAdditionalPatchData(patch2.getFile(), applyFilePatch.getPatch());
            }
            if (patchStatus == ApplyPatchStatus.ABORT) {
                return patchStatus;
            }
            status = ApplyPatchStatus.and(status, patchStatus);
            if (patchStatus == ApplyPatchStatus.FAILURE) {
                this.myFailedPatches.add((FilePatch)applyFilePatch.getPatch());
                continue;
            }
            if (patchStatus == ApplyPatchStatus.SKIP) continue;
            this.myVerifier.doMoveIfNeeded(patch2.getFile());
            this.myRemainingPatches.remove(applyFilePatch.getPatch());
        }
        return status;
    }

    private static <V extends FilePatch> void applyAdditionalPatchData(@NotNull VirtualFile fileToApplyData, @NotNull V filePatch) {
        if (fileToApplyData == null) {
            PatchApplier.$$$reportNull$$$0(28);
        }
        if (filePatch == null) {
            PatchApplier.$$$reportNull$$$0(29);
        }
        int newFileMode = filePatch.getNewFileMode();
        File file2 = VfsUtilCore.virtualToIoFile((VirtualFile)fileToApplyData);
        if (newFileMode == 100755 || newFileMode == 100644) {
            try {
                file2.setExecutable(newFileMode == 100755);
            }
            catch (Exception e) {
                LOG.warn("Can't change file mode for " + fileToApplyData.getPresentableName());
            }
        }
    }

    private static void showApplyStatus(@NotNull Project project, ApplyPatchStatus status) {
        if (project == null) {
            PatchApplier.$$$reportNull$$$0(30);
        }
        VcsNotifier vcsNotifier = VcsNotifier.getInstance(project);
        if (status == ApplyPatchStatus.ALREADY_APPLIED) {
            vcsNotifier.notifyMinorInfo("vcs.patch.already.applied", VcsBundle.message((String)"patch.apply.notification.title", (Object[])new Object[0]), VcsBundle.message((String)"patch.apply.already.applied", (Object[])new Object[0]));
        } else if (status == ApplyPatchStatus.PARTIAL) {
            vcsNotifier.notifyMinorInfo("vcs.patch.partially.applied", VcsBundle.message((String)"patch.apply.notification.title", (Object[])new Object[0]), VcsBundle.message((String)"patch.apply.partially.applied", (Object[])new Object[0]));
        } else if (status == ApplyPatchStatus.SUCCESS) {
            vcsNotifier.notifySuccess("vcs.patch.apply.success.applied", "", VcsBundle.message((String)"patch.apply.success.applied.text", (Object[])new Object[0]));
        }
    }

    public static void showError(Project project, @NlsContexts.DialogMessage String message2) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        VcsImplUtil.showErrorMessage(project, message2, VcsBundle.message((String)"patch.apply.dialog.title", (Object[])new Object[0]));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseDirectory";
                break;
            }
            case 2: 
            case 5: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patches";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/diff/impl/patch/formove/PatchApplier";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "labelToRevert";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directlyAffected";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indirectlyAffected";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textPatches";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "binaryPatches";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileToApplyData";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePatch";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/diff/impl/patch/formove/PatchApplier";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getRemainingPatches";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFailedPatches";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getBinaryPatches";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "nonWriteActionPreCheck";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "createFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "runWithDefaultConfirmations";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "executePatchGroup";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "askToRollback";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "rollbackUnderProgressIfNeeded";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "refreshPassedFiles";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "actualApply";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "applyList";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "applyAdditionalPatchData";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "showApplyStatus";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

