/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions;

import com.intellij.application.options.EditorFontsConstants;
import com.intellij.ide.lightEdit.LightEditCompatible;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.editor.EditorBundle;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.terminal.JBTerminalWidget;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 \u000e2\u00020\u00012\u00020\u0002:\u0003\u000e\u000f\u0010B\u001f\b\u0002\u0012\u000e\u0010\u0003\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0001\u0002\u0011\u0012\u00a8\u0006\u0013"}, d2={"Lcom/intellij/openapi/editor/actions/TerminalChangeFontSizeAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "Lcom/intellij/ide/lightEdit/LightEditCompatible;", "text", "Ljava/util/function/Supplier;", "", "myStep", "", "(Ljava/util/function/Supplier;I)V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "Companion", "DecreaseEditorFontSize", "IncreaseEditorFontSize", "Lcom/intellij/openapi/editor/actions/TerminalChangeFontSizeAction$IncreaseEditorFontSize;", "Lcom/intellij/openapi/editor/actions/TerminalChangeFontSizeAction$DecreaseEditorFontSize;", "intellij.platform.execution.impl"})
public abstract class TerminalChangeFontSizeAction
extends DumbAwareAction
implements LightEditCompatible {
    private final int myStep;
    @NotNull
    public static final Companion Companion = new Companion(null);

    public void actionPerformed(@NotNull AnActionEvent e) {
        int newFontSize;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        JBTerminalWidget terminalWidget = Companion.getTerminalWidget(e);
        if (terminalWidget != null && (newFontSize = terminalWidget.getFontSize() + this.myStep) >= EditorFontsConstants.getMinEditorFontSize() && newFontSize <= EditorFontsConstants.getMaxEditorFontSize()) {
            terminalWidget.setFontSize(newFontSize);
        }
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Presentation presentation2 = e.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation2, (String)"e.presentation");
        presentation2.setEnabled(Companion.getTerminalWidget(e) != null);
    }

    private TerminalChangeFontSizeAction(Supplier<String> text2, int myStep) {
        super(text2);
        this.myStep = myStep;
    }

    public /* synthetic */ TerminalChangeFontSizeAction(Supplier text2, int myStep, DefaultConstructorMarker $constructor_marker) {
        this(text2, myStep);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/intellij/openapi/editor/actions/TerminalChangeFontSizeAction$IncreaseEditorFontSize;", "Lcom/intellij/openapi/editor/actions/TerminalChangeFontSizeAction;", "()V", "intellij.platform.execution.impl"})
    public static final class IncreaseEditorFontSize
    extends TerminalChangeFontSizeAction {
        public IncreaseEditorFontSize() {
            Supplier supplier2 = EditorBundle.messagePointer((String)"increase.editor.font", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)supplier2, (String)"EditorBundle.messagePoin\u2026r(\"increase.editor.font\")");
            super(supplier2, 1, null);
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/intellij/openapi/editor/actions/TerminalChangeFontSizeAction$DecreaseEditorFontSize;", "Lcom/intellij/openapi/editor/actions/TerminalChangeFontSizeAction;", "()V", "intellij.platform.execution.impl"})
    public static final class DecreaseEditorFontSize
    extends TerminalChangeFontSizeAction {
        public DecreaseEditorFontSize() {
            Supplier supplier2 = EditorBundle.messagePointer((String)"decrease.editor.font", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)supplier2, (String)"EditorBundle.messagePoin\u2026r(\"decrease.editor.font\")");
            super(supplier2, -1, null);
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/openapi/editor/actions/TerminalChangeFontSizeAction$Companion;", "", "()V", "getTerminalWidget", "Lcom/intellij/terminal/JBTerminalWidget;", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.platform.execution.impl"})
    public static final class Companion {
        @Nullable
        public final JBTerminalWidget getTerminalWidget(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            return e.getDataContext().getData(JBTerminalWidget.TERMINAL_DATA_KEY);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

