/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.colors.impl;

import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponentWithModificationTracker;
import com.intellij.openapi.components.ReportValue;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.EditorFontCache;
import com.intellij.openapi.editor.colors.FontPreferences;
import com.intellij.openapi.editor.colors.ModifiableFontPreferences;
import com.intellij.openapi.editor.colors.impl.FontPreferencesImpl;
import com.intellij.openapi.editor.impl.FontFamilyService;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.util.SystemProperties;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="DefaultFont", storages={@Storage(value="editor.xml")})
public final class AppEditorFontOptions
implements PersistentStateComponentWithModificationTracker<PersistentFontPreferences> {
    private static final Logger LOG = Logger.getInstance(AppEditorFontOptions.class);
    public static final boolean NEW_FONT_SELECTOR = SystemProperties.getBooleanProperty((String)"new.editor.font.selector", (boolean)true);
    private final FontPreferencesImpl myFontPreferences = new FontPreferencesImpl();
    private final SimpleModificationTracker myTracker = new SimpleModificationTracker();

    public AppEditorFontOptions() {
        Application app = ApplicationManager.getApplication();
        if (!app.isHeadlessEnvironment() || app.isUnitTestMode()) {
            this.myFontPreferences.register(FontPreferences.DEFAULT_FONT_NAME, UISettings.restoreFontSize((int)FontPreferences.DEFAULT_FONT_SIZE, (Float)Float.valueOf(1.0f)));
        }
    }

    public long getStateModificationCount() {
        return this.myTracker.getModificationCount();
    }

    public static AppEditorFontOptions getInstance() {
        return (AppEditorFontOptions)ApplicationManager.getApplication().getService(AppEditorFontOptions.class);
    }

    @NotNull
    public PersistentFontPreferences getState() {
        return new PersistentFontPreferences((FontPreferences)this.myFontPreferences);
    }

    public void loadState(@NotNull PersistentFontPreferences state) {
        if (state == null) {
            AppEditorFontOptions.$$$reportNull$$$0(0);
        }
        AppEditorFontOptions.copyState(state, this.myFontPreferences);
        this.myFontPreferences.setChangeListener(() -> EditorFontCache.getInstance().reset());
    }

    private static void copyState(PersistentFontPreferences state, @NotNull ModifiableFontPreferences fontPreferences) {
        if (fontPreferences == null) {
            AppEditorFontOptions.$$$reportNull$$$0(1);
        }
        fontPreferences.clear();
        int fontSize = UISettings.restoreFontSize((int)state.FONT_SIZE, (Float)Float.valueOf(state.FONT_SCALE));
        String[] names2 = AppEditorFontOptions.migrateFamilyNameIfNeeded(state.FONT_FAMILY, state.FONT_REGULAR_SUB_FAMILY, state.FONT_BOLD_SUB_FAMILY);
        fontPreferences.register(names2[0], fontSize);
        fontPreferences.setRegularSubFamily(names2[1]);
        fontPreferences.setBoldSubFamily(names2[2]);
        fontPreferences.setLineSpacing(state.LINE_SPACING);
        fontPreferences.setUseLigatures(state.USE_LIGATURES);
        if (state.SECONDARY_FONT_FAMILY != null) {
            fontPreferences.register(state.SECONDARY_FONT_FAMILY, fontSize);
        }
    }

    private static String[] migrateFamilyNameIfNeeded(String family, String regularSubFamily, String boldSubFamily) {
        if (regularSubFamily == null && boldSubFamily == null && FontFamilyService.isServiceSupported()) {
            Object[] result2 = FontFamilyService.migrateFontSetting(family);
            LOG.info("Font setting migration: " + family + " -> " + Arrays.toString(result2));
            return result2;
        }
        return new String[]{family, regularSubFamily, boldSubFamily};
    }

    public static void initDefaults(@NotNull ModifiableFontPreferences fontPreferences) {
        if (fontPreferences == null) {
            AppEditorFontOptions.$$$reportNull$$$0(2);
        }
        AppEditorFontOptions.copyState(PersistentFontPreferences.getDefaultState(), fontPreferences);
    }

    public void update(@NotNull FontPreferences newPreferences) {
        if (newPreferences == null) {
            AppEditorFontOptions.$$$reportNull$$$0(3);
        }
        newPreferences.copyTo((FontPreferences)this.myFontPreferences);
        this.myTracker.incModificationCount();
    }

    @NotNull
    public FontPreferences getFontPreferences() {
        FontPreferencesImpl fontPreferencesImpl = this.myFontPreferences;
        if (fontPreferencesImpl == null) {
            AppEditorFontOptions.$$$reportNull$$$0(4);
        }
        return fontPreferencesImpl;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fontPreferences";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newPreferences";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/colors/impl/AppEditorFontOptions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/colors/impl/AppEditorFontOptions";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFontPreferences";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "copyState";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "initDefaults";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class PersistentFontPreferences {
        @ReportValue
        public int FONT_SIZE = FontPreferences.DEFAULT_FONT_SIZE;
        @ReportValue
        @NlsSafe
        @NotNull
        public String FONT_FAMILY = FontPreferences.DEFAULT_FONT_NAME;
        @ReportValue
        @NlsSafe
        @Nullable
        public String FONT_REGULAR_SUB_FAMILY;
        @ReportValue
        @NlsSafe
        @Nullable
        public String FONT_BOLD_SUB_FAMILY;
        @ReportValue
        public float FONT_SCALE = 1.0f;
        @ReportValue
        public float LINE_SPACING = 1.2f;
        @ReportValue
        public boolean USE_LIGATURES = false;
        @ReportValue
        @NlsSafe
        @Nullable
        public String SECONDARY_FONT_FAMILY;

        private PersistentFontPreferences() {
        }

        public PersistentFontPreferences(FontPreferences fontPreferences) {
            this.FONT_FAMILY = fontPreferences.getFontFamily();
            this.FONT_REGULAR_SUB_FAMILY = fontPreferences.getRegularSubFamily();
            this.FONT_BOLD_SUB_FAMILY = fontPreferences.getBoldSubFamily();
            this.FONT_SIZE = fontPreferences.getSize(this.FONT_FAMILY);
            this.FONT_SCALE = UISettings.getDefFontScale();
            this.LINE_SPACING = fontPreferences.getLineSpacing();
            this.USE_LIGATURES = fontPreferences.useLigatures();
            List fontFamilies = fontPreferences.getEffectiveFontFamilies();
            if (fontFamilies.size() > 1) {
                this.SECONDARY_FONT_FAMILY = (String)fontFamilies.get(1);
            }
        }

        private static PersistentFontPreferences getDefaultState() {
            return new PersistentFontPreferences();
        }
    }
}

