/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.impl.RangeMarkerImpl;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import org.jetbrains.annotations.NotNull;

class ErrorStripeMarkerImpl
extends RangeMarkerImpl {
    private static final Logger LOG = Logger.getInstance(ErrorStripeMarkerImpl.class);
    private final RangeHighlighterEx myHighlighter;

    ErrorStripeMarkerImpl(@NotNull DocumentEx document, @NotNull RangeHighlighterEx highlighter) {
        if (document == null) {
            ErrorStripeMarkerImpl.$$$reportNull$$$0(0);
        }
        if (highlighter == null) {
            ErrorStripeMarkerImpl.$$$reportNull$$$0(1);
        }
        super(document, highlighter.getStartOffset(), highlighter.getEndOffset(), false, true);
        this.myHighlighter = highlighter;
    }

    @NotNull
    public RangeHighlighterEx getHighlighter() {
        RangeHighlighterEx rangeHighlighterEx = this.myHighlighter;
        if (rangeHighlighterEx == null) {
            ErrorStripeMarkerImpl.$$$reportNull$$$0(2);
        }
        return rangeHighlighterEx;
    }

    @Override
    protected void changedUpdateImpl(@NotNull DocumentEvent e) {
        if (e == null) {
            ErrorStripeMarkerImpl.$$$reportNull$$$0(3);
        }
        if (this.myHighlighter.isPersistent()) {
            this.persistentHighlighterUpdate(e, this.myHighlighter.getTargetArea() == HighlighterTargetArea.LINES_IN_RANGE);
        } else {
            super.changedUpdateImpl(e);
        }
        this.validateState(e);
    }

    private void validateState(DocumentEvent e) {
        if (this.myHighlighter.isValid()) {
            if (!this.isValid()) {
                LOG.error("Base highlighter " + this.myHighlighter + " is valid, mirror " + this + " is invalid after " + e);
            } else if (this.intervalStart() != this.myHighlighter.getStartOffset() || this.intervalEnd() != this.myHighlighter.getEndOffset()) {
                LOG.error("Mirror highlighter " + this + " diverged from base one " + this.myHighlighter + " after " + e);
                this.setIntervalStart(this.myHighlighter.getStartOffset());
                this.setIntervalEnd(this.myHighlighter.getEndOffset());
            }
        } else if (this.isValid()) {
            LOG.error("Base highlighter " + this.myHighlighter + " is invalid, mirror " + this + " is valid after " + e);
            this.invalidate(e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlighter";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/impl/ErrorStripeMarkerImpl";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/impl/ErrorStripeMarkerImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getHighlighter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "changedUpdateImpl";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

