/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.application.options.EditorFontsConstants;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.colors.FontPreferences;
import com.intellij.util.ui.FontInfo;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FontFamilyService {
    private static final String MAIN_FALLBACK_SUB_FAMILY = "Regular";
    private static final String BOLD_FALLBACK_SUB_FAMILY = "Bold";

    public static boolean isServiceSupported() {
        return FontFamilyService.getInstance().isSupportedImpl();
    }

    @NotNull
    public static List<String> getAvailableFamilies() {
        List<String> list2 = FontFamilyService.getInstance().getAvailableFamiliesImpl();
        if (list2 == null) {
            FontFamilyService.$$$reportNull$$$0(0);
        }
        return list2;
    }

    public static boolean isMonospaced(@NotNull String family) {
        if (family == null) {
            FontFamilyService.$$$reportNull$$$0(1);
        }
        return FontFamilyService.getInstance().isMonospacedImpl(family);
    }

    @NotNull
    public static @NotNull List<@NotNull String> getSubFamilies(@NotNull String family) {
        if (family == null) {
            FontFamilyService.$$$reportNull$$$0(2);
        }
        List<String> list2 = FontFamilyService.getInstance().getSubFamiliesImpl(family);
        if (list2 == null) {
            FontFamilyService.$$$reportNull$$$0(3);
        }
        return list2;
    }

    @NotNull
    public static String getRecommendedSubFamily(@NotNull String family) {
        if (family == null) {
            FontFamilyService.$$$reportNull$$$0(4);
        }
        String string = FontFamilyService.getInstance().getRecommendedSubFamilyImpl(family);
        if (string == null) {
            FontFamilyService.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    public static String getRecommendedBoldSubFamily(@NotNull String family, @NotNull String mainSubFamily) {
        if (family == null) {
            FontFamilyService.$$$reportNull$$$0(6);
        }
        if (mainSubFamily == null) {
            FontFamilyService.$$$reportNull$$$0(7);
        }
        String string = FontFamilyService.getInstance().getRecommendedBoldSubFamilyImpl(family, mainSubFamily);
        if (string == null) {
            FontFamilyService.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    public static Font getFont(@NotNull String family, @Nullable String regularSubFamily, @Nullable String boldSubFamily, @JdkConstants.FontStyle int style) {
        if (family == null) {
            FontFamilyService.$$$reportNull$$$0(9);
        }
        Font font = FontFamilyService.getInstance().getFontImpl(family, regularSubFamily, boldSubFamily, style);
        if (font == null) {
            FontFamilyService.$$$reportNull$$$0(10);
        }
        return font;
    }

    @NotNull
    public static Font getFont(@NotNull String family, @Nullable String regularSubFamily, @Nullable String boldSubFamily, @JdkConstants.FontStyle int style, int size2) {
        if (family == null) {
            FontFamilyService.$$$reportNull$$$0(11);
        }
        Font font = FontFamilyService.getFont(family, regularSubFamily, boldSubFamily, style).deriveFont((float)size2);
        if (font == null) {
            FontFamilyService.$$$reportNull$$$0(12);
        }
        return font;
    }

    @NotNull
    public static Font getFont(@NotNull String family, @NotNull String subFamily, int size2) {
        if (family == null) {
            FontFamilyService.$$$reportNull$$$0(13);
        }
        if (subFamily == null) {
            FontFamilyService.$$$reportNull$$$0(14);
        }
        return FontFamilyService.getFont(family, subFamily, subFamily, 0, size2);
    }

    public static String @NotNull [] migrateFontSetting(@NotNull String family) {
        if (family == null) {
            FontFamilyService.$$$reportNull$$$0(15);
        }
        String[] stringArray = FontFamilyService.getInstance().migrateFontSettingImpl(family);
        if (stringArray == null) {
            FontFamilyService.$$$reportNull$$$0(16);
        }
        return stringArray;
    }

    @NotNull
    private static FontFamilyService getInstance() {
        FontFamilyService instance = (FontFamilyService)ApplicationManager.getApplication().getService(FontFamilyService.class);
        FontFamilyService fontFamilyService = instance == null ? new FontFamilyService() : instance;
        if (fontFamilyService == null) {
            FontFamilyService.$$$reportNull$$$0(17);
        }
        return fontFamilyService;
    }

    protected boolean isSupportedImpl() {
        return false;
    }

    @NotNull
    protected List<String> getAvailableFamiliesImpl() {
        List<String> list2 = Arrays.asList(GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames(Locale.ENGLISH));
        if (list2 == null) {
            FontFamilyService.$$$reportNull$$$0(18);
        }
        return list2;
    }

    protected boolean isMonospacedImpl(@NotNull String family) {
        if (family == null) {
            FontFamilyService.$$$reportNull$$$0(19);
        }
        return FontInfo.isMonospacedWithStyles((Font)new Font(family, 0, EditorFontsConstants.getDefaultEditorFontSize()));
    }

    @NotNull
    protected @NotNull List<@NotNull String> getSubFamiliesImpl(@NotNull String family) {
        if (family == null) {
            FontFamilyService.$$$reportNull$$$0(20);
        }
        List<String> list2 = Arrays.asList(MAIN_FALLBACK_SUB_FAMILY, BOLD_FALLBACK_SUB_FAMILY);
        if (list2 == null) {
            FontFamilyService.$$$reportNull$$$0(21);
        }
        return list2;
    }

    @NotNull
    protected String getRecommendedSubFamilyImpl(@NotNull String family) {
        if (family == null) {
            FontFamilyService.$$$reportNull$$$0(22);
        }
        return MAIN_FALLBACK_SUB_FAMILY;
    }

    @NotNull
    protected String getRecommendedBoldSubFamilyImpl(@NotNull String family, @NotNull String mainSubFamily) {
        if (family == null) {
            FontFamilyService.$$$reportNull$$$0(23);
        }
        if (mainSubFamily == null) {
            FontFamilyService.$$$reportNull$$$0(24);
        }
        return BOLD_FALLBACK_SUB_FAMILY;
    }

    @NotNull
    protected Font getFontImpl(@NotNull String family, @Nullable String regularSubFamily, @Nullable String boldSubFamily, @JdkConstants.FontStyle int style) {
        Font font;
        if (family == null) {
            FontFamilyService.$$$reportNull$$$0(25);
        }
        if ((font = new Font(family, style, 1)).getFamily().equals("Dialog") && !"Dialog".equals(family)) {
            return new Font(FontPreferences.DEFAULT_FONT_NAME, style, 1);
        }
        Font font2 = font;
        if (font2 == null) {
            FontFamilyService.$$$reportNull$$$0(26);
        }
        return font2;
    }

    protected String @NotNull [] migrateFontSettingImpl(@NotNull String family) {
        if (family == null) {
            FontFamilyService.$$$reportNull$$$0(27);
        }
        String[] stringArray = new String[]{family, null, null};
        if (stringArray == null) {
            FontFamilyService.$$$reportNull$$$0(28);
        }
        return stringArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 27: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 27: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/impl/FontFamilyService";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 25: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "family";
                break;
            }
            case 7: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mainSubFamily";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subFamily";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getAvailableFamilies";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/impl/FontFamilyService";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubFamilies";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getRecommendedSubFamily";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getRecommendedBoldSubFamily";
                break;
            }
            case 10: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getFont";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "migrateFontSetting";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getAvailableFamiliesImpl";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubFamiliesImpl";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getFontImpl";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "migrateFontSettingImpl";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isMonospaced";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getSubFamilies";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getRecommendedSubFamily";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getRecommendedBoldSubFamily";
                break;
            }
            case 9: 
            case 11: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getFont";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "migrateFontSetting";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isMonospacedImpl";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getSubFamiliesImpl";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getRecommendedSubFamilyImpl";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getRecommendedBoldSubFamilyImpl";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getFontImpl";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "migrateFontSettingImpl";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 27: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

