/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LanguageLineWrapPositionStrategy;
import com.intellij.openapi.editor.LineWrapPositionStrategy;
import com.intellij.openapi.editor.SoftWrap;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.TextChangeImpl;
import com.intellij.openapi.editor.impl.softwrap.SoftWrapDrawingType;
import com.intellij.openapi.editor.impl.softwrap.SoftWrapImpl;
import com.intellij.openapi.editor.impl.softwrap.SoftWrapPainter;
import com.intellij.openapi.editor.impl.softwrap.SoftWrapsStorage;
import com.intellij.openapi.editor.impl.softwrap.mapping.CachingSoftWrapDataMapper;
import com.intellij.openapi.editor.impl.softwrap.mapping.IncrementalCacheUpdateEvent;
import com.intellij.openapi.editor.impl.view.EditorView;
import com.intellij.openapi.editor.impl.view.WrapElementMeasuringIterator;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.DocumentUtil;
import org.jetbrains.annotations.NotNull;

public class SoftWrapEngine {
    private static final int BASIC_LOOK_BACK_LENGTH = 10;
    private final EditorImpl myEditor;
    private final Document myDocument;
    private final CharSequence myText;
    private final EditorView myView;
    private final SoftWrapsStorage myStorage;
    private final CachingSoftWrapDataMapper myDataMapper;
    private final int myVisibleWidth;
    private final int myMaxWidthAtWrap;
    private final int mySoftWrapWidth;
    private final IncrementalCacheUpdateEvent myEvent;
    private final int myRelativeIndent;
    private LineWrapPositionStrategy myLineWrapPositionStrategy;

    public SoftWrapEngine(@NotNull EditorImpl editor, @NotNull SoftWrapPainter painter, @NotNull SoftWrapsStorage storage2, @NotNull CachingSoftWrapDataMapper dataMapper, @NotNull IncrementalCacheUpdateEvent event, int visibleWidth, int relativeIndent) {
        if (editor == null) {
            SoftWrapEngine.$$$reportNull$$$0(0);
        }
        if (painter == null) {
            SoftWrapEngine.$$$reportNull$$$0(1);
        }
        if (storage2 == null) {
            SoftWrapEngine.$$$reportNull$$$0(2);
        }
        if (dataMapper == null) {
            SoftWrapEngine.$$$reportNull$$$0(3);
        }
        if (event == null) {
            SoftWrapEngine.$$$reportNull$$$0(4);
        }
        this.myEditor = editor;
        this.myDocument = editor.getDocument();
        this.myText = this.myDocument.getImmutableCharSequence();
        this.myView = editor.myView;
        this.myStorage = storage2;
        this.myDataMapper = dataMapper;
        this.myVisibleWidth = visibleWidth;
        this.myMaxWidthAtWrap = visibleWidth - painter.getMinDrawingWidth(SoftWrapDrawingType.BEFORE_SOFT_WRAP_LINE_FEED);
        this.mySoftWrapWidth = painter.getMinDrawingWidth(SoftWrapDrawingType.AFTER_SOFT_WRAP);
        this.myEvent = event;
        this.myRelativeIndent = relativeIndent;
    }

    public void generate() {
        int startOffset = this.myEvent.getStartOffset();
        int minEndOffset = this.myEvent.getMandatoryEndOffset();
        int maxEndOffset = this.getEndOffsetUpperEstimate();
        SoftWrap lastSoftWrap = null;
        boolean minWrapOffsetAtFolding = false;
        int minWrapOffset = -1;
        int maxWrapOffset = -1;
        float nonWhitespaceStartX = 0.0f;
        int nonWhitespaceStartOffset = -1;
        float x = startOffset == 0 ? this.myView.getPrefixTextWidthInPixels() : ((lastSoftWrap = this.myStorage.getSoftWrap(startOffset)) == null ? 0.0f : (float)lastSoftWrap.getIndentInPixels());
        WrapElementMeasuringIterator it = new WrapElementMeasuringIterator(this.myView, startOffset, maxEndOffset);
        while (!it.atEnd()) {
            if (it.isLineBreak()) {
                minWrapOffset = -1;
                maxWrapOffset = -1;
                x = 0.0f;
                lastSoftWrap = null;
                nonWhitespaceStartOffset = -1;
                if (it.getElementEndOffset() > minEndOffset) {
                    this.myEvent.setActualEndOffset(it.getElementEndOffset());
                    return;
                }
            } else {
                if (this.myRelativeIndent >= 0 && nonWhitespaceStartOffset == -1 && !it.isWhitespace()) {
                    nonWhitespaceStartX = x;
                    nonWhitespaceStartOffset = it.getElementStartOffset();
                }
                x = it.getElementEndX(x);
                if (minWrapOffset < 0 || x <= (float)this.myMaxWidthAtWrap && it.isFoldRegion()) {
                    minWrapOffset = it.getElementEndOffset();
                    minWrapOffsetAtFolding = it.isFoldRegion();
                } else {
                    if (x > (float)this.myMaxWidthAtWrap && maxWrapOffset < 0 && (maxWrapOffset = it.getElementStartOffset()) > minWrapOffset && it.isFoldRegion()) {
                        minWrapOffset = maxWrapOffset;
                    }
                    if (x > (float)this.myVisibleWidth) {
                        int wrapOffset = (lastSoftWrap = this.createSoftWrap(lastSoftWrap, minWrapOffset, maxWrapOffset, minWrapOffsetAtFolding, nonWhitespaceStartOffset, nonWhitespaceStartX)).getStart();
                        if (wrapOffset > minEndOffset && this.myDataMapper.matchesOldSoftWrap(lastSoftWrap, this.myEvent.getLengthDiff())) {
                            this.myEvent.setActualEndOffset(wrapOffset);
                            return;
                        }
                        minWrapOffset = -1;
                        maxWrapOffset = -1;
                        x = lastSoftWrap.getIndentInPixels();
                        if (wrapOffset <= it.getElementStartOffset()) {
                            it.retreat(wrapOffset);
                            continue;
                        }
                    }
                }
            }
            it.advance();
        }
        this.myEvent.setActualEndOffset(maxEndOffset);
    }

    private SoftWrap createSoftWrap(SoftWrap lastSoftWrap, int minWrapOffset, int maxWrapOffset, boolean preferMinOffset, int nonWhitespaceStartOffset, float nonWhitespaceStartX) {
        int wrapOffset = minWrapOffset >= maxWrapOffset ? minWrapOffset : this.calcSoftWrapOffset(minWrapOffset, maxWrapOffset, preferMinOffset);
        int indentInColumns = 1;
        int indentInPixels = this.mySoftWrapWidth;
        if (this.myRelativeIndent >= 0) {
            if (lastSoftWrap == null) {
                if (nonWhitespaceStartOffset >= 0 && nonWhitespaceStartOffset < wrapOffset) {
                    indentInColumns += this.myEditor.offsetToLogicalPosition((int)nonWhitespaceStartOffset).column;
                    indentInPixels = (int)((float)indentInPixels + nonWhitespaceStartX);
                }
                indentInColumns += this.myRelativeIndent;
                indentInPixels = (int)((float)indentInPixels + (float)this.myRelativeIndent * this.myView.getPlainSpaceWidth());
            } else {
                indentInColumns = lastSoftWrap.getIndentInColumns();
                indentInPixels = lastSoftWrap.getIndentInPixels();
            }
        }
        SoftWrapImpl result2 = new SoftWrapImpl(new TextChangeImpl("\n" + StringUtil.repeatSymbol((char)' ', (int)(indentInColumns - 1)), wrapOffset), indentInColumns, indentInPixels);
        this.myStorage.storeOrReplace(result2);
        return result2;
    }

    private int calcSoftWrapOffset(int minOffset, int maxOffset, boolean preferMinOffset) {
        int wrapOffset;
        if (SoftWrapEngine.canBreakBeforeOrAfterCodePoint(Character.codePointAt(this.myText, maxOffset))) {
            return maxOffset;
        }
        int offset = maxOffset;
        for (int i2 = 0; i2 < 10 && offset >= minOffset; ++i2) {
            int prevOffset = Character.offsetByCodePoints(this.myText, offset, -1);
            if (SoftWrapEngine.canBreakBeforeOrAfterCodePoint(Character.codePointAt(this.myText, prevOffset))) {
                return offset;
            }
            offset = prevOffset;
        }
        if (this.myLineWrapPositionStrategy == null) {
            this.myLineWrapPositionStrategy = LanguageLineWrapPositionStrategy.INSTANCE.forEditor((Editor)this.myEditor);
        }
        if ((wrapOffset = this.myLineWrapPositionStrategy.calculateWrapPosition(this.myDocument, this.myEditor.getProject(), minOffset - 1, maxOffset + 1, maxOffset + 1, false, true)) < 0) {
            return preferMinOffset ? minOffset : maxOffset;
        }
        if (wrapOffset < minOffset) {
            return minOffset;
        }
        if (wrapOffset > maxOffset) {
            return maxOffset;
        }
        if (DocumentUtil.isInsideSurrogatePair(this.myDocument, wrapOffset)) {
            return wrapOffset - 1;
        }
        return wrapOffset;
    }

    private static boolean canBreakBeforeOrAfterCodePoint(int codePoint) {
        return codePoint == 32 || codePoint == 9 || codePoint >= 12032 && codePoint < 65536;
    }

    private int getEndOffsetUpperEstimate() {
        int endOffsetUpperEstimate = EditorUtil.getNotFoldedLineEndOffset(this.myEditor, this.myEvent.getMandatoryEndOffset());
        int line = this.myDocument.getLineNumber(endOffsetUpperEstimate);
        if (line < this.myDocument.getLineCount() - 1) {
            endOffsetUpperEstimate = this.myDocument.getLineStartOffset(line + 1);
        }
        return endOffsetUpperEstimate;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "editor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "painter";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "storage";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "dataMapper";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[0] = "event";
                break;
            }
        }
        objectArray[1] = "com/intellij/openapi/editor/impl/SoftWrapEngine";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

