/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.ide.DataManager;
import com.intellij.injected.editor.DocumentWindow;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.DocumentRunnable;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.ex.EditorSettingsExternalizable;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileDocumentManagerListener;
import com.intellij.openapi.fileEditor.TrailingSpacesOptions;
import com.intellij.openapi.fileEditor.TrailingSpacesOptionsProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.ShutDownTracker;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.text.CharArrayUtil;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TrailingSpacesStripper
implements FileDocumentManagerListener {
    private static final Key<Boolean> DISABLE_FOR_FILE_KEY = Key.create((String)"DISABLE_TRAILING_SPACE_STRIPPER_FOR_FILE_KEY");
    private final Set<Document> myDocumentsToStripLater = new HashSet<Document>();

    public void beforeAllDocumentsSaving() {
        HashSet<Document> documentsToStrip = new HashSet<Document>(this.myDocumentsToStripLater);
        this.myDocumentsToStripLater.clear();
        for (Document document : documentsToStrip) {
            this.strip(document);
        }
    }

    public void beforeDocumentSaving(@NotNull Document document) {
        if (document == null) {
            TrailingSpacesStripper.$$$reportNull$$$0(0);
        }
        this.strip(document);
    }

    private void strip(final @NotNull Document document) {
        int end;
        int start2;
        boolean success2;
        TrailingSpacesOptions options2;
        if (document == null) {
            TrailingSpacesStripper.$$$reportNull$$$0(1);
        }
        if ((options2 = TrailingSpacesStripper.getOptions(document)) == null) {
            return;
        }
        if (options2.isStripTrailingSpaces() && !(success2 = TrailingSpacesStripper.strip(document, options2.isChangedLinesOnly(), options2.isKeepTrailingSpacesOnCaretLine()))) {
            this.myDocumentsToStripLater.add(document);
        }
        if (options2.isRemoveTrailingBlankLines()) {
            TrailingSpacesStripper.removeTrailngBlankLines(document, options2.isEnsureNewLineAtEOF());
        }
        int lines2 = document.getLineCount();
        if (options2.isEnsureNewLineAtEOF() && lines2 > 0 && (start2 = document.getLineStartOffset(lines2 - 1)) != (end = document.getLineEndOffset(lines2 - 1))) {
            final CharSequence content2 = document.getCharsSequence();
            TrailingSpacesStripper.performUndoableWrite(new DocumentRunnable(document, null){

                public void run() {
                    if (CharArrayUtil.containsOnlyWhiteSpaces((CharSequence)content2.subSequence(start2, end)) && options2.isStripTrailingSpaces() && (!options2.isKeepTrailingSpacesOnCaretLine() || !this.hasCaretIn(start2, end))) {
                        document.deleteString(start2, end);
                    } else {
                        document.insertString(end, (CharSequence)"\n");
                    }
                }

                private boolean hasCaretIn(int start22, int end2) {
                    Editor activeEditor = TrailingSpacesStripper.getActiveEditor(document);
                    List carets = activeEditor == null ? Collections.emptyList() : activeEditor.getCaretModel().getAllCarets();
                    for (Caret caret : carets) {
                        int offset = caret.getOffset();
                        if (offset < start22 || offset > end2) continue;
                        return true;
                    }
                    return false;
                }
            });
        }
    }

    private static void removeTrailngBlankLines(final @NotNull Document document, boolean keepLast) {
        if (document == null) {
            TrailingSpacesStripper.$$$reportNull$$$0(2);
        }
        if (document.getLineCount() > 0) {
            int firstNewLineOffset;
            int endOffset = document.getTextLength() - 1;
            final Ref deleteToExclusive = Ref.create((Object)(endOffset + 1));
            CharSequence content2 = document.getCharsSequence();
            int blankAreaOffset = CharArrayUtil.shiftBackward((CharSequence)content2, (int)endOffset, (String)" \t\r\n");
            if (blankAreaOffset < endOffset && (firstNewLineOffset = CharArrayUtil.indexOf((CharSequence)content2, (CharSequence)"\n", (int)blankAreaOffset)) > 0) {
                int lastLNewLineOffset;
                if (keepLast && (lastLNewLineOffset = CharArrayUtil.lastIndexOf((CharSequence)content2, (String)"\n", (int)endOffset)) >= firstNewLineOffset) {
                    deleteToExclusive.set((Object)lastLNewLineOffset);
                }
                TrailingSpacesStripper.performUndoableWrite(new DocumentRunnable(document, null){

                    public void run() {
                        document.deleteString(firstNewLineOffset, ((Integer)deleteToExclusive.get()).intValue());
                    }
                });
            }
        }
    }

    private static void performUndoableWrite(@NotNull DocumentRunnable documentRunnable) {
        if (documentRunnable == null) {
            TrailingSpacesStripper.$$$reportNull$$$0(3);
        }
        ApplicationManager.getApplication().runWriteAction(() -> CommandProcessor.getInstance().runUndoTransparentAction((Runnable)documentRunnable));
    }

    public void clearLineModificationFlags(@NotNull Document document) {
        int[] caretLines;
        if (document == null) {
            TrailingSpacesStripper.$$$reportNull$$$0(4);
        }
        if (document instanceof DocumentWindow) {
            document = ((DocumentWindow)document).getDelegate();
        }
        if (!(document instanceof DocumentImpl)) {
            return;
        }
        Editor activeEditor = TrailingSpacesStripper.getActiveEditor(document);
        boolean isVirtualSpaceEnabled = activeEditor == null || activeEditor.getSettings().isVirtualSpace();
        TrailingSpacesOptions options2 = TrailingSpacesStripper.getOptions(document);
        if (options2 == null) {
            return;
        }
        if (activeEditor != null && options2.isChangedLinesOnly() && options2.isStripTrailingSpaces() && !isVirtualSpaceEnabled) {
            List carets = activeEditor.getCaretModel().getAllCarets();
            caretLines = new int[carets.size()];
            for (int i2 = 0; i2 < carets.size(); ++i2) {
                Caret caret = (Caret)carets.get(i2);
                caretLines[i2] = caret.getLogicalPosition().line;
            }
        } else {
            caretLines = ArrayUtilRt.EMPTY_INT_ARRAY;
        }
        ((DocumentImpl)document).clearLineModificationFlagsExcept(caretLines);
    }

    private static Editor getActiveEditor(@NotNull Document document) {
        Editor activeEditor;
        if (document == null) {
            TrailingSpacesStripper.$$$reportNull$$$0(5);
        }
        Component focusOwner = IdeFocusManager.getGlobalInstance().getFocusOwner();
        DataContext dataContext = DataManager.getInstance().getDataContext(focusOwner);
        Editor editor = activeEditor = ApplicationManager.getApplication().isDisposed() ? null : (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        if (activeEditor != null && activeEditor.getDocument() != document) {
            activeEditor = null;
        }
        return activeEditor;
    }

    public static boolean strip(@NotNull Document document, boolean inChangedLinesOnly, boolean skipCaretLines) {
        if (document == null) {
            TrailingSpacesStripper.$$$reportNull$$$0(6);
        }
        if (document instanceof DocumentWindow) {
            document = ((DocumentWindow)document).getDelegate();
        }
        if (!(document instanceof DocumentImpl)) {
            return true;
        }
        Editor activeEditor = TrailingSpacesStripper.getActiveEditor(document);
        List carets = activeEditor == null ? Collections.emptyList() : activeEditor.getCaretModel().getAllCarets();
        ArrayList<VisualPosition> visualCarets = new ArrayList<VisualPosition>(carets.size());
        int[] caretOffsets = new int[carets.size()];
        for (int i2 = 0; i2 < carets.size(); ++i2) {
            Caret caret = (Caret)carets.get(i2);
            visualCarets.add(caret.getVisualPosition());
            caretOffsets[i2] = caret.getOffset();
        }
        boolean markAsNeedsStrippingLater = ((DocumentImpl)document).stripTrailingSpaces(TrailingSpacesStripper.getProject(document, activeEditor), inChangedLinesOnly, (int[])(skipCaretLines ? caretOffsets : null));
        if (activeEditor != null && !ShutDownTracker.isShutdownHookRunning()) {
            activeEditor.getCaretModel().runBatchCaretOperation(() -> {
                for (int i2 = 0; i2 < carets.size(); ++i2) {
                    Caret caret = (Caret)carets.get(i2);
                    if (!caret.isValid()) continue;
                    caret.moveToVisualPosition((VisualPosition)visualCarets.get(i2));
                }
            });
        }
        return !markAsNeedsStrippingLater;
    }

    @Nullable
    private static Project getProject(@NotNull Document document, @Nullable Editor editor) {
        if (document == null) {
            TrailingSpacesStripper.$$$reportNull$$$0(7);
        }
        if (editor != null) {
            return editor.getProject();
        }
        VirtualFile file2 = FileDocumentManager.getInstance().getFile(document);
        if (file2 != null) {
            return ProjectUtil.guessProjectForFile((VirtualFile)file2);
        }
        return null;
    }

    public void documentDeleted(@NotNull Document doc) {
        if (doc == null) {
            TrailingSpacesStripper.$$$reportNull$$$0(8);
        }
        this.myDocumentsToStripLater.remove(doc);
    }

    public void unsavedDocumentsDropped() {
        this.myDocumentsToStripLater.clear();
    }

    public static void setEnabled(@NotNull VirtualFile file2, boolean enabled) {
        if (file2 == null) {
            TrailingSpacesStripper.$$$reportNull$$$0(9);
        }
        DISABLE_FOR_FILE_KEY.set((UserDataHolder)file2, (Object)(enabled ? null : Boolean.TRUE));
    }

    public static boolean isEnabled(@NotNull VirtualFile file2) {
        if (file2 == null) {
            TrailingSpacesStripper.$$$reportNull$$$0(10);
        }
        return !Boolean.TRUE.equals(DISABLE_FOR_FILE_KEY.get((UserDataHolder)file2));
    }

    @Nullable
    public static TrailingSpacesOptions getOptions(@NotNull Document document) {
        EditorSettingsExternalizable editorSettings;
        FileDocumentManager fileDocumentManager;
        VirtualFile file2;
        if (document == null) {
            TrailingSpacesStripper.$$$reportNull$$$0(11);
        }
        if (document.isWritable() && (file2 = (fileDocumentManager = FileDocumentManager.getInstance()).getFile(document)) != null && file2.isValid() && !Boolean.TRUE.equals(DISABLE_FOR_FILE_KEY.get((UserDataHolder)file2)) && (editorSettings = EditorSettingsExternalizable.getInstance()) != null) {
            Editor activeEditor = TrailingSpacesStripper.getActiveEditor(document);
            Project project = TrailingSpacesStripper.getProject(document, activeEditor);
            MyTrailingSpacesOptions currOptions = new MyTrailingSpacesOptions();
            if (project != null) {
                for (TrailingSpacesOptionsProvider provider2 : TrailingSpacesOptionsProvider.EP_NAME.getExtensionList()) {
                    TrailingSpacesOptionsProvider.Options providerOptions = provider2.getOptions(project, file2);
                    if (providerOptions == null) continue;
                    currOptions.setStripTrailingSpaces(providerOptions.getStripTrailingSpaces());
                    currOptions.setEnsureNewLineAtEOF(providerOptions.getEnsureNewLineAtEOF());
                    currOptions.setRemoveTrailingBlankLines(providerOptions.getRemoveTrailingBlankLines());
                    currOptions.setChangedLinesOnly(providerOptions.getChangedLinesOnly());
                    currOptions.setKeepTrailingSpacesOnCaretLine(providerOptions.getKeepTrailingSpacesOnCaretLine());
                }
            }
            return currOptions;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "documentRunnable";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "doc";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/editor/impl/TrailingSpacesStripper";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "beforeDocumentSaving";
                break;
            }
            case 1: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "strip";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "removeTrailngBlankLines";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "performUndoableWrite";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "clearLineModificationFlags";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getActiveEditor";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "getProject";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "documentDeleted";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "setEnabled";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "isEnabled";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "getOptions";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class MyTrailingSpacesOptions
    implements TrailingSpacesOptions {
        @Nullable
        private Boolean myStripTrailingSpaces;
        @Nullable
        private Boolean myEnsureNewLineAtEOF;
        @Nullable
        private Boolean myRemoveTrailingBlankLines;
        @Nullable
        private Boolean myChangedLinesOnly;
        @Nullable
        private Boolean myKeepTrailingSpacesOnCaretLine;
        private final EditorSettingsExternalizable myEditorSettings = EditorSettingsExternalizable.getInstance();

        private MyTrailingSpacesOptions() {
        }

        private void setStripTrailingSpaces(@Nullable Boolean stripTrailingSpaces) {
            if (stripTrailingSpaces != null && this.myStripTrailingSpaces == null) {
                this.myStripTrailingSpaces = stripTrailingSpaces;
            }
        }

        private void setRemoveTrailingBlankLines(@Nullable Boolean removeTrailingBlankLines) {
            if (removeTrailingBlankLines != null && this.myRemoveTrailingBlankLines == null) {
                this.myRemoveTrailingBlankLines = removeTrailingBlankLines;
            }
        }

        private void setEnsureNewLineAtEOF(@Nullable Boolean ensureNewLineAtEOF) {
            if (ensureNewLineAtEOF != null && this.myEnsureNewLineAtEOF == null) {
                this.myEnsureNewLineAtEOF = ensureNewLineAtEOF;
            }
        }

        private void setChangedLinesOnly(@Nullable Boolean changedLinesOnly) {
            if (changedLinesOnly != null && this.myChangedLinesOnly == null) {
                this.myChangedLinesOnly = changedLinesOnly;
            }
        }

        private void setKeepTrailingSpacesOnCaretLine(@Nullable Boolean keepTrailingSpacesOnCaretLine) {
            if (keepTrailingSpacesOnCaretLine != null && this.myKeepTrailingSpacesOnCaretLine == null) {
                this.myKeepTrailingSpacesOnCaretLine = keepTrailingSpacesOnCaretLine;
            }
        }

        public boolean isStripTrailingSpaces() {
            return this.myStripTrailingSpaces != null ? this.myStripTrailingSpaces : !"None".equals(this.myEditorSettings.getStripTrailingSpaces());
        }

        public boolean isRemoveTrailingBlankLines() {
            return this.myRemoveTrailingBlankLines != null ? this.myRemoveTrailingBlankLines.booleanValue() : this.myEditorSettings.isRemoveTrailingBlankLines();
        }

        public boolean isEnsureNewLineAtEOF() {
            return this.myEnsureNewLineAtEOF != null ? this.myEnsureNewLineAtEOF.booleanValue() : this.myEditorSettings.isEnsureNewLineAtEOF();
        }

        public boolean isChangedLinesOnly() {
            return this.myChangedLinesOnly != null ? this.myChangedLinesOnly : !"Whole".equals(this.myEditorSettings.getStripTrailingSpaces());
        }

        public boolean isKeepTrailingSpacesOnCaretLine() {
            return this.myKeepTrailingSpacesOnCaretLine != null ? this.myKeepTrailingSpacesOnCaretLine.booleanValue() : this.myEditorSettings.isKeepTrailingSpacesOnCaretLine();
        }
    }
}

