/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl.softwrap;

import com.intellij.diagnostic.Dumpable;
import com.intellij.openapi.editor.SoftWrap;
import com.intellij.openapi.editor.ex.SoftWrapChangeListener;
import com.intellij.openapi.editor.impl.softwrap.SoftWrapImpl;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SoftWrapsStorage
implements Dumpable {
    private final List<SoftWrapImpl> myWraps = new ArrayList<SoftWrapImpl>();
    private final List<SoftWrapImpl> myWrapsView = Collections.unmodifiableList(this.myWraps);
    private final List<SoftWrapChangeListener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();

    public boolean isEmpty() {
        return this.myWraps.isEmpty();
    }

    @Nullable
    public SoftWrap getSoftWrap(int offset) {
        int i2 = this.getSoftWrapIndex(offset);
        return i2 >= 0 ? (SoftWrap)this.myWraps.get(i2) : null;
    }

    @NotNull
    public List<SoftWrapImpl> getSoftWraps() {
        List<SoftWrapImpl> list2 = this.myWrapsView;
        if (list2 == null) {
            SoftWrapsStorage.$$$reportNull$$$0(0);
        }
        return list2;
    }

    public int getSoftWrapIndex(int offset) {
        return ObjectUtils.binarySearch((int)0, (int)this.myWraps.size(), i2 -> Integer.compare(this.myWraps.get(i2).getStart(), offset));
    }

    public int getNumberOfSoftWrapsInRange(int startOffset, int endOffset) {
        SoftWrap softWrap;
        int startIndex = this.getSoftWrapIndex(startOffset);
        if (startIndex < 0) {
            startIndex = -startIndex - 1;
        }
        if (startIndex >= this.myWraps.size()) {
            return 0;
        }
        int result2 = 0;
        for (int endIndex = startIndex; endIndex < this.myWraps.size() && (softWrap = (SoftWrap)this.myWraps.get(endIndex)).getStart() <= endOffset; ++endIndex) {
            ++result2;
        }
        return result2;
    }

    public void storeOrReplace(SoftWrapImpl softWrap) {
        int i2 = this.getSoftWrapIndex(softWrap.getStart());
        if (i2 >= 0) {
            this.myWraps.set(i2, softWrap);
            return;
        }
        i2 = -i2 - 1;
        this.myWraps.add(i2, softWrap);
    }

    public void remove(SoftWrapImpl softWrap) {
        if (this.myWraps.isEmpty()) {
            return;
        }
        int i2 = this.myWraps.size() - 1;
        if (this.myWraps.get(i2).getStart() != softWrap.getStart()) {
            i2 = this.getSoftWrapIndex(softWrap.getStart());
        }
        if (i2 >= 0) {
            this.myWraps.remove(i2);
        }
    }

    public List<SoftWrapImpl> removeStartingFrom(int offset) {
        int startIndex = this.getSoftWrapIndex(offset);
        if (startIndex < 0) {
            startIndex = -startIndex - 1;
        }
        if (startIndex >= this.myWraps.size()) {
            return Collections.emptyList();
        }
        List<SoftWrapImpl> tail = this.myWraps.subList(startIndex, this.myWraps.size());
        ArrayList<SoftWrapImpl> result2 = new ArrayList<SoftWrapImpl>(tail);
        tail.clear();
        return result2;
    }

    public void addAll(List<? extends SoftWrapImpl> softWraps) {
        this.myWraps.addAll(softWraps);
    }

    public void removeAll() {
        this.myWraps.clear();
        this.notifyListenersAboutChange();
    }

    public boolean addSoftWrapChangeListener(@NotNull SoftWrapChangeListener listener2) {
        if (listener2 == null) {
            SoftWrapsStorage.$$$reportNull$$$0(1);
        }
        return this.myListeners.add(listener2);
    }

    public void notifyListenersAboutChange() {
        for (SoftWrapChangeListener listener2 : this.myListeners) {
            listener2.softWrapsChanged();
        }
    }

    @NotNull
    public String dumpState() {
        String string = this.myWraps.toString();
        if (string == null) {
            SoftWrapsStorage.$$$reportNull$$$0(2);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/impl/softwrap/SoftWrapsStorage";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getSoftWraps";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/impl/softwrap/SoftWrapsStorage";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "dumpState";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "addSoftWrapChangeListener";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

