/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.importing;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.externalSystem.model.project.ProjectId;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@com.intellij.openapi.components.State(name="ExternalSystem.GAVStateComponent", storages={@Storage(value="jps2ext.xml")})
@ApiStatus.Experimental
public class GAVStateComponent
implements PersistentStateComponent<State> {
    private State myState = new State();

    @Nullable
    public State getState() {
        return this.myState;
    }

    public Map<String, ProjectId> getMapping() {
        HashMap<String, ProjectId> result2 = new HashMap<String, ProjectId>();
        for (String mappingEncoded : this.getState().moduleMapping) {
            String[] gavAsArray = mappingEncoded.split(":");
            String module = gavAsArray[0];
            ProjectId projectId = new ProjectId(gavAsArray[1], gavAsArray[2], gavAsArray[3]);
            if (!Objects.nonNull(module)) continue;
            result2.put(module, projectId);
        }
        return result2;
    }

    public void addMapping(String moduleName, String groupId2, String artifactId2, String version2) {
        this.myState.moduleMapping.add(String.join((CharSequence)":", moduleName, groupId2, artifactId2, version2));
    }

    public void loadState(@NotNull State state) {
        if (state == null) {
            GAVStateComponent.$$$reportNull$$$0(0);
        }
        this.myState = state;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/openapi/externalSystem/importing/GAVStateComponent", "loadState"));
    }

    public static class State {
        public Set<String> moduleMapping = new HashSet<String>();
    }
}

