/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.execution;

import com.intellij.execution.configuration.EnvironmentVariablesComponent;
import com.intellij.execution.configuration.EnvironmentVariablesData;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.execution.ExternalSystemTaskExecutionSettings;
import com.intellij.openapi.externalSystem.service.execution.TaskCompletionProvider;
import com.intellij.openapi.externalSystem.service.ui.ExternalProjectPathField;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.externalSystem.util.ExternalSystemSettingsControl;
import com.intellij.openapi.externalSystem.util.ExternalSystemUiUtil;
import com.intellij.openapi.externalSystem.util.PaintAwarePanel;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.RawCommandLineEditor;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.execution.ParametersListUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ExternalSystemTaskSettingsControl
implements ExternalSystemSettingsControl<ExternalSystemTaskExecutionSettings> {
    @NotNull
    private final ProjectSystemId myExternalSystemId;
    @NotNull
    private final Project myProject;
    private JBLabel myProjectPathLabel;
    private ExternalProjectPathField myProjectPathField;
    private JBLabel myTasksLabel;
    private EditorTextField myTasksTextField;
    private JBLabel myVmOptionsLabel;
    private RawCommandLineEditor myVmOptionsEditor;
    private JBLabel myArgumentsLabel;
    private RawCommandLineEditor myArgumentsEditor;
    private EnvironmentVariablesComponent myEnvVariablesComponent;
    @Nullable
    private ExternalSystemTaskExecutionSettings myOriginalSettings;

    public ExternalSystemTaskSettingsControl(@NotNull Project project, @NotNull ProjectSystemId externalSystemId2) {
        if (project == null) {
            ExternalSystemTaskSettingsControl.$$$reportNull$$$0(0);
        }
        if (externalSystemId2 == null) {
            ExternalSystemTaskSettingsControl.$$$reportNull$$$0(1);
        }
        this.myProject = project;
        this.myExternalSystemId = externalSystemId2;
    }

    public void setOriginalSettings(@Nullable ExternalSystemTaskExecutionSettings originalSettings) {
        this.myOriginalSettings = originalSettings;
    }

    @Override
    public void fillUi(@NotNull PaintAwarePanel canvas, int indentLevel) {
        if (canvas == null) {
            ExternalSystemTaskSettingsControl.$$$reportNull$$$0(2);
        }
        this.myProjectPathLabel = new JBLabel(ExternalSystemBundle.message((String)"run.configuration.settings.label.project", (Object[])new Object[]{this.myExternalSystemId.getReadableName()}));
        FileChooserDescriptor projectPathChooserDescriptor = ExternalSystemApiUtil.getExternalProjectConfigDescriptor((ProjectSystemId)this.myExternalSystemId);
        String title2 = ExternalSystemBundle.message((String)"settings.label.select.project", (Object[])new Object[]{this.myExternalSystemId.getReadableName()});
        this.myProjectPathField = new ExternalProjectPathField(this.myProject, this.myExternalSystemId, projectPathChooserDescriptor, title2){

            public Dimension getPreferredSize() {
                return ExternalSystemTaskSettingsControl.this.myVmOptionsEditor == null ? super.getPreferredSize() : ExternalSystemTaskSettingsControl.this.myVmOptionsEditor.getTextField().getPreferredSize();
            }
        };
        canvas.add((Component)this.myProjectPathLabel, ExternalSystemUiUtil.getLabelConstraints(0));
        canvas.add((Component)((Object)this.myProjectPathField), ExternalSystemUiUtil.getFillLineConstraints(0));
        this.myTasksLabel = new JBLabel(ExternalSystemBundle.message((String)"run.configuration.settings.label.tasks", (Object[])new Object[0]));
        this.myTasksTextField = new EditorTextField("", this.myProject, (FileType)PlainTextFileType.INSTANCE);
        canvas.add((Component)this.myTasksLabel, ExternalSystemUiUtil.getLabelConstraints(0));
        canvas.add((Component)((Object)this.myTasksTextField), ExternalSystemUiUtil.getFillLineConstraints(0));
        new TaskCompletionProvider(this.myProject, this.myExternalSystemId, this.myProjectPathField).apply(this.myTasksTextField);
        this.myVmOptionsLabel = new JBLabel(ExternalSystemBundle.message((String)"run.configuration.settings.label.vmoptions", (Object[])new Object[0]));
        this.myVmOptionsEditor = new RawCommandLineEditor();
        this.myVmOptionsEditor.setDialogCaption(ExternalSystemBundle.message((String)"run.configuration.settings.label.vmoptions", (Object[])new Object[0]));
        canvas.add((Component)this.myVmOptionsLabel, ExternalSystemUiUtil.getLabelConstraints(0));
        canvas.add((Component)this.myVmOptionsEditor, ExternalSystemUiUtil.getFillLineConstraints(0));
        this.myArgumentsLabel = new JBLabel(ExternalSystemBundle.message((String)"run.configuration.settings.label.arguments", (Object[])new Object[0]));
        this.myArgumentsEditor = new RawCommandLineEditor();
        this.myArgumentsEditor.setDialogCaption(ExternalSystemBundle.message((String)"run.configuration.settings.label.arguments", (Object[])new Object[0]));
        canvas.add((Component)this.myArgumentsLabel, ExternalSystemUiUtil.getLabelConstraints(0));
        canvas.add((Component)this.myArgumentsEditor, ExternalSystemUiUtil.getFillLineConstraints(0));
        this.myEnvVariablesComponent = new EnvironmentVariablesComponent();
        JBLabel myEnvVariablesComponentLabel = this.myEnvVariablesComponent.getLabel();
        myEnvVariablesComponentLabel.remove((Component)myEnvVariablesComponentLabel);
        canvas.add((Component)myEnvVariablesComponentLabel, ExternalSystemUiUtil.getLabelConstraints(0));
        canvas.add((Component)((Object)this.myEnvVariablesComponent), ExternalSystemUiUtil.getFillLineConstraints(0));
    }

    @Override
    public void reset() {
        this.myProjectPathField.setText("");
        this.myTasksTextField.setText("");
        this.myVmOptionsEditor.setText("");
        this.myArgumentsEditor.setText("");
        this.myEnvVariablesComponent.setEnvData(EnvironmentVariablesData.DEFAULT);
        this.showUi(true);
        if (this.myOriginalSettings == null) {
            return;
        }
        String path2 = this.myOriginalSettings.getExternalProjectPath();
        if (StringUtil.isEmpty((String)path2)) {
            path2 = "";
        }
        this.myProjectPathField.setText(path2);
        this.myTasksTextField.setText(StringUtil.join((Collection)this.myOriginalSettings.getTaskNames(), (String)" "));
        this.myVmOptionsEditor.setText(this.myOriginalSettings.getVmOptions());
        this.myArgumentsEditor.setText(this.myOriginalSettings.getScriptParameters());
        this.myEnvVariablesComponent.setEnvData(EnvironmentVariablesData.create(this.myOriginalSettings.getEnv(), this.myOriginalSettings.isPassParentEnvs()));
    }

    @Override
    public boolean isModified() {
        if (this.myOriginalSettings == null) {
            return false;
        }
        return !Objects.equals(ExternalSystemApiUtil.normalizePath((String)this.myProjectPathField.getText()), ExternalSystemApiUtil.normalizePath((String)this.myOriginalSettings.getExternalProjectPath())) || !Objects.equals(ExternalSystemApiUtil.normalizePath((String)this.myTasksTextField.getText()), ExternalSystemApiUtil.normalizePath((String)StringUtil.join((Collection)this.myOriginalSettings.getTaskNames(), (String)" "))) || !Objects.equals(ExternalSystemApiUtil.normalizePath((String)this.myVmOptionsEditor.getText()), ExternalSystemApiUtil.normalizePath((String)this.myOriginalSettings.getVmOptions())) || !Objects.equals(ExternalSystemApiUtil.normalizePath((String)this.myArgumentsEditor.getText()), ExternalSystemApiUtil.normalizePath((String)this.myOriginalSettings.getScriptParameters())) || this.myEnvVariablesComponent.isPassParentEnvs() != this.myOriginalSettings.isPassParentEnvs() || !this.myEnvVariablesComponent.getEnvs().equals(this.myOriginalSettings.getEnv());
    }

    @Override
    public void apply(@NotNull ExternalSystemTaskExecutionSettings settings2) {
        if (settings2 == null) {
            ExternalSystemTaskSettingsControl.$$$reportNull$$$0(3);
        }
        String projectPath = this.myProjectPathField.getText();
        settings2.setExternalProjectPath(projectPath);
        List tasks = ParametersListUtil.parse((String)this.myTasksTextField.getText(), (boolean)true, (boolean)true);
        settings2.setTaskNames(tasks);
        settings2.setVmOptions(this.myVmOptionsEditor.getText());
        settings2.setScriptParameters(this.myArgumentsEditor.getText());
        settings2.setPassParentEnvs(this.myEnvVariablesComponent.isPassParentEnvs());
        settings2.setEnv((Map)(this.myEnvVariablesComponent.getEnvs().isEmpty() ? Collections.emptyMap() : new HashMap<String, String>(this.myEnvVariablesComponent.getEnvs())));
    }

    @Override
    public boolean validate(@NotNull ExternalSystemTaskExecutionSettings settings2) throws ConfigurationException {
        if (settings2 == null) {
            ExternalSystemTaskSettingsControl.$$$reportNull$$$0(4);
        }
        String projectPath = this.myProjectPathField.getText();
        if (this.myOriginalSettings == null) {
            throw new ConfigurationException(ExternalSystemBundle.message((String)"dialog.message.can.t.store.external.task.settings.into.run.configuration", (Object[])new Object[]{this.myTasksTextField.getText(), projectPath, this.myVmOptionsEditor.getText(), this.myArgumentsEditor.getText()}));
        }
        return true;
    }

    @Override
    public void disposeUIResources() {
        ExternalSystemUiUtil.disposeUi(this);
    }

    @Override
    public void showUi(boolean show2) {
        ExternalSystemUiUtil.showUi(this, show2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalSystemId";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "canvas";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/externalSystem/service/execution/ExternalSystemTaskSettingsControl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "fillUi";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "apply";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "validate";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

