/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project.manage;

import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.model.project.ProjectSdkData;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.manage.AbstractProjectDataService;
import com.intellij.openapi.externalSystem.util.DisposeAwareProjectChange;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ProjectRootManager;
import java.util.Arrays;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0001B\u0005\u00a2\u0006\u0002\u0010\u0004J\u001b\u0010\u0005\u001a\u0015\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00020\u00020\u0006\u00a2\u0006\u0002\b\bH\u0016J6\u0010\t\u001a\u00020\n2\u0012\u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\r0\f2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0018\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u0002H\u0002\u00a8\u0006\u0015"}, d2={"Lcom/intellij/openapi/externalSystem/service/project/manage/ProjectSdkDataService;", "Lcom/intellij/openapi/externalSystem/service/project/manage/AbstractProjectDataService;", "Lcom/intellij/openapi/externalSystem/model/project/ProjectSdkData;", "Lcom/intellij/openapi/project/Project;", "()V", "getTargetDataKey", "Lcom/intellij/openapi/externalSystem/model/Key;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "importData", "", "toImport", "", "Lcom/intellij/openapi/externalSystem/model/DataNode;", "projectData", "Lcom/intellij/openapi/externalSystem/model/project/ProjectData;", "project", "modelsProvider", "Lcom/intellij/openapi/externalSystem/service/project/IdeModifiableModelsProvider;", "importProjectSdk", "sdkData", "intellij.platform.externalSystem.impl"})
public final class ProjectSdkDataService
extends AbstractProjectDataService<ProjectSdkData, Project> {
    @NotNull
    public Key<ProjectSdkData> getTargetDataKey() {
        return ProjectSdkData.KEY;
    }

    public void importData(@NotNull Collection<? extends DataNode<ProjectSdkData>> toImport, @Nullable ProjectData projectData2, @NotNull Project project, @NotNull IdeModifiableModelsProvider modelsProvider) {
        Intrinsics.checkNotNullParameter(toImport, (String)"toImport");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)modelsProvider, (String)"modelsProvider");
        if (toImport.isEmpty() || projectData2 == null) {
            return;
        }
        boolean bl = toImport.size() == 1;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string = "Expected to get a single project but got %d: %s";
            Object[] objectArray = new Object[]{toImport.size(), toImport};
            boolean bl5 = false;
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
            String string3 = string2;
            throw (Throwable)new IllegalArgumentException(string3.toString());
        }
        if (!ExternalSystemApiUtil.isOneToOneMapping((Project)project, (ProjectData)projectData2, (Module[])modelsProvider.getModules())) {
            return;
        }
        for (DataNode<ProjectSdkData> dataNode : toImport) {
            ExternalSystemApiUtil.executeProjectChangeAction((DisposeAwareProjectChange)new DisposeAwareProjectChange(this, project, dataNode, (ComponentManager)project){
                final /* synthetic */ ProjectSdkDataService this$0;
                final /* synthetic */ Project $project;
                final /* synthetic */ DataNode $sdkDataNode;

                public void execute() {
                    Object object = this.$sdkDataNode.getData();
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"sdkDataNode.data");
                    ProjectSdkDataService.access$importProjectSdk(this.this$0, this.$project, (ProjectSdkData)object);
                }
                {
                    this.this$0 = this$0;
                    this.$project = $captured_local_variable$1;
                    this.$sdkDataNode = $captured_local_variable$2;
                    super($super_call_param$3);
                }
            });
        }
    }

    private final void importProjectSdk(Project project, ProjectSdkData sdkData) {
        ProjectRootManager projectRootManager;
        String string = sdkData.getSdkName();
        if (string == null) {
            return;
        }
        String sdkName = string;
        ProjectJdkTable projectJdkTable = ProjectJdkTable.getInstance();
        Sdk sdk2 = projectJdkTable.findJdk(sdkName);
        ProjectRootManager projectRootManager2 = projectRootManager = ProjectRootManager.getInstance((Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)projectRootManager2, (String)"projectRootManager");
        Sdk projectSdk = projectRootManager2.getProjectSdk();
        if (projectSdk == null) {
            projectRootManager.setProjectSdk(sdk2);
        }
    }

    public static final /* synthetic */ void access$importProjectSdk(ProjectSdkDataService $this, Project project, ProjectSdkData sdkData) {
        $this.importProjectSdk(project, sdkData);
    }
}

