/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.statistics;

import com.intellij.internal.statistic.StructuredIdeActivity;
import com.intellij.internal.statistic.beans.MetricEvent;
import com.intellij.internal.statistic.beans.MetricEventFactoryKt;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.internal.statistic.service.fus.collectors.ProjectUsagesCollector;
import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.ExternalSystemModulePropertyManager;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemJdkUtil;
import com.intellij.openapi.externalSystem.service.execution.TargetEnvironmentConfigurationProvider;
import com.intellij.openapi.externalSystem.settings.AbstractExternalSystemSettings;
import com.intellij.openapi.externalSystem.statistics.ExternalSystemActionsCollector;
import com.intellij.openapi.externalSystem.statistics.ExternalSystemStatUtilKt;
import com.intellij.openapi.externalSystem.statistics.ExternalSystemTaskCollector;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.Version;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \n2\u00020\u0001:\u0002\n\u000bB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\tH\u0014\u00a8\u0006\f"}, d2={"Lcom/intellij/openapi/externalSystem/statistics/ExternalSystemUsagesCollector;", "Lcom/intellij/internal/statistic/service/fus/collectors/ProjectUsagesCollector;", "()V", "getGroupId", "", "getMetrics", "", "Lcom/intellij/internal/statistic/beans/MetricEvent;", "project", "Lcom/intellij/openapi/project/Project;", "Companion", "ExternalSystemTaskId", "intellij.platform.externalSystem.impl"})
public final class ExternalSystemUsagesCollector
extends ProjectUsagesCollector {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public String getGroupId() {
        return "build.tools";
    }

    @NotNull
    protected Set<MetricEvent> getMetrics(@NotNull Project project) {
        Set usages;
        block3: {
            Module module;
            boolean bl;
            Module[] moduleArray;
            block2: {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                boolean bl2 = false;
                usages = new LinkedHashSet();
                Iterator iterator2 = ExternalSystemApiUtil.getAllManagers().iterator();
                while (iterator2.hasNext()) {
                    ExternalSystemManager manager2;
                    ExternalSystemManager externalSystemManager = manager2 = (ExternalSystemManager)iterator2.next();
                    Intrinsics.checkNotNullExpressionValue((Object)externalSystemManager, (String)"manager");
                    Object object = externalSystemManager.getSettingsProvider().fun((Object)project);
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"manager.settingsProvider.`fun`(project)");
                    if (((AbstractExternalSystemSettings)object).getLinkedProjectsSettings().isEmpty()) continue;
                    ProjectSystemId projectSystemId = manager2.getSystemId();
                    Intrinsics.checkNotNullExpressionValue((Object)projectSystemId, (String)"manager.systemId");
                    usages.add(MetricEventFactoryKt.newMetric((String)"externalSystemId", (String)ExternalSystemStatUtilKt.getAnonymizedSystemId(projectSystemId)));
                }
                ModuleManager moduleManager = ModuleManager.getInstance((Project)project);
                Intrinsics.checkNotNullExpressionValue((Object)moduleManager, (String)"ModuleManager.getInstance(project)");
                Module[] moduleArray2 = moduleManager.getModules();
                Intrinsics.checkNotNullExpressionValue((Object)moduleArray2, (String)"ModuleManager.getInstance(project).modules");
                moduleArray = moduleArray2;
                bl = false;
                Module[] moduleArray3 = moduleArray;
                boolean bl3 = false;
                Module[] moduleArray4 = moduleArray3;
                int n = moduleArray4.length;
                for (int j = 0; j < n; ++j) {
                    Module module2;
                    Module it = module2 = moduleArray4[j];
                    boolean bl4 = false;
                    Module module3 = it;
                    Intrinsics.checkNotNullExpressionValue((Object)module3, (String)"it");
                    if (!ExternalSystemModulePropertyManager.Companion.getInstance(module3).isMavenized()) continue;
                    module = module2;
                    break block2;
                }
                module = null;
            }
            if (module == null) break block3;
            moduleArray = module;
            bl = false;
            boolean bl5 = false;
            Module[] it = moduleArray;
            boolean bl6 = false;
            usages.add(MetricEventFactoryKt.newMetric((String)"externalSystemId", (String)"Maven"));
        }
        return usages;
    }

    @JvmStatic
    @NotNull
    public static final StructuredIdeActivity externalSystemTaskStarted(@Nullable Project project, @Nullable ProjectSystemId systemId2, @NotNull ExternalSystemTaskId taskId, @Nullable TargetEnvironmentConfigurationProvider environmentConfigurationProvider) {
        return Companion.externalSystemTaskStarted(project, systemId2, taskId, environmentConfigurationProvider);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lcom/intellij/openapi/externalSystem/statistics/ExternalSystemUsagesCollector$ExternalSystemTaskId;", "", "(Ljava/lang/String;I)V", "ResolveProject", "ExecuteTask", "intellij.platform.externalSystem.impl"})
    public static final class ExternalSystemTaskId
    extends Enum<ExternalSystemTaskId> {
        public static final /* enum */ ExternalSystemTaskId ResolveProject;
        public static final /* enum */ ExternalSystemTaskId ExecuteTask;
        private static final /* synthetic */ ExternalSystemTaskId[] $VALUES;

        static {
            ExternalSystemTaskId[] externalSystemTaskIdArray = new ExternalSystemTaskId[2];
            ExternalSystemTaskId[] externalSystemTaskIdArray2 = externalSystemTaskIdArray;
            externalSystemTaskIdArray[0] = ResolveProject = new ExternalSystemTaskId();
            externalSystemTaskIdArray[1] = ExecuteTask = new ExternalSystemTaskId();
            $VALUES = externalSystemTaskIdArray;
        }

        public static ExternalSystemTaskId[] values() {
            return (ExternalSystemTaskId[])$VALUES.clone();
        }

        public static ExternalSystemTaskId valueOf(String string) {
            return Enum.valueOf(ExternalSystemTaskId.class, string);
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J.\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0007J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0010J \u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0010\u00a8\u0006\u0013"}, d2={"Lcom/intellij/openapi/externalSystem/statistics/ExternalSystemUsagesCollector$Companion;", "", "()V", "externalSystemTaskStarted", "Lcom/intellij/internal/statistic/StructuredIdeActivity;", "project", "Lcom/intellij/openapi/project/Project;", "systemId", "Lcom/intellij/openapi/externalSystem/model/ProjectSystemId;", "taskId", "Lcom/intellij/openapi/externalSystem/statistics/ExternalSystemUsagesCollector$ExternalSystemTaskId;", "environmentConfigurationProvider", "Lcom/intellij/openapi/externalSystem/service/execution/TargetEnvironmentConfigurationProvider;", "getJRETypeUsage", "Lcom/intellij/internal/statistic/beans/MetricEvent;", "key", "", "jreName", "getJREVersionUsage", "intellij.platform.externalSystem.impl"})
    public static final class Companion {
        @NotNull
        public final MetricEvent getJRETypeUsage(@NotNull String key, @Nullable String jreName) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            CharSequence charSequence = jreName;
            boolean bl = false;
            boolean bl2 = false;
            String anonymizedName = charSequence == null || StringsKt.isBlank((CharSequence)charSequence) ? "empty" : (CollectionsKt.listOf((Object[])new String[]{"#JAVA_INTERNAL", "#USE_PROJECT_JDK", "#JAVA_HOME"}).contains(jreName) ? jreName : "custom");
            return MetricEventFactoryKt.newMetric((String)key, (String)anonymizedName);
        }

        @NotNull
        public final MetricEvent getJREVersionUsage(@NotNull Project project, @NotNull String key, @Nullable String jreName) {
            Object object;
            block6: {
                block5: {
                    String string;
                    Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                    Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                    Sdk jdk = ExternalSystemJdkUtil.getJdk(project, jreName);
                    object = jdk;
                    if (object == null || (object = object.getVersionString()) == null) break block5;
                    Object object2 = object;
                    boolean bl = false;
                    boolean bl2 = false;
                    Object it = object2;
                    boolean bl3 = false;
                    Version version2 = Version.parseVersion((String)it);
                    if (version2 != null) {
                        Version version3 = version2;
                        boolean bl4 = false;
                        boolean bl5 = false;
                        Version parsed = version3;
                        boolean bl6 = false;
                        string = "" + parsed.major + '.' + parsed.minor;
                    } else {
                        string = object = null;
                    }
                    if (string != null) break block6;
                }
                object = "unknown";
            }
            Object versionString = object;
            return MetricEventFactoryKt.newMetric((String)key, (String)versionString);
        }

        @JvmStatic
        @NotNull
        public final StructuredIdeActivity externalSystemTaskStarted(@Nullable Project project, @Nullable ProjectSystemId systemId2, @NotNull ExternalSystemTaskId taskId, @Nullable TargetEnvironmentConfigurationProvider environmentConfigurationProvider) {
            Intrinsics.checkNotNullParameter((Object)((Object)taskId), (String)"taskId");
            return ExternalSystemTaskCollector.EXTERNAL_TASK_ACTIVITY.started(project, new Function0<List<? extends EventPair<?>>>(systemId2, taskId, environmentConfigurationProvider){
                final /* synthetic */ ProjectSystemId $systemId;
                final /* synthetic */ ExternalSystemTaskId $taskId;
                final /* synthetic */ TargetEnvironmentConfigurationProvider $environmentConfigurationProvider;

                /*
                 * WARNING - void declaration
                 */
                @NotNull
                public final List<EventPair<?>> invoke() {
                    void var1_1;
                    block0: {
                        List data2 = CollectionsKt.mutableListOf((Object[])new EventPair[]{ExternalSystemActionsCollector.Companion.getEXTERNAL_SYSTEM_ID().with((Object)ExternalSystemStatUtilKt.anonymizeSystemId(this.$systemId))});
                        data2.add(ExternalSystemTaskCollector.TASK_ID_FIELD.with((Object)((Object)this.$taskId)));
                        Object object = this.$environmentConfigurationProvider;
                        if (object == null || (object = object.getEnvironmentConfiguration()) == null || (object = object.getTypeId()) == null) break block0;
                        Object object2 = object;
                        boolean bl = false;
                        boolean bl2 = false;
                        Object it = object2;
                        boolean bl3 = false;
                        data2.add(ExternalSystemTaskCollector.TARGET_FIELD.with(it));
                    }
                    return var1_1;
                }
                {
                    this.$systemId = projectSystemId;
                    this.$taskId = externalSystemTaskId;
                    this.$environmentConfigurationProvider = targetEnvironmentConfigurationProvider;
                    super(0);
                }
            });
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

