/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileChooser.impl;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileSaverDescriptor;
import com.intellij.openapi.fileChooser.PathChooserDialog;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.nio.file.Path;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FileChooserUtil {
    private static final String LAST_OPENED_FILE_PATH = "last_opened_file_path";

    @Nullable
    public static VirtualFile getLastOpenedFile(@Nullable Project project) {
        String path2 = project == null ? PropertiesComponent.getInstance().getValue(LAST_OPENED_FILE_PATH) : PropertiesComponent.getInstance((Project)project).getValue(LAST_OPENED_FILE_PATH);
        return path2 != null ? LocalFileSystem.getInstance().findFileByPath(path2) : null;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    public static void setLastOpenedFile(@Nullable Project project, @Nullable VirtualFile file2) {
        if (file2 == null) {
            return;
        }
        if (project == null) {
            PropertiesComponent.getInstance().setValue(LAST_OPENED_FILE_PATH, file2.getPath());
        } else if (!project.isDisposed()) {
            PropertiesComponent.getInstance((Project)project).setValue(LAST_OPENED_FILE_PATH, file2.getPath());
        }
    }

    public static void setLastOpenedFile(@Nullable Project project, @NotNull Path file2) {
        if (file2 == null) {
            FileChooserUtil.$$$reportNull$$$0(0);
        }
        if (project == null) {
            PropertiesComponent.getInstance().setValue(LAST_OPENED_FILE_PATH, FileUtil.toSystemIndependentName((String)file2.toString()));
        } else if (!project.isDisposed()) {
            PropertiesComponent.getInstance((Project)project).setValue(LAST_OPENED_FILE_PATH, FileUtil.toSystemIndependentName((String)file2.toString()));
        }
    }

    @Nullable
    public static VirtualFile getFileToSelect(@NotNull FileChooserDescriptor descriptor2, @Nullable Project project, @Nullable VirtualFile toSelect2, @Nullable VirtualFile lastPath) {
        if (descriptor2 == null) {
            FileChooserUtil.$$$reportNull$$$0(1);
        }
        boolean chooseDir = descriptor2 instanceof FileSaverDescriptor;
        VirtualFile result2 = toSelect2 == null && lastPath == null ? (project == null || project.isDefault() ? null : ProjectUtil.guessProjectDir((Project)project)) : (toSelect2 != null && lastPath != null ? (Boolean.TRUE.equals(descriptor2.getUserData(PathChooserDialog.PREFER_LAST_OVER_EXPLICIT)) ? lastPath : toSelect2) : (toSelect2 == null ? lastPath : toSelect2));
        if (result2 != null) {
            if (chooseDir && !result2.isDirectory()) {
                result2 = result2.getParent();
            }
        } else if (SystemInfo.isUnix) {
            result2 = VfsUtil.getUserHomeDir();
        }
        return result2;
    }

    @NotNull
    public static List<VirtualFile> getChosenFiles(@NotNull FileChooserDescriptor descriptor2, @NotNull List<? extends VirtualFile> selectedFiles) {
        if (descriptor2 == null) {
            FileChooserUtil.$$$reportNull$$$0(2);
        }
        if (selectedFiles == null) {
            FileChooserUtil.$$$reportNull$$$0(3);
        }
        List list2 = ContainerUtil.mapNotNull(selectedFiles, file2 -> file2 != null && file2.isValid() ? descriptor2.getFileToSelect(file2) : null);
        if (list2 == null) {
            FileChooserUtil.$$$reportNull$$$0(4);
        }
        return list2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedFiles";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/fileChooser/impl/FileChooserUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/fileChooser/impl/FileChooserUtil";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getChosenFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setLastOpenedFile";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getFileToSelect";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getChosenFiles";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

