/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl;

import com.intellij.ide.IdeBundle;
import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.service.fus.collectors.FUCounterUsageLogger;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.impl.ActionToolbarImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.FileEditorStateLevel;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileEditor.ex.FileEditorProviderManager;
import com.intellij.openapi.fileEditor.ex.FileEditorWithProvider;
import com.intellij.openapi.fileEditor.ex.IdeDocumentHistory;
import com.intellij.openapi.fileEditor.impl.EditorWindowHolder;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl;
import com.intellij.openapi.fileEditor.impl.FileEditorProviderManagerImpl;
import com.intellij.openapi.fileEditor.impl.HistoryEntry;
import com.intellij.openapi.fileEditor.impl.IdeDocumentHistoryImpl;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.Weighted;
import com.intellij.openapi.util.registry.ExperimentalUI;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.FocusWatcher;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.JBColor;
import com.intellij.ui.PrevNextActionsDescriptor;
import com.intellij.ui.SideBorder;
import com.intellij.ui.TabbedPaneWrapper;
import com.intellij.ui.components.JBPanelWithEmptyText;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.ui.tabs.JBTabs;
import com.intellij.ui.tabs.impl.JBTabsImpl;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditorComposite
implements Disposable {
    private static final Logger LOG = Logger.getInstance(EditorComposite.class);
    @NotNull
    private final VirtualFile myFile;
    private boolean myPinned;
    private boolean myPreview;
    volatile FileEditor[] myEditors;
    private final long myInitialFileTimeStamp;
    private TabbedPaneWrapper myTabbedPaneWrapper;
    @NotNull
    private final MyComponent myComponent;
    private final FocusWatcher myFocusWatcher;
    private FileEditor mySelectedEditor;
    private final FileEditorManagerEx myFileEditorManager;
    private final Map<FileEditor, JComponent> myTopComponents;
    private final Map<FileEditor, JComponent> myBottomComponents;
    private final Map<FileEditor, @NlsContexts.TabTitle String> myDisplayNames;
    private FileEditorProvider[] myProviders;

    EditorComposite(@NotNull VirtualFile file2, @NotNull @NotNull FileEditor @NotNull [] editors2, @NotNull @NotNull FileEditorProvider @NotNull [] providers, @NotNull FileEditorManagerEx fileEditorManager) {
        if (file2 == null) {
            EditorComposite.$$$reportNull$$$0(0);
        }
        if (editors2 == null) {
            EditorComposite.$$$reportNull$$$0(1);
        }
        if (providers == null) {
            EditorComposite.$$$reportNull$$$0(2);
        }
        if (fileEditorManager == null) {
            EditorComposite.$$$reportNull$$$0(3);
        }
        this.myTopComponents = new HashMap<FileEditor, JComponent>();
        this.myBottomComponents = new HashMap<FileEditor, JComponent>();
        this.myDisplayNames = new HashMap<FileEditor, String>();
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myFile = file2;
        this.myEditors = editors2;
        this.myProviders = providers;
        for (FileEditor editor : editors2) {
            FileEditor.FILE_KEY.set((UserDataHolder)editor, (Object)this.myFile);
        }
        if (ArrayUtil.contains(null, (Object[])editors2)) {
            throw new IllegalArgumentException("Must not pass null editors in " + Arrays.asList(editors2));
        }
        this.myFileEditorManager = fileEditorManager;
        this.myInitialFileTimeStamp = this.myFile.getTimeStamp();
        final Project project = fileEditorManager.getProject();
        Disposer.register((Disposable)project, (Disposable)this);
        if (editors2.length > 1) {
            this.myTabbedPaneWrapper = this.createTabbedPaneWrapper(editors2, null);
            JComponent component2 = this.myTabbedPaneWrapper.getComponent();
            this.myComponent = new MyComponent(component2, () -> component2);
        } else if (editors2.length == 1) {
            this.myTabbedPaneWrapper = null;
            FileEditor editor = editors2[0];
            this.myComponent = new MyComponent(this.createEditorComponent(editor), () -> ((FileEditor)editor).getPreferredFocusedComponent());
        } else {
            throw new IllegalArgumentException("editors array cannot be empty");
        }
        this.mySelectedEditor = editors2[0];
        this.myFocusWatcher = new FocusWatcher();
        this.myFocusWatcher.install((Component)this.myComponent);
        project.getMessageBus().connect((Disposable)this).subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)new FileEditorManagerListener(){

            public void selectionChanged(@NotNull FileEditorManagerEvent event) {
                VirtualFile newFile;
                VirtualFile oldFile;
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (Comparing.equal((Object)(oldFile = event.getOldFile()), (Object)(newFile = event.getNewFile())) && Comparing.equal((Object)EditorComposite.this.getFile(), (Object)newFile)) {
                    Runnable runnable2 = () -> {
                        FileEditor newEditor;
                        FileEditor oldEditor = event.getOldEditor();
                        if (oldEditor != null) {
                            oldEditor.deselectNotify();
                        }
                        if ((newEditor = event.getNewEditor()) != null) {
                            newEditor.selectNotify();
                            FUCounterUsageLogger.getInstance().logEvent(project, "file.editor", "alternative.file.editor.selected", new FeatureUsageData().addData("fileEditor", newEditor.getClass().getName()).addAnonymizedPath(newFile.getPath()));
                        }
                        ((FileEditorProviderManagerImpl)FileEditorProviderManager.getInstance()).providerSelected(EditorComposite.this);
                        ((IdeDocumentHistoryImpl)IdeDocumentHistory.getInstance(EditorComposite.this.myFileEditorManager.getProject())).onSelectionChanged();
                    };
                    if (ApplicationManager.getApplication().isDispatchThread()) {
                        CommandProcessor.getInstance().executeCommand(EditorComposite.this.myFileEditorManager.getProject(), runnable2, IdeBundle.message((String)"command.switch.active.editor", (Object[])new Object[0]), null);
                    } else {
                        runnable2.run();
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/fileEditor/impl/EditorComposite$1", "selectionChanged"));
            }
        });
    }

    public FileEditorProvider @NotNull [] getProviders() {
        if (this.myProviders == null) {
            EditorComposite.$$$reportNull$$$0(4);
        }
        return this.myProviders;
    }

    @NotNull
    private TabbedPaneWrapper.AsJBTabs createTabbedPaneWrapper(FileEditor @NotNull [] editors2, MyComponent myComponent) {
        if (editors2 == null) {
            EditorComposite.$$$reportNull$$$0(5);
        }
        PrevNextActionsDescriptor descriptor2 = new PrevNextActionsDescriptor("NextEditorTab", "PreviousEditorTab");
        TabbedPaneWrapper.AsJBTabs wrapper2 = new TabbedPaneWrapper.AsJBTabs(this.myFileEditorManager.getProject(), 3, descriptor2, this);
        boolean firstEditor = true;
        for (FileEditor editor : editors2) {
            JComponent component2 = firstEditor && myComponent != null ? (JComponent)myComponent.getComponent(0) : this.createEditorComponent(editor);
            wrapper2.addTab(this.getDisplayName(editor), component2);
            firstEditor = false;
        }
        wrapper2.addChangeListener(new MyChangeListener());
        TabbedPaneWrapper.AsJBTabs asJBTabs = wrapper2;
        if (asJBTabs == null) {
            EditorComposite.$$$reportNull$$$0(6);
        }
        return asJBTabs;
    }

    @NotNull
    private JComponent createEditorComponent(@NotNull FileEditor editor) {
        if (editor == null) {
            EditorComposite.$$$reportNull$$$0(7);
        }
        JPanel component2 = new JPanel(new BorderLayout());
        JComponent comp = editor.getComponent();
        if (!FileEditorManagerImpl.isDumbAware(editor)) {
            comp = DumbService.getInstance((Project)this.myFileEditorManager.getProject()).wrapGently(comp, (Disposable)editor);
        }
        component2.add((Component)comp, "Center");
        TopBottomPanel topPanel = new TopBottomPanel();
        this.myTopComponents.put(editor, (JComponent)((Object)topPanel));
        component2.add((Component)((Object)topPanel), "North");
        TopBottomPanel bottomPanel2 = new TopBottomPanel();
        this.myBottomComponents.put(editor, (JComponent)((Object)bottomPanel2));
        component2.add((Component)((Object)bottomPanel2), "South");
        JPanel jPanel2 = component2;
        if (jPanel2 == null) {
            EditorComposite.$$$reportNull$$$0(8);
        }
        return jPanel2;
    }

    public boolean isPinned() {
        return this.myPinned;
    }

    void setPinned(boolean pinned) {
        this.myPinned = pinned;
        Container parent = this.getComponent().getParent();
        if (parent instanceof JComponent) {
            ((JComponent)parent).putClientProperty(JBTabsImpl.PINNED, this.myPinned ? Boolean.TRUE : null);
        }
    }

    public boolean isPreview() {
        return this.myPreview;
    }

    void setPreview(boolean preview2) {
        this.myPreview = preview2;
    }

    private void fireSelectedEditorChanged(@NotNull FileEditor oldSelectedEditor, @NotNull FileEditor newSelectedEditor) {
        if (oldSelectedEditor == null) {
            EditorComposite.$$$reportNull$$$0(9);
        }
        if (newSelectedEditor == null) {
            EditorComposite.$$$reportNull$$$0(10);
        }
        if (!(EventQueue.isDispatchThread() && this.myFileEditorManager.isInsideChange() || Comparing.equal((Object)oldSelectedEditor, (Object)newSelectedEditor))) {
            this.myFileEditorManager.notifyPublisher(() -> {
                FileEditorManagerEvent event = new FileEditorManagerEvent((FileEditorManager)this.myFileEditorManager, this.myFile, oldSelectedEditor, this.myFile, newSelectedEditor);
                FileEditorManagerListener publisher = (FileEditorManagerListener)this.myFileEditorManager.getProject().getMessageBus().syncPublisher(FileEditorManagerListener.FILE_EDITOR_MANAGER);
                publisher.selectionChanged(event);
            });
            JComponent component2 = newSelectedEditor.getComponent();
            EditorWindowHolder holder = (EditorWindowHolder)ComponentUtil.getParentOfType(EditorWindowHolder.class, (Component)component2);
            if (holder != null) {
                ((FileEditorManagerImpl)this.myFileEditorManager).addSelectionRecord(this.myFile, holder.getEditorWindow());
            }
        }
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        if (this.mySelectedEditor == null) {
            return null;
        }
        Component component2 = this.myFocusWatcher.getFocusedComponent();
        if (!(component2 instanceof JComponent && component2.isShowing() && component2.isEnabled() && component2.isFocusable())) {
            return this.getSelectedEditor().getPreferredFocusedComponent();
        }
        return (JComponent)component2;
    }

    @NotNull
    public VirtualFile getFile() {
        VirtualFile virtualFile2 = this.myFile;
        if (virtualFile2 == null) {
            EditorComposite.$$$reportNull$$$0(11);
        }
        return virtualFile2;
    }

    @NotNull
    public FileEditorManager getFileEditorManager() {
        FileEditorManagerEx fileEditorManagerEx = this.myFileEditorManager;
        if (fileEditorManagerEx == null) {
            EditorComposite.$$$reportNull$$$0(12);
        }
        return fileEditorManagerEx;
    }

    public long getInitialFileTimeStamp() {
        return this.myInitialFileTimeStamp;
    }

    public FileEditor @NotNull [] getEditors() {
        if (this.myEditors == null) {
            EditorComposite.$$$reportNull$$$0(13);
        }
        return this.myEditors;
    }

    @NotNull
    List<JComponent> getTopComponents(@NotNull FileEditor editor) {
        if (editor == null) {
            EditorComposite.$$$reportNull$$$0(14);
        }
        SmartList result2 = new SmartList();
        JComponent container = this.myTopComponents.get(editor);
        for (Component each : container.getComponents()) {
            if (!(each instanceof NonOpaquePanel)) continue;
            result2.add(((NonOpaquePanel)each).getTargetComponent());
        }
        List<JComponent> list2 = Collections.unmodifiableList(result2);
        if (list2 == null) {
            EditorComposite.$$$reportNull$$$0(15);
        }
        return list2;
    }

    @Nullable
    public JBTabs getTabs() {
        return this.myTabbedPaneWrapper == null ? null : ((TabbedPaneWrapper.AsJBTabs)this.myTabbedPaneWrapper).getTabs();
    }

    public void addTopComponent(@NotNull FileEditor editor, @NotNull JComponent component2) {
        if (editor == null) {
            EditorComposite.$$$reportNull$$$0(16);
        }
        if (component2 == null) {
            EditorComposite.$$$reportNull$$$0(17);
        }
        this.manageTopOrBottomComponent(editor, component2, true, false);
    }

    public void removeTopComponent(@NotNull FileEditor editor, @NotNull JComponent component2) {
        if (editor == null) {
            EditorComposite.$$$reportNull$$$0(18);
        }
        if (component2 == null) {
            EditorComposite.$$$reportNull$$$0(19);
        }
        this.manageTopOrBottomComponent(editor, component2, true, true);
    }

    void addBottomComponent(@NotNull FileEditor editor, @NotNull JComponent component2) {
        if (editor == null) {
            EditorComposite.$$$reportNull$$$0(20);
        }
        if (component2 == null) {
            EditorComposite.$$$reportNull$$$0(21);
        }
        this.manageTopOrBottomComponent(editor, component2, false, false);
    }

    void removeBottomComponent(@NotNull FileEditor editor, @NotNull JComponent component2) {
        if (editor == null) {
            EditorComposite.$$$reportNull$$$0(22);
        }
        if (component2 == null) {
            EditorComposite.$$$reportNull$$$0(23);
        }
        this.manageTopOrBottomComponent(editor, component2, false, true);
    }

    private void manageTopOrBottomComponent(@NotNull FileEditor editor, @NotNull JComponent component2, boolean top, boolean remove) {
        JComponent container;
        if (editor == null) {
            EditorComposite.$$$reportNull$$$0(24);
        }
        if (component2 == null) {
            EditorComposite.$$$reportNull$$$0(25);
        }
        JComponent jComponent = container = top ? this.myTopComponents.get(editor) : this.myBottomComponents.get(editor);
        assert (container != null);
        if (remove) {
            container.remove(component2.getParent());
        } else {
            NonOpaquePanel wrapper2 = new NonOpaquePanel(component2);
            if (!Boolean.TRUE.equals(component2.getClientProperty(FileEditorManager.SEPARATOR_DISABLED))) {
                wrapper2.setBorder((Border)EditorComposite.createTopBottomSideBorder(top));
            }
            container.add((Component)wrapper2, EditorComposite.calcComponentInsertionIndex(component2, container));
        }
        container.revalidate();
    }

    private static int calcComponentInsertionIndex(@NotNull JComponent newComponent, @NotNull JComponent container) {
        if (newComponent == null) {
            EditorComposite.$$$reportNull$$$0(26);
        }
        if (container == null) {
            EditorComposite.$$$reportNull$$$0(27);
        }
        int max = container.getComponentCount();
        for (int i2 = 0; i2 < max; ++i2) {
            double w2;
            Component childWrapper = container.getComponent(i2);
            Component childComponent = childWrapper instanceof Wrapper ? ((Wrapper)childWrapper).getTargetComponent() : childWrapper;
            boolean weighted1 = newComponent instanceof Weighted;
            boolean weighted2 = childComponent instanceof Weighted;
            if (!weighted2) continue;
            if (!weighted1) {
                return i2;
            }
            double w1 = ((Weighted)newComponent).getWeight();
            if (!(w1 < (w2 = ((Weighted)childComponent).getWeight()))) continue;
            return i2;
        }
        return -1;
    }

    public void setDisplayName(@NotNull FileEditor editor, @NlsContexts.TabTitle @NotNull String name) {
        if (editor == null) {
            EditorComposite.$$$reportNull$$$0(28);
        }
        if (name == null) {
            EditorComposite.$$$reportNull$$$0(29);
        }
        int index2 = ContainerUtil.indexOfIdentity((List)ContainerUtil.immutableList((Object[])this.myEditors), (Object)editor);
        assert (index2 != -1);
        this.myDisplayNames.put(editor, name);
        if (this.myTabbedPaneWrapper != null) {
            this.myTabbedPaneWrapper.setTitleAt(index2, name);
        }
    }

    @NotNull
    @NlsContexts.TabTitle
    protected String getDisplayName(@NotNull FileEditor editor) {
        if (editor == null) {
            EditorComposite.$$$reportNull$$$0(30);
        }
        String string = (String)ObjectUtils.notNull((Object)this.myDisplayNames.get(editor), (Object)editor.getName());
        if (string == null) {
            EditorComposite.$$$reportNull$$$0(31);
        }
        return string;
    }

    @NotNull
    FileEditor getSelectedEditor() {
        FileEditor fileEditor = this.getSelectedWithProvider().getFileEditor();
        if (fileEditor == null) {
            EditorComposite.$$$reportNull$$$0(32);
        }
        return fileEditor;
    }

    @NotNull
    public FileEditorWithProvider getSelectedWithProvider() {
        LOG.assertTrue(this.myEditors.length > 0, (Object)this.myEditors.length);
        if (this.myEditors.length == 1) {
            LOG.assertTrue(this.myTabbedPaneWrapper == null);
            return new FileEditorWithProvider(this.myEditors[0], this.myProviders[0]);
        }
        LOG.assertTrue(this.myTabbedPaneWrapper != null);
        int index2 = this.myTabbedPaneWrapper.getSelectedIndex();
        if (index2 == -1) {
            index2 = 0;
        }
        LOG.assertTrue(index2 >= 0, (Object)index2);
        LOG.assertTrue(index2 < this.myEditors.length, (Object)index2);
        return new FileEditorWithProvider(this.myEditors[index2], this.myProviders[index2]);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    @NotNull
    public Pair<FileEditor, FileEditorProvider> getSelectedEditorWithProvider() {
        FileEditorWithProvider info2 = this.getSelectedWithProvider();
        Pair pair = Pair.create((Object)info2.getFileEditor(), (Object)info2.getProvider());
        if (pair == null) {
            EditorComposite.$$$reportNull$$$0(33);
        }
        return pair;
    }

    void setSelectedEditor(int index2) {
        if (this.myEditors.length == 1) {
            LOG.assertTrue(this.myTabbedPaneWrapper == null);
        } else {
            LOG.assertTrue(this.myTabbedPaneWrapper != null);
            this.myTabbedPaneWrapper.setSelectedIndex(index2);
        }
    }

    @NotNull
    public JComponent getComponent() {
        MyComponent myComponent = this.myComponent;
        if (myComponent == null) {
            EditorComposite.$$$reportNull$$$0(34);
        }
        return myComponent;
    }

    @Nullable
    public JComponent getFocusComponent() {
        return this.myComponent.myFocusComponent.get();
    }

    public boolean isModified() {
        return ContainerUtil.exists((Object[])this.getEditors(), editor -> editor.isModified());
    }

    public static boolean isEditorComposite(@NotNull Component component2) {
        if (component2 == null) {
            EditorComposite.$$$reportNull$$$0(35);
        }
        return component2 instanceof MyComponent;
    }

    public void dispose() {
        for (FileEditor editor : this.myEditors) {
            if (Disposer.isDisposed((Disposable)editor)) continue;
            Disposer.dispose((Disposable)editor);
        }
        this.myFocusWatcher.deinstall(this.myFocusWatcher.getTopComponent());
    }

    private void addEditor(@NotNull FileEditor editor) {
        if (editor == null) {
            EditorComposite.$$$reportNull$$$0(36);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myEditors = (FileEditor[])ArrayUtil.append((Object[])this.myEditors, (Object)editor);
        FileEditor.FILE_KEY.set((UserDataHolder)editor, (Object)this.myFile);
        if (this.myTabbedPaneWrapper == null) {
            this.myTabbedPaneWrapper = this.createTabbedPaneWrapper(this.myEditors, this.myComponent);
            this.myComponent.setComponent(this.myTabbedPaneWrapper.getComponent());
        } else {
            JComponent component2 = this.createEditorComponent(editor);
            this.myTabbedPaneWrapper.addTab(this.getDisplayName(editor), component2);
        }
        this.myFocusWatcher.deinstall(this.myFocusWatcher.getTopComponent());
        this.myFocusWatcher.install((Component)this.myComponent);
    }

    @NotNull
    private static SideBorder createTopBottomSideBorder(final boolean top) {
        return new SideBorder(null, top ? 8 : 2){

            public Color getLineColor() {
                EditorColorsScheme scheme2 = EditorColorsManager.getInstance().getGlobalScheme();
                if (ExperimentalUI.isNewEditorTabs()) {
                    return scheme2.getDefaultBackground();
                }
                Color result2 = scheme2.getColor(top ? EditorColors.SEPARATOR_ABOVE_COLOR : EditorColors.SEPARATOR_BELOW_COLOR);
                if (result2 == null) {
                    result2 = scheme2.getColor(EditorColors.TEARLINE_COLOR);
                }
                return result2 == null ? JBColor.BLACK : result2;
            }
        };
    }

    @NotNull
    HistoryEntry currentStateAsHistoryEntry() {
        Object[] editors2 = this.getEditors();
        FileEditorState[] states = new FileEditorState[editors2.length];
        for (int j = 0; j < states.length; ++j) {
            states[j] = editors2[j].getState(FileEditorStateLevel.FULL);
            LOG.assertTrue(states[j] != null);
        }
        int selectedProviderIndex = ArrayUtil.find((Object[])editors2, (Object)this.getSelectedEditor());
        LOG.assertTrue(selectedProviderIndex != -1);
        FileEditorProvider[] providers = this.getProviders();
        HistoryEntry historyEntry = HistoryEntry.createLight(this.getFile(), providers, states, providers[selectedProviderIndex]);
        if (historyEntry == null) {
            EditorComposite.$$$reportNull$$$0(37);
        }
        return historyEntry;
    }

    public void addEditor(@NotNull FileEditor editor, @NotNull FileEditorProvider provider2) {
        if (editor == null) {
            EditorComposite.$$$reportNull$$$0(38);
        }
        if (provider2 == null) {
            EditorComposite.$$$reportNull$$$0(39);
        }
        this.addEditor(editor);
        this.myProviders = (FileEditorProvider[])ArrayUtil.append((Object[])this.myProviders, (Object)provider2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 37: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 37: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editors";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "providers";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileEditorManager";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/fileEditor/impl/EditorComposite";
                break;
            }
            case 7: 
            case 14: 
            case 16: 
            case 18: 
            case 20: 
            case 22: 
            case 24: 
            case 28: 
            case 30: 
            case 36: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldSelectedEditor";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newSelectedEditor";
                break;
            }
            case 17: 
            case 19: 
            case 21: 
            case 23: 
            case 25: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newComponent";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/fileEditor/impl/EditorComposite";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getProviders";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createTabbedPaneWrapper";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditorComponent";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getFile";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileEditorManager";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditors";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getTopComponents";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedEditor";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedEditorWithProvider";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "currentStateAsHistoryEntry";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 37: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createTabbedPaneWrapper";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createEditorComponent";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "fireSelectedEditorChanged";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getTopComponents";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "addTopComponent";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "removeTopComponent";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "addBottomComponent";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "removeBottomComponent";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "manageTopOrBottomComponent";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "calcComponentInsertionIndex";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "setDisplayName";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getDisplayName";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "isEditorComposite";
                break;
            }
            case 36: 
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "addEditor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 37: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class TopBottomPanel
    extends JBPanelWithEmptyText {
        private TopBottomPanel() {
            this.setLayout(new BoxLayout((Container)((Object)this), 1));
        }

        public Color getBackground() {
            EditorColorsScheme globalScheme = EditorColorsManager.getInstance().getGlobalScheme();
            if (ExperimentalUI.isNewEditorTabs()) {
                return globalScheme.getDefaultBackground();
            }
            Color color = globalScheme.getColor(EditorColors.GUTTER_BACKGROUND);
            return color == null ? EditorColors.GUTTER_BACKGROUND.getDefaultColor() : color;
        }

        protected void addImpl(Component comp, Object constraints2, int index2) {
            super.addImpl(comp, constraints2, index2);
            if (comp instanceof JComponent) {
                List toolbars = UIUtil.findComponentsOfType((JComponent)((JComponent)comp), ActionToolbarImpl.class);
                for (ActionToolbarImpl toolbar : toolbars) {
                    Color color = toolbar.getBackground();
                    if (!JBColor.PanelBackground.equals(color) && color != null) continue;
                    toolbar.setBackground((Color)new JBColor(() -> EditorColorsManager.getInstance().getGlobalScheme().getDefaultBackground()));
                }
            }
        }
    }

    private class MyComponent
    extends JPanel
    implements DataProvider {
        @NotNull
        private Supplier<? extends JComponent> myFocusComponent;

        MyComponent(@NotNull JComponent realComponent, Supplier<? extends JComponent> focusComponent) {
            if (realComponent == null) {
                MyComponent.$$$reportNull$$$0(0);
            }
            if (focusComponent == null) {
                MyComponent.$$$reportNull$$$0(1);
            }
            super(new BorderLayout());
            this.setFocusable(false);
            this.myFocusComponent = focusComponent;
            this.add((Component)realComponent, "Center");
        }

        void setComponent(JComponent newComponent) {
            this.add((Component)newComponent, "Center");
            this.myFocusComponent = () -> newComponent;
        }

        @Override
        public boolean requestFocusInWindow() {
            JComponent focusComponent = this.myFocusComponent.get();
            return focusComponent != null && focusComponent.requestFocusInWindow();
        }

        @Override
        public void requestFocus() {
            JComponent focusComponent = this.myFocusComponent.get();
            if (focusComponent != null) {
                IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)focusComponent, true));
            }
        }

        @Override
        public boolean requestDefaultFocus() {
            JComponent focusComponent = this.myFocusComponent.get();
            return focusComponent != null && focusComponent.requestDefaultFocus();
        }

        @Override
        public final Object getData(@NotNull String dataId) {
            if (dataId == null) {
                MyComponent.$$$reportNull$$$0(2);
            }
            if (PlatformDataKeys.FILE_EDITOR.is(dataId)) {
                return EditorComposite.this.getSelectedEditor();
            }
            if (CommonDataKeys.VIRTUAL_FILE.is(dataId)) {
                return EditorComposite.this.myFile.isValid() ? EditorComposite.this.myFile : null;
            }
            if (CommonDataKeys.VIRTUAL_FILE_ARRAY.is(dataId)) {
                VirtualFile[] virtualFileArray;
                if (EditorComposite.this.myFile.isValid()) {
                    VirtualFile[] virtualFileArray2 = new VirtualFile[1];
                    virtualFileArray = virtualFileArray2;
                    virtualFileArray2[0] = EditorComposite.this.myFile;
                } else {
                    virtualFileArray = null;
                }
                return virtualFileArray;
            }
            JComponent component2 = EditorComposite.this.getPreferredFocusedComponent();
            if (component2 instanceof DataProvider && component2 != this) {
                return ((DataProvider)((Object)component2)).getData(dataId);
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "realComponent";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "focusComponent";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataId";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/fileEditor/impl/EditorComposite$MyComponent";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getData";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private final class MyChangeListener
    implements ChangeListener {
        private MyChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            FileEditor oldSelectedEditor = EditorComposite.this.mySelectedEditor;
            LOG.assertTrue(oldSelectedEditor != null);
            int selectedIndex = EditorComposite.this.myTabbedPaneWrapper.getSelectedIndex();
            LOG.assertTrue(selectedIndex != -1);
            EditorComposite.this.mySelectedEditor = EditorComposite.this.myEditors[selectedIndex];
            EditorComposite.this.fireSelectedEditorChanged(oldSelectedEditor, EditorComposite.this.mySelectedEditor);
        }
    }
}

