/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl;

import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.impl.TestEditorTabGroup;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TestEditorSplitter {
    private final HashMap<String, TestEditorTabGroup> myTabGroups = new HashMap();
    private static final String Default = "Default";
    private String myActiveTabGroupName = "Default";

    public TestEditorSplitter() {
        this.myTabGroups.put(Default, new TestEditorTabGroup(Default));
        this.myActiveTabGroupName = Default;
    }

    private TestEditorTabGroup getActiveTabGroup() {
        return this.myTabGroups.get(this.myActiveTabGroupName);
    }

    public void openAndFocusTab(VirtualFile virtualFile2, FileEditor fileEditor, FileEditorProvider provider2) {
        this.getActiveTabGroup().openTab(virtualFile2, fileEditor, provider2);
    }

    public void setActiveTabGroup(@NotNull String tabGroup) {
        TestEditorTabGroup result2;
        if (tabGroup == null) {
            TestEditorSplitter.$$$reportNull$$$0(0);
        }
        if ((result2 = this.myTabGroups.get(tabGroup)) == null) {
            result2 = new TestEditorTabGroup(tabGroup);
            this.myTabGroups.put(tabGroup, result2);
        }
        this.myActiveTabGroupName = tabGroup;
    }

    @Nullable
    public FileEditor getFocusedFileEditor() {
        Pair<FileEditor, FileEditorProvider> openedEditor = this.getActiveTabGroup().getOpenedEditor();
        if (openedEditor == null) {
            return null;
        }
        return (FileEditor)openedEditor.first;
    }

    @Nullable
    public FileEditorProvider getProviderFromFocused() {
        Pair<FileEditor, FileEditorProvider> openedEditor = this.getActiveTabGroup().getOpenedEditor();
        if (openedEditor == null) {
            return null;
        }
        return (FileEditorProvider)openedEditor.second;
    }

    public VirtualFile getFocusedFile() {
        return this.getActiveTabGroup().getOpenedFile();
    }

    public void setFocusedFile(VirtualFile file2) {
        for (TestEditorTabGroup group2 : this.myTabGroups.values()) {
            if (!group2.contains(file2)) continue;
            this.setActiveTabGroup(group2.getName());
            group2.setOpenedFile(file2);
            break;
        }
    }

    public void closeFile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            TestEditorSplitter.$$$reportNull$$$0(1);
        }
        TestEditorTabGroup testEditorTabGroup = this.getActiveTabGroup();
        String key = this.myActiveTabGroupName;
        if (!testEditorTabGroup.contains(file2)) {
            for (Map.Entry<String, TestEditorTabGroup> next : this.myTabGroups.entrySet()) {
                key = next.getKey();
                TestEditorTabGroup value2 = next.getValue();
                if (!value2.contains(file2)) continue;
                testEditorTabGroup = value2;
                break;
            }
        }
        testEditorTabGroup.closeTab(file2);
        if (!Objects.equals(key, Default) && testEditorTabGroup.getTabCount() == 0) {
            this.myTabGroups.remove(key);
        }
    }

    @Nullable
    public Pair<FileEditor, FileEditorProvider> getEditorAndProvider(VirtualFile file2) {
        return this.getActiveTabGroup().getEditorAndProvider(file2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tabGroup";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/fileEditor/impl/TestEditorSplitter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "setActiveTabGroup";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "closeFile";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

