/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl.text;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.BackgroundableDataProvider;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.EditorKind;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.EditorMarkupModel;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.impl.text.EditorHighlighterUpdater;
import com.intellij.openapi.fileEditor.impl.text.FileDropHandler;
import com.intellij.openapi.fileEditor.impl.text.TextEditorImpl;
import com.intellij.openapi.fileEditor.impl.text.TextEditorProvider;
import com.intellij.openapi.fileTypes.FileTypeEvent;
import com.intellij.openapi.fileTypes.FileTypeListener;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.util.ui.JBSwingUtilities;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class TextEditorComponent
extends JBLoadingPanel
implements DataProvider,
Disposable,
BackgroundableDataProvider {
    private static final Logger LOG = Logger.getInstance(TextEditorComponent.class);
    private final Project myProject;
    @NotNull
    private final VirtualFile myFile;
    private final TextEditorImpl myTextEditor;
    private final Document myDocument;
    @NotNull
    private final Editor myEditor;
    private boolean myModified;
    private boolean myValid;
    private final EditorHighlighterUpdater myEditorHighlighterUpdater;
    private volatile boolean myDisposed;

    TextEditorComponent(@NotNull Project project, @NotNull VirtualFile file2, @NotNull TextEditorImpl textEditor) {
        if (project == null) {
            TextEditorComponent.$$$reportNull$$$0(0);
        }
        if (file2 == null) {
            TextEditorComponent.$$$reportNull$$$0(1);
        }
        if (textEditor == null) {
            TextEditorComponent.$$$reportNull$$$0(2);
        }
        super((LayoutManager)new BorderLayout(), (Disposable)textEditor);
        this.myProject = project;
        this.myFile = file2;
        this.myTextEditor = textEditor;
        this.myDocument = FileDocumentManager.getInstance().getDocument(this.myFile);
        LOG.assertTrue(this.myDocument != null);
        this.myDocument.addDocumentListener((DocumentListener)new MyDocumentListener(), (Disposable)this);
        this.myEditor = this.createEditor();
        this.myEditor.getComponent().setFocusable(false);
        this.add(this.myEditor.getComponent(), "Center");
        this.myModified = this.isModifiedImpl();
        this.myValid = this.isEditorValidImpl();
        LOG.assertTrue(this.myValid);
        MyVirtualFileListener myVirtualFileListener = new MyVirtualFileListener();
        this.myFile.getFileSystem().addVirtualFileListener((VirtualFileListener)myVirtualFileListener);
        Disposer.register((Disposable)this, () -> this.myFile.getFileSystem().removeVirtualFileListener((VirtualFileListener)myVirtualFileListener));
        this.myEditorHighlighterUpdater = new EditorHighlighterUpdater(this.myProject, this, (EditorEx)this.myEditor, this.myFile);
        project.getMessageBus().connect((Disposable)this).subscribe(FileTypeManager.TOPIC, (Object)new MyFileTypeListener());
    }

    public void dispose() {
        this.disposeEditor();
        this.myDisposed = true;
    }

    public boolean isDisposed() {
        return this.myDisposed;
    }

    public void loadingFinished() {
        if (this.isLoading()) {
            this.stopLoading();
        }
        this.getContentPanel().setVisible(true);
    }

    private static void assertThread() {
        ApplicationManager.getApplication().assertIsDispatchThread();
    }

    @NotNull
    Editor getEditor() {
        Editor editor = this.myEditor;
        if (editor == null) {
            TextEditorComponent.$$$reportNull$$$0(3);
        }
        return editor;
    }

    @NotNull
    private Editor createEditor() {
        Editor editor = EditorFactory.getInstance().createEditor(this.myDocument, this.myProject, EditorKind.MAIN_EDITOR);
        ((EditorMarkupModel)editor.getMarkupModel()).setErrorStripeVisible(true);
        ((EditorEx)editor).getGutterComponentEx().setForceShowRightFreePaintersArea(true);
        ((EditorEx)editor).setFile(this.myFile);
        ((EditorEx)editor).setContextMenuGroupId("EditorPopupMenu");
        ((EditorImpl)editor).setDropHandler(new FileDropHandler(editor));
        TextEditorProvider.putTextEditor(editor, this.myTextEditor);
        Editor editor2 = editor;
        if (editor2 == null) {
            TextEditorComponent.$$$reportNull$$$0(4);
        }
        return editor2;
    }

    private void disposeEditor() {
        EditorFactory.getInstance().releaseEditor(this.myEditor);
    }

    boolean isModified() {
        TextEditorComponent.assertThread();
        return this.myModified;
    }

    private boolean isModifiedImpl() {
        return FileDocumentManager.getInstance().isFileModified(this.myFile);
    }

    void updateModifiedProperty() {
        Boolean oldModified = this.myModified;
        this.myModified = this.isModifiedImpl();
        this.myTextEditor.firePropertyChange("modified", oldModified, this.myModified);
    }

    boolean isEditorValid() {
        return this.myValid && !this.myEditor.isDisposed();
    }

    private boolean isEditorValidImpl() {
        return FileDocumentManager.getInstance().getDocument(this.myFile) != null;
    }

    private void updateValidProperty() {
        Boolean oldValid = this.myValid;
        this.myValid = this.isEditorValidImpl();
        this.myTextEditor.firePropertyChange("valid", oldValid, this.myValid);
    }

    @Nullable
    private Editor validateCurrentEditor() {
        JComponent jComponent;
        Component focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        if (focusOwner instanceof JComponent && (jComponent = (JComponent)focusOwner).getClientProperty("AuxEditorComponent") != null) {
            return null;
        }
        return this.myEditor;
    }

    @Nullable
    public DataProvider createBackgroundDataProvider() {
        Editor e = this.validateCurrentEditor();
        if (e == null || e.isDisposed()) {
            return null;
        }
        FileEditorManager fileEditorManager = !this.myProject.isDisposed() && !this.myProject.isDefault() ? FileEditorManager.getInstance((Project)this.myProject) : null;
        Caret currentCaret = e.getCaretModel().getCurrentCaret();
        return dataId -> {
            Object o;
            if (fileEditorManager != null && (o = fileEditorManager.getData(dataId, e, currentCaret)) != null) {
                return o;
            }
            if (CommonDataKeys.EDITOR.is(dataId)) {
                return e;
            }
            if (CommonDataKeys.VIRTUAL_FILE.is(dataId)) {
                return this.myFile.isValid() ? this.myFile : null;
            }
            return null;
        };
    }

    @NotNull
    public VirtualFile getFile() {
        VirtualFile virtualFile2 = this.myFile;
        if (virtualFile2 == null) {
            TextEditorComponent.$$$reportNull$$$0(5);
        }
        return virtualFile2;
    }

    public Color getBackground() {
        return this.myEditor == null ? super.getBackground() : this.myEditor.getContentComponent().getBackground();
    }

    protected Graphics getComponentGraphics(Graphics g) {
        return JBSwingUtilities.runGlobalCGTransform((JComponent)((Object)this), (Graphics)super.getComponentGraphics(g));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textEditor";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/fileEditor/impl/text/TextEditorComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/fileEditor/impl/text/TextEditorComponent";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditor";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private final class MyVirtualFileListener
    implements VirtualFileListener {
        private MyVirtualFileListener() {
        }

        public void propertyChanged(@NotNull VirtualFilePropertyEvent e) {
            if (e == null) {
                MyVirtualFileListener.$$$reportNull$$$0(0);
            }
            if ("name".equals(e.getPropertyName())) {
                TextEditorComponent.this.updateValidProperty();
                if (Comparing.equal((Object)e.getFile(), (Object)TextEditorComponent.this.myFile) && ("FileContentUtilCore.saveOrReload".equals(e.getRequestor()) || !Comparing.equal((Object)e.getOldValue(), (Object)e.getNewValue()))) {
                    TextEditorComponent.this.myEditorHighlighterUpdater.updateHighlighters();
                }
            }
        }

        public void contentsChanged(@NotNull VirtualFileEvent event) {
            if (event == null) {
                MyVirtualFileListener.$$$reportNull$$$0(1);
            }
            if (event.isFromSave()) {
                TextEditorComponent.assertThread();
                VirtualFile file2 = event.getFile();
                LOG.assertTrue(file2.isValid());
                if (TextEditorComponent.this.myFile.equals(file2)) {
                    TextEditorComponent.this.updateModifiedProperty();
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/fileEditor/impl/text/TextEditorComponent$MyVirtualFileListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "propertyChanged";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "contentsChanged";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private final class MyFileTypeListener
    implements FileTypeListener {
        private MyFileTypeListener() {
        }

        public void fileTypesChanged(@NotNull FileTypeEvent event) {
            if (event == null) {
                MyFileTypeListener.$$$reportNull$$$0(0);
            }
            TextEditorComponent.assertThread();
            TextEditorComponent.this.updateValidProperty();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/fileEditor/impl/text/TextEditorComponent$MyFileTypeListener", "fileTypesChanged"));
        }
    }

    private final class MyDocumentListener
    implements DocumentListener {
        private final Runnable myUpdateRunnable = () -> {
            this.myUpdateScheduled = false;
            TextEditorComponent.this.updateModifiedProperty();
        };
        private boolean myUpdateScheduled;

        MyDocumentListener() {
        }

        public void documentChanged(@NotNull DocumentEvent e) {
            if (e == null) {
                MyDocumentListener.$$$reportNull$$$0(0);
            }
            if (!this.myUpdateScheduled) {
                ApplicationManager.getApplication().invokeLater(this.myUpdateRunnable);
                this.myUpdateScheduled = true;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/fileEditor/impl/text/TextEditorComponent$MyDocumentListener", "documentChanged"));
        }
    }
}

