/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl.text;

import com.intellij.codeHighlighting.BackgroundEditorHighlighter;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.CaretState;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.fileEditor.DocumentsEditor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorLocation;
import com.intellij.openapi.fileEditor.FileEditorPolicy;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.FileEditorStateLevel;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.impl.DefaultPlatformFileEditorProvider;
import com.intellij.openapi.fileEditor.impl.text.AsyncEditorLoader;
import com.intellij.openapi.fileEditor.impl.text.QuickDefinitionProvider;
import com.intellij.openapi.fileEditor.impl.text.TextEditorImpl;
import com.intellij.openapi.fileEditor.impl.text.TextEditorState;
import com.intellij.openapi.fileTypes.BinaryFileTypeDecompilers;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.SingleRootFileViewProvider;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.swing.JComponent;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TextEditorProvider
implements DefaultPlatformFileEditorProvider,
QuickDefinitionProvider,
DumbAware {
    protected static final Logger LOG = Logger.getInstance(TextEditorProvider.class);
    private static final Key<TextEditor> TEXT_EDITOR_KEY = Key.create((String)"textEditor");
    @NonNls
    private static final String TYPE_ID = "text-editor";
    @NonNls
    private static final String LINE_ATTR = "line";
    @NonNls
    private static final String COLUMN_ATTR = "column";
    @NonNls
    private static final String LEAN_FORWARD_ATTR = "lean-forward";
    @NonNls
    private static final String SELECTION_START_LINE_ATTR = "selection-start-line";
    @NonNls
    private static final String SELECTION_START_COLUMN_ATTR = "selection-start-column";
    @NonNls
    private static final String SELECTION_END_LINE_ATTR = "selection-end-line";
    @NonNls
    private static final String SELECTION_END_COLUMN_ATTR = "selection-end-column";
    @NonNls
    private static final String RELATIVE_CARET_POSITION_ATTR = "relative-caret-position";
    @NonNls
    private static final String CARET_ELEMENT = "caret";

    @NotNull
    public static TextEditorProvider getInstance() {
        TextEditorProvider textEditorProvider = Objects.requireNonNull((TextEditorProvider)FileEditorProvider.EP_FILE_EDITOR_PROVIDER.findFirstAssignableExtension(TextEditorProvider.class));
        if (textEditorProvider == null) {
            TextEditorProvider.$$$reportNull$$$0(0);
        }
        return textEditorProvider;
    }

    public boolean accept(@NotNull Project project, @NotNull VirtualFile file2) {
        if (project == null) {
            TextEditorProvider.$$$reportNull$$$0(1);
        }
        if (file2 == null) {
            TextEditorProvider.$$$reportNull$$$0(2);
        }
        return TextEditorProvider.isTextFile(file2) && !SingleRootFileViewProvider.isTooLargeForContentLoading(file2);
    }

    @NotNull
    public FileEditor createEditor(@NotNull Project project, @NotNull VirtualFile file2) {
        if (project == null) {
            TextEditorProvider.$$$reportNull$$$0(3);
        }
        if (file2 == null) {
            TextEditorProvider.$$$reportNull$$$0(4);
        }
        LOG.assertTrue(this.accept(project, file2));
        return new TextEditorImpl(project, file2, this);
    }

    @NotNull
    public FileEditorState readState(@NotNull Element element2, @NotNull Project project, @NotNull VirtualFile file2) {
        if (element2 == null) {
            TextEditorProvider.$$$reportNull$$$0(5);
        }
        if (project == null) {
            TextEditorProvider.$$$reportNull$$$0(6);
        }
        if (file2 == null) {
            TextEditorProvider.$$$reportNull$$$0(7);
        }
        TextEditorState state = new TextEditorState();
        if (JDOMUtil.isEmpty((Element)element2)) {
            TextEditorState textEditorState = state;
            if (textEditorState == null) {
                TextEditorProvider.$$$reportNull$$$0(8);
            }
            return textEditorState;
        }
        List caretElements = element2.getChildren(CARET_ELEMENT);
        if (caretElements.isEmpty()) {
            state.CARETS = new TextEditorState.CaretState[]{TextEditorProvider.readCaretInfo(element2)};
        } else {
            state.CARETS = new TextEditorState.CaretState[caretElements.size()];
            for (int i2 = 0; i2 < caretElements.size(); ++i2) {
                state.CARETS[i2] = TextEditorProvider.readCaretInfo((Element)caretElements.get(i2));
            }
        }
        state.RELATIVE_CARET_POSITION = StringUtilRt.parseInt((String)element2.getAttributeValue(RELATIVE_CARET_POSITION_ATTR), (int)0);
        TextEditorState textEditorState = state;
        if (textEditorState == null) {
            TextEditorProvider.$$$reportNull$$$0(9);
        }
        return textEditorState;
    }

    @NotNull
    private static TextEditorState.CaretState readCaretInfo(@NotNull Element element2) {
        if (element2 == null) {
            TextEditorProvider.$$$reportNull$$$0(10);
        }
        TextEditorState.CaretState caretState = new TextEditorState.CaretState();
        caretState.LINE = TextEditorProvider.parseWithDefault(element2, LINE_ATTR);
        caretState.COLUMN = TextEditorProvider.parseWithDefault(element2, COLUMN_ATTR);
        caretState.LEAN_FORWARD = Boolean.parseBoolean(element2.getAttributeValue(LEAN_FORWARD_ATTR));
        caretState.SELECTION_START_LINE = TextEditorProvider.parseWithDefault(element2, SELECTION_START_LINE_ATTR);
        caretState.SELECTION_START_COLUMN = TextEditorProvider.parseWithDefault(element2, SELECTION_START_COLUMN_ATTR);
        caretState.SELECTION_END_LINE = TextEditorProvider.parseWithDefault(element2, SELECTION_END_LINE_ATTR);
        caretState.SELECTION_END_COLUMN = TextEditorProvider.parseWithDefault(element2, SELECTION_END_COLUMN_ATTR);
        TextEditorState.CaretState caretState2 = caretState;
        if (caretState2 == null) {
            TextEditorProvider.$$$reportNull$$$0(11);
        }
        return caretState2;
    }

    private static int parseWithDefault(@NotNull Element element2, @NotNull String attributeName) {
        if (element2 == null) {
            TextEditorProvider.$$$reportNull$$$0(12);
        }
        if (attributeName == null) {
            TextEditorProvider.$$$reportNull$$$0(13);
        }
        return StringUtilRt.parseInt((String)element2.getAttributeValue(attributeName), (int)0);
    }

    public void writeState(@NotNull FileEditorState _state, @NotNull Project project, @NotNull Element element2) {
        if (_state == null) {
            TextEditorProvider.$$$reportNull$$$0(14);
        }
        if (project == null) {
            TextEditorProvider.$$$reportNull$$$0(15);
        }
        if (element2 == null) {
            TextEditorProvider.$$$reportNull$$$0(16);
        }
        TextEditorState state = (TextEditorState)_state;
        if (state.RELATIVE_CARET_POSITION != 0) {
            element2.setAttribute(RELATIVE_CARET_POSITION_ATTR, Integer.toString(state.RELATIVE_CARET_POSITION));
        }
        for (TextEditorState.CaretState caretState : state.CARETS) {
            Element e = new Element(CARET_ELEMENT);
            TextEditorProvider.writeIfNot0(e, LINE_ATTR, caretState.LINE);
            TextEditorProvider.writeIfNot0(e, COLUMN_ATTR, caretState.COLUMN);
            if (caretState.LEAN_FORWARD) {
                e.setAttribute(LEAN_FORWARD_ATTR, Boolean.toString(true));
            }
            TextEditorProvider.writeIfNot0(e, SELECTION_START_LINE_ATTR, caretState.SELECTION_START_LINE);
            TextEditorProvider.writeIfNot0(e, SELECTION_START_COLUMN_ATTR, caretState.SELECTION_START_COLUMN);
            TextEditorProvider.writeIfNot0(e, SELECTION_END_LINE_ATTR, caretState.SELECTION_END_LINE);
            TextEditorProvider.writeIfNot0(e, SELECTION_END_LINE_ATTR, caretState.SELECTION_END_LINE);
            TextEditorProvider.writeIfNot0(e, SELECTION_END_COLUMN_ATTR, caretState.SELECTION_END_COLUMN);
            if (JDOMUtil.isEmpty((Element)e)) continue;
            element2.addContent(e);
        }
    }

    private static void writeIfNot0(@NotNull Element element2, @NotNull String name, int value2) {
        if (element2 == null) {
            TextEditorProvider.$$$reportNull$$$0(17);
        }
        if (name == null) {
            TextEditorProvider.$$$reportNull$$$0(18);
        }
        if (value2 != 0) {
            element2.setAttribute(name, Integer.toString(value2));
        }
    }

    @NotNull
    public String getEditorTypeId() {
        return TYPE_ID;
    }

    @NotNull
    public FileEditorPolicy getPolicy() {
        FileEditorPolicy fileEditorPolicy = FileEditorPolicy.NONE;
        if (fileEditorPolicy == null) {
            TextEditorProvider.$$$reportNull$$$0(19);
        }
        return fileEditorPolicy;
    }

    @NotNull
    public TextEditor getTextEditor(@NotNull Editor editor) {
        TextEditor textEditor;
        if (editor == null) {
            TextEditorProvider.$$$reportNull$$$0(20);
        }
        if ((textEditor = (TextEditor)editor.getUserData(TEXT_EDITOR_KEY)) == null) {
            textEditor = this.createWrapperForEditor(editor);
            TextEditorProvider.putTextEditor(editor, textEditor);
        }
        TextEditor textEditor2 = textEditor;
        if (textEditor2 == null) {
            TextEditorProvider.$$$reportNull$$$0(21);
        }
        return textEditor2;
    }

    @NotNull
    protected EditorWrapper createWrapperForEditor(@NotNull Editor editor) {
        if (editor == null) {
            TextEditorProvider.$$$reportNull$$$0(22);
        }
        return new EditorWrapper(editor);
    }

    public static Document @NotNull [] getDocuments(@NotNull FileEditor editor) {
        Document document;
        if (editor == null) {
            TextEditorProvider.$$$reportNull$$$0(23);
        }
        if (editor instanceof DocumentsEditor) {
            DocumentsEditor documentsEditor = (DocumentsEditor)editor;
            Document[] documentArray = documentsEditor.getDocuments();
            if (documentArray == null) {
                TextEditorProvider.$$$reportNull$$$0(24);
            }
            return documentArray;
        }
        if (editor instanceof TextEditor) {
            Document document2 = ((TextEditor)editor).getEditor().getDocument();
            Document[] documentArray = new Document[]{document2};
            if (documentArray == null) {
                TextEditorProvider.$$$reportNull$$$0(25);
            }
            return documentArray;
        }
        VirtualFile file2 = editor.getFile();
        if (file2 != null && (document = FileDocumentManager.getInstance().getDocument(file2)) != null) {
            Document[] documentArray = new Document[]{document};
            if (documentArray == null) {
                TextEditorProvider.$$$reportNull$$$0(26);
            }
            return documentArray;
        }
        if (Document.EMPTY_ARRAY == null) {
            TextEditorProvider.$$$reportNull$$$0(27);
        }
        return Document.EMPTY_ARRAY;
    }

    @ApiStatus.Internal
    public static void putTextEditor(@NotNull Editor editor, @NotNull TextEditor textEditor) {
        if (editor == null) {
            TextEditorProvider.$$$reportNull$$$0(28);
        }
        if (textEditor == null) {
            TextEditorProvider.$$$reportNull$$$0(29);
        }
        editor.putUserData(TEXT_EDITOR_KEY, (Object)textEditor);
    }

    @NotNull
    protected TextEditorState getStateImpl(Project project, @NotNull Editor editor, @NotNull FileEditorStateLevel level) {
        if (editor == null) {
            TextEditorProvider.$$$reportNull$$$0(30);
        }
        if (level == null) {
            TextEditorProvider.$$$reportNull$$$0(31);
        }
        TextEditorState state = new TextEditorState();
        CaretModel caretModel = editor.getCaretModel();
        List caretsAndSelections = caretModel.getCaretsAndSelections();
        state.CARETS = new TextEditorState.CaretState[caretsAndSelections.size()];
        for (int i2 = 0; i2 < caretsAndSelections.size(); ++i2) {
            CaretState caretState = (CaretState)caretsAndSelections.get(i2);
            LogicalPosition caretPosition = caretState.getCaretPosition();
            LogicalPosition selectionStartPosition = caretState.getSelectionStart();
            LogicalPosition selectionEndPosition = caretState.getSelectionEnd();
            TextEditorState.CaretState s = new TextEditorState.CaretState();
            s.LINE = TextEditorProvider.getLine(caretPosition);
            s.COLUMN = TextEditorProvider.getColumn(caretPosition);
            s.LEAN_FORWARD = caretPosition != null && caretPosition.leansForward;
            s.VISUAL_COLUMN_ADJUSTMENT = caretState.getVisualColumnAdjustment();
            s.SELECTION_START_LINE = TextEditorProvider.getLine(selectionStartPosition);
            s.SELECTION_START_COLUMN = TextEditorProvider.getColumn(selectionStartPosition);
            s.SELECTION_END_LINE = TextEditorProvider.getLine(selectionEndPosition);
            s.SELECTION_END_COLUMN = TextEditorProvider.getColumn(selectionEndPosition);
            state.CARETS[i2] = s;
        }
        state.RELATIVE_CARET_POSITION = level == FileEditorStateLevel.UNDO ? Integer.MAX_VALUE : EditorUtil.calcRelativeCaretPosition(editor);
        TextEditorState textEditorState = state;
        if (textEditorState == null) {
            TextEditorProvider.$$$reportNull$$$0(32);
        }
        return textEditorState;
    }

    public static boolean isTextFile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            TextEditorProvider.$$$reportNull$$$0(33);
        }
        if (file2.isDirectory() || !file2.isValid()) {
            return false;
        }
        FileType ft = file2.getFileType();
        return !ft.isBinary() || BinaryFileTypeDecompilers.getInstance().forFileType(ft) != null;
    }

    private static int getLine(@Nullable LogicalPosition pos) {
        return pos == null ? 0 : pos.line;
    }

    private static int getColumn(@Nullable LogicalPosition pos) {
        return pos == null ? 0 : pos.column;
    }

    protected void setStateImpl(Project project, Editor editor, TextEditorState state, boolean exactState) {
        TextEditorState.CaretState[] carets = state.CARETS;
        if (carets.length > 0) {
            ArrayList<CaretState> states = new ArrayList<CaretState>(carets.length);
            for (TextEditorState.CaretState caretState : carets) {
                states.add(new CaretState(new LogicalPosition(caretState.LINE, caretState.COLUMN, caretState.LEAN_FORWARD), caretState.VISUAL_COLUMN_ADJUSTMENT, new LogicalPosition(caretState.SELECTION_START_LINE, caretState.SELECTION_START_COLUMN), new LogicalPosition(caretState.SELECTION_END_LINE, caretState.SELECTION_END_COLUMN)));
            }
            editor.getCaretModel().setCaretsAndSelections(states, false);
        }
        int relativeCaretPosition = state.RELATIVE_CARET_POSITION;
        Runnable scrollingRunnable = () -> {
            if (!editor.isDisposed()) {
                editor.getScrollingModel().disableAnimation();
                if (relativeCaretPosition != Integer.MAX_VALUE) {
                    EditorUtil.setRelativeCaretPosition(editor, relativeCaretPosition);
                }
                if (!exactState) {
                    editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
                }
                editor.getScrollingModel().enableAnimation();
            }
        };
        AsyncEditorLoader.performWhenLoaded(editor, () -> {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                scrollingRunnable.run();
            } else {
                UiNotifyConnector.doWhenFirstShown((JComponent)editor.getContentComponent(), (Runnable)scrollingRunnable);
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 22: 
            case 23: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 33: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 22: 
            case 23: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 33: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/fileEditor/impl/text/TextEditorProvider";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: 
            case 10: 
            case 12: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributeName";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "_state";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 20: 
            case 22: 
            case 23: 
            case 28: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textEditor";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "level";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 22: 
            case 23: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/fileEditor/impl/text/TextEditorProvider";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "readState";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "readCaretInfo";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getPolicy";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextEditor";
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getDocuments";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getStateImpl";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createEditor";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "readState";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "readCaretInfo";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "parseWithDefault";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "writeState";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "writeIfNot0";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getTextEditor";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "createWrapperForEditor";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getDocuments";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "putTextEditor";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getStateImpl";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "isTextFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 22: 
            case 23: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 33: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected class EditorWrapper
    extends UserDataHolderBase
    implements TextEditor {
        private final Editor myEditor;

        EditorWrapper(Editor editor) {
            if (editor == null) {
                EditorWrapper.$$$reportNull$$$0(0);
            }
            this.myEditor = editor;
        }

        @NotNull
        public Editor getEditor() {
            Editor editor = this.myEditor;
            if (editor == null) {
                EditorWrapper.$$$reportNull$$$0(1);
            }
            return editor;
        }

        @NotNull
        public JComponent getComponent() {
            JComponent jComponent = this.myEditor.getComponent();
            if (jComponent == null) {
                EditorWrapper.$$$reportNull$$$0(2);
            }
            return jComponent;
        }

        public JComponent getPreferredFocusedComponent() {
            return this.myEditor.getContentComponent();
        }

        @NotNull
        public String getName() {
            String string = IdeBundle.message((String)"tab.title.text", (Object[])new Object[0]);
            if (string == null) {
                EditorWrapper.$$$reportNull$$$0(3);
            }
            return string;
        }

        public StructureViewBuilder getStructureViewBuilder() {
            VirtualFile file2 = this.getFile();
            if (file2 == null) {
                return null;
            }
            Project project = this.myEditor.getProject();
            if (project == null) {
                return null;
            }
            return StructureViewBuilder.PROVIDER.getStructureViewBuilder(file2.getFileType(), file2, project);
        }

        @NotNull
        public FileEditorState getState(@NotNull FileEditorStateLevel level) {
            if (level == null) {
                EditorWrapper.$$$reportNull$$$0(4);
            }
            TextEditorState textEditorState = TextEditorProvider.this.getStateImpl(null, this.myEditor, level);
            if (textEditorState == null) {
                EditorWrapper.$$$reportNull$$$0(5);
            }
            return textEditorState;
        }

        public void setState(@NotNull FileEditorState state) {
            if (state == null) {
                EditorWrapper.$$$reportNull$$$0(6);
            }
            this.setState(state, false);
        }

        public void setState(@NotNull FileEditorState state, boolean exactState) {
            if (state == null) {
                EditorWrapper.$$$reportNull$$$0(7);
            }
            TextEditorProvider.this.setStateImpl(null, this.myEditor, (TextEditorState)state, exactState);
        }

        public boolean isModified() {
            return false;
        }

        public boolean isValid() {
            return true;
        }

        public void dispose() {
        }

        public void selectNotify() {
        }

        public void deselectNotify() {
        }

        public void addPropertyChangeListener(@NotNull PropertyChangeListener listener2) {
            if (listener2 == null) {
                EditorWrapper.$$$reportNull$$$0(8);
            }
        }

        public void removePropertyChangeListener(@NotNull PropertyChangeListener listener2) {
            if (listener2 == null) {
                EditorWrapper.$$$reportNull$$$0(9);
            }
        }

        public BackgroundEditorHighlighter getBackgroundHighlighter() {
            return null;
        }

        public FileEditorLocation getCurrentLocation() {
            return null;
        }

        public boolean canNavigateTo(@NotNull Navigatable navigatable) {
            if (navigatable == null) {
                EditorWrapper.$$$reportNull$$$0(10);
            }
            return false;
        }

        public void navigateTo(@NotNull Navigatable navigatable) {
            if (navigatable == null) {
                EditorWrapper.$$$reportNull$$$0(11);
            }
        }

        @Nullable
        public VirtualFile getFile() {
            return FileDocumentManager.getInstance().getFile(this.myEditor.getDocument());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/fileEditor/impl/text/TextEditorProvider$EditorWrapper";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "level";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "state";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "listener";
                    break;
                }
                case 10: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "navigatable";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/fileEditor/impl/text/TextEditorProvider$EditorWrapper";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getEditor";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getComponent";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getState";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 5: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getState";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "setState";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "addPropertyChangeListener";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "removePropertyChangeListener";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "canNavigateTo";
                    break;
                }
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "navigateTo";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

