/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.keymap.impl.ui;

import com.intellij.ide.IdeBundle;
import com.intellij.openapi.actionSystem.ex.QuickList;
import com.intellij.openapi.actionSystem.ex.QuickListsManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.keymap.KeyMapBundle;
import com.intellij.openapi.keymap.impl.ui.KeymapListener;
import com.intellij.openapi.keymap.impl.ui.QuickListPanel;
import com.intellij.openapi.options.ConfigurableUi;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.ui.Splitter;
import com.intellij.ui.DocumentAdapter;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.ListItemEditor;
import com.intellij.util.ui.ListModelEditor;
import java.awt.CardLayout;
import java.awt.Component;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NotNull;

final class QuickListsUi
implements ConfigurableUi<List<QuickList>> {
    public static final String EMPTY = "empty";
    public static final String PANEL = "panel";
    private final KeymapListener keymapListener;
    private final ListItemEditor<QuickList> itemEditor = new ListItemEditor<QuickList>(){

        @Override
        @NotNull
        public Class<QuickList> getItemClass() {
            return QuickList.class;
        }

        @Override
        public QuickList clone(@NotNull QuickList item, boolean forInPlaceEditing) {
            if (item == null) {
                1.$$$reportNull$$$0(0);
            }
            return new QuickList(item.getName(), item.getDescription(), item.getActionIds());
        }

        @Override
        public boolean isEmpty(@NotNull QuickList item) {
            if (item == null) {
                1.$$$reportNull$$$0(1);
            }
            return item.getName().isEmpty() && item.getDescription() == null && item.getActionIds().length == 0;
        }

        @Override
        @NotNull
        public String getName(@NotNull QuickList item) {
            if (item == null) {
                1.$$$reportNull$$$0(2);
            }
            String string = item.getDisplayName();
            if (string == null) {
                1.$$$reportNull$$$0(3);
            }
            return string;
        }

        @Override
        public boolean isRemovable(@NotNull QuickList item) {
            if (item == null) {
                1.$$$reportNull$$$0(4);
            }
            return QuickListsManager.getInstance().getSchemeManager().isMetadataEditable(item);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "item";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/keymap/impl/ui/QuickListsUi$1";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/keymap/impl/ui/QuickListsUi$1";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "clone";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "isEmpty";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getName";
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "isRemovable";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    };
    private final ListModelEditor<QuickList> editor = new ListModelEditor<QuickList>(this.itemEditor);
    private final JComponent component;
    private final QuickListPanel itemPanel;
    private final JPanel itemPanelWrapper;

    QuickListsUi() {
        this.keymapListener = (KeymapListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(KeymapListener.CHANGE_TOPIC);
        final CardLayout cardLayout = new CardLayout();
        this.editor.disableUpDownActions();
        this.editor.getList().setEmptyText(KeyMapBundle.message((String)"no.quick.lists", (Object[])new Object[0]));
        this.editor.getList().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                QuickList item = QuickListsUi.this.editor.getSelected();
                if (item == null) {
                    cardLayout.show(QuickListsUi.this.itemPanelWrapper, QuickListsUi.EMPTY);
                    QuickListsUi.this.itemPanel.setItem(null);
                } else {
                    cardLayout.show(QuickListsUi.this.itemPanelWrapper, QuickListsUi.PANEL);
                    QuickListsUi.this.itemPanel.setItem(QuickListsUi.this.editor.getMutable(item));
                }
            }
        });
        this.itemPanel = new QuickListPanel(this.editor.getModel());
        this.itemPanel.myName.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                QuickList item;
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                if ((item = QuickListsUi.this.itemPanel.item) != null) {
                    String name = QuickListsUi.this.itemPanel.myName.getText();
                    boolean changed2 = !item.getName().equals(name);
                    item.setName(name);
                    if (changed2) {
                        QuickListsUi.this.editor.getList().repaint();
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/keymap/impl/ui/QuickListsUi$3", "textChanged"));
            }
        });
        this.itemPanelWrapper = new JPanel(cardLayout);
        JLabel descLabel = new JLabel(IdeBundle.message((String)"quick.lists.description", (Object[])new Object[0]));
        descLabel.setBorder((Border)JBUI.Borders.empty((int)0, (int)25));
        this.itemPanelWrapper.add((Component)descLabel, EMPTY);
        this.itemPanelWrapper.add((Component)this.itemPanel.getPanel(), PANEL);
        Splitter splitter = new Splitter(false, 0.3f);
        splitter.setFirstComponent(this.editor.createComponent());
        splitter.setSecondComponent((JComponent)this.itemPanelWrapper);
        this.component = splitter;
    }

    public void reset(@NotNull List<QuickList> settings2) {
        if (settings2 == null) {
            QuickListsUi.$$$reportNull$$$0(0);
        }
        this.editor.reset(settings2);
    }

    public boolean isModified(@NotNull List<QuickList> settings2) {
        if (settings2 == null) {
            QuickListsUi.$$$reportNull$$$0(1);
        }
        this.itemPanel.apply();
        return this.editor.isModified();
    }

    public void apply(@NotNull List<QuickList> settings2) throws ConfigurationException {
        if (settings2 == null) {
            QuickListsUi.$$$reportNull$$$0(2);
        }
        this.itemPanel.apply();
        this.editor.ensureNonEmptyNames(IdeBundle.message((String)"quick.lists.not.empty.name", (Object[])new Object[0]));
        this.editor.processModifiedItems((newItem, oldItem) -> {
            if (!oldItem.getName().equals(newItem.getName())) {
                this.keymapListener.quickListRenamed((QuickList)oldItem, (QuickList)newItem);
            }
            return true;
        });
        if (this.isModified(settings2)) {
            List<QuickList> result2 = this.editor.apply();
            this.keymapListener.processCurrentKeymapChanged(result2.toArray(new QuickList[0]));
            QuickListsManager.getInstance().setQuickLists(result2);
        }
    }

    @NotNull
    public JComponent getComponent() {
        JComponent jComponent = this.component;
        if (jComponent == null) {
            QuickListsUi.$$$reportNull$$$0(3);
        }
        return jComponent;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/keymap/impl/ui/QuickListsUi";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/keymap/impl/ui/QuickListsUi";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "reset";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isModified";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "apply";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

