/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots.impl.jdkDownloader;

import com.intellij.execution.wsl.WSLDistribution;
import com.intellij.execution.wsl.WslDistributionManager;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkDownloadDialogKt;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkDownloaderMergedModel;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkDownloaderModel;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkInstaller;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkItem;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkVersionItem;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkVersionVendorCombobox;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkVersionVendorElement;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkVersionVendorItem;
import com.intellij.openapi.ui.BrowseFolderRunnable;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.components.ComponentsKt;
import com.intellij.ui.layout.CCFlags;
import com.intellij.ui.layout.Cell;
import com.intellij.ui.layout.LCFlags;
import com.intellij.ui.layout.LayoutBuilder;
import com.intellij.ui.layout.LayoutImplKt;
import com.intellij.ui.layout.LayoutKt;
import com.intellij.ui.layout.Row;
import com.intellij.ui.layout.RowBuilder;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B)\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010$\u001a\u00020\u0011H\u0014J\n\u0010%\u001a\u0004\u0018\u00010&H\u0014J\u0016\u0010'\u001a\b\u0012\u0004\u0012\u00020\u000f0(2\u0006\u0010)\u001a\u00020\u001eH\u0002J\u0010\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020\u000fH\u0002J\u0012\u0010-\u001a\u00020+2\b\u0010.\u001a\u0004\u0018\u00010/H\u0002J\u0012\u00100\u001a\u00020+2\b\u0010.\u001a\u0004\u0018\u00010/H\u0002J\u0012\u00101\u001a\u00020+2\b\u0010.\u001a\u0004\u0018\u00010#H\u0002J\u0014\u00102\u001a\u0010\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u000204\u0018\u000103J\u0010\u00105\u001a\u00020+2\u0006\u00106\u001a\u000207H\u0002J1\u00108\u001a\u00020+\"\u0006\b\u0000\u00109\u0018\u0001*\b\u0012\u0004\u0012\u0002H90\u000e2\u0014\b\u0004\u0010:\u001a\u000e\u0012\u0004\u0012\u0002H9\u0012\u0004\u0012\u00020+0;H\u0082\bJ#\u0010<\u001a\u00020+*\u00020\u00132\u0014\b\u0004\u0010:\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020+0;H\u0082\bR\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u000e\u0010\u001d\u001a\u00020\u001eX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u000fX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\"\u001a\b\u0012\u0004\u0012\u00020#0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006="}, d2={"Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkDownloadDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "project", "Lcom/intellij/openapi/project/Project;", "parentComponent", "Ljava/awt/Component;", "sdkType", "Lcom/intellij/openapi/projectRoots/SdkTypeId;", "mergedModel", "Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkDownloaderMergedModel;", "(Lcom/intellij/openapi/project/Project;Ljava/awt/Component;Lcom/intellij/openapi/projectRoots/SdkTypeId;Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkDownloaderMergedModel;)V", "currentModel", "Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkDownloaderModel;", "installDirCombo", "Lcom/intellij/openapi/ui/ComboBox;", "", "installDirComponent", "Ljavax/swing/JComponent;", "installDirTextField", "Lcom/intellij/openapi/ui/TextFieldWithBrowseButton;", "getMergedModel", "()Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkDownloaderMergedModel;", "panel", "getParentComponent", "()Ljava/awt/Component;", "getProject", "()Lcom/intellij/openapi/project/Project;", "getSdkType", "()Lcom/intellij/openapi/projectRoots/SdkTypeId;", "selectedItem", "Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkItem;", "selectedPath", "vendorComboBox", "Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkVersionVendorCombobox;", "versionComboBox", "Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkVersionItem;", "createCenterPanel", "doValidate", "Lcom/intellij/openapi/ui/ValidationInfo;", "getSuggestedInstallDirs", "", "newVersion", "onTargetPathChanged", "", "path", "onVendorActionItemSelected", "it", "Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkVersionVendorElement;", "onVendorSelectionChange", "onVersionSelectionChange", "selectJdkAndPath", "Lkotlin/Pair;", "Ljava/nio/file/Path;", "setModel", "forWsl", "", "onSelectionChange", "T", "action", "Lkotlin/Function1;", "onTextChange", "intellij.platform.lang.impl"})
public final class JdkDownloadDialog
extends DialogWrapper {
    private final JComponent panel;
    private final ComboBox<JdkVersionItem> versionComboBox;
    private final JdkVersionVendorCombobox vendorComboBox;
    private final TextFieldWithBrowseButton installDirTextField;
    private final ComboBox<String> installDirCombo;
    private final JComponent installDirComponent;
    private JdkDownloaderModel currentModel;
    private JdkItem selectedItem;
    private String selectedPath;
    @Nullable
    private final Project project;
    @Nullable
    private final Component parentComponent;
    @NotNull
    private final SdkTypeId sdkType;
    @NotNull
    private final JdkDownloaderMergedModel mergedModel;

    private final void setModel(boolean forWsl) {
        JdkVersionItem jdkVersionItem;
        JdkVersionVendorItem newVendorItem;
        JdkVersionVendorItem jdkVersionVendorItem;
        JdkVersionItem newVersionItem;
        JdkVersionItem jdkVersionItem2;
        JdkVersionVendorItem jdkVersionVendorItem2;
        JdkDownloaderModel model2 = this.mergedModel.selectModel(forWsl);
        if (this.currentModel == model2) {
            return;
        }
        Object object = this.versionComboBox.getSelectedItem();
        if (!(object instanceof JdkVersionItem)) {
            object = null;
        }
        JdkVersionItem prevSelectedVersion = (JdkVersionItem)object;
        Object object2 = this.vendorComboBox.getSelectedItem();
        if (!(object2 instanceof JdkVersionVendorItem)) {
            object2 = null;
        }
        JdkVersionVendorItem jdkVersionVendorItem3 = (JdkVersionVendorItem)object2;
        if (jdkVersionVendorItem3 != null) {
            JdkVersionVendorItem jdkVersionVendorItem4 = jdkVersionVendorItem3;
            boolean bl = false;
            boolean bl2 = false;
            JdkVersionVendorItem it = jdkVersionVendorItem4;
            boolean bl3 = false;
            jdkVersionVendorItem2 = it.getCanBeSelected() ? jdkVersionVendorItem4 : null;
        } else {
            jdkVersionVendorItem2 = null;
        }
        JdkVersionVendorItem prevSelectedJdk = jdkVersionVendorItem2;
        this.currentModel = model2;
        Collection $this$toTypedArray$iv = model2.getVersionGroups();
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        JdkVersionItem[] jdkVersionItemArray = thisCollection$iv.toArray(new JdkVersionItem[0]);
        if (jdkVersionItemArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        this.versionComboBox.setModel((ComboBoxModel)new DefaultComboBoxModel<JdkVersionItem>(jdkVersionItemArray));
        if (prevSelectedVersion != null) {
            Object v5;
            block16: {
                Iterable $this$singleOrNull$iv = model2.getVersionGroups();
                boolean $i$f$singleOrNull = false;
                Object single$iv = null;
                boolean found$iv = false;
                for (Object element$iv : $this$singleOrNull$iv) {
                    JdkVersionItem it = (JdkVersionItem)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getJdkVersion(), (Object)prevSelectedVersion.getJdkVersion())) continue;
                    if (found$iv) {
                        v5 = null;
                        break block16;
                    }
                    single$iv = element$iv;
                    found$iv = true;
                }
                v5 = !found$iv ? null : single$iv;
            }
            jdkVersionItem2 = v5;
        } else {
            jdkVersionItem2 = newVersionItem = null;
        }
        if (newVersionItem != null && prevSelectedJdk != null) {
            Object v7;
            block17: {
                Iterable $this$singleOrNull$iv = CollectionsKt.plus((Collection)newVersionItem.getIncludedItems(), (Iterable)newVersionItem.getExcludedItems());
                boolean $i$f$singleOrNull = false;
                Object single$iv = null;
                boolean found$iv = false;
                for (Object element$iv : $this$singleOrNull$iv) {
                    JdkVersionVendorItem it = (JdkVersionVendorItem)element$iv;
                    boolean bl = false;
                    if (!(it.getCanBeSelected() && Intrinsics.areEqual((Object)it.getItem().getSuggestedSdkName(), (Object)prevSelectedJdk.getItem().getSuggestedSdkName()))) continue;
                    if (found$iv) {
                        v7 = null;
                        break block17;
                    }
                    single$iv = element$iv;
                    found$iv = true;
                }
                v7 = !found$iv ? null : single$iv;
            }
            jdkVersionVendorItem = v7;
        } else {
            jdkVersionVendorItem = newVendorItem = null;
        }
        if ((jdkVersionItem = newVersionItem) == null) {
            jdkVersionItem = model2.getDefaultVersion();
        }
        this.onVersionSelectionChange(jdkVersionItem);
        JdkVersionVendorItem jdkVersionVendorItem5 = newVendorItem;
        if (jdkVersionVendorItem5 == null) {
            jdkVersionVendorItem5 = model2.getDefaultVersionVendor();
        }
        this.onVendorSelectionChange(jdkVersionVendorItem5);
    }

    private final void onTargetPathChanged(String path2) {
        String path3;
        String string = FileUtil.expandUserHome((String)path2);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"FileUtil.expandUserHome(path)");
        this.selectedPath = path3 = string;
        this.setModel(WslDistributionManager.isWslPath(path3));
    }

    private final void onVendorActionItemSelected(JdkVersionVendorElement it) {
        if (!(it instanceof JdkVersionVendorItem)) {
            return;
        }
        JdkVersionItem jdkVersionItem = ((JdkVersionVendorItem)it).getParent();
        if (jdkVersionItem == null) {
            return;
        }
        JdkVersionItem parent = jdkVersionItem;
        this.onVersionSelectionChange(parent);
        this.vendorComboBox.setSelectedItem(((JdkVersionVendorItem)it).getSelectItem());
    }

    private final void onVendorSelectionChange(JdkVersionVendorElement it) {
        if (!(it instanceof JdkVersionVendorItem) || !((JdkVersionVendorItem)it).getCanBeSelected()) {
            return;
        }
        this.vendorComboBox.setSelectedItem(((JdkVersionVendorItem)it).getSelectItem());
        JdkItem newVersion = ((JdkVersionVendorItem)it).getItem();
        String path2 = ((Object)JdkInstaller.Companion.getInstance().defaultInstallDir(newVersion, this.mergedModel.getProjectWSLDistribution())).toString();
        String relativePath = FileUtil.getLocationRelativeToUserHome((String)path2);
        if (this.installDirTextField != null) {
            this.installDirTextField.setText(relativePath);
        } else {
            ComboBox<String> comboBox2 = this.installDirCombo;
            Intrinsics.checkNotNull(comboBox2);
            comboBox2.setModel((ComboBoxModel)new CollectionComboBoxModel(this.getSuggestedInstallDirs(newVersion), (Object)relativePath));
        }
        this.selectedPath = path2;
        this.selectedItem = newVersion;
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> getSuggestedInstallDirs(JdkItem newVersion) {
        void $this$mapTo$iv$iv;
        String string;
        Collection collection;
        void $this$mapTo$iv;
        Iterable iterable = CollectionsKt.plus((Collection)CollectionsKt.listOf(null), (Iterable)this.mergedModel.getWslDistributions());
        Collection destination$iv = new LinkedHashSet();
        boolean $i$f$mapTo22 = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it;
            WSLDistribution wSLDistribution = (WSLDistribution)item$iv;
            collection = destination$iv;
            boolean bl = false;
            string = ((Object)JdkInstaller.Companion.getInstance().defaultInstallDir(newVersion, (WSLDistribution)it)).toString();
            collection.add(string);
        }
        Iterable $this$map$iv = destination$iv;
        boolean $i$f$map = false;
        Iterable $i$f$mapTo22 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string2 = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            string = FileUtil.getLocationRelativeToUserHome((String)it);
            collection.add(string);
        }
        return (List)destination$iv$iv;
    }

    private final void onVersionSelectionChange(JdkVersionItem it) {
        if (it == null) {
            return;
        }
        this.versionComboBox.setSelectedItem((Object)it);
        this.vendorComboBox.setModel(it.getModel());
    }

    @Nullable
    protected ValidationInfo doValidate() {
        ValidationInfo validationInfo;
        String error2;
        ValidationInfo validationInfo2 = super.doValidate();
        if (validationInfo2 != null) {
            ValidationInfo validationInfo3 = validationInfo2;
            boolean bl = false;
            boolean bl2 = false;
            ValidationInfo it = validationInfo3;
            boolean bl3 = false;
            return it;
        }
        JdkInstaller jdkInstaller = JdkInstaller.Companion.getInstance();
        String string = this.selectedPath;
        if (string == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"selectedPath");
        }
        Object object = jdkInstaller.validateInstallDir(string);
        String string2 = error2 = (String)object.component2();
        if (string2 != null) {
            object = string2;
            boolean bl = false;
            boolean bl4 = false;
            Object it = object;
            boolean bl5 = false;
            validationInfo = new ValidationInfo(error2, this.installDirComponent);
        } else {
            validationInfo = null;
        }
        return validationInfo;
    }

    @NotNull
    protected JComponent createCenterPanel() {
        return this.panel;
    }

    @Nullable
    public final Pair<JdkItem, Path> selectJdkAndPath() {
        Pair<Path, String> pair;
        Path selectedFile;
        if (!this.showAndGet()) {
            return null;
        }
        JdkInstaller jdkInstaller = JdkInstaller.Companion.getInstance();
        String string = this.selectedPath;
        if (string == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"selectedPath");
        }
        if ((selectedFile = (Path)(pair = jdkInstaller.validateInstallDir(string)).component1()) == null) {
            return null;
        }
        JdkItem jdkItem = this.selectedItem;
        if (jdkItem == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"selectedItem");
        }
        return TuplesKt.to((Object)jdkItem, (Object)selectedFile);
    }

    private final void onTextChange(TextFieldWithBrowseButton $this$onTextChange, Function1<? super String, Unit> action2) {
        int $i$f$onTextChange = 0;
        JTextField jTextField = $this$onTextChange.getTextField();
        Intrinsics.checkNotNullExpressionValue((Object)jTextField, (String)"textField");
        jTextField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter($this$onTextChange, action2){
            final /* synthetic */ TextFieldWithBrowseButton $this_onTextChange;
            final /* synthetic */ Function1 $action;

            protected void textChanged(@NotNull DocumentEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                String string = this.$this_onTextChange.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"text");
                this.$action.invoke((Object)string);
            }
            {
                this.$this_onTextChange = $receiver;
                this.$action = $captured_local_variable$1;
            }
        });
    }

    private final /* synthetic */ <T> void onSelectionChange(ComboBox<T> $this$onSelectionChange, Function1<? super T, Unit> action2) {
        int $i$f$onSelectionChange = 0;
        Intrinsics.needClassReification();
        $this$onSelectionChange.addItemListener(new ItemListener(action2){
            final /* synthetic */ Function1 $action;

            public final void itemStateChanged(ItemEvent e) {
                ItemEvent itemEvent = e;
                Intrinsics.checkNotNullExpressionValue((Object)itemEvent, (String)"e");
                if (itemEvent.getStateChange() == 1) {
                    Object object = e.getItem();
                    Intrinsics.reifiedOperationMarker((int)1, (String)"T");
                    this.$action.invoke(object);
                }
            }
            {
                this.$action = function1;
            }
        });
    }

    @Nullable
    public final Project getProject() {
        return this.project;
    }

    @Nullable
    public final Component getParentComponent() {
        return this.parentComponent;
    }

    @NotNull
    public final SdkTypeId getSdkType() {
        return this.sdkType;
    }

    @NotNull
    public final JdkDownloaderMergedModel getMergedModel() {
        return this.mergedModel;
    }

    /*
     * WARNING - void declaration
     */
    public JdkDownloadDialog(@Nullable Project project, @Nullable Component parentComponent, @NotNull SdkTypeId sdkType, @NotNull JdkDownloaderMergedModel mergedModel) {
        void $this$panel;
        LayoutBuilder builder$iv;
        ComboBox<JdkVersionItem> $this$onSelectionChange$iv;
        ComboBox $this$onTextChange$iv;
        JdkDownloadDialog this_$iv;
        Intrinsics.checkNotNullParameter((Object)sdkType, (String)"sdkType");
        Intrinsics.checkNotNullParameter((Object)mergedModel, (String)"mergedModel");
        super(project, parentComponent, false, DialogWrapper.IdeModalityType.PROJECT);
        this.project = project;
        this.parentComponent = parentComponent;
        this.sdkType = sdkType;
        this.mergedModel = mergedModel;
        this.setTitle(ProjectBundle.message((String)"dialog.title.download.jdk", (Object[])new Object[0]));
        this.setResizable(false);
        this.versionComboBox = new ComboBox();
        this.versionComboBox.setRenderer((ListCellRenderer)((Object)JdkDownloadDialogKt.access$getJdkVersionItemRenderer$p()));
        this.versionComboBox.setSwingPopup(false);
        this.vendorComboBox = new JdkVersionVendorCombobox();
        if (this.mergedModel.getHasWsl()) {
            this.installDirCombo = new ComboBox();
            this.installDirCombo.setEditable(true);
            this.installDirCombo.initBrowsableEditor((Runnable)new BrowseFolderRunnable(ProjectBundle.message((String)"dialog.title.select.path.to.install.jdk", (Object[])new Object[0]), null, this.project, FileChooserDescriptorFactory.createSingleFolderDescriptor(), (JComponent)this.installDirCombo, TextComponentAccessor.STRING_COMBOBOX_WHOLE_TEXT), this.getDisposable());
            this.installDirCombo.addActionListener(new ActionListener(){

                @Override
                public final void actionPerformed(ActionEvent it) {
                    ComboBoxEditor comboBoxEditor = installDirCombo.getEditor();
                    Intrinsics.checkNotNullExpressionValue((Object)comboBoxEditor, (String)"installDirCombo.editor");
                    Object object = comboBoxEditor.getItem();
                    if (object == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
                    }
                    this.onTargetPathChanged((String)object);
                }
            });
            this.installDirTextField = null;
            this.installDirComponent = (JComponent)this.installDirCombo;
        } else {
            String string = ProjectBundle.message((String)"dialog.title.select.path.to.install.jdk", (Object[])new Object[0]);
            FileChooserDescriptor fileChooserDescriptor2 = FileChooserDescriptorFactory.createSingleFolderDescriptor();
            Intrinsics.checkNotNullExpressionValue((Object)fileChooserDescriptor2, (String)"FileChooserDescriptorFac\u2026eSingleFolderDescriptor()");
            TextFieldWithBrowseButton textFieldWithBrowseButton2 = this.installDirTextField = ComponentsKt.textFieldWithBrowseButton$default(this.project, string, fileChooserDescriptor2, null, 8, null);
            this_$iv = this;
            boolean $i$f$onTextChange = false;
            JTextField jTextField = $this$onTextChange$iv.getTextField();
            Intrinsics.checkNotNullExpressionValue((Object)jTextField, (String)"textField");
            jTextField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter((TextFieldWithBrowseButton)$this$onTextChange$iv, this){
                final /* synthetic */ TextFieldWithBrowseButton $this_onTextChange;
                final /* synthetic */ JdkDownloadDialog this$0;
                {
                    this.$this_onTextChange = $receiver;
                    this.this$0 = jdkDownloadDialog;
                }

                protected void textChanged(@NotNull DocumentEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    String string = this.$this_onTextChange.getText();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"text");
                    String it = string;
                    boolean bl = false;
                    JdkDownloadDialog.access$onTargetPathChanged(this.this$0, it);
                }
            });
            this.installDirCombo = null;
            this.installDirComponent = (JComponent)this.installDirTextField;
        }
        this.vendorComboBox.onActionItemSelected((Function1<? super JdkVersionVendorItem, Unit>)((Function1)new Function1<JdkVersionVendorElement, Unit>(this){

            public final void invoke(@Nullable JdkVersionVendorElement p1) {
                ((JdkDownloadDialog)((Object)this.receiver)).onVendorActionItemSelected(p1);
            }
        }));
        $this$onTextChange$iv = this.vendorComboBox;
        this_$iv = this;
        JdkDownloadDialog $i$f$onTextChange = this;
        boolean $i$f$onSelectionChange = false;
        $this$onSelectionChange$iv.addItemListener(new ItemListener($i$f$onTextChange){
            final /* synthetic */ JdkDownloadDialog receiver$0$inlined;
            {
                this.receiver$0$inlined = jdkDownloadDialog;
            }

            public final void itemStateChanged(ItemEvent e) {
                ItemEvent itemEvent = e;
                Intrinsics.checkNotNullExpressionValue((Object)itemEvent, (String)"e");
                if (itemEvent.getStateChange() == 1) {
                    Object object = e.getItem();
                    if (object == null) {
                        throw new NullPointerException("null cannot be cast to non-null type com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkVersionVendorElement");
                    }
                    JdkVersionVendorElement p1 = (JdkVersionVendorElement)object;
                    boolean bl = false;
                    JdkDownloadDialog.access$onVendorSelectionChange(this.receiver$0$inlined, p1);
                }
            }
        });
        $this$onSelectionChange$iv = this.versionComboBox;
        this_$iv = this;
        $i$f$onTextChange = this;
        $i$f$onSelectionChange = false;
        $this$onSelectionChange$iv.addItemListener(new ItemListener($i$f$onTextChange){
            final /* synthetic */ JdkDownloadDialog receiver$0$inlined;
            {
                this.receiver$0$inlined = jdkDownloadDialog;
            }

            public final void itemStateChanged(ItemEvent e) {
                ItemEvent itemEvent = e;
                Intrinsics.checkNotNullExpressionValue((Object)itemEvent, (String)"e");
                if (itemEvent.getStateChange() == 1) {
                    Object object = e.getItem();
                    if (object == null) {
                        throw new NullPointerException("null cannot be cast to non-null type com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkVersionItem");
                    }
                    JdkVersionItem p1 = (JdkVersionItem)object;
                    boolean bl = false;
                    JdkDownloadDialog.access$onVersionSelectionChange(this.receiver$0$inlined, p1);
                }
            }
        });
        LCFlags[] constraints$iv = new LCFlags[]{};
        String title$iv = null;
        boolean $i$f$panel = false;
        LayoutBuilder layoutBuilder = builder$iv = LayoutImplKt.createLayoutBuilder();
        JdkDownloadDialog jdkDownloadDialog = this;
        boolean bl = false;
        RowBuilder.DefaultImpls.row$default((RowBuilder)$this$panel, ProjectBundle.message((String)"dialog.row.jdk.version", (Object[])new Object[0]), false, (Function1)new Function1<Row, Unit>(this){
            final /* synthetic */ JdkDownloadDialog this$0;
            {
                this.this$0 = jdkDownloadDialog;
                super(1);
            }

            public final void invoke(@NotNull Row $this$row) {
                Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$receiver");
                Cell.invoke$default($this$row, (JComponent)JdkDownloadDialog.access$getVersionComboBox$p(this.this$0), new CCFlags[0], null, null, 6, null).sizeGroup("combo");
            }
        }, 2, null);
        RowBuilder.DefaultImpls.row$default((RowBuilder)$this$panel, ProjectBundle.message((String)"dialog.row.jdk.vendor", (Object[])new Object[0]), false, (Function1)new Function1<Row, Unit>(this){
            final /* synthetic */ JdkDownloadDialog this$0;
            {
                this.this$0 = jdkDownloadDialog;
                super(1);
            }

            public final void invoke(@NotNull Row $this$row) {
                Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$receiver");
                Cell.invoke$default($this$row, (JComponent)((Object)JdkDownloadDialog.access$getVendorComboBox$p(this.this$0)), new CCFlags[0], null, null, 6, null).sizeGroup("combo").focused();
            }
        }, 2, null);
        RowBuilder.DefaultImpls.row$default((RowBuilder)$this$panel, ProjectBundle.message((String)"dialog.row.jdk.location", (Object[])new Object[0]), false, (Function1)new Function1<Row, Unit>(this){
            final /* synthetic */ JdkDownloadDialog this$0;
            {
                this.this$0 = jdkDownloadDialog;
                super(1);
            }

            public final void invoke(@NotNull Row $this$row) {
                Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$receiver");
                Cell.invoke$default($this$row, JdkDownloadDialog.access$getInstallDirComponent$p(this.this$0), new CCFlags[0], null, null, 6, null);
            }
        }, 2, null);
        Unit unit = Unit.INSTANCE;
        DialogPanel panel$iv = ComponentsKt.DialogPanel(title$iv, null);
        builder$iv.getBuilder().build((Container)panel$iv, constraints$iv);
        LayoutKt.initPanel(builder$iv, panel$iv);
        jdkDownloadDialog.panel = (JComponent)panel$iv;
        this.myOKAction.putValue("Name", ProjectBundle.message((String)"dialog.button.download.jdk", (Object[])new Object[0]));
        this.setModel(this.mergedModel.getProjectWSLDistribution() != null);
        this.init();
    }

    public static final /* synthetic */ void access$onVendorSelectionChange(JdkDownloadDialog $this, JdkVersionVendorElement it) {
        $this.onVendorSelectionChange(it);
    }

    public static final /* synthetic */ void access$onVersionSelectionChange(JdkDownloadDialog $this, JdkVersionItem it) {
        $this.onVersionSelectionChange(it);
    }

    public static final /* synthetic */ ComboBox access$getVersionComboBox$p(JdkDownloadDialog $this) {
        return $this.versionComboBox;
    }

    public static final /* synthetic */ JdkVersionVendorCombobox access$getVendorComboBox$p(JdkDownloadDialog $this) {
        return $this.vendorComboBox;
    }

    public static final /* synthetic */ JComponent access$getInstallDirComponent$p(JdkDownloadDialog $this) {
        return $this.installDirComponent;
    }
}

