/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.impl.ProjectRootManagerComponent;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001\u0007B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/openapi/roots/impl/DumpWatchedRootsAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "Root", "intellij.platform.lang.impl"})
public final class DumpWatchedRootsAction
extends DumbAwareAction {
    /*
     * WARNING - void declaration
     */
    public void actionPerformed(@NotNull AnActionEvent e) {
        void $this$sortedBy$iv;
        void $this$mapTo$iv$iv;
        Object object;
        Object object2;
        Object destination$iv$iv;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        ProjectManager projectManager = ProjectManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)projectManager, (String)"ProjectManager.getInstance()");
        Project[] projectArray = projectManager.getOpenProjects();
        Intrinsics.checkNotNullExpressionValue((Object)projectArray, (String)"ProjectManager.getInstance().openProjects");
        Project[] projects = projectArray;
        MultiMap roots2Project = new MultiMap();
        for (Project project : projects) {
            void $this$mapTo$iv$iv2;
            ProjectRootManager projectRootManager = ProjectRootManager.getInstance((Project)project);
            if (projectRootManager == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.intellij.openapi.roots.impl.ProjectRootManagerComponent");
            }
            Set<LocalFileSystem.WatchRequest> set2 = ((ProjectRootManagerComponent)projectRootManager).getRootsToWatch();
            Intrinsics.checkNotNullExpressionValue(set2, (String)"(ProjectRootManager.getI\u2026erComponent).rootsToWatch");
            Iterable $this$map$iv = set2;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void it;
                LocalFileSystem.WatchRequest watchRequest = (LocalFileSystem.WatchRequest)item$iv$iv;
                object2 = destination$iv$iv;
                boolean bl = false;
                void v4 = it;
                Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"it");
                object = v4.getRootPath();
                object2.add(object);
            }
            List roots = (List)destination$iv$iv;
            for (String root : roots) {
                roots2Project.putValue((Object)root, (Object)project);
            }
        }
        Set set3 = roots2Project.entrySet();
        Intrinsics.checkNotNullExpressionValue((Object)set3, (String)"roots2Project.entrySet()");
        Iterable $this$map$iv = set3;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Collection<String> collection;
            void $this$mapTo$iv$iv3;
            void $this$map$iv2;
            void it;
            destination$iv$iv = (Map.Entry)item$iv$iv;
            object2 = destination$iv$iv2;
            boolean bl = false;
            Object k = it.getKey();
            Intrinsics.checkNotNullExpressionValue(k, (String)"it.key");
            String string = (String)k;
            Object v = it.getValue();
            Intrinsics.checkNotNullExpressionValue(v, (String)"it.value");
            Iterable iterable2 = (Iterable)v;
            String string2 = string;
            boolean $i$f$map2 = false;
            void var19_28 = $this$map$iv2;
            Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv3) {
                void p;
                Project project = (Project)item$iv$iv2;
                collection = destination$iv$iv3;
                boolean bl2 = false;
                StringBuilder stringBuilder = new StringBuilder();
                void v10 = p;
                Intrinsics.checkNotNullExpressionValue((Object)v10, (String)"p");
                String string3 = stringBuilder.append(v10.getName()).append("-").append(p.getLocationHash()).toString();
                collection.add(string3);
            }
            collection = (List)destination$iv$iv3;
            List list2 = CollectionsKt.sorted((Iterable)collection);
            String string4 = string2;
            object = new Root(string4, list2);
            object2.add(object);
        }
        $this$map$iv = (List)destination$iv$iv2;
        boolean $i$f$sortedBy = false;
        boolean bl = false;
        List roots = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator<T>(){

            public final int compare(T a, T b) {
                boolean bl = false;
                Root it = (Root)a;
                boolean bl2 = false;
                Comparable comparable = (Comparable)((Object)it.getPath());
                it = (Root)b;
                Comparable comparable2 = comparable;
                bl2 = false;
                String string = it.getPath();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)string)));
            }
        });
        BaseListPopupStep<Root> baseListPopupStep2 = new BaseListPopupStep<Root>(roots, "Registered Roots", roots){
            final /* synthetic */ List $roots;

            public boolean isSpeedSearchEnabled() {
                return true;
            }

            @NotNull
            public String getTextFor(@Nullable Root value2) {
                Object object;
                Root root = value2;
                return StringUtil.shortenPathWithEllipsis((String)String.valueOf(root != null ? root.getPath() : null), (int)100) + "  (" + ((object = value2) != null && (object = ((Root)object).getProjects()) != null ? CollectionsKt.joinToString$default((Iterable)((Iterable)object), (CharSequence)",", null, null, (int)0, null, null, (int)62, null) : null) + ')';
            }
            {
                this.$roots = $captured_local_variable$0;
                super($super_call_param$1, $super_call_param$2);
            }
        };
        ListPopup listPopup = JBPopupFactory.getInstance().createListPopup((ListPopupStep)baseListPopupStep2);
        Intrinsics.checkNotNullExpressionValue((Object)listPopup, (String)"JBPopupFactory.getInstan\u2026tPopup(baseListPopupStep)");
        ListPopup popup2 = listPopup;
        popup2.showInBestPositionFor(e.getDataContext());
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005H\u00c6\u0003J#\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lcom/intellij/openapi/roots/impl/DumpWatchedRootsAction$Root;", "", "path", "", "projects", "", "(Ljava/lang/String;Ljava/util/List;)V", "getPath", "()Ljava/lang/String;", "getProjects", "()Ljava/util/List;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.platform.lang.impl"})
    private static final class Root {
        @NotNull
        private final String path;
        @NotNull
        private final List<String> projects;

        @NotNull
        public final String getPath() {
            return this.path;
        }

        @NotNull
        public final List<String> getProjects() {
            return this.projects;
        }

        public Root(@NotNull String path2, @NotNull List<String> projects) {
            Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
            Intrinsics.checkNotNullParameter(projects, (String)"projects");
            this.path = path2;
            this.projects = projects;
        }

        @NotNull
        public final String component1() {
            return this.path;
        }

        @NotNull
        public final List<String> component2() {
            return this.projects;
        }

        @NotNull
        public final Root copy(@NotNull String path2, @NotNull List<String> projects) {
            Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
            Intrinsics.checkNotNullParameter(projects, (String)"projects");
            return new Root(path2, projects);
        }

        public static /* synthetic */ Root copy$default(Root root, String string, List list2, int n, Object object) {
            if ((n & 1) != 0) {
                string = root.path;
            }
            if ((n & 2) != 0) {
                list2 = root.projects;
            }
            return root.copy(string, list2);
        }

        @NotNull
        public String toString() {
            return "Root(path=" + this.path + ", projects=" + this.projects + ")";
        }

        public int hashCode() {
            String string = this.path;
            List<String> list2 = this.projects;
            return (string != null ? string.hashCode() : 0) * 31 + (list2 != null ? ((Object)list2).hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Root)) break block3;
                    Root root = (Root)object;
                    if (!Intrinsics.areEqual((Object)this.path, (Object)root.path) || !Intrinsics.areEqual(this.projects, root.projects)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

