/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PackageDirectoryCache {
    private static final Logger LOG = Logger.getInstance(PackageDirectoryCache.class);
    private final MultiMap<String, VirtualFile> myRootsByPackagePrefix;
    private final Map<String, PackageInfo> myDirectoriesByPackageNameCache;
    private final Set<String> myNonExistentPackages;

    public PackageDirectoryCache(@NotNull MultiMap<String, VirtualFile> rootsByPackagePrefix) {
        if (rootsByPackagePrefix == null) {
            PackageDirectoryCache.$$$reportNull$$$0(0);
        }
        this.myRootsByPackagePrefix = MultiMap.create();
        this.myDirectoriesByPackageNameCache = new ConcurrentHashMap<String, PackageInfo>();
        this.myNonExistentPackages = ContainerUtil.newConcurrentSet();
        for (String prefix2 : rootsByPackagePrefix.keySet()) {
            for (VirtualFile file2 : rootsByPackagePrefix.get((Object)prefix2)) {
                if (!file2.isValid()) {
                    LOG.error("Invalid root: " + file2);
                    continue;
                }
                this.myRootsByPackagePrefix.putValue((Object)prefix2, (Object)file2);
            }
        }
    }

    void clear() {
        this.myNonExistentPackages.clear();
        this.myDirectoriesByPackageNameCache.clear();
    }

    public void onLowMemory() {
        this.myNonExistentPackages.clear();
    }

    @NotNull
    public List<VirtualFile> getDirectoriesByPackageName(@NotNull String packageName) {
        PackageInfo info2;
        if (packageName == null) {
            PackageDirectoryCache.$$$reportNull$$$0(1);
        }
        List<Object> list2 = (info2 = this.getPackageInfo(packageName)) == null ? Collections.emptyList() : Collections.unmodifiableList(info2.myPackageDirectories);
        if (list2 == null) {
            PackageDirectoryCache.$$$reportNull$$$0(2);
        }
        return list2;
    }

    @Nullable
    private PackageInfo getPackageInfo(@NotNull String packageName) {
        PackageInfo info2;
        if (packageName == null) {
            PackageDirectoryCache.$$$reportNull$$$0(3);
        }
        if ((info2 = this.myDirectoriesByPackageNameCache.get(packageName)) == null && !this.myNonExistentPackages.contains(packageName)) {
            if (packageName.length() > Registry.intValue((String)"java.max.package.name.length") || StringUtil.containsAnyChar((String)packageName, (String)";[/")) {
                return null;
            }
            SmartList result2 = new SmartList();
            if (StringUtil.isNotEmpty((String)packageName) && !StringUtil.startsWithChar((CharSequence)packageName, (char)'.')) {
                int i2 = packageName.lastIndexOf(46);
                while (true) {
                    PackageInfo parentInfo;
                    if ((parentInfo = this.getPackageInfo(i2 > 0 ? packageName.substring(0, i2) : "")) != null) {
                        result2.addAll(parentInfo.getSubPackageDirectories(packageName.substring(i2 + 1)));
                    }
                    if (i2 < 0) break;
                    i2 = packageName.lastIndexOf(46, i2 - 1);
                    ProgressManager.checkCanceled();
                }
            }
            for (VirtualFile file2 : this.myRootsByPackagePrefix.get((Object)packageName)) {
                if (!file2.isDirectory() || !file2.isValid()) continue;
                result2.add(file2);
            }
            if (!result2.isEmpty()) {
                info2 = new PackageInfo(packageName, (List<? extends VirtualFile>)result2);
                this.myDirectoriesByPackageNameCache.put(packageName, info2);
            } else {
                this.myNonExistentPackages.add(packageName);
            }
        }
        return info2;
    }

    @NotNull
    public Set<String> getSubpackageNames(@NotNull String packageName, @NotNull GlobalSearchScope scope2) {
        PackageInfo info2;
        if (packageName == null) {
            PackageDirectoryCache.$$$reportNull$$$0(4);
        }
        if (scope2 == null) {
            PackageDirectoryCache.$$$reportNull$$$0(5);
        }
        if ((info2 = this.getPackageInfo(packageName)) == null) {
            Set<String> set2 = Collections.emptySet();
            if (set2 == null) {
                PackageDirectoryCache.$$$reportNull$$$0(6);
            }
            return set2;
        }
        HashSet<String> result2 = new HashSet<String>();
        for (Map.Entry entry2 : ((MultiMap)info2.mySubPackages.getValue()).entrySet()) {
            String shortName = (String)entry2.getKey();
            Collection directories = (Collection)entry2.getValue();
            if (!ContainerUtil.exists((Iterable)directories, arg_0 -> ((GlobalSearchScope)scope2).contains(arg_0))) continue;
            result2.add(shortName);
        }
        Set<String> set3 = Collections.unmodifiableSet(result2);
        if (set3 == null) {
            PackageDirectoryCache.$$$reportNull$$$0(7);
        }
        return set3;
    }

    @NotNull
    public static PackageDirectoryCache createCache(@NotNull List<? extends VirtualFile> roots) {
        if (roots == null) {
            PackageDirectoryCache.$$$reportNull$$$0(8);
        }
        MultiMap map2 = MultiMap.create();
        map2.putValues((Object)"", roots);
        return new PackageDirectoryCache((MultiMap<String, VirtualFile>)map2);
    }

    protected boolean isPackageDirectory(@NotNull VirtualFile dir, @NotNull String packageName) {
        if (dir == null) {
            PackageDirectoryCache.$$$reportNull$$$0(9);
        }
        if (packageName == null) {
            PackageDirectoryCache.$$$reportNull$$$0(10);
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootsByPackagePrefix";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 2: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/impl/PackageDirectoryCache";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/impl/PackageDirectoryCache";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDirectoriesByPackageName";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubpackageNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getDirectoriesByPackageName";
                break;
            }
            case 2: 
            case 6: 
            case 7: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getPackageInfo";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getSubpackageNames";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createCache";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isPackageDirectory";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private final class PackageInfo {
        @NotNull
        final String myQname;
        @NotNull
        final List<? extends VirtualFile> myPackageDirectories;
        final NotNullLazyValue<MultiMap<String, VirtualFile>> mySubPackages;

        PackageInfo(@NotNull String qname, List<? extends VirtualFile> packageDirectories) {
            if (qname == null) {
                PackageInfo.$$$reportNull$$$0(0);
            }
            if (packageDirectories == null) {
                PackageInfo.$$$reportNull$$$0(1);
            }
            this.myQname = qname;
            this.myPackageDirectories = packageDirectories;
            this.mySubPackages = NotNullLazyValue.volatileLazy(() -> {
                MultiMap result2 = MultiMap.createLinked();
                for (VirtualFile virtualFile2 : this.myPackageDirectories) {
                    ProgressManager.checkCanceled();
                    for (VirtualFile child2 : virtualFile2.getChildren()) {
                        String packageName;
                        String childName = child2.getName();
                        String string = packageName = this.myQname.isEmpty() ? childName : this.myQname + "." + childName;
                        if (!child2.isDirectory() || !PackageDirectoryCache.this.isPackageDirectory(child2, packageName)) continue;
                        result2.putValue((Object)childName, (Object)child2);
                    }
                }
                return result2;
            });
        }

        @NotNull
        Collection<VirtualFile> getSubPackageDirectories(String shortName) {
            Collection collection = ((MultiMap)this.mySubPackages.getValue()).get((Object)shortName);
            if (collection == null) {
                PackageInfo.$$$reportNull$$$0(2);
            }
            return collection;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "qname";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "packageDirectories";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/roots/impl/PackageDirectoryCache$PackageInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/roots/impl/PackageDirectoryCache$PackageInfo";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSubPackageDirectories";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

