/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.updateSettings.impl;

import com.intellij.ide.IdeBundle;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.IdeUrlTrackingParametersProvider;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.openapi.updateSettings.impl.BuildInfo;
import com.intellij.openapi.updateSettings.impl.UpdateChain;
import com.intellij.openapi.updateSettings.impl.UpdateChannel;
import com.intellij.openapi.updateSettings.impl.UpdateInfoPanel;
import com.intellij.openapi.updateSettings.impl.UpdateInfoStatsCollector;
import com.intellij.openapi.updateSettings.impl.UpdateSettingsConfigurable;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.BrowserHyperlinkListener;
import com.intellij.ui.JBColor;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.ActionLink;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.FontUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000i\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000*\u0001\f\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JP\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u00172\n\b\u0001\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u001dH\u0007J\u0018\u0010\u001e\u001a\u00020\u00192\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00020\u001dH\u0007J,\u0010\u001f\u001a\u00020\u00192\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010 \u001a\u00020!H\u0003J\u0010\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020#H\u0002J \u0010%\u001a\u00020\u00192\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010&\u001a\u00020'H\u0003R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\r\u00a8\u0006("}, d2={"Lcom/intellij/openapi/updateSettings/impl/UpdateInfoPanel;", "", "()V", "DEFAULT_MAX_HEIGHT", "", "DEFAULT_MIN_HEIGHT", "DEFAULT_WIDTH", "DIVIDER_COLOR", "Lcom/intellij/ui/JBColor;", "PATCH_SIZE_RANGE", "Lkotlin/text/Regex;", "REPORTING_LISTENER", "com/intellij/openapi/updateSettings/impl/UpdateInfoPanel$REPORTING_LISTENER$1", "Lcom/intellij/openapi/updateSettings/impl/UpdateInfoPanel$REPORTING_LISTENER$1;", "create", "Ljavax/swing/JPanel;", "newBuild", "Lcom/intellij/openapi/updateSettings/impl/BuildInfo;", "patches", "Lcom/intellij/openapi/updateSettings/impl/UpdateChain;", "testPatch", "Ljava/io/File;", "writeProtected", "", "licenseInfo", "", "licenseWarn", "enableLink", "updatedChannel", "Lcom/intellij/openapi/updateSettings/impl/UpdateChannel;", "downloadUrl", "infoLabelText", "appInfo", "Lcom/intellij/openapi/application/ApplicationInfo;", "smallFont", "Ljava/awt/Font;", "font", "textPaneContent", "appNames", "Lcom/intellij/openapi/application/ApplicationNamesInfo;", "intellij.platform.ide.impl"})
public final class UpdateInfoPanel {
    private static final int DEFAULT_MIN_HEIGHT = 300;
    private static final int DEFAULT_MAX_HEIGHT = 600;
    private static final int DEFAULT_WIDTH = 700;
    private static final JBColor DIVIDER_COLOR;
    private static final Regex PATCH_SIZE_RANGE;
    private static final REPORTING_LISTENER.1 REPORTING_LISTENER;
    @NotNull
    public static final UpdateInfoPanel INSTANCE;

    @JvmStatic
    @NotNull
    public static final JPanel create(@NotNull BuildInfo newBuild, @Nullable UpdateChain patches2, @Nullable File testPatch, boolean writeProtected, @NlsContexts.Label @Nullable String licenseInfo, boolean licenseWarn, boolean enableLink, @NotNull UpdateChannel updatedChannel) {
        Intrinsics.checkNotNullParameter((Object)newBuild, (String)"newBuild");
        Intrinsics.checkNotNullParameter((Object)updatedChannel, (String)"updatedChannel");
        ApplicationInfo appInfo = ApplicationInfo.getInstance();
        ApplicationNamesInfo applicationNamesInfo = ApplicationNamesInfo.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)applicationNamesInfo, (String)"ApplicationNamesInfo.getInstance()");
        ApplicationNamesInfo appNames = applicationNamesInfo;
        JEditorPane textPane = new JEditorPane("text/html", "");
        textPane.setBorder((Border)JBUI.Borders.empty((int)10, (int)16));
        textPane.setEditable(false);
        textPane.setCaretPosition(0);
        textPane.setText(INSTANCE.textPaneContent(newBuild, updatedChannel, appNames));
        textPane.addHyperlinkListener((HyperlinkListener)((Object)REPORTING_LISTENER));
        JScrollPane jScrollPane = ScrollPaneFactory.createScrollPane((Component)textPane, (boolean)true);
        Intrinsics.checkNotNullExpressionValue((Object)jScrollPane, (String)"ScrollPaneFactory.createScrollPane(textPane, true)");
        JScrollPane scrollPane = jScrollPane;
        scrollPane.setBorder(JBUI.Borders.customLine((Color)((Color)DIVIDER_COLOR), (int)0, (int)0, (int)1, (int)0));
        int n = scrollPane.getPreferredSize().width;
        int n2 = 700;
        boolean bl = false;
        scrollPane.setPreferredSize(new Dimension(Math.min(n, n2), RangesKt.coerceIn((int)scrollPane.getPreferredSize().height, (int)300, (int)600)));
        JPanel infoPanel = new JPanel((LayoutManager)new VerticalFlowLayout(0, 10));
        infoPanel.setBorder((Border)JBUI.Borders.empty((int)8, (int)16));
        if (licenseInfo != null) {
            JBLabel label2 = new JBLabel(licenseInfo);
            label2.setForeground(licenseWarn ? (Color)JBColor.RED : null);
            Font font = label2.getFont();
            Intrinsics.checkNotNullExpressionValue((Object)font, (String)"label.font");
            label2.setFont(INSTANCE.smallFont(font));
            infoPanel.add((Component)label2);
        }
        if (writeProtected) {
            JBLabel label3 = new JBLabel(IdeBundle.message((String)"updates.write.protected", (Object[])new Object[]{appNames.getProductName(), PathManager.getHomePath()}));
            label3.setForeground((Color)JBColor.RED);
            Font font = label3.getFont();
            Intrinsics.checkNotNullExpressionValue((Object)font, (String)"label.font");
            label3.setFont(INSTANCE.smallFont(font));
            infoPanel.add((Component)label3);
        }
        JPanel infoRow = new JPanel(new FlowLayout(0, 0, 0));
        JBLabel infoLabel = new JBLabel();
        SimpleTextAttributes simpleTextAttributes = SimpleTextAttributes.GRAY_ITALIC_ATTRIBUTES;
        Intrinsics.checkNotNullExpressionValue((Object)simpleTextAttributes, (String)"SimpleTextAttributes.GRAY_ITALIC_ATTRIBUTES");
        infoLabel.setForeground(simpleTextAttributes.getFgColor());
        Font font = infoLabel.getFont();
        Intrinsics.checkNotNullExpressionValue((Object)font, (String)"infoLabel.font");
        infoLabel.setFont(INSTANCE.smallFont(font));
        ApplicationInfo applicationInfo = appInfo;
        Intrinsics.checkNotNullExpressionValue((Object)applicationInfo, (String)"appInfo");
        infoLabel.setText(INSTANCE.infoLabelText(newBuild, patches2, testPatch, applicationInfo));
        infoRow.add((Component)infoLabel);
        if (enableLink) {
            String string = IdeBundle.message((String)"updates.configure.updates.label", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"IdeBundle.message(\"updat\u2026configure.updates.label\")");
            ActionLink link2 = new ActionLink(string, (Function1)new Function1<ActionEvent, Unit>(infoRow){
                final /* synthetic */ JPanel $infoRow;

                public final void invoke(@NotNull ActionEvent it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    ShowSettingsUtil.getInstance().editConfigurable((Component)this.$infoRow, (Configurable)new UpdateSettingsConfigurable(false));
                }
                {
                    this.$infoRow = jPanel2;
                    super(1);
                }
            });
            link2.setBorder((Border)JBUI.Borders.empty((int)0, (int)4, (int)0, (int)0));
            Font font2 = link2.getFont();
            Intrinsics.checkNotNullExpressionValue((Object)font2, (String)"link.font");
            link2.setFont(INSTANCE.smallFont(font2));
            infoRow.add((Component)link2);
        }
        infoPanel.add(infoRow);
        JPanel panel2 = new JPanel(new BorderLayout());
        panel2.add((Component)scrollPane, "Center");
        panel2.add((Component)infoPanel, "South");
        return panel2;
    }

    @NlsSafe
    private final String textPaneContent(BuildInfo newBuild, UpdateChannel updatedChannel, ApplicationNamesInfo appNames) {
        String string;
        String string2 = UIUtil.getCssFontDeclaration((Font)UIUtil.getLabelFont());
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"UIUtil.getCssFontDeclara\u2026on(UIUtil.getLabelFont())");
        String style = string2;
        String message2 = newBuild.getMessage();
        CharSequence charSequence = message2;
        boolean bl = false;
        if (!StringsKt.isBlank((CharSequence)charSequence)) {
            string = message2;
        } else {
            String string3 = IdeBundle.message((String)"updates.new.version.available", (Object[])new Object[]{appNames.getFullProductName(), UpdateInfoPanel.downloadUrl(newBuild, updatedChannel)});
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"IdeBundle.message(\"updat\u2026ewBuild, updatedChannel))");
        }
        String content2 = string;
        return "<html><head>" + style + "</head><body>" + content2 + "</body></html>";
    }

    /*
     * Unable to fully structure code
     */
    @NlsContexts.DetailedDescription
    private final String infoLabelText(BuildInfo newBuild, UpdateChain patches, File testPatch, ApplicationInfo appInfo) {
        block5: {
            block4: {
                if (testPatch == null) break block4;
                var6_5 = testPatch.length() >> 20;
                var8_7 = 1L;
                var10_9 = false;
                v0 = String.valueOf(Math.max(var6_5, var8_7));
                break block5;
            }
            if (patches == null) ** GOTO lbl-1000
            var6_6 = patches.getSize();
            var7_10 = false;
            var8_8 = false;
            if (!(var6_6 == null || StringsKt.isBlank((CharSequence)var6_6) != false)) {
                match = UpdateInfoPanel.PATCH_SIZE_RANGE.matchEntire((CharSequence)patches.getSize());
                v0 = match != null ? (String)match.getGroupValues().get(1) : patches.getSize();
            } else lbl-1000:
            // 2 sources

            {
                v0 = null;
            }
        }
        patchSize = v0;
        if (patchSize != null) {
            v1 = IdeBundle.message((String)"updates.from.to.size", (Object[])new Object[]{appInfo.getFullVersion(), newBuild.getVersion(), newBuild.getNumber(), patchSize});
            v2 = v1;
            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"IdeBundle.message(\"updat\u2026wBuild.number, patchSize)");
        } else {
            v3 = IdeBundle.message((String)"updates.from.to", (Object[])new Object[]{appInfo.getFullVersion(), newBuild.getVersion(), newBuild.getNumber()});
            v2 = v3;
            Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"IdeBundle.message(\"updat\u2026version, newBuild.number)");
        }
        return v2;
    }

    private final Font smallFont(Font font) {
        Font font2;
        if (SystemInfo.isMac) {
            Font font3 = FontUtil.minusOne((Font)font);
            font2 = font3;
            Intrinsics.checkNotNullExpressionValue((Object)font3, (String)"FontUtil.minusOne(font)");
        } else if (SystemInfo.isLinux) {
            Font font4 = FontUtil.minusOne((Font)FontUtil.minusOne((Font)font));
            font2 = font4;
            Intrinsics.checkNotNullExpressionValue((Object)font4, (String)"FontUtil.minusOne(FontUtil.minusOne(font))");
        } else {
            font2 = font;
        }
        return font2;
    }

    @JvmStatic
    @NotNull
    public static final String downloadUrl(@NotNull BuildInfo newBuild, @NotNull UpdateChannel updatedChannel) {
        String string;
        String string2;
        Intrinsics.checkNotNullParameter((Object)newBuild, (String)"newBuild");
        Intrinsics.checkNotNullParameter((Object)updatedChannel, (String)"updatedChannel");
        IdeUrlTrackingParametersProvider ideUrlTrackingParametersProvider = IdeUrlTrackingParametersProvider.getInstance();
        String string3 = newBuild.getDownloadUrl();
        if (string3 == null) {
            string3 = string2 = newBuild.getBlogPost();
        }
        if (string3 == null) {
            string2 = string = updatedChannel.getUrl();
        }
        if (string2 == null) {
            string = "https://www.jetbrains.com";
        }
        String string4 = ideUrlTrackingParametersProvider.augmentUrl(string);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"IdeUrlTrackingParameters\u2026tps://www.jetbrains.com\")");
        return string4;
    }

    private UpdateInfoPanel() {
    }

    static {
        UpdateInfoPanel updateInfoPanel;
        INSTANCE = updateInfoPanel = new UpdateInfoPanel();
        DIVIDER_COLOR = new JBColor(0xD9D9D9, 0x515151);
        String string = "from \\d+ to (\\d+)";
        boolean bl = false;
        PATCH_SIZE_RANGE = new Regex(string);
        REPORTING_LISTENER = new BrowserHyperlinkListener(){

            protected void hyperlinkActivated(@NotNull HyperlinkEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                UpdateInfoStatsCollector.click(e.getDescription());
                super.hyperlinkActivated(e);
            }
        };
    }
}

