/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.updateSettings.impl;

import com.intellij.openapi.updateSettings.UpdateStrategyCustomization;
import com.intellij.openapi.updateSettings.impl.BuildInfo;
import com.intellij.openapi.updateSettings.impl.ChannelStatus;
import com.intellij.openapi.updateSettings.impl.PatchInfo;
import com.intellij.openapi.updateSettings.impl.PlatformUpdates;
import com.intellij.openapi.updateSettings.impl.Product;
import com.intellij.openapi.updateSettings.impl.UpdateChain;
import com.intellij.openapi.updateSettings.impl.UpdateChannel;
import com.intellij.openapi.updateSettings.impl.UpdateSettings;
import com.intellij.openapi.updateSettings.impl.UpdateStrategy;
import com.intellij.openapi.updateSettings.impl.UpdatesInfo;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.openapi.util.BuildRange;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.graph.InboundSemiGraph;
import com.intellij.util.graph.impl.ShortestPathFinder;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B!\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB/\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0006\u0010\u000e\u001a\u00020\u000fJ\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u0003H\u0002J\u001e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019H\u0002J\"\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\u00172\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u001e\u001a\u00020\u0003H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/intellij/openapi/updateSettings/impl/UpdateStrategy;", "", "currentBuild", "Lcom/intellij/openapi/util/BuildNumber;", "updates", "Lcom/intellij/openapi/updateSettings/impl/UpdatesInfo;", "settings", "Lcom/intellij/openapi/updateSettings/impl/UpdateSettings;", "(Lcom/intellij/openapi/util/BuildNumber;Lcom/intellij/openapi/updateSettings/impl/UpdatesInfo;Lcom/intellij/openapi/updateSettings/impl/UpdateSettings;)V", "product", "Lcom/intellij/openapi/updateSettings/impl/Product;", "customization", "Lcom/intellij/openapi/updateSettings/UpdateStrategyCustomization;", "(Lcom/intellij/openapi/util/BuildNumber;Lcom/intellij/openapi/updateSettings/impl/Product;Lcom/intellij/openapi/updateSettings/impl/UpdateSettings;Lcom/intellij/openapi/updateSettings/UpdateStrategyCustomization;)V", "checkForUpdates", "Lcom/intellij/openapi/updateSettings/impl/PlatformUpdates;", "compareBuilds", "", "n1", "n2", "isApplicable", "", "candidate", "Lcom/intellij/openapi/updateSettings/impl/BuildInfo;", "ignoredBuilds", "", "", "patches", "Lcom/intellij/openapi/updateSettings/impl/UpdateChain;", "newBuild", "from", "intellij.platform.ide.impl"})
public final class UpdateStrategy {
    private final BuildNumber currentBuild;
    private final Product product;
    private final UpdateSettings settings;
    private final UpdateStrategyCustomization customization;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final PlatformUpdates checkForUpdates() {
        PlatformUpdates platformUpdates;
        if (this.product == null || this.product.getChannels().isEmpty()) {
            return PlatformUpdates.Empty.INSTANCE;
        }
        ChannelStatus channelStatus = this.settings.getSelectedChannelStatus();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)channelStatus), (String)"settings.selectedChannelStatus");
        ChannelStatus selectedChannel = channelStatus;
        List<String> list2 = this.settings.getIgnoredBuildNumbers();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"settings.ignoredBuildNumbers");
        Set ignoredBuilds = CollectionsKt.toSet((Iterable)list2);
        Sequence $this$sortedBy$iv = SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)this.product.getChannels()), (Function1)((Function1)new Function1<UpdateChannel, Boolean>(selectedChannel){
            final /* synthetic */ ChannelStatus $selectedChannel;

            public final boolean invoke(@NotNull UpdateChannel ch) {
                Intrinsics.checkNotNullParameter((Object)ch, (String)"ch");
                return ch.getStatus().compareTo((Enum)this.$selectedChannel) >= 0;
            }
            {
                this.$selectedChannel = channelStatus;
                super(1);
            }
        }));
        boolean $i$f$sortedBy = false;
        boolean bl = false;
        Pair pair = (Pair)SequencesKt.maxWithOrNull((Sequence)SequencesKt.filter((Sequence)SequencesKt.flatMap((Sequence)SequencesKt.sortedWith((Sequence)$this$sortedBy$iv, (Comparator)new Comparator<T>(){

            public final int compare(T a, T b) {
                boolean bl = false;
                UpdateChannel ch = (UpdateChannel)a;
                boolean bl2 = false;
                Comparable comparable = (Comparable)((Object)ch.getStatus());
                ch = (UpdateChannel)b;
                Comparable comparable2 = comparable;
                bl2 = false;
                ChannelStatus channelStatus = ch.getStatus();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)channelStatus)));
            }
        }), (Function1)checkForUpdates.3.INSTANCE), (Function1)((Function1)new Function1<Pair<? extends BuildInfo, ? extends UpdateChannel>, Boolean>(this, ignoredBuilds){
            final /* synthetic */ UpdateStrategy this$0;
            final /* synthetic */ Set $ignoredBuilds;

            public final boolean invoke(@NotNull Pair<BuildInfo, UpdateChannel> p) {
                Intrinsics.checkNotNullParameter(p, (String)"p");
                return UpdateStrategy.access$isApplicable(this.this$0, (BuildInfo)p.getFirst(), this.$ignoredBuilds);
            }
            {
                this.this$0 = updateStrategy;
                this.$ignoredBuilds = set2;
                super(1);
            }
        })), (Comparator)new Comparator(this){
            final /* synthetic */ UpdateStrategy this$0;

            public final int compare(Pair<BuildInfo, UpdateChannel> p1, Pair<BuildInfo, UpdateChannel> p2) {
                return UpdateStrategy.access$compareBuilds(this.this$0, ((BuildInfo)p1.getFirst()).getNumber(), ((BuildInfo)p2.getFirst()).getNumber());
            }
            {
                this.this$0 = updateStrategy;
            }
        });
        if (pair != null) {
            void newBuild;
            Pair pair2 = pair;
            boolean bl2 = false;
            bl = false;
            Pair $dstr$newBuild$channel = pair2;
            boolean bl3 = false;
            BuildInfo buildInfo = (BuildInfo)$dstr$newBuild$channel.component1();
            UpdateChannel channel2 = (UpdateChannel)$dstr$newBuild$channel.component2();
            platformUpdates = new PlatformUpdates.Loaded((BuildInfo)newBuild, channel2, this.patches((BuildInfo)newBuild, this.product, this.currentBuild));
        } else {
            platformUpdates = PlatformUpdates.Empty.INSTANCE;
        }
        return platformUpdates;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isApplicable(BuildInfo candidate, Set<String> ignoredBuilds) {
        if (!this.customization.isNewerVersion(candidate.getNumber(), this.currentBuild)) return false;
        if (ignoredBuilds.contains(candidate.getNumber().asStringWithoutProductCode())) return false;
        BuildRange buildRange = candidate.getTarget();
        if (buildRange == null) return true;
        boolean bl = buildRange.inRange(this.currentBuild);
        if (!bl) return false;
        return true;
    }

    private final int compareBuilds(BuildNumber n1, BuildNumber n2) {
        int preferSameMajorVersion = Intrinsics.compare((int)(this.customization.haveSameMajorVersion(this.currentBuild, n1) ? 1 : 0), (int)(this.customization.haveSameMajorVersion(this.currentBuild, n2) ? 1 : 0));
        return preferSameMajorVersion != 0 ? preferSameMajorVersion : n1.compareTo(n2);
    }

    /*
     * WARNING - void declaration
     */
    private final UpdateChain patches(BuildInfo newBuild, Product product, BuildNumber from2) {
        Object v0;
        block8: {
            Iterable iterable = newBuild.getPatches();
            boolean bl = false;
            Iterable iterable2 = iterable;
            boolean bl2 = false;
            for (Object object : iterable2) {
                PatchInfo it = (PatchInfo)object;
                boolean bl3 = false;
                if (!(it.isAvailable() && it.getFromBuild().compareTo(from2) == 0)) continue;
                v0 = object;
                break block8;
            }
            v0 = null;
        }
        PatchInfo single = v0;
        if (single != null) {
            return new UpdateChain(CollectionsKt.listOf((Object[])new BuildNumber[]{from2, newBuild.getNumber()}), single.getSize());
        }
        MultiMap upgrades = new MultiMap();
        boolean bl = false;
        Map sizes = new LinkedHashMap();
        Regex number = new Regex("\\d+");
        Iterable $this$forEach$iv = product.getChannels();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            UpdateChannel channel2 = (UpdateChannel)element$iv;
            boolean bl4 = false;
            Iterable $this$forEach$iv2 = channel2.getBuilds();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                BuildInfo build2 = (BuildInfo)element$iv2;
                boolean bl5 = false;
                Intrinsics.checkNotNullExpressionValue((Object)build2.getNumber().withoutProductCode(), (String)"build.number.withoutProductCode()");
                Iterable $this$forEach$iv3 = build2.getPatches();
                boolean $i$f$forEach3 = false;
                for (Object element$iv3 : $this$forEach$iv3) {
                    Integer maxSize2;
                    BuildNumber fromBuild;
                    BuildNumber toBuild;
                    PatchInfo patch2 = (PatchInfo)element$iv3;
                    boolean bl6 = false;
                    if (!patch2.isAvailable()) continue;
                    Intrinsics.checkNotNullExpressionValue((Object)patch2.getFromBuild().withoutProductCode(), (String)"patch.fromBuild.withoutProductCode()");
                    upgrades.putValue((Object)toBuild, (Object)fromBuild);
                    if (patch2.getSize() == null || (maxSize2 = (Integer)SequencesKt.maxOrNull((Sequence)SequencesKt.filterNotNull((Sequence)SequencesKt.map((Sequence)Regex.findAll$default((Regex)number, (CharSequence)patch2.getSize(), (int)0, (int)2, null), (Function1)patches.1.1.1.maxSize.1.INSTANCE)))) == null) continue;
                    Map map2 = sizes;
                    Pair pair = TuplesKt.to((Object)TuplesKt.to((Object)fromBuild, (Object)toBuild), (Object)maxSize2);
                    boolean bl7 = false;
                    map2.put(pair.getFirst(), pair.getSecond());
                }
            }
        }
        InboundSemiGraph<BuildNumber> graph2 = new InboundSemiGraph<BuildNumber>(upgrades){
            final /* synthetic */ MultiMap $upgrades;

            @NotNull
            public Set<BuildNumber> getNodes() {
                Set set2 = this.$upgrades.keySet();
                Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"upgrades.keySet()");
                Collection collection = this.$upgrades.values();
                Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"upgrades.values()");
                return SetsKt.plus((Set)set2, (Iterable)collection);
            }

            @NotNull
            public Iterator<BuildNumber> getIn(@NotNull BuildNumber n) {
                Intrinsics.checkNotNullParameter((Object)n, (String)"n");
                return this.$upgrades.get((Object)n).iterator();
            }
            {
                this.$upgrades = $captured_local_variable$0;
            }
        };
        List<BuildNumber> path2 = new ShortestPathFinder<BuildNumber>((InboundSemiGraph)graph2).findPath(from2.withoutProductCode(), newBuild.getNumber().withoutProductCode());
        if (path2 == null || path2.size() <= 2) {
            return null;
        }
        int total = 0;
        int element$iv = 1;
        int n = path2.size();
        while (element$iv < n) {
            void i2;
            Integer size2 = (Integer)sizes.get(TuplesKt.to((Object)path2.get((int)(i2 - true)), (Object)path2.get((int)i2)));
            if (size2 == null) {
                total = -1;
                break;
            }
            total += size2.intValue();
            ++i2;
        }
        return new UpdateChain(path2, total > 0 ? String.valueOf(total) : null);
    }

    @JvmOverloads
    public UpdateStrategy(@NotNull BuildNumber currentBuild, @Nullable Product product, @NotNull UpdateSettings settings2, @NotNull UpdateStrategyCustomization customization) {
        Intrinsics.checkNotNullParameter((Object)currentBuild, (String)"currentBuild");
        Intrinsics.checkNotNullParameter((Object)settings2, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)customization, (String)"customization");
        this.currentBuild = currentBuild;
        this.product = product;
        this.settings = settings2;
        this.customization = customization;
    }

    public /* synthetic */ UpdateStrategy(BuildNumber buildNumber, Product product, UpdateSettings updateSettings, UpdateStrategyCustomization updateStrategyCustomization, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            product = null;
        }
        if ((n & 4) != 0) {
            UpdateSettings updateSettings2 = UpdateSettings.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)updateSettings2, (String)"UpdateSettings.getInstance()");
            updateSettings = updateSettings2;
        }
        if ((n & 8) != 0) {
            UpdateStrategyCustomization updateStrategyCustomization2 = UpdateStrategyCustomization.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)updateStrategyCustomization2, (String)"UpdateStrategyCustomization.getInstance()");
            updateStrategyCustomization = updateStrategyCustomization2;
        }
        this(buildNumber, product, updateSettings, updateStrategyCustomization);
    }

    @JvmOverloads
    public UpdateStrategy(@NotNull BuildNumber currentBuild, @Nullable Product product, @NotNull UpdateSettings settings2) {
        this(currentBuild, product, settings2, null, 8, null);
    }

    @JvmOverloads
    public UpdateStrategy(@NotNull BuildNumber currentBuild, @Nullable Product product) {
        this(currentBuild, product, null, null, 12, null);
    }

    @JvmOverloads
    public UpdateStrategy(@NotNull BuildNumber currentBuild) {
        this(currentBuild, null, null, null, 14, null);
    }

    @Deprecated(message="Please use `UpdateStrategy(BuildNumber, Product, UpdateSettings)` instead")
    @ApiStatus.ScheduledForRemoval(inVersion="2022.2")
    public UpdateStrategy(@NotNull BuildNumber currentBuild, @NotNull UpdatesInfo updates2, @NotNull UpdateSettings settings2) {
        Intrinsics.checkNotNullParameter((Object)currentBuild, (String)"currentBuild");
        Intrinsics.checkNotNullParameter((Object)updates2, (String)"updates");
        Intrinsics.checkNotNullParameter((Object)settings2, (String)"settings");
        this(currentBuild, updates2.getProduct(), settings2, null, 8, null);
    }

    public /* synthetic */ UpdateStrategy(BuildNumber buildNumber, UpdatesInfo updatesInfo, UpdateSettings updateSettings, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            UpdateSettings updateSettings2 = UpdateSettings.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)updateSettings2, (String)"UpdateSettings.getInstance()");
            updateSettings = updateSettings2;
        }
        this(buildNumber, updatesInfo, updateSettings);
    }

    public static final /* synthetic */ boolean access$isApplicable(UpdateStrategy $this, BuildInfo candidate, Set ignoredBuilds) {
        return $this.isApplicable(candidate, ignoredBuilds);
    }

    public static final /* synthetic */ int access$compareBuilds(UpdateStrategy $this, BuildNumber n1, BuildNumber n2) {
        return $this.compareBuilds(n1, n2);
    }
}

