/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.FilesProcessor;
import com.intellij.openapi.vcs.FilesProcessorImpl;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0006\b&\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\rH\u0004J\u0016\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\t0\u0011H\u0004J\b\u0010\u0012\u001a\u00020\u000fH\u0004J\b\u0010\u0013\u001a\u00020\u000fH\u0016J\u0016\u0010\u0014\u001a\u00020\u000f2\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\u0011H&J\u001c\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\t0\u00112\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\u0011H&J\b\u0010\u0016\u001a\u00020\u000fH\u0014J\b\u0010\u0017\u001a\u00020\u0018H\u0004J\b\u0010\u0019\u001a\u00020\u0018H$J\u0016\u0010\u001a\u001a\u00020\u000f2\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\u0011H\u0016J\u0016\u0010\u001b\u001a\u00020\u00182\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\t0\u0011H\u0004J\u000e\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\t0\rH\u0004R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001e"}, d2={"Lcom/intellij/openapi/vcs/FilesProcessorImpl;", "Lcom/intellij/openapi/vcs/FilesProcessor;", "project", "Lcom/intellij/openapi/project/Project;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/Disposable;)V", "files", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "getProject", "()Lcom/intellij/openapi/project/Project;", "acquireValidFiles", "", "addNewFiles", "", "filesToAdd", "", "clearFiles", "dispose", "doActionOnChosenFiles", "doFilterFiles", "handleProcessingForCurrentProject", "isFilesEmpty", "", "needDoForCurrentProject", "processFiles", "removeFiles", "filesToRemove", "selectValidFiles", "intellij.platform.vcs.impl"})
public abstract class FilesProcessorImpl
implements FilesProcessor {
    private final Set<VirtualFile> files;
    @NotNull
    private final Project project;

    public abstract void doActionOnChosenFiles(@NotNull Collection<? extends VirtualFile> var1);

    @NotNull
    public abstract Collection<VirtualFile> doFilterFiles(@NotNull Collection<? extends VirtualFile> var1);

    public void processFiles(@NotNull Collection<? extends VirtualFile> files2) {
        Intrinsics.checkNotNullParameter(files2, (String)"files");
        Collection<VirtualFile> filteredFiles = this.doFilterFiles(files2);
        if (filteredFiles.isEmpty()) {
            return;
        }
        this.addNewFiles(filteredFiles);
        if (this.needDoForCurrentProject()) {
            this.doActionOnChosenFiles((Collection<? extends VirtualFile>)this.acquireValidFiles());
        } else {
            this.handleProcessingForCurrentProject();
        }
    }

    protected void handleProcessingForCurrentProject() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean removeFiles(@NotNull Collection<? extends VirtualFile> filesToRemove2) {
        Intrinsics.checkNotNullParameter(filesToRemove2, (String)"filesToRemove");
        Set<VirtualFile> set2 = this.files;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (set2) {
            boolean bl3 = false;
            boolean bl4 = VcsUtil.removeAllFromSet(this.files, filesToRemove2);
            return bl4;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean isFilesEmpty() {
        Set<VirtualFile> set2 = this.files;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (set2) {
            boolean bl3 = false;
            boolean bl4 = this.files.isEmpty();
            return bl4;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void addNewFiles(@NotNull Collection<? extends VirtualFile> filesToAdd) {
        Intrinsics.checkNotNullParameter(filesToAdd, (String)"filesToAdd");
        Set<VirtualFile> set2 = this.files;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (set2) {
            boolean bl3 = false;
            bl2 = this.files.addAll(filesToAdd);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    protected final List<VirtualFile> selectValidFiles() {
        Set<VirtualFile> set2 = this.files;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (set2) {
            boolean bl3 = false;
            CollectionsKt.removeAll((Iterable)this.files, (Function1)selectValidFiles.1.1.INSTANCE);
            List list2 = CollectionsKt.toList((Iterable)this.files);
            return list2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    protected final List<VirtualFile> acquireValidFiles() {
        Set<VirtualFile> set2 = this.files;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (set2) {
            void $this$filterTo$iv$iv;
            boolean bl3 = false;
            Iterable $this$filter$iv = this.files;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                VirtualFile it = (VirtualFile)element$iv$iv;
                boolean bl4 = false;
                if (!it.isValid()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List result2 = (List)destination$iv$iv;
            this.files.clear();
            List list2 = result2;
            return list2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void clearFiles() {
        Set<VirtualFile> set2 = this.files;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (set2) {
            boolean bl3 = false;
            this.files.clear();
            Unit unit = Unit.INSTANCE;
        }
    }

    public void dispose() {
        this.clearFiles();
    }

    protected abstract boolean needDoForCurrentProject();

    @NotNull
    protected final Project getProject() {
        return this.project;
    }

    public FilesProcessorImpl(@NotNull Project project, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        this.project = project;
        boolean bl = false;
        this.files = new LinkedHashSet();
        Disposer.register((Disposable)parentDisposable, (Disposable)((Disposable)this));
    }
}

