/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.changes.FileHolder;
import com.intellij.openapi.vcs.changes.FilePathHolder;
import com.intellij.openapi.vcs.changes.FilePathHolderImpl;
import com.intellij.openapi.vcs.changes.RecursiveFilePathHolderImpl;
import com.intellij.openapi.vcs.changes.VcsManagedFilesHolder;
import com.intellij.openapi.vcs.changes.VcsModifiableDirtyScope;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public abstract class CompositeFilePathHolder
implements FileHolder {
    protected final Project myProject;
    private final ProjectLevelVcsManager myVcsManager;
    private final Map<AbstractVcs, FilePathHolder> myMap;

    public CompositeFilePathHolder(@NotNull Project project) {
        if (project == null) {
            CompositeFilePathHolder.$$$reportNull$$$0(0);
        }
        this.myMap = new HashMap<AbstractVcs, FilePathHolder>();
        this.myProject = project;
        this.myVcsManager = ProjectLevelVcsManager.getInstance((Project)this.myProject);
    }

    @Override
    public void cleanAll() {
        this.myMap.values().forEach(FileHolder::cleanAll);
        this.myMap.clear();
    }

    @Override
    public void cleanAndAdjustScope(@NotNull VcsModifiableDirtyScope scope2) {
        AbstractVcs vcs;
        FilePathHolder holder;
        if (scope2 == null) {
            CompositeFilePathHolder.$$$reportNull$$$0(1);
        }
        if ((holder = this.myMap.get(vcs = scope2.getVcs())) != null) {
            holder.cleanAndAdjustScope(scope2);
        }
    }

    protected void copyFrom(@NotNull CompositeFilePathHolder holder) {
        if (holder == null) {
            CompositeFilePathHolder.$$$reportNull$$$0(2);
        }
        for (Map.Entry<AbstractVcs, FilePathHolder> entry2 : holder.myMap.entrySet()) {
            this.myMap.put(entry2.getKey(), (FilePathHolder)entry2.getValue().copy());
        }
    }

    public void addFile(@NotNull AbstractVcs vcs, @NotNull FilePath file2) {
        if (vcs == null) {
            CompositeFilePathHolder.$$$reportNull$$$0(3);
        }
        if (file2 == null) {
            CompositeFilePathHolder.$$$reportNull$$$0(4);
        }
        this.myMap.get(vcs).addFile(file2);
    }

    public boolean isInUpdatingMode() {
        return this.myMap.values().stream().anyMatch(holder -> holder instanceof VcsManagedFilesHolder && ((VcsManagedFilesHolder)holder).isInUpdatingMode());
    }

    public boolean containsFile(@NotNull FilePath file2) {
        AbstractVcs vcs;
        if (file2 == null) {
            CompositeFilePathHolder.$$$reportNull$$$0(5);
        }
        if ((vcs = this.myVcsManager.getVcsFor(file2)) == null) {
            return false;
        }
        FilePathHolder holder = this.myMap.get(vcs);
        return holder != null && holder.containsFile(file2);
    }

    @NotNull
    public Collection<FilePath> getFiles() {
        HashSet<FilePath> result2 = new HashSet<FilePath>();
        for (FilePathHolder fileHolder : this.myMap.values()) {
            result2.addAll(fileHolder.values());
        }
        HashSet<FilePath> hashSet = result2;
        if (hashSet == null) {
            CompositeFilePathHolder.$$$reportNull$$$0(6);
        }
        return hashSet;
    }

    @Override
    public void notifyVcsStarted(@NotNull AbstractVcs vcs) {
        if (vcs == null) {
            CompositeFilePathHolder.$$$reportNull$$$0(7);
        }
        if (!this.myMap.containsKey(vcs)) {
            this.myMap.put(vcs, this.createHolderForVcs(this.myProject, vcs));
        }
        for (FileHolder fileHolder : this.myMap.values()) {
            fileHolder.notifyVcsStarted(vcs);
        }
    }

    @NotNull
    protected abstract FilePathHolder createHolderForVcs(@NotNull Project var1, @NotNull AbstractVcs var2);

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CompositeFilePathHolder holder = (CompositeFilePathHolder)o;
        return Objects.equals(this.myMap, holder.myMap);
    }

    public int hashCode() {
        return Objects.hash(this.myMap);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcs";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/CompositeFilePathHolder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/CompositeFilePathHolder";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "cleanAndAdjustScope";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "copyFrom";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addFile";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "containsFile";
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "notifyVcsStarted";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class IgnoredFilesCompositeHolder
    extends CompositeFilePathHolder {
        public IgnoredFilesCompositeHolder(@NotNull Project project) {
            if (project == null) {
                IgnoredFilesCompositeHolder.$$$reportNull$$$0(0);
            }
            super(project);
        }

        @Override
        @NotNull
        protected FilePathHolder createHolderForVcs(@NotNull Project project, @NotNull AbstractVcs vcs) {
            VcsManagedFilesHolder.Provider provider2;
            if (project == null) {
                IgnoredFilesCompositeHolder.$$$reportNull$$$0(1);
            }
            if (vcs == null) {
                IgnoredFilesCompositeHolder.$$$reportNull$$$0(2);
            }
            if ((provider2 = (VcsManagedFilesHolder.Provider)VcsManagedFilesHolder.VCS_IGNORED_FILES_HOLDER_EP.findFirstSafe((AreaInstance)project, ep2 -> ep2.getVcs().equals((Object)vcs))) != null) {
                VcsManagedFilesHolder vcsManagedFilesHolder = provider2.createHolder();
                if (vcsManagedFilesHolder == null) {
                    IgnoredFilesCompositeHolder.$$$reportNull$$$0(3);
                }
                return vcsManagedFilesHolder;
            }
            return new RecursiveFilePathHolderImpl(project);
        }

        @Override
        public IgnoredFilesCompositeHolder copy() {
            IgnoredFilesCompositeHolder result2 = new IgnoredFilesCompositeHolder(this.myProject);
            result2.copyFrom(this);
            return result2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "vcs";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/changes/CompositeFilePathHolder$IgnoredFilesCompositeHolder";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/changes/CompositeFilePathHolder$IgnoredFilesCompositeHolder";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createHolderForVcs";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "createHolderForVcs";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class UnversionedFilesCompositeHolder
    extends CompositeFilePathHolder {
        public UnversionedFilesCompositeHolder(@NotNull Project project) {
            if (project == null) {
                UnversionedFilesCompositeHolder.$$$reportNull$$$0(0);
            }
            super(project);
        }

        @Override
        @NotNull
        protected FilePathHolder createHolderForVcs(@NotNull Project project, @NotNull AbstractVcs vcs) {
            VcsManagedFilesHolder.Provider provider2;
            if (project == null) {
                UnversionedFilesCompositeHolder.$$$reportNull$$$0(1);
            }
            if (vcs == null) {
                UnversionedFilesCompositeHolder.$$$reportNull$$$0(2);
            }
            if ((provider2 = (VcsManagedFilesHolder.Provider)VcsManagedFilesHolder.VCS_UNVERSIONED_FILES_HOLDER_EP.findFirstSafe((AreaInstance)project, ep2 -> ep2.getVcs().equals((Object)vcs))) != null) {
                VcsManagedFilesHolder vcsManagedFilesHolder = provider2.createHolder();
                if (vcsManagedFilesHolder == null) {
                    UnversionedFilesCompositeHolder.$$$reportNull$$$0(3);
                }
                return vcsManagedFilesHolder;
            }
            return new FilePathHolderImpl(project);
        }

        @Override
        public UnversionedFilesCompositeHolder copy() {
            UnversionedFilesCompositeHolder result2 = new UnversionedFilesCompositeHolder(this.myProject);
            result2.copyFrom(this);
            return result2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "vcs";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/changes/CompositeFilePathHolder$UnversionedFilesCompositeHolder";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/changes/CompositeFilePathHolder$UnversionedFilesCompositeHolder";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createHolderForVcs";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "createHolderForVcs";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

