/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.committed;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ChangeListColumn;
import com.intellij.openapi.vcs.CommittedChangesProvider;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.committed.ChangeListFilteringStrategy;
import com.intellij.openapi.vcs.changes.committed.ColumnFilteringStrategy;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesTreeBrowser;
import com.intellij.openapi.vcs.changes.committed.LabeledComboBoxAction;
import com.intellij.openapi.vcs.changes.committed.NoneChangeListFilteringStrategy;
import com.intellij.openapi.vcs.changes.committed.StructureFilteringStrategy;
import com.intellij.util.Function;
import com.intellij.util.NotNullFunction;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class SelectFilteringAction
extends LabeledComboBoxAction
implements DumbAware {
    @NotNull
    private final Project myProject;
    @NotNull
    private final CommittedChangesTreeBrowser myBrowser;
    @NotNull
    private ChangeListFilteringStrategy myPreviousSelection;

    public SelectFilteringAction(@NotNull Project project, @NotNull CommittedChangesTreeBrowser browser2) {
        if (project == null) {
            SelectFilteringAction.$$$reportNull$$$0(0);
        }
        if (browser2 == null) {
            SelectFilteringAction.$$$reportNull$$$0(1);
        }
        super(VcsBundle.message((String)"committed.changes.filter.title", (Object[])new Object[0]));
        this.myPreviousSelection = NoneChangeListFilteringStrategy.INSTANCE;
        this.myProject = project;
        this.myBrowser = browser2;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            SelectFilteringAction.$$$reportNull$$$0(2);
        }
        e.getPresentation().setText(this.myPreviousSelection.toString());
    }

    @NotNull
    protected DefaultActionGroup createPopupActionGroup(JComponent button4) {
        return new DefaultActionGroup(ContainerUtil.map(this.collectStrategies(), (Function)((NotNullFunction)strategy -> new SetFilteringAction((ChangeListFilteringStrategy)strategy))));
    }

    @NotNull
    protected Condition<AnAction> getPreselectCondition() {
        Condition condition2 = action2 -> ((SetFilteringAction)action2).myStrategy.getKey().equals((Object)this.myPreviousSelection.getKey());
        if (condition2 == null) {
            SelectFilteringAction.$$$reportNull$$$0(3);
        }
        return condition2;
    }

    @NotNull
    private List<ChangeListFilteringStrategy> collectStrategies() {
        ArrayList<ChangeListFilteringStrategy> result2 = new ArrayList<ChangeListFilteringStrategy>();
        result2.add(NoneChangeListFilteringStrategy.INSTANCE);
        result2.add(new StructureFilteringStrategy(this.myProject));
        boolean addNameFilter = false;
        for (AbstractVcs vcs : ProjectLevelVcsManager.getInstance((Project)this.myProject).getAllActiveVcss()) {
            CommittedChangesProvider provider2 = vcs.getCommittedChangesProvider();
            if (provider2 == null) continue;
            addNameFilter = true;
            for (ChangeListColumn column2 : provider2.getColumns()) {
                if (!ChangeListColumn.isCustom((ChangeListColumn)column2)) continue;
                result2.add(new ColumnFilteringStrategy(column2, provider2.getClass()));
            }
        }
        if (addNameFilter) {
            result2.add(new ColumnFilteringStrategy(ChangeListColumn.NAME, CommittedChangesProvider.class));
        }
        ArrayList<ChangeListFilteringStrategy> arrayList = result2;
        if (arrayList == null) {
            SelectFilteringAction.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "browser";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/committed/SelectFilteringAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/committed/SelectFilteringAction";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreselectCondition";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "collectStrategies";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private final class SetFilteringAction
    extends DumbAwareAction {
        @NotNull
        private final ChangeListFilteringStrategy myStrategy;

        private SetFilteringAction(ChangeListFilteringStrategy strategy) {
            if (strategy == null) {
                SetFilteringAction.$$$reportNull$$$0(0);
            }
            super(strategy.toString());
            this.myStrategy = strategy;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                SetFilteringAction.$$$reportNull$$$0(1);
            }
            if (!NoneChangeListFilteringStrategy.INSTANCE.equals(SelectFilteringAction.this.myPreviousSelection)) {
                SelectFilteringAction.this.myBrowser.removeFilteringStrategy(SelectFilteringAction.this.myPreviousSelection.getKey());
            }
            if (!NoneChangeListFilteringStrategy.INSTANCE.equals(this.myStrategy)) {
                SelectFilteringAction.this.myBrowser.setFilteringStrategy(this.myStrategy);
            }
            SelectFilteringAction.this.myPreviousSelection = this.myStrategy;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "strategy";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/vcs/changes/committed/SelectFilteringAction$SetFilteringAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

