/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.conflicts;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusFactory;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.conflicts.ChangelistConflictTracker;
import com.intellij.openapi.vcs.impl.FileStatusProvider;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ChangelistConflictFileStatusProvider
implements FileStatusProvider {
    public static final FileStatus MODIFIED_OUTSIDE = FileStatusFactory.getInstance().createFileStatus("modifiedOutside", VcsBundle.messagePointer((String)"settings.file.status.color.modified.in.not.active.changelist", (Object[])new Object[0]), null);
    public static final FileStatus ADDED_OUTSIDE = FileStatusFactory.getInstance().createFileStatus("addedOutside", VcsBundle.messagePointer((String)"settings.file.status.color.added.in.not.active.changelist", (Object[])new Object[0]), null);
    public static final FileStatus CHANGELIST_CONFLICT = FileStatusFactory.getInstance().createFileStatus("changelistConflict", VcsBundle.messagePointer((String)"settings.file.status.color.changelist.conflict", (Object[])new Object[0]), null);
    private final Project myProject;

    public ChangelistConflictFileStatusProvider(@NotNull Project project) {
        if (project == null) {
            ChangelistConflictFileStatusProvider.$$$reportNull$$$0(0);
        }
        this.myProject = project;
    }

    @Override
    @Nullable
    public FileStatus getFileStatus(@NotNull VirtualFile virtualFile2) {
        FileStatus status;
        if (virtualFile2 == null) {
            ChangelistConflictFileStatusProvider.$$$reportNull$$$0(1);
        }
        ChangelistConflictTracker conflictTracker = ChangelistConflictTracker.getInstance(this.myProject);
        ChangelistConflictTracker.Options options2 = conflictTracker.getOptions();
        if (options2.HIGHLIGHT_CONFLICTS && conflictTracker.hasConflict(virtualFile2)) {
            return CHANGELIST_CONFLICT;
        }
        if (options2.HIGHLIGHT_NON_ACTIVE_CHANGELIST && ((status = ChangeListManager.getInstance((Project)this.myProject).getStatus(virtualFile2)) == FileStatus.MODIFIED || status == FileStatus.ADDED) && !conflictTracker.isFromActiveChangelist(virtualFile2)) {
            return status == FileStatus.MODIFIED ? MODIFIED_OUTSIDE : ADDED_OUTSIDE;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/vcs/changes/conflicts/ChangelistConflictFileStatusProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getFileStatus";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

