/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.conflicts;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.conflicts.ChangelistConflictConfigurable;
import com.intellij.openapi.vcs.changes.conflicts.ChangelistConflictResolution;
import com.intellij.openapi.vcs.changes.conflicts.ChangelistConflictTracker;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.InplaceButton;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ChangelistConflictNotificationPanel
extends EditorNotificationPanel {
    private final ChangeList myChangeList;
    private final VirtualFile myFile;
    private final ChangelistConflictTracker myTracker;

    @Nullable
    public static ChangelistConflictNotificationPanel create(ChangelistConflictTracker tracker2, @NotNull VirtualFile file2, @NotNull FileEditor fileEditor) {
        ChangeListManager manager2;
        Change change;
        if (file2 == null) {
            ChangelistConflictNotificationPanel.$$$reportNull$$$0(0);
        }
        if (fileEditor == null) {
            ChangelistConflictNotificationPanel.$$$reportNull$$$0(1);
        }
        if ((change = (manager2 = tracker2.getChangeListManager()).getChange(file2)) == null) {
            return null;
        }
        LocalChangeList changeList = manager2.getChangeList(change);
        if (changeList == null) {
            return null;
        }
        return new ChangelistConflictNotificationPanel(tracker2, file2, fileEditor, changeList);
    }

    private ChangelistConflictNotificationPanel(ChangelistConflictTracker tracker2, @NotNull VirtualFile file2, @NotNull FileEditor fileEditor, LocalChangeList changeList) {
        if (file2 == null) {
            ChangelistConflictNotificationPanel.$$$reportNull$$$0(2);
        }
        if (fileEditor == null) {
            ChangelistConflictNotificationPanel.$$$reportNull$$$0(3);
        }
        super(fileEditor);
        this.myTracker = tracker2;
        this.myFile = file2;
        final Project project = this.myTracker.getProject();
        ChangeListManager manager2 = tracker2.getChangeListManager();
        this.myChangeList = changeList;
        this.myLabel.setText(VcsBundle.message((String)"changes.file.from.non.active.changelist.is.modified", (Object[])new Object[0]));
        this.createActionLabel(VcsBundle.message((String)"link.label.move.changes", (Object[])new Object[0]), () -> ChangelistConflictResolution.MOVE.resolveConflict(project, this.myChangeList.getChanges(), this.myFile)).setToolTipText(VcsBundle.message((String)"changes.move.changes.to.active.change.list.name", (Object[])new Object[]{manager2.getDefaultChangeList().getName()}));
        this.createActionLabel(VcsBundle.message((String)"link.label.switch.changelist", (Object[])new Object[0]), () -> {
            Change change = this.myTracker.getChangeListManager().getChange(this.myFile);
            if (change == null) {
                Messages.showInfoMessage((String)VcsBundle.message((String)"dialog.message.no.changes.for.this.file", (Object[])new Object[0]), (String)VcsBundle.message((String)"dialog.title.message", (Object[])new Object[0]));
            } else {
                ChangelistConflictResolution.SWITCH.resolveConflict(project, Collections.singletonList(change), null);
            }
        }).setToolTipText(VcsBundle.message((String)"changes.set.active.changelist.to.change.list.name", (Object[])new Object[]{this.myChangeList.getName()}));
        this.createActionLabel(VcsBundle.message((String)"link.label.ignore", (Object[])new Object[0]), () -> this.myTracker.ignoreConflict(this.myFile, true)).setToolTipText(VcsBundle.message((String)"changes.hide.this.notification", (Object[])new Object[0]));
        this.myLinksPanel.add((Component)new InplaceButton(VcsBundle.message((String)"tooltip.show.options.dialog", (Object[])new Object[0]), AllIcons.General.Settings, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ShowSettingsUtil.getInstance().showSettingsDialog(project, ChangelistConflictConfigurable.class);
            }
        }));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileEditor";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/vcs/changes/conflicts/ChangelistConflictNotificationPanel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "create";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

