/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.history.LocalHistory;
import com.intellij.history.LocalHistoryAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListChange;
import com.intellij.openapi.vcs.changes.ChangeListManagerImpl;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.InvokeAfterUpdateMode;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vcs.changes.ui.RollbackProgressModifier;
import com.intellij.openapi.vcs.ex.PartialLocalLineStatusTracker;
import com.intellij.openapi.vcs.impl.PartialChangesUtil;
import com.intellij.openapi.vcs.rollback.DefaultRollbackEnvironment;
import com.intellij.openapi.vcs.rollback.RollbackEnvironment;
import com.intellij.openapi.vcs.rollback.RollbackProgressListener;
import com.intellij.openapi.vcs.update.RefreshVFsSynchronously;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PairFunction;
import com.intellij.util.WaitForProgressToShow;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RollbackWorker {
    private final Project myProject;
    @Nls(capitalization=Nls.Capitalization.Title)
    private final String myOperationName;
    private final boolean myInvokedFromModalContext;
    private final List<VcsException> myExceptions;

    public RollbackWorker(Project project) {
        this(project, DefaultRollbackEnvironment.getRollbackOperationText(), false);
    }

    public RollbackWorker(Project project, @Nls(capitalization=Nls.Capitalization.Title) String operationName, boolean invokedFromModalContext) {
        this.myProject = project;
        this.myOperationName = operationName;
        this.myInvokedFromModalContext = invokedFromModalContext;
        this.myExceptions = new ArrayList<VcsException>(0);
    }

    public void doRollback(@NotNull Collection<? extends Change> changes, boolean deleteLocallyAddedFiles) {
        if (changes == null) {
            RollbackWorker.$$$reportNull$$$0(0);
        }
        this.doRollback(changes, deleteLocallyAddedFiles, null, null);
    }

    public void doRollback(@NotNull Collection<? extends Change> changes, boolean deleteLocallyAddedFiles, @Nullable Runnable afterVcsRefreshInAwt, @Nullable @Nls String localHistoryActionName) {
        if (changes == null) {
            RollbackWorker.$$$reportNull$$$0(1);
        }
        this.doRollback(changes, deleteLocallyAddedFiles, afterVcsRefreshInAwt, localHistoryActionName, false);
    }

    public void doRollback(@NotNull Collection<? extends Change> changes, boolean deleteLocallyAddedFiles, @Nullable Runnable afterVcsRefreshInAwt, @Nullable @Nls String localHistoryActionName, boolean honorExcludedFromCommit) {
        if (changes == null) {
            RollbackWorker.$$$reportNull$$$0(2);
        }
        ProgressManager.getInstance().executeNonCancelableSection(() -> {
            ChangeListManagerImpl changeListManager = ChangeListManagerImpl.getInstanceImpl(this.myProject);
            Collection affectedChangelists = changeListManager.getAffectedLists((Collection)changes);
            LocalHistoryAction action2 = LocalHistory.getInstance().startAction(this.myOperationName);
            Runnable afterRefresh = () -> {
                action2.finish();
                LocalHistory.getInstance().putSystemLabel(this.myProject, (String)ObjectUtils.notNull((Object)localHistoryActionName, (Object)this.myOperationName), -1);
                InvokeAfterUpdateMode updateMode = this.myInvokedFromModalContext ? InvokeAfterUpdateMode.SYNCHRONOUS_CANCELLABLE : InvokeAfterUpdateMode.SILENT;
                changeListManager.invokeAfterUpdate(() -> {
                    for (LocalChangeList list2 : affectedChangelists) {
                        changeListManager.scheduleAutomaticEmptyChangeListDeletion(list2);
                    }
                    if (afterVcsRefreshInAwt != null) {
                        afterVcsRefreshInAwt.run();
                    }
                }, updateMode, VcsBundle.message((String)"changes.refresh.changelists.after.update", (Object[])new Object[0]), ModalityState.current());
            };
            List<Change> otherChanges = this.revertPartialChanges(changes, honorExcludedFromCommit);
            if (otherChanges.isEmpty()) {
                WaitForProgressToShow.runOrInvokeLaterAboveProgress((Runnable)afterRefresh, null, (Project)this.myProject);
                return;
            }
            final MyRollbackRunnable rollbackAction = new MyRollbackRunnable(otherChanges, deleteLocallyAddedFiles, afterRefresh);
            if (ApplicationManager.getApplication().isDispatchThread() && !this.myInvokedFromModalContext) {
                ProgressManager.getInstance().run((Task)new Task.Backgroundable(this.myProject, this.myOperationName, false, VcsConfiguration.getInstance((Project)this.myProject).getRollbackOption()){

                    public void run(@NotNull ProgressIndicator indicator2) {
                        if (indicator2 == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        rollbackAction.run();
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/vcs/changes/ui/RollbackWorker$1", "run"));
                    }
                });
            } else if (this.myInvokedFromModalContext) {
                ProgressManager.getInstance().run((Task)new Task.Modal(this.myProject, this.myOperationName, false){

                    public void run(@NotNull ProgressIndicator indicator2) {
                        if (indicator2 == null) {
                            2.$$$reportNull$$$0(0);
                        }
                        rollbackAction.run();
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/vcs/changes/ui/RollbackWorker$2", "run"));
                    }
                });
            } else {
                rollbackAction.run();
            }
            changeListManager.showLocalChangesInvalidated();
        });
    }

    @NotNull
    private List<Change> revertPartialChanges(@NotNull Collection<? extends Change> changes, boolean honorExcludedFromCommit) {
        if (changes == null) {
            RollbackWorker.$$$reportNull$$$0(3);
        }
        List<Change> list2 = PartialChangesUtil.processPartialChanges(this.myProject, changes, true, (PairFunction<? super List<ChangeListChange>, ? super PartialLocalLineStatusTracker, Boolean>)((PairFunction)(partialChanges, tracker2) -> {
            Set selectedIds;
            if (!tracker2.hasPartialChangesToCommit()) {
                return false;
            }
            if (!honorExcludedFromCommit && (selectedIds = ContainerUtil.map2Set((Collection)partialChanges, change -> change.getChangeListId())).containsAll(tracker2.getAffectedChangeListsIds())) {
                return false;
            }
            List changelistIds = ContainerUtil.map((Collection)partialChanges, change -> change.getChangeListId());
            tracker2.rollbackChanges(changelistIds, honorExcludedFromCommit);
            return true;
        }));
        if (list2 == null) {
            RollbackWorker.$$$reportNull$$$0(4);
        }
        return list2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changes";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/ui/RollbackWorker";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/ui/RollbackWorker";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "revertPartialChanges";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "doRollback";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "revertPartialChanges";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private final class MyRollbackRunnable
    implements Runnable {
        private final Collection<? extends Change> myChanges;
        private final boolean myDeleteLocallyAddedFiles;
        private final Runnable myAfterRefresh;
        private ProgressIndicator myIndicator;

        private MyRollbackRunnable(Collection<? extends Change> changes, boolean deleteLocallyAddedFiles, Runnable afterRefresh) {
            this.myChanges = changes;
            this.myDeleteLocallyAddedFiles = deleteLocallyAddedFiles;
            this.myAfterRefresh = afterRefresh;
        }

        @Override
        public void run() {
            ChangesUtil.markInternalOperation(this.myChanges, (boolean)true);
            try {
                this.doRun();
            }
            finally {
                ChangesUtil.markInternalOperation(this.myChanges, (boolean)false);
            }
        }

        private void doRun() {
            this.myIndicator = ProgressManager.getInstance().getProgressIndicator();
            ArrayList changesToRefresh = new ArrayList();
            try {
                ChangesUtil.processChangesByVcs((Project)RollbackWorker.this.myProject, this.myChanges, (vcs, changes) -> {
                    RollbackEnvironment environment2 = vcs.getRollbackEnvironment();
                    if (environment2 != null) {
                        changesToRefresh.addAll(changes);
                        if (this.myIndicator != null) {
                            this.myIndicator.setText(VcsBundle.message((String)"changes.progress.text.vcs.name.performing.operation.name", (Object[])new Object[]{vcs.getDisplayName(), StringUtil.toLowerCase((String)RollbackWorker.this.myOperationName)}));
                            this.myIndicator.setIndeterminate(false);
                            this.myIndicator.checkCanceled();
                        }
                        environment2.rollbackChanges(changes, RollbackWorker.this.myExceptions, (RollbackProgressListener)new RollbackProgressModifier(changes.size(), this.myIndicator));
                        if (this.myIndicator != null) {
                            this.myIndicator.setText2("");
                            this.myIndicator.checkCanceled();
                        }
                        if (RollbackWorker.this.myExceptions.isEmpty() && this.myDeleteLocallyAddedFiles) {
                            this.deleteAddedFilesLocally(changes);
                        }
                    }
                });
            }
            catch (ProcessCanceledException processCanceledException) {
                // empty catch block
            }
            if (this.myIndicator != null) {
                this.myIndicator.setIndeterminate(true);
                this.myIndicator.setText2("");
                this.myIndicator.setText(VcsBundle.message((String)"progress.text.synchronizing.files", (Object[])new Object[0]));
            }
            this.doRefresh(RollbackWorker.this.myProject, changesToRefresh);
            if (!RollbackWorker.this.myExceptions.isEmpty()) {
                AbstractVcsHelper.getInstance((Project)RollbackWorker.this.myProject).showErrors(RollbackWorker.this.myExceptions, RollbackWorker.this.myOperationName);
            }
        }

        private void doRefresh(Project project, List<? extends Change> changesToRefresh) {
            Runnable forAwtThread = () -> {
                VcsDirtyScopeManager manager2 = VcsDirtyScopeManager.getInstance((Project)RollbackWorker.this.myProject);
                ProjectLevelVcsManager vcsManager2 = ProjectLevelVcsManager.getInstance((Project)RollbackWorker.this.myProject);
                for (Change change : changesToRefresh) {
                    ContentRevision beforeRevision = change.getBeforeRevision();
                    ContentRevision afterRevision = change.getAfterRevision();
                    if (!change.isIsReplaced() && beforeRevision != null && Comparing.equal((Object)beforeRevision, (Object)afterRevision)) {
                        manager2.fileDirty(beforeRevision.getFile());
                        continue;
                    }
                    this.markDirty(manager2, vcsManager2, beforeRevision);
                    this.markDirty(manager2, vcsManager2, afterRevision);
                }
                this.myAfterRefresh.run();
            };
            RefreshVFsSynchronously.updateChangesForRollback(changesToRefresh);
            WaitForProgressToShow.runOrInvokeLaterAboveProgress((Runnable)forAwtThread, null, (Project)project);
        }

        private void markDirty(@NotNull VcsDirtyScopeManager manager2, @NotNull ProjectLevelVcsManager vcsManager2, @Nullable ContentRevision revision) {
            if (manager2 == null) {
                MyRollbackRunnable.$$$reportNull$$$0(0);
            }
            if (vcsManager2 == null) {
                MyRollbackRunnable.$$$reportNull$$$0(1);
            }
            if (revision != null) {
                FilePath parent = revision.getFile().getParentPath();
                if (parent != null && this.couldBeMarkedDirty(vcsManager2, parent)) {
                    manager2.dirDirtyRecursively(parent);
                } else {
                    manager2.fileDirty(revision.getFile());
                }
            }
        }

        private boolean couldBeMarkedDirty(@NotNull ProjectLevelVcsManager vcsGuess, @NotNull FilePath path2) {
            if (vcsGuess == null) {
                MyRollbackRunnable.$$$reportNull$$$0(2);
            }
            if (path2 == null) {
                MyRollbackRunnable.$$$reportNull$$$0(3);
            }
            return vcsGuess.getVcsFor(path2) != null;
        }

        private void deleteAddedFilesLocally(List<? extends Change> changes) {
            if (this.myIndicator != null) {
                this.myIndicator.setText(VcsBundle.message((String)"changes.deleting.added.files.locally", (Object[])new Object[0]));
                this.myIndicator.setFraction(0.0);
            }
            int changesSize = changes.size();
            for (int i2 = 0; i2 < changesSize; ++i2) {
                Change c = changes.get(i2);
                if (c.getType() != Change.Type.NEW) continue;
                ContentRevision rev = c.getAfterRevision();
                assert (rev != null);
                File ioFile = rev.getFile().getIOFile();
                if (this.myIndicator != null) {
                    this.myIndicator.setText2(ioFile.getAbsolutePath());
                    this.myIndicator.setFraction((double)i2 / (double)changesSize);
                }
                FileUtil.delete((File)ioFile);
            }
            if (this.myIndicator != null) {
                this.myIndicator.setText2("");
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "manager";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "vcsManager";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "vcsGuess";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/vcs/changes/ui/RollbackWorker$MyRollbackRunnable";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "markDirty";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "couldBeMarkedDirty";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

