/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.openapi.ListSelection;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesTree;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.containers.TreeTraversal;
import java.io.File;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.JTree;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class VcsTreeModelData {
    @NotNull
    public static VcsTreeModelData all(@NotNull JTree tree) {
        if (tree == null) {
            VcsTreeModelData.$$$reportNull$$$0(0);
        }
        assert (tree.getModel().getRoot() instanceof ChangesBrowserNode);
        return new AllUnderData(VcsTreeModelData.getRoot(tree));
    }

    @NotNull
    public static VcsTreeModelData selected(@NotNull JTree tree) {
        if (tree == null) {
            VcsTreeModelData.$$$reportNull$$$0(1);
        }
        assert (tree.getModel().getRoot() instanceof ChangesBrowserNode);
        return new SelectedData(tree);
    }

    @NotNull
    public static VcsTreeModelData exactlySelected(@NotNull JTree tree) {
        if (tree == null) {
            VcsTreeModelData.$$$reportNull$$$0(2);
        }
        assert (tree.getModel().getRoot() instanceof ChangesBrowserNode);
        return new ExactlySelectedData(tree);
    }

    @NotNull
    public static VcsTreeModelData included(@NotNull ChangesTree tree) {
        if (tree == null) {
            VcsTreeModelData.$$$reportNull$$$0(3);
        }
        assert (tree.getModel().getRoot() instanceof ChangesBrowserNode);
        return new IncludedUnderData(tree, VcsTreeModelData.getRoot((JTree)((Object)tree)));
    }

    @NotNull
    public static VcsTreeModelData children(@NotNull ChangesBrowserNode<?> node2) {
        if (node2 == null) {
            VcsTreeModelData.$$$reportNull$$$0(4);
        }
        return new AllUnderData(node2);
    }

    @NotNull
    public static VcsTreeModelData allUnderTag(@NotNull JTree tree, @NotNull Object tag2) {
        if (tree == null) {
            VcsTreeModelData.$$$reportNull$$$0(5);
        }
        if (tag2 == null) {
            VcsTreeModelData.$$$reportNull$$$0(6);
        }
        assert (tree.getModel().getRoot() instanceof ChangesBrowserNode);
        ChangesBrowserNode<?> tagNode = VcsTreeModelData.findTagNode(tree, tag2);
        if (tagNode == null) {
            return new EmptyData();
        }
        return new AllUnderData(tagNode);
    }

    @NotNull
    public static VcsTreeModelData selectedUnderTag(@NotNull JTree tree, @NotNull Object tag2) {
        if (tree == null) {
            VcsTreeModelData.$$$reportNull$$$0(7);
        }
        if (tag2 == null) {
            VcsTreeModelData.$$$reportNull$$$0(8);
        }
        assert (tree.getModel().getRoot() instanceof ChangesBrowserNode);
        return new SelectedTagData(tree, tag2);
    }

    @NotNull
    public static VcsTreeModelData includedUnderTag(@NotNull ChangesTree tree, @NotNull Object tag2) {
        if (tree == null) {
            VcsTreeModelData.$$$reportNull$$$0(9);
        }
        if (tag2 == null) {
            VcsTreeModelData.$$$reportNull$$$0(10);
        }
        assert (tree.getModel().getRoot() instanceof ChangesBrowserNode);
        ChangesBrowserNode<?> tagNode = VcsTreeModelData.findTagNode((JTree)((Object)tree), tag2);
        if (tagNode == null) {
            return new EmptyData();
        }
        return new IncludedUnderData(tree, tagNode);
    }

    @NotNull
    public abstract Stream<ChangesBrowserNode<?>> rawNodesStream();

    @NotNull
    public Stream<ChangesBrowserNode<?>> nodesStream() {
        Stream<ChangesBrowserNode<?>> stream = this.rawNodesStream().filter(ChangesBrowserNode::isMeaningfulNode);
        if (stream == null) {
            VcsTreeModelData.$$$reportNull$$$0(11);
        }
        return stream;
    }

    @NotNull
    public Stream<Object> rawUserObjectsStream() {
        Stream<Object> stream = this.rawUserObjectsStream(Object.class);
        if (stream == null) {
            VcsTreeModelData.$$$reportNull$$$0(12);
        }
        return stream;
    }

    @NotNull
    public <U> Stream<U> rawUserObjectsStream(@NotNull Class<U> clazz) {
        if (clazz == null) {
            VcsTreeModelData.$$$reportNull$$$0(13);
        }
        Stream<Object> stream = this.rawNodesStream().map(ChangesBrowserNode::getUserObject).filter(clazz::isInstance);
        if (stream == null) {
            VcsTreeModelData.$$$reportNull$$$0(14);
        }
        return stream;
    }

    @NotNull
    public Stream<Object> userObjectsStream() {
        Stream<Object> stream = this.userObjectsStream(Object.class);
        if (stream == null) {
            VcsTreeModelData.$$$reportNull$$$0(15);
        }
        return stream;
    }

    @NotNull
    public <U> Stream<U> userObjectsStream(@NotNull Class<U> clazz) {
        if (clazz == null) {
            VcsTreeModelData.$$$reportNull$$$0(16);
        }
        Stream<Object> stream = this.nodesStream().map(ChangesBrowserNode::getUserObject).filter(clazz::isInstance);
        if (stream == null) {
            VcsTreeModelData.$$$reportNull$$$0(17);
        }
        return stream;
    }

    @NotNull
    public List<Object> userObjects() {
        List<Object> list2 = this.userObjectsStream().collect(Collectors.toList());
        if (list2 == null) {
            VcsTreeModelData.$$$reportNull$$$0(18);
        }
        return list2;
    }

    @NotNull
    public <U> List<U> userObjects(@NotNull Class<U> clazz) {
        if (clazz == null) {
            VcsTreeModelData.$$$reportNull$$$0(19);
        }
        List list2 = this.userObjectsStream(clazz).collect(Collectors.toList());
        if (list2 == null) {
            VcsTreeModelData.$$$reportNull$$$0(20);
        }
        return list2;
    }

    @NotNull
    public static ListSelection<Object> getListSelectionOrAll(@NotNull JTree tree) {
        List<Object> entries2;
        if (tree == null) {
            VcsTreeModelData.$$$reportNull$$$0(21);
        }
        if ((entries2 = VcsTreeModelData.selected(tree).userObjects()).size() > 1) {
            ListSelection listSelection = ListSelection.createAt(entries2, (int)0);
            if (listSelection == null) {
                VcsTreeModelData.$$$reportNull$$$0(22);
            }
            return listSelection;
        }
        ChangesBrowserNode selected2 = VcsTreeModelData.selected(tree).nodesStream().findFirst().orElse(null);
        List<Object> allEntries = VcsTreeModelData.underExpandByDefault(selected2) ? new AllExpandedByDefaultData(VcsTreeModelData.getRoot(tree)).userObjects() : VcsTreeModelData.all(tree).userObjects();
        if (allEntries.size() <= entries2.size()) {
            ListSelection listSelection = ListSelection.createAt(entries2, (int)0);
            if (listSelection == null) {
                VcsTreeModelData.$$$reportNull$$$0(23);
            }
            return listSelection;
        }
        int index2 = selected2 != null ? ContainerUtil.indexOfIdentity(allEntries, selected2.getUserObject()) : 0;
        ListSelection listSelection = ListSelection.createAt(allEntries, (int)index2);
        if (listSelection == null) {
            VcsTreeModelData.$$$reportNull$$$0(24);
        }
        return listSelection;
    }

    @Nullable
    public static Object getData(@Nullable Project project, @NotNull JTree tree, @NotNull String dataId) {
        if (tree == null) {
            VcsTreeModelData.$$$reportNull$$$0(25);
        }
        if (dataId == null) {
            VcsTreeModelData.$$$reportNull$$$0(26);
        }
        if (CommonDataKeys.PROJECT.is(dataId)) {
            return project;
        }
        if (VcsDataKeys.CHANGES.is(dataId)) {
            Change[] changes = (Change[])VcsTreeModelData.mapToChange(VcsTreeModelData.selected(tree)).toArray(Change[]::new);
            if (changes.length != 0) {
                return changes;
            }
            return VcsTreeModelData.mapToChange(VcsTreeModelData.all(tree)).toArray(Change[]::new);
        }
        if (VcsDataKeys.SELECTED_CHANGES.is(dataId) || VcsDataKeys.SELECTED_CHANGES_IN_DETAILS.is(dataId)) {
            return VcsTreeModelData.mapToChange(VcsTreeModelData.selected(tree)).toArray(Change[]::new);
        }
        if (VcsDataKeys.CHANGES_SELECTION.is(dataId)) {
            return VcsTreeModelData.getListSelectionOrAll(tree).map(entry2 -> (Change)ObjectUtils.tryCast((Object)entry2, Change.class));
        }
        if (VcsDataKeys.CHANGE_LEAD_SELECTION.is(dataId)) {
            return VcsTreeModelData.mapToChange(VcsTreeModelData.exactlySelected(tree)).limit(1L).toArray(Change[]::new);
        }
        if (CommonDataKeys.VIRTUAL_FILE_ARRAY.is(dataId)) {
            return VcsTreeModelData.mapToVirtualFile(VcsTreeModelData.selected(tree)).toArray(VirtualFile[]::new);
        }
        if (CommonDataKeys.NAVIGATABLE_ARRAY.is(dataId)) {
            if (project == null) {
                return null;
            }
            return ChangesUtil.getNavigatableArray((Project)project, VcsTreeModelData.mapToNavigatableFile(VcsTreeModelData.selected(tree)));
        }
        if (VcsDataKeys.IO_FILE_ARRAY.is(dataId)) {
            return VcsTreeModelData.mapToIoFile(VcsTreeModelData.selected(tree)).toArray(File[]::new);
        }
        return null;
    }

    @NotNull
    private static Stream<Change> mapToChange(@NotNull VcsTreeModelData data2) {
        if (data2 == null) {
            VcsTreeModelData.$$$reportNull$$$0(27);
        }
        Stream<Change> stream = data2.userObjectsStream().filter(it -> it instanceof Change).map(entry2 -> (Change)entry2);
        if (stream == null) {
            VcsTreeModelData.$$$reportNull$$$0(28);
        }
        return stream;
    }

    @NotNull
    private static Stream<VirtualFile> mapToNavigatableFile(@NotNull VcsTreeModelData data2) {
        if (data2 == null) {
            VcsTreeModelData.$$$reportNull$$$0(29);
        }
        Stream<VirtualFile> stream = data2.userObjectsStream().flatMap(entry2 -> {
            if (entry2 instanceof Change) {
                return ChangesUtil.getPathsCaseSensitive((Change)((Change)entry2)).map(FilePath::getVirtualFile);
            }
            if (entry2 instanceof VirtualFile) {
                return Stream.of((VirtualFile)entry2);
            }
            if (entry2 instanceof FilePath) {
                return Stream.of(((FilePath)entry2).getVirtualFile());
            }
            return Stream.empty();
        }).filter(Objects::nonNull);
        if (stream == null) {
            VcsTreeModelData.$$$reportNull$$$0(30);
        }
        return stream;
    }

    @NotNull
    private static Stream<VirtualFile> mapToVirtualFile(@NotNull VcsTreeModelData data2) {
        if (data2 == null) {
            VcsTreeModelData.$$$reportNull$$$0(31);
        }
        Stream<VirtualFile> stream = data2.userObjectsStream().map(entry2 -> {
            if (entry2 instanceof Change) {
                FilePath path2 = ChangesUtil.getAfterPath((Change)((Change)entry2));
                return path2 != null ? path2.getVirtualFile() : null;
            }
            if (entry2 instanceof VirtualFile) {
                return (VirtualFile)entry2;
            }
            if (entry2 instanceof FilePath) {
                return ((FilePath)entry2).getVirtualFile();
            }
            return null;
        }).filter(Objects::nonNull);
        if (stream == null) {
            VcsTreeModelData.$$$reportNull$$$0(32);
        }
        return stream;
    }

    @NotNull
    private static Stream<File> mapToIoFile(@NotNull VcsTreeModelData data2) {
        if (data2 == null) {
            VcsTreeModelData.$$$reportNull$$$0(33);
        }
        Stream<File> stream = data2.userObjectsStream().map(entry2 -> {
            if (entry2 instanceof Change) {
                FilePath path2 = ChangesUtil.getAfterPath((Change)((Change)entry2));
                return path2 != null ? path2.getIOFile() : null;
            }
            return null;
        }).filter(Objects::nonNull);
        if (stream == null) {
            VcsTreeModelData.$$$reportNull$$$0(34);
        }
        return stream;
    }

    @Nullable
    private static ChangesBrowserNode<?> findTagNode(@NotNull JTree tree, @NotNull Object tag2) {
        if (tree == null) {
            VcsTreeModelData.$$$reportNull$$$0(35);
        }
        if (tag2 == null) {
            VcsTreeModelData.$$$reportNull$$$0(36);
        }
        ChangesBrowserNode root = (ChangesBrowserNode)tree.getModel().getRoot();
        Enumeration<TreeNode> children2 = root.children();
        Iterator iterator2 = ContainerUtil.iterate(children2);
        return (ChangesBrowserNode)ContainerUtil.find((Iterator)iterator2, node2 -> tag2.equals(node2.getUserObject()));
    }

    private static boolean underExpandByDefault(@Nullable ChangesBrowserNode<?> node2) {
        while (node2 != null) {
            if (!node2.shouldExpandByDefault()) {
                return false;
            }
            node2 = node2.getParent();
        }
        return true;
    }

    @NotNull
    private static ChangesBrowserNode<?> getRoot(@NotNull JTree tree) {
        if (tree == null) {
            VcsTreeModelData.$$$reportNull$$$0(37);
        }
        ChangesBrowserNode changesBrowserNode = (ChangesBrowserNode)tree.getModel().getRoot();
        if (changesBrowserNode == null) {
            VcsTreeModelData.$$$reportNull$$$0(38);
        }
        return changesBrowserNode;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 28: 
            case 30: 
            case 32: 
            case 34: 
            case 38: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 28: 
            case 30: 
            case 32: 
            case 34: 
            case 38: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 6: 
            case 8: 
            case 10: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 28: 
            case 30: 
            case 32: 
            case 34: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/ui/VcsTreeModelData";
                break;
            }
            case 13: 
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 27: 
            case 29: 
            case 31: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/ui/VcsTreeModelData";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "nodesStream";
                break;
            }
            case 12: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "rawUserObjectsStream";
                break;
            }
            case 15: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "userObjectsStream";
                break;
            }
            case 18: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "userObjects";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getListSelectionOrAll";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "mapToChange";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "mapToNavigatableFile";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "mapToVirtualFile";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "mapToIoFile";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoot";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "all";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "selected";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "exactlySelected";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "included";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "children";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "allUnderTag";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "selectedUnderTag";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "includedUnderTag";
                break;
            }
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 28: 
            case 30: 
            case 32: 
            case 34: 
            case 38: {
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "rawUserObjectsStream";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "userObjectsStream";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "userObjects";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getListSelectionOrAll";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "mapToChange";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "mapToNavigatableFile";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "mapToVirtualFile";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "mapToIoFile";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "findTagNode";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getRoot";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 28: 
            case 30: 
            case 32: 
            case 34: 
            case 38: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class AllExpandedByDefaultData
    extends VcsTreeModelData {
        @NotNull
        private final ChangesBrowserNode<?> myNode;

        AllExpandedByDefaultData(@NotNull ChangesBrowserNode<?> node2) {
            if (node2 == null) {
                AllExpandedByDefaultData.$$$reportNull$$$0(0);
            }
            this.myNode = node2;
        }

        @Override
        @NotNull
        public Stream<ChangesBrowserNode<?>> rawNodesStream() {
            JBTreeTraverser traverser = JBTreeTraverser.from(node2 -> {
                if (node2.shouldExpandByDefault()) {
                    return () -> {
                        Enumeration<TreeNode> children2 = node2.children();
                        return ContainerUtil.iterate(children2);
                    };
                }
                return Collections.emptyList();
            });
            StreamEx streamEx = StreamEx.of((Iterator)((JBTreeTraverser)traverser.withRoot(this.myNode)).traverse(TreeTraversal.PRE_ORDER_DFS).iterator());
            if (streamEx == null) {
                AllExpandedByDefaultData.$$$reportNull$$$0(1);
            }
            return streamEx;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/changes/ui/VcsTreeModelData$AllExpandedByDefaultData";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/changes/ui/VcsTreeModelData$AllExpandedByDefaultData";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "rawNodesStream";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class IncludedUnderData
    extends VcsTreeModelData {
        private final ChangesBrowserNode<?> myNode;
        private final Set<Object> myIncluded;

        IncludedUnderData(@NotNull ChangesTree tree, @NotNull ChangesBrowserNode<?> node2) {
            if (tree == null) {
                IncludedUnderData.$$$reportNull$$$0(0);
            }
            if (node2 == null) {
                IncludedUnderData.$$$reportNull$$$0(1);
            }
            this.myNode = node2;
            this.myIncluded = tree.getIncludedSet();
        }

        @Override
        @NotNull
        public Stream<ChangesBrowserNode<?>> rawNodesStream() {
            Stream<ChangesBrowserNode<?>> stream = this.myNode.getNodesUnderStream().filter(node2 -> this.myIncluded.contains(node2.getUserObject()));
            if (stream == null) {
                IncludedUnderData.$$$reportNull$$$0(2);
            }
            return stream;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tree";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/changes/ui/VcsTreeModelData$IncludedUnderData";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/changes/ui/VcsTreeModelData$IncludedUnderData";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "rawNodesStream";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class SelectedTagData
    extends ExactlySelectedTagData {
        SelectedTagData(@NotNull JTree tree, @NotNull Object tag2) {
            if (tree == null) {
                SelectedTagData.$$$reportNull$$$0(0);
            }
            if (tag2 == null) {
                SelectedTagData.$$$reportNull$$$0(1);
            }
            super(tree, tag2);
        }

        @Override
        @NotNull
        public Stream<ChangesBrowserNode<?>> rawNodesStream() {
            Stream<ChangesBrowserNode<?>> stream = super.rawNodesStream().flatMap(ChangesBrowserNode::getNodesUnderStream).distinct();
            if (stream == null) {
                SelectedTagData.$$$reportNull$$$0(2);
            }
            return stream;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tree";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tag";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/changes/ui/VcsTreeModelData$SelectedTagData";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/changes/ui/VcsTreeModelData$SelectedTagData";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "rawNodesStream";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class ExactlySelectedTagData
    extends VcsTreeModelData {
        private final TreePath[] myPaths;
        private final ChangesBrowserNode<?> myTagNode;

        ExactlySelectedTagData(@NotNull JTree tree, @NotNull Object tag2) {
            if (tree == null) {
                ExactlySelectedTagData.$$$reportNull$$$0(0);
            }
            if (tag2 == null) {
                ExactlySelectedTagData.$$$reportNull$$$0(1);
            }
            this.myPaths = tree.getSelectionPaths();
            this.myTagNode = VcsTreeModelData.findTagNode(tree, tag2);
        }

        @Override
        @NotNull
        public Stream<ChangesBrowserNode<?>> rawNodesStream() {
            ChangesBrowserNode<?> tagNode = this.myTagNode;
            if (tagNode == null) {
                Stream<ChangesBrowserNode<?>> stream = Stream.empty();
                if (stream == null) {
                    ExactlySelectedTagData.$$$reportNull$$$0(2);
                }
                return stream;
            }
            TreePath[] paths2 = this.myPaths;
            if (paths2 == null) {
                Stream<ChangesBrowserNode<?>> stream = Stream.empty();
                if (stream == null) {
                    ExactlySelectedTagData.$$$reportNull$$$0(3);
                }
                return stream;
            }
            Stream<ChangesBrowserNode<?>> stream = Stream.of(paths2).filter(path2 -> path2.getPathCount() <= 1 || path2.getPathComponent(1) == tagNode).map(path2 -> (ChangesBrowserNode)path2.getLastPathComponent());
            if (stream == null) {
                ExactlySelectedTagData.$$$reportNull$$$0(4);
            }
            return stream;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tree";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tag";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/changes/ui/VcsTreeModelData$ExactlySelectedTagData";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/changes/ui/VcsTreeModelData$ExactlySelectedTagData";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "rawNodesStream";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class ExactlySelectedData
    extends VcsTreeModelData {
        private final TreePath[] myPaths;

        ExactlySelectedData(@NotNull JTree tree) {
            if (tree == null) {
                ExactlySelectedData.$$$reportNull$$$0(0);
            }
            this.myPaths = tree.getSelectionPaths();
        }

        @Override
        @NotNull
        public Stream<ChangesBrowserNode<?>> rawNodesStream() {
            TreePath[] paths2 = this.myPaths;
            if (paths2 == null) {
                Stream<ChangesBrowserNode<?>> stream = Stream.empty();
                if (stream == null) {
                    ExactlySelectedData.$$$reportNull$$$0(1);
                }
                return stream;
            }
            Stream<ChangesBrowserNode<?>> stream = Stream.of(paths2).map(path2 -> (ChangesBrowserNode)path2.getLastPathComponent());
            if (stream == null) {
                ExactlySelectedData.$$$reportNull$$$0(2);
            }
            return stream;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tree";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/changes/ui/VcsTreeModelData$ExactlySelectedData";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/changes/ui/VcsTreeModelData$ExactlySelectedData";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "rawNodesStream";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class SelectedData
    extends ExactlySelectedData {
        SelectedData(@NotNull JTree tree) {
            if (tree == null) {
                SelectedData.$$$reportNull$$$0(0);
            }
            super(tree);
        }

        @Override
        @NotNull
        public Stream<ChangesBrowserNode<?>> rawNodesStream() {
            Stream<ChangesBrowserNode<?>> stream = super.rawNodesStream().flatMap(ChangesBrowserNode::getNodesUnderStream).distinct();
            if (stream == null) {
                SelectedData.$$$reportNull$$$0(1);
            }
            return stream;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tree";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/changes/ui/VcsTreeModelData$SelectedData";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/changes/ui/VcsTreeModelData$SelectedData";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "rawNodesStream";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class AllUnderData
    extends VcsTreeModelData {
        @NotNull
        private final ChangesBrowserNode<?> myNode;

        AllUnderData(@NotNull ChangesBrowserNode<?> node2) {
            if (node2 == null) {
                AllUnderData.$$$reportNull$$$0(0);
            }
            this.myNode = node2;
        }

        @Override
        @NotNull
        public Stream<ChangesBrowserNode<?>> rawNodesStream() {
            Stream<ChangesBrowserNode<?>> stream = this.myNode.getNodesUnderStream();
            if (stream == null) {
                AllUnderData.$$$reportNull$$$0(1);
            }
            return stream;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/changes/ui/VcsTreeModelData$AllUnderData";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/changes/ui/VcsTreeModelData$AllUnderData";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "rawNodesStream";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class EmptyData
    extends VcsTreeModelData {
        EmptyData() {
        }

        @Override
        @NotNull
        public Stream<ChangesBrowserNode<?>> rawNodesStream() {
            Stream<ChangesBrowserNode<?>> stream = Stream.empty();
            if (stream == null) {
                EmptyData.$$$reportNull$$$0(0);
            }
            return stream;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/VcsTreeModelData$EmptyData", "rawNodesStream"));
        }
    }
}

