/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui.browser;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ui.ChangeNodeDecorator;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserBase;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.TreeModelBuilder;
import com.intellij.openapi.vcs.changes.ui.browser.ChangesFilterer;
import com.intellij.ui.components.ProgressBarLoadingDecorator;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FilterableChangesBrowser
extends ChangesBrowserBase
implements Disposable {
    private final ChangesFilterer myChangesFilterer;
    private ProgressBarLoadingDecorator myLoadingDecorator;

    protected FilterableChangesBrowser(@NotNull Project project, boolean showCheckboxes, boolean highlightProblems) {
        if (project == null) {
            FilterableChangesBrowser.$$$reportNull$$$0(0);
        }
        super(project, showCheckboxes, highlightProblems);
        this.myChangesFilterer = new ChangesFilterer(this.myProject, this::updateTreeOnFilterChange);
        Disposer.register((Disposable)this, (Disposable)this.myChangesFilterer);
    }

    private void updateTreeOnFilterChange() {
        boolean oldKeepTreeState = this.myViewer.isKeepTreeState();
        this.myViewer.setKeepTreeState(true);
        this.myViewer.rebuildTree();
        this.myViewer.setKeepTreeState(oldKeepTreeState);
        this.myViewer.expandDefaults();
        float progress2 = this.myChangesFilterer.getProgress();
        if (progress2 == 1.0f) {
            this.myLoadingDecorator.stopLoading();
        } else {
            this.myLoadingDecorator.startLoading();
            this.myLoadingDecorator.getProgressBar().setIndeterminate(progress2 == 0.0f);
            this.myLoadingDecorator.getProgressBar().setValue((int)(100.0f * progress2));
        }
        this.onActiveChangesFilterChanges();
    }

    protected void onActiveChangesFilterChanges() {
    }

    public void dispose() {
    }

    public boolean hasActiveChangesFilter() {
        return this.myChangesFilterer.hasActiveFilter();
    }

    public void clearActiveChangesFilter() {
        this.myChangesFilterer.clearFilter();
    }

    /*
     * WARNING - void declaration
     */
    @RequiresEdt
    public ChangesFilterer.FilteredState filterChanges(@NotNull List<? extends Change> list2, boolean bl) {
        void shouldFilter;
        void changes;
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (changes == null) {
            FilterableChangesBrowser.$$$reportNull$$$0(1);
        }
        if (shouldFilter == false) {
            this.myChangesFilterer.setChanges(null);
            return ChangesFilterer.FilteredState.create((List<? extends Change>)changes);
        }
        this.myChangesFilterer.setChanges((List<? extends Change>)changes);
        return this.myChangesFilterer.getFilteredChanges();
    }

    @Override
    @Nullable
    public Object getData(@NotNull String dataId) {
        if (dataId == null) {
            FilterableChangesBrowser.$$$reportNull$$$0(2);
        }
        if (ChangesFilterer.DATA_KEY.is(dataId)) {
            return this.myChangesFilterer;
        }
        return super.getData(dataId);
    }

    @Override
    @NotNull
    protected JComponent createCenterPanel() {
        JComponent centerPanel = super.createCenterPanel();
        this.myLoadingDecorator = new ProgressBarLoadingDecorator((JPanel)JBUI.Panels.simplePanel((Component)centerPanel), (Disposable)this, 300);
        JComponent jComponent = this.myLoadingDecorator.getComponent();
        if (jComponent == null) {
            FilterableChangesBrowser.$$$reportNull$$$0(3);
        }
        return jComponent;
    }

    protected static void setFilteredChanges(@NotNull TreeModelBuilder builder2, @NotNull ChangesFilterer.FilteredState filteredState, @Nullable ChangeNodeDecorator changeNodeDecorator) {
        if (builder2 == null) {
            FilterableChangesBrowser.$$$reportNull$$$0(4);
        }
        if (filteredState == null) {
            FilterableChangesBrowser.$$$reportNull$$$0(5);
        }
        builder2.setChanges(filteredState.getChanges(), changeNodeDecorator);
        FilterableChangesBrowser.setPendingChanges(builder2, filteredState.getPending(), changeNodeDecorator);
        FilterableChangesBrowser.setFilteredOutChanges(builder2, filteredState.getFilteredOut(), changeNodeDecorator);
    }

    protected static void setPendingChanges(@NotNull TreeModelBuilder builder2, @NotNull Collection<? extends Change> changes, @Nullable ChangeNodeDecorator changeNodeDecorator) {
        if (builder2 == null) {
            FilterableChangesBrowser.$$$reportNull$$$0(6);
        }
        if (changes == null) {
            FilterableChangesBrowser.$$$reportNull$$$0(7);
        }
        if (changes.isEmpty()) {
            return;
        }
        ChangesBrowserNode<?> tagNode = builder2.createTagNode(VcsBundle.message((String)"changes.nodetitle.filter.pending", (Object[])new Object[0]), false);
        builder2.insertChanges(changes, tagNode, changeNodeDecorator);
    }

    protected static void setFilteredOutChanges(@NotNull TreeModelBuilder builder2, @NotNull Collection<? extends Change> changes, @Nullable ChangeNodeDecorator changeNodeDecorator) {
        if (builder2 == null) {
            FilterableChangesBrowser.$$$reportNull$$$0(8);
        }
        if (changes == null) {
            FilterableChangesBrowser.$$$reportNull$$$0(9);
        }
        if (changes.isEmpty()) {
            return;
        }
        ChangesBrowserNode<?> tagNode = builder2.createTagNode(VcsBundle.message((String)"changes.nodetitle.filtered.out", (Object[])new Object[0]), false);
        builder2.insertChanges(changes, tagNode, changeNodeDecorator);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changes";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/ui/browser/FilterableChangesBrowser";
                break;
            }
            case 4: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filteredState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/ui/browser/FilterableChangesBrowser";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createCenterPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "filterChanges";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setFilteredChanges";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setPendingChanges";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setFilteredOutChanges";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

