/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.changes.ChangeListManagerImpl;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.impl.ActiveChangeListTracker;
import com.intellij.openapi.vcs.impl.LineStatusTrackerManager;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rH\u0002J\n\u0010\u000e\u001a\u0004\u0018\u00010\u0006H\u0016J\u0010\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rH\u0016R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0015"}, d2={"Lcom/intellij/openapi/vcs/impl/ActiveChangeListTrackerImpl;", "Lcom/intellij/openapi/vcs/impl/ActiveChangeListTracker;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "forcedChangeListId", "", "getProject", "()Lcom/intellij/openapi/project/Project;", "doRunUnderChangeList", "", "changelistId", "task", "Ljava/lang/Runnable;", "getActiveChangeListId", "isActiveChangeList", "changeList", "Lcom/intellij/openapi/vcs/changes/LocalChangeList;", "runUnderChangeList", "", "Companion", "intellij.platform.vcs.impl"})
public class ActiveChangeListTrackerImpl
implements ActiveChangeListTracker {
    private String forcedChangeListId;
    @NotNull
    private final Project project;
    private static final Logger LOG;
    @NotNull
    public static final Companion Companion;

    @Override
    @Nullable
    public String getActiveChangeListId() {
        return this.forcedChangeListId;
    }

    @Override
    public boolean isActiveChangeList(@NotNull LocalChangeList changeList) {
        Intrinsics.checkNotNullParameter((Object)changeList, (String)"changeList");
        String activeListId = this.getActiveChangeListId();
        if (activeListId != null) {
            return Intrinsics.areEqual((Object)changeList.getId(), (Object)activeListId);
        }
        return changeList.isDefault();
    }

    @Override
    public void runUnderChangeList(@NotNull String changelistId, @NotNull Runnable task2) {
        Intrinsics.checkNotNullParameter((Object)changelistId, (String)"changelistId");
        Intrinsics.checkNotNullParameter((Object)task2, (String)"task");
        if (!this.doRunUnderChangeList(changelistId, task2)) {
            task2.run();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final boolean doRunUnderChangeList(String changelistId, Runnable task2) {
        void success2;
        LineStatusTrackerManager lstManager = LineStatusTrackerManager.Companion.getInstanceImpl(this.project);
        if (!lstManager.arePartialChangelistsEnabled()) {
            return false;
        }
        if (this.forcedChangeListId != null) {
            LOG.warn("Conflicting forced changelist request", new Throwable());
            return false;
        }
        Ref.BooleanRef booleanRef = new Ref.BooleanRef();
        booleanRef.element = false;
        ChangeListManagerImpl changeListManager = ChangeListManagerImpl.getInstanceImpl(this.project);
        changeListManager.executeUnderDataLock(new Runnable(this, changeListManager, changelistId, (Ref.BooleanRef)success2, task2){
            final /* synthetic */ ActiveChangeListTrackerImpl this$0;
            final /* synthetic */ ChangeListManagerImpl $changeListManager;
            final /* synthetic */ String $changelistId;
            final /* synthetic */ Ref.BooleanRef $success;
            final /* synthetic */ Runnable $task;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void run() {
                if (this.$changeListManager.getChangeList(this.$changelistId) != null) {
                    ActiveChangeListTrackerImpl.access$setForcedChangeListId$p(this.this$0, this.$changelistId);
                    try {
                        ActiveChangeListTrackerImpl.access$getLOG$cp().debug("running operation under changelist: " + this.$changelistId);
                        this.$success.element = true;
                        this.$task.run();
                    }
                    finally {
                        ActiveChangeListTrackerImpl.access$setForcedChangeListId$p(this.this$0, null);
                    }
                }
            }
            {
                this.this$0 = activeChangeListTrackerImpl;
                this.$changeListManager = changeListManagerImpl;
                this.$changelistId = string;
                this.$success = booleanRef;
                this.$task = runnable2;
            }
        });
        return success2.element;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public ActiveChangeListTrackerImpl(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    static {
        Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(ActiveChangeListTracker.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        LOG = logger;
    }

    public static final /* synthetic */ String access$getForcedChangeListId$p(ActiveChangeListTrackerImpl $this) {
        return $this.forcedChangeListId;
    }

    public static final /* synthetic */ void access$setForcedChangeListId$p(ActiveChangeListTrackerImpl $this, String string) {
        $this.forcedChangeListId = string;
    }

    public static final /* synthetic */ Logger access$getLOG$cp() {
        return LOG;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/openapi/vcs/impl/ActiveChangeListTrackerImpl$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.platform.vcs.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

