/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.impl.projectlevelman;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.CollectionFactory;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FilePathMapping<T> {
    private final boolean myCaseSensitive;
    private final Map<String, T> myPathMap;
    private final IntSet myPathHashSet = new IntOpenHashSet();

    public FilePathMapping(boolean caseSensitive) {
        this.myCaseSensitive = caseSensitive;
        this.myPathMap = caseSensitive ? new HashMap() : CollectionFactory.createCaseInsensitiveStringMap();
    }

    public void add(@NotNull String filePath, @NotNull T value2) {
        if (filePath == null) {
            FilePathMapping.$$$reportNull$$$0(0);
        }
        if (value2 == null) {
            FilePathMapping.$$$reportNull$$$0(1);
        }
        String path2 = StringUtil.trimTrailing((String)filePath, (char)'/');
        this.myPathMap.put(path2, value2);
        this.myPathHashSet.add(FilePathMapping.pathHashCode(this.myCaseSensitive, path2));
    }

    public void remove(@NotNull String filePath) {
        if (filePath == null) {
            FilePathMapping.$$$reportNull$$$0(2);
        }
        String path2 = StringUtil.trimTrailing((String)filePath, (char)'/');
        this.myPathMap.remove(path2);
    }

    public void clear() {
        this.myPathMap.clear();
        this.myPathHashSet.clear();
    }

    @NotNull
    public Collection<T> values() {
        Collection<T> collection = this.myPathMap.values();
        if (collection == null) {
            FilePathMapping.$$$reportNull$$$0(3);
        }
        return collection;
    }

    public boolean containsKey(@NotNull String filePath) {
        if (filePath == null) {
            FilePathMapping.$$$reportNull$$$0(4);
        }
        String path2 = StringUtil.trimTrailing((String)filePath, (char)'/');
        return this.myPathMap.containsKey(path2);
    }

    @Nullable
    public T getMappingFor(@NotNull String filePath) {
        if (filePath == null) {
            FilePathMapping.$$$reportNull$$$0(5);
        }
        String path2 = StringUtil.trimTrailing((String)filePath, (char)'/');
        int index2 = 0;
        int prefixHash = 0;
        IntArrayList matches = new IntArrayList();
        if (this.myPathHashSet.contains(prefixHash)) {
            matches.add(index2);
        }
        while (index2 < path2.length()) {
            int nextIndex = path2.indexOf(47, index2 + 1);
            if (nextIndex == -1) {
                nextIndex = path2.length();
            }
            if (this.myPathHashSet.contains(prefixHash = FilePathMapping.pathHashCode(this.myCaseSensitive, path2, index2, nextIndex, prefixHash))) {
                matches.add(nextIndex);
            }
            index2 = nextIndex;
        }
        for (int i2 = matches.size() - 1; i2 >= 0; --i2) {
            String prefix2 = path2.substring(0, matches.getInt(i2));
            T root = this.myPathMap.get(prefix2);
            if (root == null) continue;
            return root;
        }
        return null;
    }

    private static int pathHashCode(boolean caseSensitive, @NotNull String path2) {
        if (path2 == null) {
            FilePathMapping.$$$reportNull$$$0(6);
        }
        return FilePathMapping.pathHashCode(caseSensitive, path2, 0, path2.length(), 0);
    }

    private static int pathHashCode(boolean caseSensitive, @NotNull String path2, int offset1, int offset2, int prefixHash) {
        if (path2 == null) {
            FilePathMapping.$$$reportNull$$$0(7);
        }
        if (caseSensitive) {
            return StringUtil.stringHashCode((CharSequence)path2, (int)offset1, (int)offset2, (int)prefixHash);
        }
        return StringUtil.stringHashCodeInsensitive((CharSequence)path2, (int)offset1, (int)offset2, (int)prefixHash);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/impl/projectlevelman/FilePathMapping";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/impl/projectlevelman/FilePathMapping";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "values";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "remove";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "containsKey";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getMappingFor";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "pathHashCode";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

